/*******************************************************************************
 * Copyright (c) 2010,2011 E.D.Willink and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
package org.eclipse.qvtd.pivot.qvtbase.attributes;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.scoping.AbstractAttribution;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.Unit;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;

public class TypedModelAttribution extends AbstractAttribution
{
	public static final TypedModelAttribution INSTANCE = new TypedModelAttribution();

	@Override
	public ScopeView computeLookup(@NonNull EObject target, @NonNull EnvironmentView environmentView, @NonNull ScopeView scopeView) {
		TypedModel typedModel = (TypedModel)target;
		BaseModel model = QVTbaseUtil.getContainingModel(typedModel);
		if (model != null) {
			for (Unit unit : model.getUnit()) {
				environmentView.addElement(unit.getName(), unit.getUsedPackage());
			}
		}
//		org.eclipse.ocl.examples.pivot.Package targetPackage = (org.eclipse.ocl.examples.pivot.Package)target;
//		MetaModelManager metaModelManager = environmentView.getMetaModelManager();
//		environmentView.addNamedElements(metaModelManager.getLocalPackages(targetPackage));
//		environmentView.addNamedElements(metaModelManager.getLocalClasses(targetPackage));
//		environmentView.addNamedElements(targetPackage.getOwnedPrecedence());
		return scopeView.getParent();
	}
}
