/*******************************************************************************
 * Copyright (c) 2014 E.D.Willink and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
/*
* generated by Xtext
*/
package org.eclipse.qvtd.xtext.qvtrelation.services;

import com.google.inject.Singleton;
import com.google.inject.Inject;

import java.util.List;

import org.eclipse.xtext.*;
import org.eclipse.xtext.service.GrammarProvider;
import org.eclipse.xtext.service.AbstractElementFinder.*;

import org.eclipse.ocl.examples.xtext.essentialocl.services.EssentialOCLGrammarAccess;

@Singleton
public class QVTrelationGrammarAccess extends AbstractGrammarElementFinder {
	
	
	public class TopLevelCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TopLevelCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Alternatives cAlternatives_0 = (Alternatives)cGroup.eContents().get(0);
		private final Assignment cOwnedImportAssignment_0_0 = (Assignment)cAlternatives_0.eContents().get(0);
		private final RuleCall cOwnedImportUnitCSParserRuleCall_0_0_0 = (RuleCall)cOwnedImportAssignment_0_0.eContents().get(0);
		private final Assignment cOwnedLibraryAssignment_0_1 = (Assignment)cAlternatives_0.eContents().get(1);
		private final RuleCall cOwnedLibraryLibraryCSParserRuleCall_0_1_0 = (RuleCall)cOwnedLibraryAssignment_0_1.eContents().get(0);
		private final Assignment cTransformationsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cTransformationsTransformationCSParserRuleCall_1_0 = (RuleCall)cTransformationsAssignment_1.eContents().get(0);
		
		//TopLevelCS:
		//	(ownedImport+=UnitCS | / *ownedInclude+=IncludeCS |* / ownedLibrary+=LibraryCS)* transformations+=TransformationCS*;
		public ParserRule getRule() { return rule; }

		//(ownedImport+=UnitCS | / *ownedInclude+=IncludeCS |* / ownedLibrary+=LibraryCS)* transformations+=TransformationCS*
		public Group getGroup() { return cGroup; }

		//(ownedImport+=UnitCS | / *ownedInclude+=IncludeCS |* / ownedLibrary+=LibraryCS)*
		public Alternatives getAlternatives_0() { return cAlternatives_0; }

		//ownedImport+=UnitCS
		public Assignment getOwnedImportAssignment_0_0() { return cOwnedImportAssignment_0_0; }

		//UnitCS
		public RuleCall getOwnedImportUnitCSParserRuleCall_0_0_0() { return cOwnedImportUnitCSParserRuleCall_0_0_0; }

		/// *ownedInclude+=IncludeCS |* / ownedLibrary+=LibraryCS
		public Assignment getOwnedLibraryAssignment_0_1() { return cOwnedLibraryAssignment_0_1; }

		//LibraryCS
		public RuleCall getOwnedLibraryLibraryCSParserRuleCall_0_1_0() { return cOwnedLibraryLibraryCSParserRuleCall_0_1_0; }

		//transformations+=TransformationCS*
		public Assignment getTransformationsAssignment_1() { return cTransformationsAssignment_1; }

		//TransformationCS
		public RuleCall getTransformationsTransformationCSParserRuleCall_1_0() { return cTransformationsTransformationCSParserRuleCall_1_0; }
	}

	public class CollectionTemplateCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "CollectionTemplateCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Keyword cColonKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cTypeAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cTypeCollectionTypeCSParserRuleCall_2_0 = (RuleCall)cTypeAssignment_2.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Assignment cMemberIdentifiersAssignment_4_0 = (Assignment)cGroup_4.eContents().get(0);
		private final Alternatives cMemberIdentifiersAlternatives_4_0_0 = (Alternatives)cMemberIdentifiersAssignment_4_0.eContents().get(0);
		private final RuleCall cMemberIdentifiersTemplateCSParserRuleCall_4_0_0_0 = (RuleCall)cMemberIdentifiersAlternatives_4_0_0.eContents().get(0);
		private final RuleCall cMemberIdentifiersElementTemplateCSParserRuleCall_4_0_0_1 = (RuleCall)cMemberIdentifiersAlternatives_4_0_0.eContents().get(1);
		private final Group cGroup_4_1 = (Group)cGroup_4.eContents().get(1);
		private final Keyword cCommaKeyword_4_1_0 = (Keyword)cGroup_4_1.eContents().get(0);
		private final Assignment cMemberIdentifiersAssignment_4_1_1 = (Assignment)cGroup_4_1.eContents().get(1);
		private final Alternatives cMemberIdentifiersAlternatives_4_1_1_0 = (Alternatives)cMemberIdentifiersAssignment_4_1_1.eContents().get(0);
		private final RuleCall cMemberIdentifiersTemplateCSParserRuleCall_4_1_1_0_0 = (RuleCall)cMemberIdentifiersAlternatives_4_1_1_0.eContents().get(0);
		private final RuleCall cMemberIdentifiersElementTemplateCSParserRuleCall_4_1_1_0_1 = (RuleCall)cMemberIdentifiersAlternatives_4_1_1_0.eContents().get(1);
		private final Keyword cPlusSignPlusSignKeyword_4_2 = (Keyword)cGroup_4.eContents().get(2);
		private final Alternatives cAlternatives_4_3 = (Alternatives)cGroup_4.eContents().get(3);
		private final Assignment cRestIdentifierAssignment_4_3_0 = (Assignment)cAlternatives_4_3.eContents().get(0);
		private final CrossReference cRestIdentifierVariableCrossReference_4_3_0_0 = (CrossReference)cRestIdentifierAssignment_4_3_0.eContents().get(0);
		private final RuleCall cRestIdentifierVariableUnrestrictedNameParserRuleCall_4_3_0_0_1 = (RuleCall)cRestIdentifierVariableCrossReference_4_3_0_0.eContents().get(1);
		private final Keyword c_Keyword_4_3_1 = (Keyword)cAlternatives_4_3.eContents().get(1);
		private final Keyword cRightCurlyBracketKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		////UnitCS: identifier+=[pivot::Element|UnrestrictedName] ('.' identifier+=[pivot::Element|UnrestrictedName])*;
		//CollectionTemplateCS:
		//	name=UnrestrictedName? ":" type=CollectionTypeCS "{" (memberIdentifiers+=(TemplateCS | ElementTemplateCS) (","
		//	memberIdentifiers+=(TemplateCS | ElementTemplateCS))* "++" (restIdentifier=[pivot::Variable|UnrestrictedName] | "_"))?
		//	"}";
		public ParserRule getRule() { return rule; }

		//name=UnrestrictedName? ":" type=CollectionTypeCS "{" (memberIdentifiers+=(TemplateCS | ElementTemplateCS) (","
		//memberIdentifiers+=(TemplateCS | ElementTemplateCS))* "++" (restIdentifier=[pivot::Variable|UnrestrictedName] | "_"))?
		//"}"
		public Group getGroup() { return cGroup; }

		//name=UnrestrictedName?
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_0_0() { return cNameUnrestrictedNameParserRuleCall_0_0; }

		//":"
		public Keyword getColonKeyword_1() { return cColonKeyword_1; }

		//type=CollectionTypeCS
		public Assignment getTypeAssignment_2() { return cTypeAssignment_2; }

		//CollectionTypeCS
		public RuleCall getTypeCollectionTypeCSParserRuleCall_2_0() { return cTypeCollectionTypeCSParserRuleCall_2_0; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_3() { return cLeftCurlyBracketKeyword_3; }

		//(memberIdentifiers+=(TemplateCS | ElementTemplateCS) ("," memberIdentifiers+=(TemplateCS | ElementTemplateCS))* "++"
		//(restIdentifier=[pivot::Variable|UnrestrictedName] | "_"))?
		public Group getGroup_4() { return cGroup_4; }

		//memberIdentifiers+=(TemplateCS | ElementTemplateCS)
		public Assignment getMemberIdentifiersAssignment_4_0() { return cMemberIdentifiersAssignment_4_0; }

		//TemplateCS | ElementTemplateCS
		public Alternatives getMemberIdentifiersAlternatives_4_0_0() { return cMemberIdentifiersAlternatives_4_0_0; }

		//TemplateCS
		public RuleCall getMemberIdentifiersTemplateCSParserRuleCall_4_0_0_0() { return cMemberIdentifiersTemplateCSParserRuleCall_4_0_0_0; }

		//ElementTemplateCS
		public RuleCall getMemberIdentifiersElementTemplateCSParserRuleCall_4_0_0_1() { return cMemberIdentifiersElementTemplateCSParserRuleCall_4_0_0_1; }

		//("," memberIdentifiers+=(TemplateCS | ElementTemplateCS))*
		public Group getGroup_4_1() { return cGroup_4_1; }

		//","
		public Keyword getCommaKeyword_4_1_0() { return cCommaKeyword_4_1_0; }

		//memberIdentifiers+=(TemplateCS | ElementTemplateCS)
		public Assignment getMemberIdentifiersAssignment_4_1_1() { return cMemberIdentifiersAssignment_4_1_1; }

		//TemplateCS | ElementTemplateCS
		public Alternatives getMemberIdentifiersAlternatives_4_1_1_0() { return cMemberIdentifiersAlternatives_4_1_1_0; }

		//TemplateCS
		public RuleCall getMemberIdentifiersTemplateCSParserRuleCall_4_1_1_0_0() { return cMemberIdentifiersTemplateCSParserRuleCall_4_1_1_0_0; }

		//ElementTemplateCS
		public RuleCall getMemberIdentifiersElementTemplateCSParserRuleCall_4_1_1_0_1() { return cMemberIdentifiersElementTemplateCSParserRuleCall_4_1_1_0_1; }

		//"++"
		public Keyword getPlusSignPlusSignKeyword_4_2() { return cPlusSignPlusSignKeyword_4_2; }

		//restIdentifier=[pivot::Variable|UnrestrictedName] | "_"
		public Alternatives getAlternatives_4_3() { return cAlternatives_4_3; }

		//restIdentifier=[pivot::Variable|UnrestrictedName]
		public Assignment getRestIdentifierAssignment_4_3_0() { return cRestIdentifierAssignment_4_3_0; }

		//[pivot::Variable|UnrestrictedName]
		public CrossReference getRestIdentifierVariableCrossReference_4_3_0_0() { return cRestIdentifierVariableCrossReference_4_3_0_0; }

		//UnrestrictedName
		public RuleCall getRestIdentifierVariableUnrestrictedNameParserRuleCall_4_3_0_0_1() { return cRestIdentifierVariableUnrestrictedNameParserRuleCall_4_3_0_0_1; }

		//"_"
		public Keyword get_Keyword_4_3_1() { return c_Keyword_4_3_1; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_5() { return cRightCurlyBracketKeyword_5; }
	}

	public class DefaultValueCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "DefaultValueCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cPropertyIdAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cPropertyIdVariableCrossReference_0_0 = (CrossReference)cPropertyIdAssignment_0.eContents().get(0);
		private final RuleCall cPropertyIdVariableUnrestrictedNameParserRuleCall_0_0_1 = (RuleCall)cPropertyIdVariableCrossReference_0_0.eContents().get(1);
		private final Keyword cEqualsSignKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cInitialiserAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cInitialiserExpCSParserRuleCall_2_0 = (RuleCall)cInitialiserAssignment_2.eContents().get(0);
		private final Keyword cSemicolonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//DefaultValueCS:
		//	propertyId=[pivot::Variable|UnrestrictedName] "=" initialiser=ExpCS ";";
		public ParserRule getRule() { return rule; }

		//propertyId=[pivot::Variable|UnrestrictedName] "=" initialiser=ExpCS ";"
		public Group getGroup() { return cGroup; }

		//propertyId=[pivot::Variable|UnrestrictedName]
		public Assignment getPropertyIdAssignment_0() { return cPropertyIdAssignment_0; }

		//[pivot::Variable|UnrestrictedName]
		public CrossReference getPropertyIdVariableCrossReference_0_0() { return cPropertyIdVariableCrossReference_0_0; }

		//UnrestrictedName
		public RuleCall getPropertyIdVariableUnrestrictedNameParserRuleCall_0_0_1() { return cPropertyIdVariableUnrestrictedNameParserRuleCall_0_0_1; }

		//"="
		public Keyword getEqualsSignKeyword_1() { return cEqualsSignKeyword_1; }

		//initialiser=ExpCS
		public Assignment getInitialiserAssignment_2() { return cInitialiserAssignment_2; }

		//ExpCS
		public RuleCall getInitialiserExpCSParserRuleCall_2_0() { return cInitialiserExpCSParserRuleCall_2_0; }

		//";"
		public Keyword getSemicolonKeyword_3() { return cSemicolonKeyword_3; }
	}

	public class DomainCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "DomainCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Alternatives cAlternatives_0 = (Alternatives)cGroup.eContents().get(0);
		private final Assignment cCheckonlyAssignment_0_0 = (Assignment)cAlternatives_0.eContents().get(0);
		private final Keyword cCheckonlyCheckonlyKeyword_0_0_0 = (Keyword)cCheckonlyAssignment_0_0.eContents().get(0);
		private final Assignment cEnforceAssignment_0_1 = (Assignment)cAlternatives_0.eContents().get(1);
		private final Keyword cEnforceEnforceKeyword_0_1_0 = (Keyword)cEnforceAssignment_0_1.eContents().get(0);
		private final Keyword cReplaceKeyword_0_2 = (Keyword)cAlternatives_0.eContents().get(2);
		private final Keyword cDomainKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cModelIdAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final CrossReference cModelIdTypedModelCrossReference_2_0 = (CrossReference)cModelIdAssignment_2.eContents().get(0);
		private final RuleCall cModelIdTypedModelUnrestrictedNameParserRuleCall_2_0_1 = (RuleCall)cModelIdTypedModelCrossReference_2_0.eContents().get(1);
		private final Assignment cPatternAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cPatternDomainPatternCSParserRuleCall_3_0 = (RuleCall)cPatternAssignment_3.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cImplementedbyKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cImplementedByAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cImplementedByExpCSParserRuleCall_4_1_0 = (RuleCall)cImplementedByAssignment_4_1.eContents().get(0);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cDefault_valuesKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_5_1 = (Keyword)cGroup_5.eContents().get(1);
		private final Assignment cDefaultValuesAssignment_5_2 = (Assignment)cGroup_5.eContents().get(2);
		private final RuleCall cDefaultValuesDefaultValueCSParserRuleCall_5_2_0 = (RuleCall)cDefaultValuesAssignment_5_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_5_3 = (Keyword)cGroup_5.eContents().get(3);
		private final Keyword cSemicolonKeyword_6 = (Keyword)cGroup.eContents().get(6);
		
		//DomainCS:
		//	(checkonly?="checkonly" | enforce?="enforce" | "replace")? "domain" modelId=[qvtbase::TypedModel|UnrestrictedName]
		//	pattern=DomainPatternCS ("implementedby" implementedBy=ExpCS)? ("default_values" "{" defaultValues+=DefaultValueCS+
		//	"}")? ";";
		public ParserRule getRule() { return rule; }

		//(checkonly?="checkonly" | enforce?="enforce" | "replace")? "domain" modelId=[qvtbase::TypedModel|UnrestrictedName]
		//pattern=DomainPatternCS ("implementedby" implementedBy=ExpCS)? ("default_values" "{" defaultValues+=DefaultValueCS+
		//"}")? ";"
		public Group getGroup() { return cGroup; }

		//(checkonly?="checkonly" | enforce?="enforce" | "replace")?
		public Alternatives getAlternatives_0() { return cAlternatives_0; }

		//checkonly?="checkonly"
		public Assignment getCheckonlyAssignment_0_0() { return cCheckonlyAssignment_0_0; }

		//"checkonly"
		public Keyword getCheckonlyCheckonlyKeyword_0_0_0() { return cCheckonlyCheckonlyKeyword_0_0_0; }

		//enforce?="enforce"
		public Assignment getEnforceAssignment_0_1() { return cEnforceAssignment_0_1; }

		//"enforce"
		public Keyword getEnforceEnforceKeyword_0_1_0() { return cEnforceEnforceKeyword_0_1_0; }

		//"replace"
		public Keyword getReplaceKeyword_0_2() { return cReplaceKeyword_0_2; }

		//"domain"
		public Keyword getDomainKeyword_1() { return cDomainKeyword_1; }

		//modelId=[qvtbase::TypedModel|UnrestrictedName]
		public Assignment getModelIdAssignment_2() { return cModelIdAssignment_2; }

		//[qvtbase::TypedModel|UnrestrictedName]
		public CrossReference getModelIdTypedModelCrossReference_2_0() { return cModelIdTypedModelCrossReference_2_0; }

		//UnrestrictedName
		public RuleCall getModelIdTypedModelUnrestrictedNameParserRuleCall_2_0_1() { return cModelIdTypedModelUnrestrictedNameParserRuleCall_2_0_1; }

		//pattern=DomainPatternCS
		public Assignment getPatternAssignment_3() { return cPatternAssignment_3; }

		//DomainPatternCS
		public RuleCall getPatternDomainPatternCSParserRuleCall_3_0() { return cPatternDomainPatternCSParserRuleCall_3_0; }

		//("implementedby" implementedBy=ExpCS)?
		public Group getGroup_4() { return cGroup_4; }

		//"implementedby"
		public Keyword getImplementedbyKeyword_4_0() { return cImplementedbyKeyword_4_0; }

		//implementedBy=ExpCS
		public Assignment getImplementedByAssignment_4_1() { return cImplementedByAssignment_4_1; }

		//ExpCS
		public RuleCall getImplementedByExpCSParserRuleCall_4_1_0() { return cImplementedByExpCSParserRuleCall_4_1_0; }

		//("default_values" "{" defaultValues+=DefaultValueCS+ "}")?
		public Group getGroup_5() { return cGroup_5; }

		//"default_values"
		public Keyword getDefault_valuesKeyword_5_0() { return cDefault_valuesKeyword_5_0; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_5_1() { return cLeftCurlyBracketKeyword_5_1; }

		//defaultValues+=DefaultValueCS+
		public Assignment getDefaultValuesAssignment_5_2() { return cDefaultValuesAssignment_5_2; }

		//DefaultValueCS
		public RuleCall getDefaultValuesDefaultValueCSParserRuleCall_5_2_0() { return cDefaultValuesDefaultValueCSParserRuleCall_5_2_0; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_5_3() { return cRightCurlyBracketKeyword_5_3; }

		//";"
		public Keyword getSemicolonKeyword_6() { return cSemicolonKeyword_6; }
	}

	public class DomainPatternCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "DomainPatternCS");
		private final Assignment cTemplateAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cTemplateTemplateCSParserRuleCall_0 = (RuleCall)cTemplateAssignment.eContents().get(0);
		
		//DomainPatternCS:
		//	template=TemplateCS;
		public ParserRule getRule() { return rule; }

		//template=TemplateCS
		public Assignment getTemplateAssignment() { return cTemplateAssignment; }

		//TemplateCS
		public RuleCall getTemplateTemplateCSParserRuleCall_0() { return cTemplateTemplateCSParserRuleCall_0; }
	}

	public class ElementTemplateCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "ElementTemplateCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cAlternatives.eContents().get(0);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cAlternatives.eContents().get(1);
		private final Action cElementTemplateCSAction_1_0 = (Action)cGroup_1.eContents().get(0);
		private final Keyword c_Keyword_1_1 = (Keyword)cGroup_1.eContents().get(1);
		
		//ElementTemplateCS:
		//	name=UnrestrictedName | {ElementTemplateCS} "_";
		public ParserRule getRule() { return rule; }

		//name=UnrestrictedName | {ElementTemplateCS} "_"
		public Alternatives getAlternatives() { return cAlternatives; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_0_0() { return cNameUnrestrictedNameParserRuleCall_0_0; }

		//{ElementTemplateCS} "_"
		public Group getGroup_1() { return cGroup_1; }

		//{ElementTemplateCS}
		public Action getElementTemplateCSAction_1_0() { return cElementTemplateCSAction_1_0; }

		//"_"
		public Keyword get_Keyword_1_1() { return c_Keyword_1_1; }
	}

	public class KeyDeclCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "KeyDeclCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cKeyKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cPathNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cPathNamePathNameCSParserRuleCall_1_0 = (RuleCall)cPathNameAssignment_1.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Assignment cPropertyIdsAssignment_3_0 = (Assignment)cAlternatives_3.eContents().get(0);
		private final CrossReference cPropertyIdsPropertyCrossReference_3_0_0 = (CrossReference)cPropertyIdsAssignment_3_0.eContents().get(0);
		private final RuleCall cPropertyIdsPropertyUnrestrictedNameParserRuleCall_3_0_0_1 = (RuleCall)cPropertyIdsPropertyCrossReference_3_0_0.eContents().get(1);
		private final Group cGroup_3_1 = (Group)cAlternatives_3.eContents().get(1);
		private final Keyword cOppositeKeyword_3_1_0 = (Keyword)cGroup_3_1.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_3_1_1 = (Keyword)cGroup_3_1.eContents().get(1);
		private final Assignment cOppositePropertyIdsAssignment_3_1_2 = (Assignment)cGroup_3_1.eContents().get(2);
		private final RuleCall cOppositePropertyIdsPathNameCSParserRuleCall_3_1_2_0 = (RuleCall)cOppositePropertyIdsAssignment_3_1_2.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_3_1_3 = (Keyword)cGroup_3_1.eContents().get(3);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cCommaKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Alternatives cAlternatives_4_1 = (Alternatives)cGroup_4.eContents().get(1);
		private final Assignment cPropertyIdsAssignment_4_1_0 = (Assignment)cAlternatives_4_1.eContents().get(0);
		private final CrossReference cPropertyIdsPropertyCrossReference_4_1_0_0 = (CrossReference)cPropertyIdsAssignment_4_1_0.eContents().get(0);
		private final RuleCall cPropertyIdsPropertyUnrestrictedNameParserRuleCall_4_1_0_0_1 = (RuleCall)cPropertyIdsPropertyCrossReference_4_1_0_0.eContents().get(1);
		private final Group cGroup_4_1_1 = (Group)cAlternatives_4_1.eContents().get(1);
		private final Keyword cOppositeKeyword_4_1_1_0 = (Keyword)cGroup_4_1_1.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_4_1_1_1 = (Keyword)cGroup_4_1_1.eContents().get(1);
		private final Assignment cOppositePropertyIdsAssignment_4_1_1_2 = (Assignment)cGroup_4_1_1.eContents().get(2);
		private final RuleCall cOppositePropertyIdsPathNameCSParserRuleCall_4_1_1_2_0 = (RuleCall)cOppositePropertyIdsAssignment_4_1_1_2.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_4_1_1_3 = (Keyword)cGroup_4_1_1.eContents().get(3);
		private final Keyword cRightCurlyBracketKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Keyword cSemicolonKeyword_6 = (Keyword)cGroup.eContents().get(6);
		
		//KeyDeclCS:
		//	"key" pathName=PathNameCS "{" (propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "("
		//	oppositePropertyIds+=PathNameCS ")") ("," (propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "("
		//	oppositePropertyIds+=PathNameCS ")"))* "}" ";";
		public ParserRule getRule() { return rule; }

		//"key" pathName=PathNameCS "{" (propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "("
		//oppositePropertyIds+=PathNameCS ")") ("," (propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "("
		//oppositePropertyIds+=PathNameCS ")"))* "}" ";"
		public Group getGroup() { return cGroup; }

		//"key"
		public Keyword getKeyKeyword_0() { return cKeyKeyword_0; }

		//pathName=PathNameCS
		public Assignment getPathNameAssignment_1() { return cPathNameAssignment_1; }

		//PathNameCS
		public RuleCall getPathNamePathNameCSParserRuleCall_1_0() { return cPathNamePathNameCSParserRuleCall_1_0; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_2() { return cLeftCurlyBracketKeyword_2; }

		//propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "(" oppositePropertyIds+=PathNameCS ")"
		public Alternatives getAlternatives_3() { return cAlternatives_3; }

		//propertyIds+=[pivot::Property|UnrestrictedName]
		public Assignment getPropertyIdsAssignment_3_0() { return cPropertyIdsAssignment_3_0; }

		//[pivot::Property|UnrestrictedName]
		public CrossReference getPropertyIdsPropertyCrossReference_3_0_0() { return cPropertyIdsPropertyCrossReference_3_0_0; }

		//UnrestrictedName
		public RuleCall getPropertyIdsPropertyUnrestrictedNameParserRuleCall_3_0_0_1() { return cPropertyIdsPropertyUnrestrictedNameParserRuleCall_3_0_0_1; }

		//"opposite" "(" oppositePropertyIds+=PathNameCS ")"
		public Group getGroup_3_1() { return cGroup_3_1; }

		//"opposite"
		public Keyword getOppositeKeyword_3_1_0() { return cOppositeKeyword_3_1_0; }

		//"("
		public Keyword getLeftParenthesisKeyword_3_1_1() { return cLeftParenthesisKeyword_3_1_1; }

		//oppositePropertyIds+=PathNameCS
		public Assignment getOppositePropertyIdsAssignment_3_1_2() { return cOppositePropertyIdsAssignment_3_1_2; }

		//PathNameCS
		public RuleCall getOppositePropertyIdsPathNameCSParserRuleCall_3_1_2_0() { return cOppositePropertyIdsPathNameCSParserRuleCall_3_1_2_0; }

		//")"
		public Keyword getRightParenthesisKeyword_3_1_3() { return cRightParenthesisKeyword_3_1_3; }

		//("," (propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "(" oppositePropertyIds+=PathNameCS ")"))*
		public Group getGroup_4() { return cGroup_4; }

		//","
		public Keyword getCommaKeyword_4_0() { return cCommaKeyword_4_0; }

		//propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "(" oppositePropertyIds+=PathNameCS ")"
		public Alternatives getAlternatives_4_1() { return cAlternatives_4_1; }

		//propertyIds+=[pivot::Property|UnrestrictedName]
		public Assignment getPropertyIdsAssignment_4_1_0() { return cPropertyIdsAssignment_4_1_0; }

		//[pivot::Property|UnrestrictedName]
		public CrossReference getPropertyIdsPropertyCrossReference_4_1_0_0() { return cPropertyIdsPropertyCrossReference_4_1_0_0; }

		//UnrestrictedName
		public RuleCall getPropertyIdsPropertyUnrestrictedNameParserRuleCall_4_1_0_0_1() { return cPropertyIdsPropertyUnrestrictedNameParserRuleCall_4_1_0_0_1; }

		//"opposite" "(" oppositePropertyIds+=PathNameCS ")"
		public Group getGroup_4_1_1() { return cGroup_4_1_1; }

		//"opposite"
		public Keyword getOppositeKeyword_4_1_1_0() { return cOppositeKeyword_4_1_1_0; }

		//"("
		public Keyword getLeftParenthesisKeyword_4_1_1_1() { return cLeftParenthesisKeyword_4_1_1_1; }

		//oppositePropertyIds+=PathNameCS
		public Assignment getOppositePropertyIdsAssignment_4_1_1_2() { return cOppositePropertyIdsAssignment_4_1_1_2; }

		//PathNameCS
		public RuleCall getOppositePropertyIdsPathNameCSParserRuleCall_4_1_1_2_0() { return cOppositePropertyIdsPathNameCSParserRuleCall_4_1_1_2_0; }

		//")"
		public Keyword getRightParenthesisKeyword_4_1_1_3() { return cRightParenthesisKeyword_4_1_1_3; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_5() { return cRightCurlyBracketKeyword_5; }

		//";"
		public Keyword getSemicolonKeyword_6() { return cSemicolonKeyword_6; }
	}

	public class LibraryCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "LibraryCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLibraryKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cPackageAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cPackagePackageCrossReference_1_0 = (CrossReference)cPackageAssignment_1.eContents().get(0);
		private final RuleCall cPackagePackageURIParserRuleCall_1_0_1 = (RuleCall)cPackagePackageCrossReference_1_0.eContents().get(1);
		private final Keyword cSemicolonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		
		//LibraryCS returns base::LibraryCS:
		//	"library" package=[pivot::Package|URI] ";";
		public ParserRule getRule() { return rule; }

		//"library" package=[pivot::Package|URI] ";"
		public Group getGroup() { return cGroup; }

		//"library"
		public Keyword getLibraryKeyword_0() { return cLibraryKeyword_0; }

		//package=[pivot::Package|URI]
		public Assignment getPackageAssignment_1() { return cPackageAssignment_1; }

		//[pivot::Package|URI]
		public CrossReference getPackagePackageCrossReference_1_0() { return cPackagePackageCrossReference_1_0; }

		//URI
		public RuleCall getPackagePackageURIParserRuleCall_1_0_1() { return cPackagePackageURIParserRuleCall_1_0_1; }

		//";"
		public Keyword getSemicolonKeyword_2() { return cSemicolonKeyword_2; }
	}

	public class ModelDeclCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "ModelDeclCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Keyword cColonKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Alternatives cAlternatives_2 = (Alternatives)cGroup.eContents().get(2);
		private final Assignment cMetaModelIdsAssignment_2_0 = (Assignment)cAlternatives_2.eContents().get(0);
		private final CrossReference cMetaModelIdsNamespaceCrossReference_2_0_0 = (CrossReference)cMetaModelIdsAssignment_2_0.eContents().get(0);
		private final RuleCall cMetaModelIdsNamespaceUnrestrictedNameParserRuleCall_2_0_0_1 = (RuleCall)cMetaModelIdsNamespaceCrossReference_2_0_0.eContents().get(1);
		private final Group cGroup_2_1 = (Group)cAlternatives_2.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_2_1_0 = (Keyword)cGroup_2_1.eContents().get(0);
		private final Assignment cMetaModelIdsAssignment_2_1_1 = (Assignment)cGroup_2_1.eContents().get(1);
		private final CrossReference cMetaModelIdsNamespaceCrossReference_2_1_1_0 = (CrossReference)cMetaModelIdsAssignment_2_1_1.eContents().get(0);
		private final RuleCall cMetaModelIdsNamespaceUnrestrictedNameParserRuleCall_2_1_1_0_1 = (RuleCall)cMetaModelIdsNamespaceCrossReference_2_1_1_0.eContents().get(1);
		private final Group cGroup_2_1_2 = (Group)cGroup_2_1.eContents().get(2);
		private final Keyword cCommaKeyword_2_1_2_0 = (Keyword)cGroup_2_1_2.eContents().get(0);
		private final Assignment cMetaModelIdsAssignment_2_1_2_1 = (Assignment)cGroup_2_1_2.eContents().get(1);
		private final CrossReference cMetaModelIdsNamespaceCrossReference_2_1_2_1_0 = (CrossReference)cMetaModelIdsAssignment_2_1_2_1.eContents().get(0);
		private final RuleCall cMetaModelIdsNamespaceUnrestrictedNameParserRuleCall_2_1_2_1_0_1 = (RuleCall)cMetaModelIdsNamespaceCrossReference_2_1_2_1_0.eContents().get(1);
		private final Keyword cRightCurlyBracketKeyword_2_1_3 = (Keyword)cGroup_2_1.eContents().get(3);
		
		//ModelDeclCS:
		//	name=UnrestrictedName ":" (metaModelIds+=[pivot::Namespace|UnrestrictedName] | "{"
		//	metaModelIds+=[pivot::Namespace|UnrestrictedName] ("," metaModelIds+=[pivot::Namespace|UnrestrictedName])* "}");
		public ParserRule getRule() { return rule; }

		//name=UnrestrictedName ":" (metaModelIds+=[pivot::Namespace|UnrestrictedName] | "{"
		//metaModelIds+=[pivot::Namespace|UnrestrictedName] ("," metaModelIds+=[pivot::Namespace|UnrestrictedName])* "}")
		public Group getGroup() { return cGroup; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_0_0() { return cNameUnrestrictedNameParserRuleCall_0_0; }

		//":"
		public Keyword getColonKeyword_1() { return cColonKeyword_1; }

		//metaModelIds+=[pivot::Namespace|UnrestrictedName] | "{" metaModelIds+=[pivot::Namespace|UnrestrictedName] (","
		//metaModelIds+=[pivot::Namespace|UnrestrictedName])* "}"
		public Alternatives getAlternatives_2() { return cAlternatives_2; }

		//metaModelIds+=[pivot::Namespace|UnrestrictedName]
		public Assignment getMetaModelIdsAssignment_2_0() { return cMetaModelIdsAssignment_2_0; }

		//[pivot::Namespace|UnrestrictedName]
		public CrossReference getMetaModelIdsNamespaceCrossReference_2_0_0() { return cMetaModelIdsNamespaceCrossReference_2_0_0; }

		//UnrestrictedName
		public RuleCall getMetaModelIdsNamespaceUnrestrictedNameParserRuleCall_2_0_0_1() { return cMetaModelIdsNamespaceUnrestrictedNameParserRuleCall_2_0_0_1; }

		//"{" metaModelIds+=[pivot::Namespace|UnrestrictedName] ("," metaModelIds+=[pivot::Namespace|UnrestrictedName])* "}"
		public Group getGroup_2_1() { return cGroup_2_1; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_2_1_0() { return cLeftCurlyBracketKeyword_2_1_0; }

		//metaModelIds+=[pivot::Namespace|UnrestrictedName]
		public Assignment getMetaModelIdsAssignment_2_1_1() { return cMetaModelIdsAssignment_2_1_1; }

		//[pivot::Namespace|UnrestrictedName]
		public CrossReference getMetaModelIdsNamespaceCrossReference_2_1_1_0() { return cMetaModelIdsNamespaceCrossReference_2_1_1_0; }

		//UnrestrictedName
		public RuleCall getMetaModelIdsNamespaceUnrestrictedNameParserRuleCall_2_1_1_0_1() { return cMetaModelIdsNamespaceUnrestrictedNameParserRuleCall_2_1_1_0_1; }

		//("," metaModelIds+=[pivot::Namespace|UnrestrictedName])*
		public Group getGroup_2_1_2() { return cGroup_2_1_2; }

		//","
		public Keyword getCommaKeyword_2_1_2_0() { return cCommaKeyword_2_1_2_0; }

		//metaModelIds+=[pivot::Namespace|UnrestrictedName]
		public Assignment getMetaModelIdsAssignment_2_1_2_1() { return cMetaModelIdsAssignment_2_1_2_1; }

		//[pivot::Namespace|UnrestrictedName]
		public CrossReference getMetaModelIdsNamespaceCrossReference_2_1_2_1_0() { return cMetaModelIdsNamespaceCrossReference_2_1_2_1_0; }

		//UnrestrictedName
		public RuleCall getMetaModelIdsNamespaceUnrestrictedNameParserRuleCall_2_1_2_1_0_1() { return cMetaModelIdsNamespaceUnrestrictedNameParserRuleCall_2_1_2_1_0_1; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_2_1_3() { return cRightCurlyBracketKeyword_2_1_3; }
	}

	public class ObjectTemplateCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "ObjectTemplateCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Keyword cColonKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cTypeAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cTypeTypedRefCSParserRuleCall_2_0 = (RuleCall)cTypeAssignment_2.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Assignment cPropertyTemplatesAssignment_4_0 = (Assignment)cGroup_4.eContents().get(0);
		private final RuleCall cPropertyTemplatesPropertyTemplateCSParserRuleCall_4_0_0 = (RuleCall)cPropertyTemplatesAssignment_4_0.eContents().get(0);
		private final Group cGroup_4_1 = (Group)cGroup_4.eContents().get(1);
		private final Keyword cCommaKeyword_4_1_0 = (Keyword)cGroup_4_1.eContents().get(0);
		private final Assignment cPropertyTemplatesAssignment_4_1_1 = (Assignment)cGroup_4_1.eContents().get(1);
		private final RuleCall cPropertyTemplatesPropertyTemplateCSParserRuleCall_4_1_1_0 = (RuleCall)cPropertyTemplatesAssignment_4_1_1.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		//ObjectTemplateCS:
		//	name=UnrestrictedName? ":" type=TypedRefCS "{" (propertyTemplates+=PropertyTemplateCS (","
		//	propertyTemplates+=PropertyTemplateCS)*)? "}";
		public ParserRule getRule() { return rule; }

		//name=UnrestrictedName? ":" type=TypedRefCS "{" (propertyTemplates+=PropertyTemplateCS (","
		//propertyTemplates+=PropertyTemplateCS)*)? "}"
		public Group getGroup() { return cGroup; }

		//name=UnrestrictedName?
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_0_0() { return cNameUnrestrictedNameParserRuleCall_0_0; }

		//":"
		public Keyword getColonKeyword_1() { return cColonKeyword_1; }

		//type=TypedRefCS
		public Assignment getTypeAssignment_2() { return cTypeAssignment_2; }

		//TypedRefCS
		public RuleCall getTypeTypedRefCSParserRuleCall_2_0() { return cTypeTypedRefCSParserRuleCall_2_0; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_3() { return cLeftCurlyBracketKeyword_3; }

		//(propertyTemplates+=PropertyTemplateCS ("," propertyTemplates+=PropertyTemplateCS)*)?
		public Group getGroup_4() { return cGroup_4; }

		//propertyTemplates+=PropertyTemplateCS
		public Assignment getPropertyTemplatesAssignment_4_0() { return cPropertyTemplatesAssignment_4_0; }

		//PropertyTemplateCS
		public RuleCall getPropertyTemplatesPropertyTemplateCSParserRuleCall_4_0_0() { return cPropertyTemplatesPropertyTemplateCSParserRuleCall_4_0_0; }

		//("," propertyTemplates+=PropertyTemplateCS)*
		public Group getGroup_4_1() { return cGroup_4_1; }

		//","
		public Keyword getCommaKeyword_4_1_0() { return cCommaKeyword_4_1_0; }

		//propertyTemplates+=PropertyTemplateCS
		public Assignment getPropertyTemplatesAssignment_4_1_1() { return cPropertyTemplatesAssignment_4_1_1; }

		//PropertyTemplateCS
		public RuleCall getPropertyTemplatesPropertyTemplateCSParserRuleCall_4_1_1_0() { return cPropertyTemplatesPropertyTemplateCSParserRuleCall_4_1_1_0; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_5() { return cRightCurlyBracketKeyword_5; }
	}

	public class ParamDeclarationCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "ParamDeclarationCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Keyword cColonKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cOwnedTypeAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cOwnedTypeTypedRefCSParserRuleCall_2_0 = (RuleCall)cOwnedTypeAssignment_2.eContents().get(0);
		
		//ParamDeclarationCS:
		//	name=UnrestrictedName ":" ownedType=TypedRefCS;
		public ParserRule getRule() { return rule; }

		//name=UnrestrictedName ":" ownedType=TypedRefCS
		public Group getGroup() { return cGroup; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_0_0() { return cNameUnrestrictedNameParserRuleCall_0_0; }

		//":"
		public Keyword getColonKeyword_1() { return cColonKeyword_1; }

		//ownedType=TypedRefCS
		public Assignment getOwnedTypeAssignment_2() { return cOwnedTypeAssignment_2; }

		//TypedRefCS
		public RuleCall getOwnedTypeTypedRefCSParserRuleCall_2_0() { return cOwnedTypeTypedRefCSParserRuleCall_2_0; }
	}

	public class PredicateCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "PredicateCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cExprAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cExprExpCSParserRuleCall_0_0 = (RuleCall)cExprAssignment_0.eContents().get(0);
		private final Keyword cSemicolonKeyword_1 = (Keyword)cGroup.eContents().get(1);
		
		//PredicateCS:
		//	expr=ExpCS ";";
		public ParserRule getRule() { return rule; }

		//expr=ExpCS ";"
		public Group getGroup() { return cGroup; }

		//expr=ExpCS
		public Assignment getExprAssignment_0() { return cExprAssignment_0; }

		//ExpCS
		public RuleCall getExprExpCSParserRuleCall_0_0() { return cExprExpCSParserRuleCall_0_0; }

		//";"
		public Keyword getSemicolonKeyword_1() { return cSemicolonKeyword_1; }
	}

	public class PrimitiveTypeDomainCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "PrimitiveTypeDomainCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cPrimitiveKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cDomainKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final Keyword cColonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cTypeAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cTypeTypedRefCSParserRuleCall_4_0 = (RuleCall)cTypeAssignment_4.eContents().get(0);
		private final Keyword cSemicolonKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		//PrimitiveTypeDomainCS:
		//	"primitive" "domain" name=UnrestrictedName ":" type=TypedRefCS ";";
		public ParserRule getRule() { return rule; }

		//"primitive" "domain" name=UnrestrictedName ":" type=TypedRefCS ";"
		public Group getGroup() { return cGroup; }

		//"primitive"
		public Keyword getPrimitiveKeyword_0() { return cPrimitiveKeyword_0; }

		//"domain"
		public Keyword getDomainKeyword_1() { return cDomainKeyword_1; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_2_0() { return cNameUnrestrictedNameParserRuleCall_2_0; }

		//":"
		public Keyword getColonKeyword_3() { return cColonKeyword_3; }

		//type=TypedRefCS
		public Assignment getTypeAssignment_4() { return cTypeAssignment_4; }

		//TypedRefCS
		public RuleCall getTypeTypedRefCSParserRuleCall_4_0() { return cTypeTypedRefCSParserRuleCall_4_0; }

		//";"
		public Keyword getSemicolonKeyword_5() { return cSemicolonKeyword_5; }
	}

	public class PropertyTemplateCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "PropertyTemplateCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Alternatives cAlternatives_0 = (Alternatives)cGroup.eContents().get(0);
		private final Assignment cPropertyIdAssignment_0_0 = (Assignment)cAlternatives_0.eContents().get(0);
		private final CrossReference cPropertyIdPropertyCrossReference_0_0_0 = (CrossReference)cPropertyIdAssignment_0_0.eContents().get(0);
		private final RuleCall cPropertyIdPropertyUnrestrictedNameParserRuleCall_0_0_0_1 = (RuleCall)cPropertyIdPropertyCrossReference_0_0_0.eContents().get(1);
		private final Group cGroup_0_1 = (Group)cAlternatives_0.eContents().get(1);
		private final Keyword cOppositeKeyword_0_1_0 = (Keyword)cGroup_0_1.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_0_1_1 = (Keyword)cGroup_0_1.eContents().get(1);
		private final Assignment cOppositePropertyIdAssignment_0_1_2 = (Assignment)cGroup_0_1.eContents().get(2);
		private final RuleCall cOppositePropertyIdPathNameCSParserRuleCall_0_1_2_0 = (RuleCall)cOppositePropertyIdAssignment_0_1_2.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_0_1_3 = (Keyword)cGroup_0_1.eContents().get(3);
		private final Keyword cEqualsSignKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cExpressionAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cExpressionExpCSOrTemplateCSParserRuleCall_2_0 = (RuleCall)cExpressionAssignment_2.eContents().get(0);
		
		//PropertyTemplateCS:
		//	(propertyId=[pivot::Property|UnrestrictedName] | "opposite" "(" oppositePropertyId=PathNameCS ")") "="
		//	expression=ExpCSOrTemplateCS;
		public ParserRule getRule() { return rule; }

		//(propertyId=[pivot::Property|UnrestrictedName] | "opposite" "(" oppositePropertyId=PathNameCS ")") "="
		//expression=ExpCSOrTemplateCS
		public Group getGroup() { return cGroup; }

		//propertyId=[pivot::Property|UnrestrictedName] | "opposite" "(" oppositePropertyId=PathNameCS ")"
		public Alternatives getAlternatives_0() { return cAlternatives_0; }

		//propertyId=[pivot::Property|UnrestrictedName]
		public Assignment getPropertyIdAssignment_0_0() { return cPropertyIdAssignment_0_0; }

		//[pivot::Property|UnrestrictedName]
		public CrossReference getPropertyIdPropertyCrossReference_0_0_0() { return cPropertyIdPropertyCrossReference_0_0_0; }

		//UnrestrictedName
		public RuleCall getPropertyIdPropertyUnrestrictedNameParserRuleCall_0_0_0_1() { return cPropertyIdPropertyUnrestrictedNameParserRuleCall_0_0_0_1; }

		//"opposite" "(" oppositePropertyId=PathNameCS ")"
		public Group getGroup_0_1() { return cGroup_0_1; }

		//"opposite"
		public Keyword getOppositeKeyword_0_1_0() { return cOppositeKeyword_0_1_0; }

		//"("
		public Keyword getLeftParenthesisKeyword_0_1_1() { return cLeftParenthesisKeyword_0_1_1; }

		//oppositePropertyId=PathNameCS
		public Assignment getOppositePropertyIdAssignment_0_1_2() { return cOppositePropertyIdAssignment_0_1_2; }

		//PathNameCS
		public RuleCall getOppositePropertyIdPathNameCSParserRuleCall_0_1_2_0() { return cOppositePropertyIdPathNameCSParserRuleCall_0_1_2_0; }

		//")"
		public Keyword getRightParenthesisKeyword_0_1_3() { return cRightParenthesisKeyword_0_1_3; }

		//"="
		public Keyword getEqualsSignKeyword_1() { return cEqualsSignKeyword_1; }

		//expression=ExpCSOrTemplateCS
		public Assignment getExpressionAssignment_2() { return cExpressionAssignment_2; }

		//ExpCSOrTemplateCS
		public RuleCall getExpressionExpCSOrTemplateCSParserRuleCall_2_0() { return cExpressionExpCSOrTemplateCSParserRuleCall_2_0; }
	}

	public class QueryCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "QueryCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cQueryKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Assignment cInputParamDeclarationsAssignment_3_0 = (Assignment)cGroup_3.eContents().get(0);
		private final RuleCall cInputParamDeclarationsParamDeclarationCSParserRuleCall_3_0_0 = (RuleCall)cInputParamDeclarationsAssignment_3_0.eContents().get(0);
		private final Group cGroup_3_1 = (Group)cGroup_3.eContents().get(1);
		private final Keyword cCommaKeyword_3_1_0 = (Keyword)cGroup_3_1.eContents().get(0);
		private final Assignment cInputParamDeclarationsAssignment_3_1_1 = (Assignment)cGroup_3_1.eContents().get(1);
		private final RuleCall cInputParamDeclarationsParamDeclarationCSParserRuleCall_3_1_1_0 = (RuleCall)cInputParamDeclarationsAssignment_3_1_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Keyword cColonKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cOwnedTypeAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cOwnedTypeTypedRefCSParserRuleCall_6_0 = (RuleCall)cOwnedTypeAssignment_6.eContents().get(0);
		private final Alternatives cAlternatives_7 = (Alternatives)cGroup.eContents().get(7);
		private final Keyword cSemicolonKeyword_7_0 = (Keyword)cAlternatives_7.eContents().get(0);
		private final Group cGroup_7_1 = (Group)cAlternatives_7.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_7_1_0 = (Keyword)cGroup_7_1.eContents().get(0);
		private final Assignment cExpressionAssignment_7_1_1 = (Assignment)cGroup_7_1.eContents().get(1);
		private final RuleCall cExpressionExpCSParserRuleCall_7_1_1_0 = (RuleCall)cExpressionAssignment_7_1_1.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_7_1_2 = (Keyword)cGroup_7_1.eContents().get(2);
		
		//QueryCS:
		//	"query" name=UnrestrictedName "(" (inputParamDeclarations+=ParamDeclarationCS (","
		//	inputParamDeclarations+=ParamDeclarationCS)*)? ")" ":" ownedType=TypedRefCS (";" | "{" expression=ExpCS "}");
		public ParserRule getRule() { return rule; }

		//"query" name=UnrestrictedName "(" (inputParamDeclarations+=ParamDeclarationCS (","
		//inputParamDeclarations+=ParamDeclarationCS)*)? ")" ":" ownedType=TypedRefCS (";" | "{" expression=ExpCS "}")
		public Group getGroup() { return cGroup; }

		//"query"
		public Keyword getQueryKeyword_0() { return cQueryKeyword_0; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_1_0() { return cNameUnrestrictedNameParserRuleCall_1_0; }

		//"("
		public Keyword getLeftParenthesisKeyword_2() { return cLeftParenthesisKeyword_2; }

		//(inputParamDeclarations+=ParamDeclarationCS ("," inputParamDeclarations+=ParamDeclarationCS)*)?
		public Group getGroup_3() { return cGroup_3; }

		//inputParamDeclarations+=ParamDeclarationCS
		public Assignment getInputParamDeclarationsAssignment_3_0() { return cInputParamDeclarationsAssignment_3_0; }

		//ParamDeclarationCS
		public RuleCall getInputParamDeclarationsParamDeclarationCSParserRuleCall_3_0_0() { return cInputParamDeclarationsParamDeclarationCSParserRuleCall_3_0_0; }

		//("," inputParamDeclarations+=ParamDeclarationCS)*
		public Group getGroup_3_1() { return cGroup_3_1; }

		//","
		public Keyword getCommaKeyword_3_1_0() { return cCommaKeyword_3_1_0; }

		//inputParamDeclarations+=ParamDeclarationCS
		public Assignment getInputParamDeclarationsAssignment_3_1_1() { return cInputParamDeclarationsAssignment_3_1_1; }

		//ParamDeclarationCS
		public RuleCall getInputParamDeclarationsParamDeclarationCSParserRuleCall_3_1_1_0() { return cInputParamDeclarationsParamDeclarationCSParserRuleCall_3_1_1_0; }

		//")"
		public Keyword getRightParenthesisKeyword_4() { return cRightParenthesisKeyword_4; }

		//":"
		public Keyword getColonKeyword_5() { return cColonKeyword_5; }

		//ownedType=TypedRefCS
		public Assignment getOwnedTypeAssignment_6() { return cOwnedTypeAssignment_6; }

		//TypedRefCS
		public RuleCall getOwnedTypeTypedRefCSParserRuleCall_6_0() { return cOwnedTypeTypedRefCSParserRuleCall_6_0; }

		//";" | "{" expression=ExpCS "}"
		public Alternatives getAlternatives_7() { return cAlternatives_7; }

		//";"
		public Keyword getSemicolonKeyword_7_0() { return cSemicolonKeyword_7_0; }

		//"{" expression=ExpCS "}"
		public Group getGroup_7_1() { return cGroup_7_1; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_7_1_0() { return cLeftCurlyBracketKeyword_7_1_0; }

		//expression=ExpCS
		public Assignment getExpressionAssignment_7_1_1() { return cExpressionAssignment_7_1_1; }

		//ExpCS
		public RuleCall getExpressionExpCSParserRuleCall_7_1_1_0() { return cExpressionExpCSParserRuleCall_7_1_1_0; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_7_1_2() { return cRightCurlyBracketKeyword_7_1_2; }
	}

	public class RelationCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "RelationCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cTopAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final Keyword cTopTopKeyword_0_0 = (Keyword)cTopAssignment_0.eContents().get(0);
		private final Keyword cRelationKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cOverridesKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cOverridesAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final CrossReference cOverridesRelationCrossReference_3_1_0 = (CrossReference)cOverridesAssignment_3_1.eContents().get(0);
		private final RuleCall cOverridesRelationUnrestrictedNameParserRuleCall_3_1_0_1 = (RuleCall)cOverridesRelationCrossReference_3_1_0.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cVarDeclarationsAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cVarDeclarationsVarDeclarationCSParserRuleCall_5_0 = (RuleCall)cVarDeclarationsAssignment_5.eContents().get(0);
		private final Alternatives cAlternatives_6 = (Alternatives)cGroup.eContents().get(6);
		private final Assignment cDomainsAssignment_6_0 = (Assignment)cAlternatives_6.eContents().get(0);
		private final RuleCall cDomainsDomainCSParserRuleCall_6_0_0 = (RuleCall)cDomainsAssignment_6_0.eContents().get(0);
		private final Assignment cDomainsAssignment_6_1 = (Assignment)cAlternatives_6.eContents().get(1);
		private final RuleCall cDomainsPrimitiveTypeDomainCSParserRuleCall_6_1_0 = (RuleCall)cDomainsAssignment_6_1.eContents().get(0);
		private final Assignment cWhenAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final RuleCall cWhenWhenCSParserRuleCall_7_0 = (RuleCall)cWhenAssignment_7.eContents().get(0);
		private final Assignment cWhereAssignment_8 = (Assignment)cGroup.eContents().get(8);
		private final RuleCall cWhereWhereCSParserRuleCall_8_0 = (RuleCall)cWhereAssignment_8.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_9 = (Keyword)cGroup.eContents().get(9);
		
		//RelationCS:
		//	top?="top"? "relation" name=UnrestrictedName ("overrides" overrides=[qvtrelation::Relation|UnrestrictedName])? "{"
		//	varDeclarations+=VarDeclarationCS* (domains+=DomainCS | domains+=PrimitiveTypeDomainCS)+ when=WhenCS? where=WhereCS?
		//	"}";
		public ParserRule getRule() { return rule; }

		//top?="top"? "relation" name=UnrestrictedName ("overrides" overrides=[qvtrelation::Relation|UnrestrictedName])? "{"
		//varDeclarations+=VarDeclarationCS* (domains+=DomainCS | domains+=PrimitiveTypeDomainCS)+ when=WhenCS? where=WhereCS?
		//"}"
		public Group getGroup() { return cGroup; }

		//top?="top"?
		public Assignment getTopAssignment_0() { return cTopAssignment_0; }

		//"top"
		public Keyword getTopTopKeyword_0_0() { return cTopTopKeyword_0_0; }

		//"relation"
		public Keyword getRelationKeyword_1() { return cRelationKeyword_1; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_2_0() { return cNameUnrestrictedNameParserRuleCall_2_0; }

		//("overrides" overrides=[qvtrelation::Relation|UnrestrictedName])?
		public Group getGroup_3() { return cGroup_3; }

		//"overrides"
		public Keyword getOverridesKeyword_3_0() { return cOverridesKeyword_3_0; }

		//overrides=[qvtrelation::Relation|UnrestrictedName]
		public Assignment getOverridesAssignment_3_1() { return cOverridesAssignment_3_1; }

		//[qvtrelation::Relation|UnrestrictedName]
		public CrossReference getOverridesRelationCrossReference_3_1_0() { return cOverridesRelationCrossReference_3_1_0; }

		//UnrestrictedName
		public RuleCall getOverridesRelationUnrestrictedNameParserRuleCall_3_1_0_1() { return cOverridesRelationUnrestrictedNameParserRuleCall_3_1_0_1; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_4() { return cLeftCurlyBracketKeyword_4; }

		//varDeclarations+=VarDeclarationCS*
		public Assignment getVarDeclarationsAssignment_5() { return cVarDeclarationsAssignment_5; }

		//VarDeclarationCS
		public RuleCall getVarDeclarationsVarDeclarationCSParserRuleCall_5_0() { return cVarDeclarationsVarDeclarationCSParserRuleCall_5_0; }

		//(domains+=DomainCS | domains+=PrimitiveTypeDomainCS)+
		public Alternatives getAlternatives_6() { return cAlternatives_6; }

		//domains+=DomainCS
		public Assignment getDomainsAssignment_6_0() { return cDomainsAssignment_6_0; }

		//DomainCS
		public RuleCall getDomainsDomainCSParserRuleCall_6_0_0() { return cDomainsDomainCSParserRuleCall_6_0_0; }

		//domains+=PrimitiveTypeDomainCS
		public Assignment getDomainsAssignment_6_1() { return cDomainsAssignment_6_1; }

		//PrimitiveTypeDomainCS
		public RuleCall getDomainsPrimitiveTypeDomainCSParserRuleCall_6_1_0() { return cDomainsPrimitiveTypeDomainCSParserRuleCall_6_1_0; }

		//when=WhenCS?
		public Assignment getWhenAssignment_7() { return cWhenAssignment_7; }

		//WhenCS
		public RuleCall getWhenWhenCSParserRuleCall_7_0() { return cWhenWhenCSParserRuleCall_7_0; }

		//where=WhereCS?
		public Assignment getWhereAssignment_8() { return cWhereAssignment_8; }

		//WhereCS
		public RuleCall getWhereWhereCSParserRuleCall_8_0() { return cWhereWhereCSParserRuleCall_8_0; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_9() { return cRightCurlyBracketKeyword_9; }
	}

	public class TemplateCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TemplateCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Alternatives cAlternatives_0 = (Alternatives)cGroup.eContents().get(0);
		private final RuleCall cCollectionTemplateCSParserRuleCall_0_0 = (RuleCall)cAlternatives_0.eContents().get(0);
		private final RuleCall cObjectTemplateCSParserRuleCall_0_1 = (RuleCall)cAlternatives_0.eContents().get(1);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cGuardExpressionAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cGuardExpressionExpCSParserRuleCall_1_1_0 = (RuleCall)cGuardExpressionAssignment_1_1.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_1_2 = (Keyword)cGroup_1.eContents().get(2);
		
		//TemplateCS:
		//	(CollectionTemplateCS | ObjectTemplateCS) ("{" guardExpression=ExpCS "}")?;
		public ParserRule getRule() { return rule; }

		//(CollectionTemplateCS | ObjectTemplateCS) ("{" guardExpression=ExpCS "}")?
		public Group getGroup() { return cGroup; }

		//CollectionTemplateCS | ObjectTemplateCS
		public Alternatives getAlternatives_0() { return cAlternatives_0; }

		//CollectionTemplateCS
		public RuleCall getCollectionTemplateCSParserRuleCall_0_0() { return cCollectionTemplateCSParserRuleCall_0_0; }

		//ObjectTemplateCS
		public RuleCall getObjectTemplateCSParserRuleCall_0_1() { return cObjectTemplateCSParserRuleCall_0_1; }

		//("{" guardExpression=ExpCS "}")?
		public Group getGroup_1() { return cGroup_1; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_1_0() { return cLeftCurlyBracketKeyword_1_0; }

		//guardExpression=ExpCS
		public Assignment getGuardExpressionAssignment_1_1() { return cGuardExpressionAssignment_1_1; }

		//ExpCS
		public RuleCall getGuardExpressionExpCSParserRuleCall_1_1_0() { return cGuardExpressionExpCSParserRuleCall_1_1_0; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_1_2() { return cRightCurlyBracketKeyword_1_2; }
	}

	public class TransformationCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TransformationCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cTransformationKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cModelDeclsAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cModelDeclsModelDeclCSParserRuleCall_3_0 = (RuleCall)cModelDeclsAssignment_3.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cCommaKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cModelDeclsAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final RuleCall cModelDeclsModelDeclCSParserRuleCall_4_1_0 = (RuleCall)cModelDeclsAssignment_4_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Group cGroup_6 = (Group)cGroup.eContents().get(6);
		private final Keyword cExtendsKeyword_6_0 = (Keyword)cGroup_6.eContents().get(0);
		private final Assignment cExtendsAssignment_6_1 = (Assignment)cGroup_6.eContents().get(1);
		private final CrossReference cExtendsTransformationCrossReference_6_1_0 = (CrossReference)cExtendsAssignment_6_1.eContents().get(0);
		private final RuleCall cExtendsTransformationUnrestrictedNameParserRuleCall_6_1_0_1 = (RuleCall)cExtendsTransformationCrossReference_6_1_0.eContents().get(1);
		private final Group cGroup_6_2 = (Group)cGroup_6.eContents().get(2);
		private final Keyword cCommaKeyword_6_2_0 = (Keyword)cGroup_6_2.eContents().get(0);
		private final Assignment cExtendsAssignment_6_2_1 = (Assignment)cGroup_6_2.eContents().get(1);
		private final CrossReference cExtendsTransformationCrossReference_6_2_1_0 = (CrossReference)cExtendsAssignment_6_2_1.eContents().get(0);
		private final RuleCall cExtendsTransformationUnrestrictedNameParserRuleCall_6_2_1_0_1 = (RuleCall)cExtendsTransformationCrossReference_6_2_1_0.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_7 = (Keyword)cGroup.eContents().get(7);
		private final Assignment cKeyDeclsAssignment_8 = (Assignment)cGroup.eContents().get(8);
		private final RuleCall cKeyDeclsKeyDeclCSParserRuleCall_8_0 = (RuleCall)cKeyDeclsAssignment_8.eContents().get(0);
		private final Alternatives cAlternatives_9 = (Alternatives)cGroup.eContents().get(9);
		private final Assignment cRelationAssignment_9_0 = (Assignment)cAlternatives_9.eContents().get(0);
		private final RuleCall cRelationRelationCSParserRuleCall_9_0_0 = (RuleCall)cRelationAssignment_9_0.eContents().get(0);
		private final Assignment cQueriesAssignment_9_1 = (Assignment)cAlternatives_9.eContents().get(1);
		private final RuleCall cQueriesQueryCSParserRuleCall_9_1_0 = (RuleCall)cQueriesAssignment_9_1.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_10 = (Keyword)cGroup.eContents().get(10);
		
		//TransformationCS:
		//	"transformation" name=UnrestrictedName "(" modelDecls+=ModelDeclCS ("," modelDecls+=ModelDeclCS)* ")" ("extends"
		//	extends+=[qvtbase::Transformation|UnrestrictedName] ("," extends+=[qvtbase::Transformation|UnrestrictedName])*)? "{"
		//	keyDecls+=KeyDeclCS* (relation+=RelationCS | queries+=QueryCS)* "}";
		public ParserRule getRule() { return rule; }

		//"transformation" name=UnrestrictedName "(" modelDecls+=ModelDeclCS ("," modelDecls+=ModelDeclCS)* ")" ("extends"
		//extends+=[qvtbase::Transformation|UnrestrictedName] ("," extends+=[qvtbase::Transformation|UnrestrictedName])*)? "{"
		//keyDecls+=KeyDeclCS* (relation+=RelationCS | queries+=QueryCS)* "}"
		public Group getGroup() { return cGroup; }

		//"transformation"
		public Keyword getTransformationKeyword_0() { return cTransformationKeyword_0; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_1_0() { return cNameUnrestrictedNameParserRuleCall_1_0; }

		//"("
		public Keyword getLeftParenthesisKeyword_2() { return cLeftParenthesisKeyword_2; }

		//modelDecls+=ModelDeclCS
		public Assignment getModelDeclsAssignment_3() { return cModelDeclsAssignment_3; }

		//ModelDeclCS
		public RuleCall getModelDeclsModelDeclCSParserRuleCall_3_0() { return cModelDeclsModelDeclCSParserRuleCall_3_0; }

		//("," modelDecls+=ModelDeclCS)*
		public Group getGroup_4() { return cGroup_4; }

		//","
		public Keyword getCommaKeyword_4_0() { return cCommaKeyword_4_0; }

		//modelDecls+=ModelDeclCS
		public Assignment getModelDeclsAssignment_4_1() { return cModelDeclsAssignment_4_1; }

		//ModelDeclCS
		public RuleCall getModelDeclsModelDeclCSParserRuleCall_4_1_0() { return cModelDeclsModelDeclCSParserRuleCall_4_1_0; }

		//")"
		public Keyword getRightParenthesisKeyword_5() { return cRightParenthesisKeyword_5; }

		//("extends" extends+=[qvtbase::Transformation|UnrestrictedName] (","
		//extends+=[qvtbase::Transformation|UnrestrictedName])*)?
		public Group getGroup_6() { return cGroup_6; }

		//"extends"
		public Keyword getExtendsKeyword_6_0() { return cExtendsKeyword_6_0; }

		//extends+=[qvtbase::Transformation|UnrestrictedName]
		public Assignment getExtendsAssignment_6_1() { return cExtendsAssignment_6_1; }

		//[qvtbase::Transformation|UnrestrictedName]
		public CrossReference getExtendsTransformationCrossReference_6_1_0() { return cExtendsTransformationCrossReference_6_1_0; }

		//UnrestrictedName
		public RuleCall getExtendsTransformationUnrestrictedNameParserRuleCall_6_1_0_1() { return cExtendsTransformationUnrestrictedNameParserRuleCall_6_1_0_1; }

		//("," extends+=[qvtbase::Transformation|UnrestrictedName])*
		public Group getGroup_6_2() { return cGroup_6_2; }

		//","
		public Keyword getCommaKeyword_6_2_0() { return cCommaKeyword_6_2_0; }

		//extends+=[qvtbase::Transformation|UnrestrictedName]
		public Assignment getExtendsAssignment_6_2_1() { return cExtendsAssignment_6_2_1; }

		//[qvtbase::Transformation|UnrestrictedName]
		public CrossReference getExtendsTransformationCrossReference_6_2_1_0() { return cExtendsTransformationCrossReference_6_2_1_0; }

		//UnrestrictedName
		public RuleCall getExtendsTransformationUnrestrictedNameParserRuleCall_6_2_1_0_1() { return cExtendsTransformationUnrestrictedNameParserRuleCall_6_2_1_0_1; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_7() { return cLeftCurlyBracketKeyword_7; }

		//keyDecls+=KeyDeclCS*
		public Assignment getKeyDeclsAssignment_8() { return cKeyDeclsAssignment_8; }

		//KeyDeclCS
		public RuleCall getKeyDeclsKeyDeclCSParserRuleCall_8_0() { return cKeyDeclsKeyDeclCSParserRuleCall_8_0; }

		//(relation+=RelationCS | queries+=QueryCS)*
		public Alternatives getAlternatives_9() { return cAlternatives_9; }

		//relation+=RelationCS
		public Assignment getRelationAssignment_9_0() { return cRelationAssignment_9_0; }

		//RelationCS
		public RuleCall getRelationRelationCSParserRuleCall_9_0_0() { return cRelationRelationCSParserRuleCall_9_0_0; }

		//queries+=QueryCS
		public Assignment getQueriesAssignment_9_1() { return cQueriesAssignment_9_1; }

		//QueryCS
		public RuleCall getQueriesQueryCSParserRuleCall_9_1_0() { return cQueriesQueryCSParserRuleCall_9_1_0; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_10() { return cRightCurlyBracketKeyword_10; }
	}

	public class UnitCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "UnitCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cImportKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_1_0 = (Assignment)cGroup_1.eContents().get(0);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_1_0_0 = (RuleCall)cNameAssignment_1_0.eContents().get(0);
		private final Keyword cColonKeyword_1_1 = (Keyword)cGroup_1.eContents().get(1);
		private final Assignment cPathNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cPathNameURIPathNameCSParserRuleCall_2_0 = (RuleCall)cPathNameAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cColonColonKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cAllAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final Keyword cAllAsteriskKeyword_3_1_0 = (Keyword)cAllAssignment_3_1.eContents().get(0);
		private final Keyword cSemicolonKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//UnitCS returns base::ImportCS:
		//	"import" (name=UnrestrictedName ":")? pathName=URIPathNameCS ("::" all?="*")? ";";
		public ParserRule getRule() { return rule; }

		//"import" (name=UnrestrictedName ":")? pathName=URIPathNameCS ("::" all?="*")? ";"
		public Group getGroup() { return cGroup; }

		//"import"
		public Keyword getImportKeyword_0() { return cImportKeyword_0; }

		//(name=UnrestrictedName ":")?
		public Group getGroup_1() { return cGroup_1; }

		//name=UnrestrictedName
		public Assignment getNameAssignment_1_0() { return cNameAssignment_1_0; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_1_0_0() { return cNameUnrestrictedNameParserRuleCall_1_0_0; }

		//":"
		public Keyword getColonKeyword_1_1() { return cColonKeyword_1_1; }

		//pathName=URIPathNameCS
		public Assignment getPathNameAssignment_2() { return cPathNameAssignment_2; }

		//URIPathNameCS
		public RuleCall getPathNameURIPathNameCSParserRuleCall_2_0() { return cPathNameURIPathNameCSParserRuleCall_2_0; }

		//("::" all?="*")?
		public Group getGroup_3() { return cGroup_3; }

		//"::"
		public Keyword getColonColonKeyword_3_0() { return cColonColonKeyword_3_0; }

		//all?="*"
		public Assignment getAllAssignment_3_1() { return cAllAssignment_3_1; }

		//"*"
		public Keyword getAllAsteriskKeyword_3_1_0() { return cAllAsteriskKeyword_3_1_0; }

		//";"
		public Keyword getSemicolonKeyword_4() { return cSemicolonKeyword_4; }
	}

	public class VarDeclarationCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "VarDeclarationCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cVarDeclarationIdsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cVarDeclarationIdsVarDeclarationIdCSParserRuleCall_0_0 = (RuleCall)cVarDeclarationIdsAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cCommaKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cVarDeclarationIdsAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cVarDeclarationIdsVarDeclarationIdCSParserRuleCall_1_1_0 = (RuleCall)cVarDeclarationIdsAssignment_1_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cTypeAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cTypeTypedRefCSParserRuleCall_3_0 = (RuleCall)cTypeAssignment_3.eContents().get(0);
		private final Keyword cSemicolonKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//VarDeclarationCS:
		//	varDeclarationIds+=VarDeclarationIdCS ("," varDeclarationIds+=VarDeclarationIdCS)* ":" type=TypedRefCS ";";
		public ParserRule getRule() { return rule; }

		//varDeclarationIds+=VarDeclarationIdCS ("," varDeclarationIds+=VarDeclarationIdCS)* ":" type=TypedRefCS ";"
		public Group getGroup() { return cGroup; }

		//varDeclarationIds+=VarDeclarationIdCS
		public Assignment getVarDeclarationIdsAssignment_0() { return cVarDeclarationIdsAssignment_0; }

		//VarDeclarationIdCS
		public RuleCall getVarDeclarationIdsVarDeclarationIdCSParserRuleCall_0_0() { return cVarDeclarationIdsVarDeclarationIdCSParserRuleCall_0_0; }

		//("," varDeclarationIds+=VarDeclarationIdCS)*
		public Group getGroup_1() { return cGroup_1; }

		//","
		public Keyword getCommaKeyword_1_0() { return cCommaKeyword_1_0; }

		//varDeclarationIds+=VarDeclarationIdCS
		public Assignment getVarDeclarationIdsAssignment_1_1() { return cVarDeclarationIdsAssignment_1_1; }

		//VarDeclarationIdCS
		public RuleCall getVarDeclarationIdsVarDeclarationIdCSParserRuleCall_1_1_0() { return cVarDeclarationIdsVarDeclarationIdCSParserRuleCall_1_1_0; }

		//":"
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }

		//type=TypedRefCS
		public Assignment getTypeAssignment_3() { return cTypeAssignment_3; }

		//TypedRefCS
		public RuleCall getTypeTypedRefCSParserRuleCall_3_0() { return cTypeTypedRefCSParserRuleCall_3_0; }

		//";"
		public Keyword getSemicolonKeyword_4() { return cSemicolonKeyword_4; }
	}

	public class VarDeclarationIdCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "VarDeclarationIdCS");
		private final Assignment cNameAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_0 = (RuleCall)cNameAssignment.eContents().get(0);
		
		//VarDeclarationIdCS:
		//	name=UnrestrictedName;
		public ParserRule getRule() { return rule; }

		//name=UnrestrictedName
		public Assignment getNameAssignment() { return cNameAssignment; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_0() { return cNameUnrestrictedNameParserRuleCall_0; }
	}

	public class WhenCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "WhenCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cPatternCSAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cWhenKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cPredicatesAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cPredicatesPredicateCSParserRuleCall_3_0 = (RuleCall)cPredicatesAssignment_3.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//WhenCS returns PatternCS:
		//	{PatternCS} "when" "{" predicates+=PredicateCS* "}";
		public ParserRule getRule() { return rule; }

		//{PatternCS} "when" "{" predicates+=PredicateCS* "}"
		public Group getGroup() { return cGroup; }

		//{PatternCS}
		public Action getPatternCSAction_0() { return cPatternCSAction_0; }

		//"when"
		public Keyword getWhenKeyword_1() { return cWhenKeyword_1; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_2() { return cLeftCurlyBracketKeyword_2; }

		//predicates+=PredicateCS*
		public Assignment getPredicatesAssignment_3() { return cPredicatesAssignment_3; }

		//PredicateCS
		public RuleCall getPredicatesPredicateCSParserRuleCall_3_0() { return cPredicatesPredicateCSParserRuleCall_3_0; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_4() { return cRightCurlyBracketKeyword_4; }
	}

	public class WhereCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "WhereCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cPatternCSAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cWhereKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cPredicatesAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cPredicatesPredicateCSParserRuleCall_3_0 = (RuleCall)cPredicatesAssignment_3.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//WhereCS returns PatternCS:
		//	{PatternCS} "where" "{" predicates+=PredicateCS* "}";
		public ParserRule getRule() { return rule; }

		//{PatternCS} "where" "{" predicates+=PredicateCS* "}"
		public Group getGroup() { return cGroup; }

		//{PatternCS}
		public Action getPatternCSAction_0() { return cPatternCSAction_0; }

		//"where"
		public Keyword getWhereKeyword_1() { return cWhereKeyword_1; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_2() { return cLeftCurlyBracketKeyword_2; }

		//predicates+=PredicateCS*
		public Assignment getPredicatesAssignment_3() { return cPredicatesAssignment_3; }

		//PredicateCS
		public RuleCall getPredicatesPredicateCSParserRuleCall_3_0() { return cPredicatesPredicateCSParserRuleCall_3_0; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_4() { return cRightCurlyBracketKeyword_4; }
	}

	public class NameExpCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "NameExpCS");
		private final Assignment cPathNameAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cPathNamePathNameCSParserRuleCall_0 = (RuleCall)cPathNameAssignment.eContents().get(0);
		
		//NameExpCS returns essentialocl::NameExpCS:
		//	pathName=PathNameCS;
		public ParserRule getRule() { return rule; }

		//pathName=PathNameCS
		public Assignment getPathNameAssignment() { return cPathNameAssignment; }

		//PathNameCS
		public RuleCall getPathNamePathNameCSParserRuleCall_0() { return cPathNamePathNameCSParserRuleCall_0; }
	}

	public class ExpCSOrTemplateCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "ExpCSOrTemplateCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cExpCSParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cTemplateCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		////<OCLExpressionCS> ::= <PropertyCallExpCS> 
		////                    | <VariableExpCS>
		////                    | <LiteralExpCS>
		////                    | <LetExpCS>
		////                    | <IfExpCS>
		////                    | '(' <OCLExpressionCS> ')'
		////                    | <template>  
		////	notNameExpressionCS -> templateCS
		//ExpCSOrTemplateCS returns essentialocl::ExpCS:
		//	ExpCS | TemplateCS;
		public ParserRule getRule() { return rule; }

		//ExpCS | TemplateCS
		public Alternatives getAlternatives() { return cAlternatives; }

		//ExpCS
		public RuleCall getExpCSParserRuleCall_0() { return cExpCSParserRuleCall_0; }

		//TemplateCS
		public RuleCall getTemplateCSParserRuleCall_1() { return cTemplateCSParserRuleCall_1; }
	}

	public class TypedTypeRefCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TypedTypeRefCS");
		private final Assignment cPathNameAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cPathNamePathNameCSParserRuleCall_0 = (RuleCall)cPathNameAssignment.eContents().get(0);
		
		//TypedTypeRefCS returns base::TypedTypeRefCS:
		//	pathName=PathNameCS;
		public ParserRule getRule() { return rule; }

		//pathName=PathNameCS
		public Assignment getPathNameAssignment() { return cPathNameAssignment; }

		//PathNameCS
		public RuleCall getPathNamePathNameCSParserRuleCall_0() { return cPathNamePathNameCSParserRuleCall_0; }
	}

	public class TypedRefCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TypedRefCS");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cPrimitiveTypeCSParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cCollectionTypeCSParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cTypedTypeRefCSParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//TypedRefCS returns base::TypedRefCS:
		//	PrimitiveTypeCS | CollectionTypeCS | TypedTypeRefCS;
		public ParserRule getRule() { return rule; }

		//PrimitiveTypeCS | CollectionTypeCS | TypedTypeRefCS
		public Alternatives getAlternatives() { return cAlternatives; }

		//PrimitiveTypeCS
		public RuleCall getPrimitiveTypeCSParserRuleCall_0() { return cPrimitiveTypeCSParserRuleCall_0; }

		//CollectionTypeCS
		public RuleCall getCollectionTypeCSParserRuleCall_1() { return cCollectionTypeCSParserRuleCall_1; }

		//TypedTypeRefCS
		public RuleCall getTypedTypeRefCSParserRuleCall_2() { return cTypedTypeRefCSParserRuleCall_2; }
	}

	public class UnrestrictedNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "UnrestrictedName");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cEssentialOCLUnrestrictedNameParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final Keyword cCheckonlyKeyword_1 = (Keyword)cAlternatives.eContents().get(1);
		private final Keyword cDefault_valuesKeyword_2 = (Keyword)cAlternatives.eContents().get(2);
		private final Keyword cDomainKeyword_3 = (Keyword)cAlternatives.eContents().get(3);
		private final Keyword cEnforceKeyword_4 = (Keyword)cAlternatives.eContents().get(4);
		private final Keyword cExtendsKeyword_5 = (Keyword)cAlternatives.eContents().get(5);
		private final Keyword cImplementedbyKeyword_6 = (Keyword)cAlternatives.eContents().get(6);
		private final Keyword cImportKeyword_7 = (Keyword)cAlternatives.eContents().get(7);
		private final Keyword cLibraryKeyword_8 = (Keyword)cAlternatives.eContents().get(8);
		private final Keyword cKeyKeyword_9 = (Keyword)cAlternatives.eContents().get(9);
		private final Keyword cOppositeKeyword_10 = (Keyword)cAlternatives.eContents().get(10);
		private final Keyword cOverridesKeyword_11 = (Keyword)cAlternatives.eContents().get(11);
		private final Keyword cPrimitiveKeyword_12 = (Keyword)cAlternatives.eContents().get(12);
		private final Keyword cQueryKeyword_13 = (Keyword)cAlternatives.eContents().get(13);
		private final Keyword cRelationKeyword_14 = (Keyword)cAlternatives.eContents().get(14);
		private final Keyword cReplaceKeyword_15 = (Keyword)cAlternatives.eContents().get(15);
		private final Keyword cTopKeyword_16 = (Keyword)cAlternatives.eContents().get(16);
		private final Keyword cTransformationKeyword_17 = (Keyword)cAlternatives.eContents().get(17);
		private final Keyword cWhenKeyword_18 = (Keyword)cAlternatives.eContents().get(18);
		private final Keyword cWhereKeyword_19 = (Keyword)cAlternatives.eContents().get(19);
		
		////ExpCS returns essentialocl::ExpCS:
		////	InfixedExpCS
		////|	TemplateCS;
		////--	relationIdentifier -> '_'	
		//UnrestrictedName returns ecore::EString:
		//	EssentialOCLUnrestrictedName //|   '_'
		//	| "checkonly" | "default_values" | "domain" | "enforce" | "extends" | "implementedby" | "import" | "library" | "key" |
		//	"opposite" | "overrides" | "primitive" | "query" | "relation" | "replace" | "top" | "transformation" | "when" |
		//	"where";
		public ParserRule getRule() { return rule; }

		//EssentialOCLUnrestrictedName //|   '_'
		//| "checkonly" | "default_values" | "domain" | "enforce" | "extends" | "implementedby" | "import" | "library" | "key" |
		//"opposite" | "overrides" | "primitive" | "query" | "relation" | "replace" | "top" | "transformation" | "when" | "where"
		public Alternatives getAlternatives() { return cAlternatives; }

		//EssentialOCLUnrestrictedName
		public RuleCall getEssentialOCLUnrestrictedNameParserRuleCall_0() { return cEssentialOCLUnrestrictedNameParserRuleCall_0; }

		//"checkonly"
		public Keyword getCheckonlyKeyword_1() { return cCheckonlyKeyword_1; }

		//"default_values"
		public Keyword getDefault_valuesKeyword_2() { return cDefault_valuesKeyword_2; }

		//"domain"
		public Keyword getDomainKeyword_3() { return cDomainKeyword_3; }

		//"enforce"
		public Keyword getEnforceKeyword_4() { return cEnforceKeyword_4; }

		//"extends"
		public Keyword getExtendsKeyword_5() { return cExtendsKeyword_5; }

		//"implementedby"
		public Keyword getImplementedbyKeyword_6() { return cImplementedbyKeyword_6; }

		//"import"
		public Keyword getImportKeyword_7() { return cImportKeyword_7; }

		//"library"
		public Keyword getLibraryKeyword_8() { return cLibraryKeyword_8; }

		//"key"
		public Keyword getKeyKeyword_9() { return cKeyKeyword_9; }

		//"opposite"
		public Keyword getOppositeKeyword_10() { return cOppositeKeyword_10; }

		//"overrides"
		public Keyword getOverridesKeyword_11() { return cOverridesKeyword_11; }

		//"primitive"
		public Keyword getPrimitiveKeyword_12() { return cPrimitiveKeyword_12; }

		//"query"
		public Keyword getQueryKeyword_13() { return cQueryKeyword_13; }

		//"relation"
		public Keyword getRelationKeyword_14() { return cRelationKeyword_14; }

		//"replace"
		public Keyword getReplaceKeyword_15() { return cReplaceKeyword_15; }

		//"top"
		public Keyword getTopKeyword_16() { return cTopKeyword_16; }

		//"transformation"
		public Keyword getTransformationKeyword_17() { return cTransformationKeyword_17; }

		//"when"
		public Keyword getWhenKeyword_18() { return cWhenKeyword_18; }

		//"where"
		public Keyword getWhereKeyword_19() { return cWhereKeyword_19; }
	}
	
	
	private TopLevelCSElements pTopLevelCS;
	private CollectionTemplateCSElements pCollectionTemplateCS;
	private DefaultValueCSElements pDefaultValueCS;
	private DomainCSElements pDomainCS;
	private DomainPatternCSElements pDomainPatternCS;
	private ElementTemplateCSElements pElementTemplateCS;
	private KeyDeclCSElements pKeyDeclCS;
	private LibraryCSElements pLibraryCS;
	private ModelDeclCSElements pModelDeclCS;
	private ObjectTemplateCSElements pObjectTemplateCS;
	private ParamDeclarationCSElements pParamDeclarationCS;
	private PredicateCSElements pPredicateCS;
	private PrimitiveTypeDomainCSElements pPrimitiveTypeDomainCS;
	private PropertyTemplateCSElements pPropertyTemplateCS;
	private QueryCSElements pQueryCS;
	private RelationCSElements pRelationCS;
	private TemplateCSElements pTemplateCS;
	private TransformationCSElements pTransformationCS;
	private UnitCSElements pUnitCS;
	private VarDeclarationCSElements pVarDeclarationCS;
	private VarDeclarationIdCSElements pVarDeclarationIdCS;
	private WhenCSElements pWhenCS;
	private WhereCSElements pWhereCS;
	private NameExpCSElements pNameExpCS;
	private ExpCSOrTemplateCSElements pExpCSOrTemplateCS;
	private TypedTypeRefCSElements pTypedTypeRefCS;
	private TypedRefCSElements pTypedRefCS;
	private UnrestrictedNameElements pUnrestrictedName;
	
	private final Grammar grammar;

	private EssentialOCLGrammarAccess gaEssentialOCL;

	@Inject
	public QVTrelationGrammarAccess(GrammarProvider grammarProvider,
		EssentialOCLGrammarAccess gaEssentialOCL) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.gaEssentialOCL = gaEssentialOCL;
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.qvtd.xtext.qvtrelation.QVTrelation".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	
	public Grammar getGrammar() {
		return grammar;
	}
	

	public EssentialOCLGrammarAccess getEssentialOCLGrammarAccess() {
		return gaEssentialOCL;
	}

	
	//TopLevelCS:
	//	(ownedImport+=UnitCS | / *ownedInclude+=IncludeCS |* / ownedLibrary+=LibraryCS)* transformations+=TransformationCS*;
	public TopLevelCSElements getTopLevelCSAccess() {
		return (pTopLevelCS != null) ? pTopLevelCS : (pTopLevelCS = new TopLevelCSElements());
	}
	
	public ParserRule getTopLevelCSRule() {
		return getTopLevelCSAccess().getRule();
	}

	////UnitCS: identifier+=[pivot::Element|UnrestrictedName] ('.' identifier+=[pivot::Element|UnrestrictedName])*;
	//CollectionTemplateCS:
	//	name=UnrestrictedName? ":" type=CollectionTypeCS "{" (memberIdentifiers+=(TemplateCS | ElementTemplateCS) (","
	//	memberIdentifiers+=(TemplateCS | ElementTemplateCS))* "++" (restIdentifier=[pivot::Variable|UnrestrictedName] | "_"))?
	//	"}";
	public CollectionTemplateCSElements getCollectionTemplateCSAccess() {
		return (pCollectionTemplateCS != null) ? pCollectionTemplateCS : (pCollectionTemplateCS = new CollectionTemplateCSElements());
	}
	
	public ParserRule getCollectionTemplateCSRule() {
		return getCollectionTemplateCSAccess().getRule();
	}

	//DefaultValueCS:
	//	propertyId=[pivot::Variable|UnrestrictedName] "=" initialiser=ExpCS ";";
	public DefaultValueCSElements getDefaultValueCSAccess() {
		return (pDefaultValueCS != null) ? pDefaultValueCS : (pDefaultValueCS = new DefaultValueCSElements());
	}
	
	public ParserRule getDefaultValueCSRule() {
		return getDefaultValueCSAccess().getRule();
	}

	//DomainCS:
	//	(checkonly?="checkonly" | enforce?="enforce" | "replace")? "domain" modelId=[qvtbase::TypedModel|UnrestrictedName]
	//	pattern=DomainPatternCS ("implementedby" implementedBy=ExpCS)? ("default_values" "{" defaultValues+=DefaultValueCS+
	//	"}")? ";";
	public DomainCSElements getDomainCSAccess() {
		return (pDomainCS != null) ? pDomainCS : (pDomainCS = new DomainCSElements());
	}
	
	public ParserRule getDomainCSRule() {
		return getDomainCSAccess().getRule();
	}

	//DomainPatternCS:
	//	template=TemplateCS;
	public DomainPatternCSElements getDomainPatternCSAccess() {
		return (pDomainPatternCS != null) ? pDomainPatternCS : (pDomainPatternCS = new DomainPatternCSElements());
	}
	
	public ParserRule getDomainPatternCSRule() {
		return getDomainPatternCSAccess().getRule();
	}

	//ElementTemplateCS:
	//	name=UnrestrictedName | {ElementTemplateCS} "_";
	public ElementTemplateCSElements getElementTemplateCSAccess() {
		return (pElementTemplateCS != null) ? pElementTemplateCS : (pElementTemplateCS = new ElementTemplateCSElements());
	}
	
	public ParserRule getElementTemplateCSRule() {
		return getElementTemplateCSAccess().getRule();
	}

	//KeyDeclCS:
	//	"key" pathName=PathNameCS "{" (propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "("
	//	oppositePropertyIds+=PathNameCS ")") ("," (propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "("
	//	oppositePropertyIds+=PathNameCS ")"))* "}" ";";
	public KeyDeclCSElements getKeyDeclCSAccess() {
		return (pKeyDeclCS != null) ? pKeyDeclCS : (pKeyDeclCS = new KeyDeclCSElements());
	}
	
	public ParserRule getKeyDeclCSRule() {
		return getKeyDeclCSAccess().getRule();
	}

	//LibraryCS returns base::LibraryCS:
	//	"library" package=[pivot::Package|URI] ";";
	public LibraryCSElements getLibraryCSAccess() {
		return (pLibraryCS != null) ? pLibraryCS : (pLibraryCS = new LibraryCSElements());
	}
	
	public ParserRule getLibraryCSRule() {
		return getLibraryCSAccess().getRule();
	}

	//ModelDeclCS:
	//	name=UnrestrictedName ":" (metaModelIds+=[pivot::Namespace|UnrestrictedName] | "{"
	//	metaModelIds+=[pivot::Namespace|UnrestrictedName] ("," metaModelIds+=[pivot::Namespace|UnrestrictedName])* "}");
	public ModelDeclCSElements getModelDeclCSAccess() {
		return (pModelDeclCS != null) ? pModelDeclCS : (pModelDeclCS = new ModelDeclCSElements());
	}
	
	public ParserRule getModelDeclCSRule() {
		return getModelDeclCSAccess().getRule();
	}

	//ObjectTemplateCS:
	//	name=UnrestrictedName? ":" type=TypedRefCS "{" (propertyTemplates+=PropertyTemplateCS (","
	//	propertyTemplates+=PropertyTemplateCS)*)? "}";
	public ObjectTemplateCSElements getObjectTemplateCSAccess() {
		return (pObjectTemplateCS != null) ? pObjectTemplateCS : (pObjectTemplateCS = new ObjectTemplateCSElements());
	}
	
	public ParserRule getObjectTemplateCSRule() {
		return getObjectTemplateCSAccess().getRule();
	}

	//ParamDeclarationCS:
	//	name=UnrestrictedName ":" ownedType=TypedRefCS;
	public ParamDeclarationCSElements getParamDeclarationCSAccess() {
		return (pParamDeclarationCS != null) ? pParamDeclarationCS : (pParamDeclarationCS = new ParamDeclarationCSElements());
	}
	
	public ParserRule getParamDeclarationCSRule() {
		return getParamDeclarationCSAccess().getRule();
	}

	//PredicateCS:
	//	expr=ExpCS ";";
	public PredicateCSElements getPredicateCSAccess() {
		return (pPredicateCS != null) ? pPredicateCS : (pPredicateCS = new PredicateCSElements());
	}
	
	public ParserRule getPredicateCSRule() {
		return getPredicateCSAccess().getRule();
	}

	//PrimitiveTypeDomainCS:
	//	"primitive" "domain" name=UnrestrictedName ":" type=TypedRefCS ";";
	public PrimitiveTypeDomainCSElements getPrimitiveTypeDomainCSAccess() {
		return (pPrimitiveTypeDomainCS != null) ? pPrimitiveTypeDomainCS : (pPrimitiveTypeDomainCS = new PrimitiveTypeDomainCSElements());
	}
	
	public ParserRule getPrimitiveTypeDomainCSRule() {
		return getPrimitiveTypeDomainCSAccess().getRule();
	}

	//PropertyTemplateCS:
	//	(propertyId=[pivot::Property|UnrestrictedName] | "opposite" "(" oppositePropertyId=PathNameCS ")") "="
	//	expression=ExpCSOrTemplateCS;
	public PropertyTemplateCSElements getPropertyTemplateCSAccess() {
		return (pPropertyTemplateCS != null) ? pPropertyTemplateCS : (pPropertyTemplateCS = new PropertyTemplateCSElements());
	}
	
	public ParserRule getPropertyTemplateCSRule() {
		return getPropertyTemplateCSAccess().getRule();
	}

	//QueryCS:
	//	"query" name=UnrestrictedName "(" (inputParamDeclarations+=ParamDeclarationCS (","
	//	inputParamDeclarations+=ParamDeclarationCS)*)? ")" ":" ownedType=TypedRefCS (";" | "{" expression=ExpCS "}");
	public QueryCSElements getQueryCSAccess() {
		return (pQueryCS != null) ? pQueryCS : (pQueryCS = new QueryCSElements());
	}
	
	public ParserRule getQueryCSRule() {
		return getQueryCSAccess().getRule();
	}

	//RelationCS:
	//	top?="top"? "relation" name=UnrestrictedName ("overrides" overrides=[qvtrelation::Relation|UnrestrictedName])? "{"
	//	varDeclarations+=VarDeclarationCS* (domains+=DomainCS | domains+=PrimitiveTypeDomainCS)+ when=WhenCS? where=WhereCS?
	//	"}";
	public RelationCSElements getRelationCSAccess() {
		return (pRelationCS != null) ? pRelationCS : (pRelationCS = new RelationCSElements());
	}
	
	public ParserRule getRelationCSRule() {
		return getRelationCSAccess().getRule();
	}

	//TemplateCS:
	//	(CollectionTemplateCS | ObjectTemplateCS) ("{" guardExpression=ExpCS "}")?;
	public TemplateCSElements getTemplateCSAccess() {
		return (pTemplateCS != null) ? pTemplateCS : (pTemplateCS = new TemplateCSElements());
	}
	
	public ParserRule getTemplateCSRule() {
		return getTemplateCSAccess().getRule();
	}

	//TransformationCS:
	//	"transformation" name=UnrestrictedName "(" modelDecls+=ModelDeclCS ("," modelDecls+=ModelDeclCS)* ")" ("extends"
	//	extends+=[qvtbase::Transformation|UnrestrictedName] ("," extends+=[qvtbase::Transformation|UnrestrictedName])*)? "{"
	//	keyDecls+=KeyDeclCS* (relation+=RelationCS | queries+=QueryCS)* "}";
	public TransformationCSElements getTransformationCSAccess() {
		return (pTransformationCS != null) ? pTransformationCS : (pTransformationCS = new TransformationCSElements());
	}
	
	public ParserRule getTransformationCSRule() {
		return getTransformationCSAccess().getRule();
	}

	//UnitCS returns base::ImportCS:
	//	"import" (name=UnrestrictedName ":")? pathName=URIPathNameCS ("::" all?="*")? ";";
	public UnitCSElements getUnitCSAccess() {
		return (pUnitCS != null) ? pUnitCS : (pUnitCS = new UnitCSElements());
	}
	
	public ParserRule getUnitCSRule() {
		return getUnitCSAccess().getRule();
	}

	//VarDeclarationCS:
	//	varDeclarationIds+=VarDeclarationIdCS ("," varDeclarationIds+=VarDeclarationIdCS)* ":" type=TypedRefCS ";";
	public VarDeclarationCSElements getVarDeclarationCSAccess() {
		return (pVarDeclarationCS != null) ? pVarDeclarationCS : (pVarDeclarationCS = new VarDeclarationCSElements());
	}
	
	public ParserRule getVarDeclarationCSRule() {
		return getVarDeclarationCSAccess().getRule();
	}

	//VarDeclarationIdCS:
	//	name=UnrestrictedName;
	public VarDeclarationIdCSElements getVarDeclarationIdCSAccess() {
		return (pVarDeclarationIdCS != null) ? pVarDeclarationIdCS : (pVarDeclarationIdCS = new VarDeclarationIdCSElements());
	}
	
	public ParserRule getVarDeclarationIdCSRule() {
		return getVarDeclarationIdCSAccess().getRule();
	}

	//WhenCS returns PatternCS:
	//	{PatternCS} "when" "{" predicates+=PredicateCS* "}";
	public WhenCSElements getWhenCSAccess() {
		return (pWhenCS != null) ? pWhenCS : (pWhenCS = new WhenCSElements());
	}
	
	public ParserRule getWhenCSRule() {
		return getWhenCSAccess().getRule();
	}

	//WhereCS returns PatternCS:
	//	{PatternCS} "where" "{" predicates+=PredicateCS* "}";
	public WhereCSElements getWhereCSAccess() {
		return (pWhereCS != null) ? pWhereCS : (pWhereCS = new WhereCSElements());
	}
	
	public ParserRule getWhereCSRule() {
		return getWhereCSAccess().getRule();
	}

	//NameExpCS returns essentialocl::NameExpCS:
	//	pathName=PathNameCS;
	public NameExpCSElements getNameExpCSAccess() {
		return (pNameExpCS != null) ? pNameExpCS : (pNameExpCS = new NameExpCSElements());
	}
	
	public ParserRule getNameExpCSRule() {
		return getNameExpCSAccess().getRule();
	}

	////<OCLExpressionCS> ::= <PropertyCallExpCS> 
	////                    | <VariableExpCS>
	////                    | <LiteralExpCS>
	////                    | <LetExpCS>
	////                    | <IfExpCS>
	////                    | '(' <OCLExpressionCS> ')'
	////                    | <template>  
	////	notNameExpressionCS -> templateCS
	//ExpCSOrTemplateCS returns essentialocl::ExpCS:
	//	ExpCS | TemplateCS;
	public ExpCSOrTemplateCSElements getExpCSOrTemplateCSAccess() {
		return (pExpCSOrTemplateCS != null) ? pExpCSOrTemplateCS : (pExpCSOrTemplateCS = new ExpCSOrTemplateCSElements());
	}
	
	public ParserRule getExpCSOrTemplateCSRule() {
		return getExpCSOrTemplateCSAccess().getRule();
	}

	//TypedTypeRefCS returns base::TypedTypeRefCS:
	//	pathName=PathNameCS;
	public TypedTypeRefCSElements getTypedTypeRefCSAccess() {
		return (pTypedTypeRefCS != null) ? pTypedTypeRefCS : (pTypedTypeRefCS = new TypedTypeRefCSElements());
	}
	
	public ParserRule getTypedTypeRefCSRule() {
		return getTypedTypeRefCSAccess().getRule();
	}

	//TypedRefCS returns base::TypedRefCS:
	//	PrimitiveTypeCS | CollectionTypeCS | TypedTypeRefCS;
	public TypedRefCSElements getTypedRefCSAccess() {
		return (pTypedRefCS != null) ? pTypedRefCS : (pTypedRefCS = new TypedRefCSElements());
	}
	
	public ParserRule getTypedRefCSRule() {
		return getTypedRefCSAccess().getRule();
	}

	////ExpCS returns essentialocl::ExpCS:
	////	InfixedExpCS
	////|	TemplateCS;
	////--	relationIdentifier -> '_'	
	//UnrestrictedName returns ecore::EString:
	//	EssentialOCLUnrestrictedName //|   '_'
	//	| "checkonly" | "default_values" | "domain" | "enforce" | "extends" | "implementedby" | "import" | "library" | "key" |
	//	"opposite" | "overrides" | "primitive" | "query" | "relation" | "replace" | "top" | "transformation" | "when" |
	//	"where";
	public UnrestrictedNameElements getUnrestrictedNameAccess() {
		return (pUnrestrictedName != null) ? pUnrestrictedName : (pUnrestrictedName = new UnrestrictedNameElements());
	}
	
	public ParserRule getUnrestrictedNameRule() {
		return getUnrestrictedNameAccess().getRule();
	}

	////generate essentialOCLCST "http://www.eclipse.org/ocl/3.0.0/EssentialOCLCST"
	//Model returns ContextCS:
	//	ownedExpression=ExpCS;
	public EssentialOCLGrammarAccess.ModelElements getModelAccess() {
		return gaEssentialOCL.getModelAccess();
	}
	
	public ParserRule getModelRule() {
		return getModelAccess().getRule();
	}

	//terminal fragment ESCAPED_CHARACTER:
	//	"\\" ("b" | "t" | "n" | "f" | "r" | "u" | "\"" | "\'" | "\\");
	public TerminalRule getESCAPED_CHARACTERRule() {
		return gaEssentialOCL.getESCAPED_CHARACTERRule();
	} 

	//terminal fragment LETTER_CHARACTER:
	//	"a".."z" | "A".."Z" | "_";
	public TerminalRule getLETTER_CHARACTERRule() {
		return gaEssentialOCL.getLETTER_CHARACTERRule();
	} 

	//terminal DOUBLE_QUOTED_STRING:
	//	"\"" (ESCAPED_CHARACTER | !("\\" | "\""))* "\"";
	public TerminalRule getDOUBLE_QUOTED_STRINGRule() {
		return gaEssentialOCL.getDOUBLE_QUOTED_STRINGRule();
	} 

	//terminal SINGLE_QUOTED_STRING:
	//	"\'" (ESCAPED_CHARACTER | !("\\" | "\'"))* "\'";
	public TerminalRule getSINGLE_QUOTED_STRINGRule() {
		return gaEssentialOCL.getSINGLE_QUOTED_STRINGRule();
	} 

	//terminal ML_SINGLE_QUOTED_STRING:
	//	"/\'"->"\'/";
	public TerminalRule getML_SINGLE_QUOTED_STRINGRule() {
		return gaEssentialOCL.getML_SINGLE_QUOTED_STRINGRule();
	} 

	//terminal SIMPLE_ID:
	//	LETTER_CHARACTER (LETTER_CHARACTER | "0".."9")*;
	public TerminalRule getSIMPLE_IDRule() {
		return gaEssentialOCL.getSIMPLE_IDRule();
	} 

	//terminal ESCAPED_ID:
	//	"_" SINGLE_QUOTED_STRING;
	public TerminalRule getESCAPED_IDRule() {
		return gaEssentialOCL.getESCAPED_IDRule();
	} 

	//ID:
	//	SIMPLE_ID | ESCAPED_ID;
	public EssentialOCLGrammarAccess.IDElements getIDAccess() {
		return gaEssentialOCL.getIDAccess();
	}
	
	public ParserRule getIDRule() {
		return getIDAccess().getRule();
	}

	//// String to allow diverse re-use
	//// multiple leading zeroes occur as floating point fractional part
	//terminal INT:
	//	"0".."9"+;
	public TerminalRule getINTRule() {
		return gaEssentialOCL.getINTRule();
	} 

	//LOWER returns ecore::EInt:
	//	INT;
	public EssentialOCLGrammarAccess.LOWERElements getLOWERAccess() {
		return gaEssentialOCL.getLOWERAccess();
	}
	
	public ParserRule getLOWERRule() {
		return getLOWERAccess().getRule();
	}

	//UPPER returns ecore::EInt:
	//	INT | "*";
	public EssentialOCLGrammarAccess.UPPERElements getUPPERAccess() {
		return gaEssentialOCL.getUPPERAccess();
	}
	
	public ParserRule getUPPERRule() {
		return getUPPERAccess().getRule();
	}

	//// Not terminal to allow parser backtracking to sort out "5..7"
	//// EssentialOCLTokenSource pieces this together ('.' INT)? (('e' | 'E') ('+' | '-')? INT)?;
	//NUMBER_LITERAL returns BigNumber:
	//	INT;
	public EssentialOCLGrammarAccess.NUMBER_LITERALElements getNUMBER_LITERALAccess() {
		return gaEssentialOCL.getNUMBER_LITERALAccess();
	}
	
	public ParserRule getNUMBER_LITERALRule() {
		return getNUMBER_LITERALAccess().getRule();
	}

	//terminal ML_COMMENT:
	//	"/ *"->"* /";
	public TerminalRule getML_COMMENTRule() {
		return gaEssentialOCL.getML_COMMENTRule();
	} 

	//terminal SL_COMMENT:
	//	"--" !("\n" | "\r")* ("\r"? "\n")?;
	public TerminalRule getSL_COMMENTRule() {
		return gaEssentialOCL.getSL_COMMENTRule();
	} 

	//terminal WS:
	//	(" " | "\t" | "\r" | "\n")+;
	public TerminalRule getWSRule() {
		return gaEssentialOCL.getWSRule();
	} 

	//terminal ANY_OTHER:
	//	.;
	public TerminalRule getANY_OTHERRule() {
		return gaEssentialOCL.getANY_OTHERRule();
	} 

	//URI:
	//	SINGLE_QUOTED_STRING;
	public EssentialOCLGrammarAccess.URIElements getURIAccess() {
		return gaEssentialOCL.getURIAccess();
	}
	
	public ParserRule getURIRule() {
		return getURIAccess().getRule();
	}

	//EssentialOCLReservedKeyword:
	//	"and" | "else" | "endif" | "if" | "implies" | "in" | "let" | "not" | "or" | "then" | "xor";
	public EssentialOCLGrammarAccess.EssentialOCLReservedKeywordElements getEssentialOCLReservedKeywordAccess() {
		return gaEssentialOCL.getEssentialOCLReservedKeywordAccess();
	}
	
	public ParserRule getEssentialOCLReservedKeywordRule() {
		return getEssentialOCLReservedKeywordAccess().getRule();
	}

	//EssentialOCLUnaryOperatorCS returns UnaryOperatorCS:
	//	name=("-" | "not");
	public EssentialOCLGrammarAccess.EssentialOCLUnaryOperatorCSElements getEssentialOCLUnaryOperatorCSAccess() {
		return gaEssentialOCL.getEssentialOCLUnaryOperatorCSAccess();
	}
	
	public ParserRule getEssentialOCLUnaryOperatorCSRule() {
		return getEssentialOCLUnaryOperatorCSAccess().getRule();
	}

	//EssentialOCLInfixOperatorCS returns BinaryOperatorCS:
	//	name=("*" | "/" | "+" | "-" | ">" | "<" | ">=" | "<=" | "=" | "<>" | "and" | "or" | "xor" | "implies");
	public EssentialOCLGrammarAccess.EssentialOCLInfixOperatorCSElements getEssentialOCLInfixOperatorCSAccess() {
		return gaEssentialOCL.getEssentialOCLInfixOperatorCSAccess();
	}
	
	public ParserRule getEssentialOCLInfixOperatorCSRule() {
		return getEssentialOCLInfixOperatorCSAccess().getRule();
	}

	//EssentialOCLNavigationOperatorCS returns NavigationOperatorCS:
	//	name=("." | "->");
	public EssentialOCLGrammarAccess.EssentialOCLNavigationOperatorCSElements getEssentialOCLNavigationOperatorCSAccess() {
		return gaEssentialOCL.getEssentialOCLNavigationOperatorCSAccess();
	}
	
	public ParserRule getEssentialOCLNavigationOperatorCSRule() {
		return getEssentialOCLNavigationOperatorCSAccess().getRule();
	}

	//Identifier:
	//	ID;
	public EssentialOCLGrammarAccess.IdentifierElements getIdentifierAccess() {
		return gaEssentialOCL.getIdentifierAccess();
	}
	
	public ParserRule getIdentifierRule() {
		return getIdentifierAccess().getRule();
	}

	//StringLiteral:
	//	SINGLE_QUOTED_STRING;
	public EssentialOCLGrammarAccess.StringLiteralElements getStringLiteralAccess() {
		return gaEssentialOCL.getStringLiteralAccess();
	}
	
	public ParserRule getStringLiteralRule() {
		return getStringLiteralAccess().getRule();
	}

	//BinaryOperatorCS:
	//	InfixOperatorCS | NavigationOperatorCS;
	public EssentialOCLGrammarAccess.BinaryOperatorCSElements getBinaryOperatorCSAccess() {
		return gaEssentialOCL.getBinaryOperatorCSAccess();
	}
	
	public ParserRule getBinaryOperatorCSRule() {
		return getBinaryOperatorCSAccess().getRule();
	}

	//// Intended to be overrideable
	//InfixOperatorCS returns BinaryOperatorCS:
	//	EssentialOCLInfixOperatorCS;
	public EssentialOCLGrammarAccess.InfixOperatorCSElements getInfixOperatorCSAccess() {
		return gaEssentialOCL.getInfixOperatorCSAccess();
	}
	
	public ParserRule getInfixOperatorCSRule() {
		return getInfixOperatorCSAccess().getRule();
	}

	//// Intended to be overrideable
	//NavigationOperatorCS:
	//	EssentialOCLNavigationOperatorCS;
	public EssentialOCLGrammarAccess.NavigationOperatorCSElements getNavigationOperatorCSAccess() {
		return gaEssentialOCL.getNavigationOperatorCSAccess();
	}
	
	public ParserRule getNavigationOperatorCSRule() {
		return getNavigationOperatorCSAccess().getRule();
	}

	//// Intended to be overrideable
	//UnaryOperatorCS:
	//	EssentialOCLUnaryOperatorCS;
	public EssentialOCLGrammarAccess.UnaryOperatorCSElements getUnaryOperatorCSAccess() {
		return gaEssentialOCL.getUnaryOperatorCSAccess();
	}
	
	public ParserRule getUnaryOperatorCSRule() {
		return getUnaryOperatorCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	////  Names
	////---------------------------------------------------------------------
	//EssentialOCLUnrestrictedName returns ecore::EString:
	//	Identifier;
	public EssentialOCLGrammarAccess.EssentialOCLUnrestrictedNameElements getEssentialOCLUnrestrictedNameAccess() {
		return gaEssentialOCL.getEssentialOCLUnrestrictedNameAccess();
	}
	
	public ParserRule getEssentialOCLUnrestrictedNameRule() {
		return getEssentialOCLUnrestrictedNameAccess().getRule();
	}

	//EssentialOCLUnreservedName returns ecore::EString:
	//	UnrestrictedName | CollectionTypeIdentifier | PrimitiveTypeIdentifier | "Tuple";
	public EssentialOCLGrammarAccess.EssentialOCLUnreservedNameElements getEssentialOCLUnreservedNameAccess() {
		return gaEssentialOCL.getEssentialOCLUnreservedNameAccess();
	}
	
	public ParserRule getEssentialOCLUnreservedNameRule() {
		return getEssentialOCLUnreservedNameAccess().getRule();
	}

	//// Intended to be overridden
	//UnreservedName returns ecore::EString:
	//	EssentialOCLUnreservedName;
	public EssentialOCLGrammarAccess.UnreservedNameElements getUnreservedNameAccess() {
		return gaEssentialOCL.getUnreservedNameAccess();
	}
	
	public ParserRule getUnreservedNameRule() {
		return getUnreservedNameAccess().getRule();
	}

	//PathNameCS returns base::PathNameCS:
	//	path+=FirstPathElementCS ("::" path+=NextPathElementCS)*;
	public EssentialOCLGrammarAccess.PathNameCSElements getPathNameCSAccess() {
		return gaEssentialOCL.getPathNameCSAccess();
	}
	
	public ParserRule getPathNameCSRule() {
		return getPathNameCSAccess().getRule();
	}

	//FirstPathElementCS returns base::PathElementCS:
	//	element=[pivot::NamedElement|UnrestrictedName];
	public EssentialOCLGrammarAccess.FirstPathElementCSElements getFirstPathElementCSAccess() {
		return gaEssentialOCL.getFirstPathElementCSAccess();
	}
	
	public ParserRule getFirstPathElementCSRule() {
		return getFirstPathElementCSAccess().getRule();
	}

	//NextPathElementCS returns base::PathElementCS:
	//	element=[pivot::NamedElement|UnreservedName];
	public EssentialOCLGrammarAccess.NextPathElementCSElements getNextPathElementCSAccess() {
		return gaEssentialOCL.getNextPathElementCSAccess();
	}
	
	public ParserRule getNextPathElementCSRule() {
		return getNextPathElementCSAccess().getRule();
	}

	//URIPathNameCS returns base::PathNameCS:
	//	path+=URIFirstPathElementCS ("::" path+=NextPathElementCS)*;
	public EssentialOCLGrammarAccess.URIPathNameCSElements getURIPathNameCSAccess() {
		return gaEssentialOCL.getURIPathNameCSAccess();
	}
	
	public ParserRule getURIPathNameCSRule() {
		return getURIPathNameCSAccess().getRule();
	}

	//URIFirstPathElementCS returns base::PathElementCS:
	//	element=[pivot::NamedElement|UnrestrictedName] | {base::PathElementWithURICS} element=[pivot::Namespace|URI];
	public EssentialOCLGrammarAccess.URIFirstPathElementCSElements getURIFirstPathElementCSAccess() {
		return gaEssentialOCL.getURIFirstPathElementCSAccess();
	}
	
	public ParserRule getURIFirstPathElementCSRule() {
		return getURIFirstPathElementCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	////  Types
	////---------------------------------------------------------------------
	//PrimitiveTypeIdentifier:
	//	"Boolean" | "Integer" | "Real" | "String" | "UnlimitedNatural" | "OclAny" | "OclInvalid" | "OclVoid";
	public EssentialOCLGrammarAccess.PrimitiveTypeIdentifierElements getPrimitiveTypeIdentifierAccess() {
		return gaEssentialOCL.getPrimitiveTypeIdentifierAccess();
	}
	
	public ParserRule getPrimitiveTypeIdentifierRule() {
		return getPrimitiveTypeIdentifierAccess().getRule();
	}

	//PrimitiveTypeCS returns base::PrimitiveTypeRefCS:
	//	name=PrimitiveTypeIdentifier;
	public EssentialOCLGrammarAccess.PrimitiveTypeCSElements getPrimitiveTypeCSAccess() {
		return gaEssentialOCL.getPrimitiveTypeCSAccess();
	}
	
	public ParserRule getPrimitiveTypeCSRule() {
		return getPrimitiveTypeCSAccess().getRule();
	}

	//CollectionTypeIdentifier returns ecore::EString:
	//	"Set" | "Bag" | "Sequence" | "Collection" | "OrderedSet";
	public EssentialOCLGrammarAccess.CollectionTypeIdentifierElements getCollectionTypeIdentifierAccess() {
		return gaEssentialOCL.getCollectionTypeIdentifierAccess();
	}
	
	public ParserRule getCollectionTypeIdentifierRule() {
		return getCollectionTypeIdentifierAccess().getRule();
	}

	//CollectionTypeCS:
	//	name=CollectionTypeIdentifier ("(" ownedType=TypeExpCS ")")?;
	public EssentialOCLGrammarAccess.CollectionTypeCSElements getCollectionTypeCSAccess() {
		return gaEssentialOCL.getCollectionTypeCSAccess();
	}
	
	public ParserRule getCollectionTypeCSRule() {
		return getCollectionTypeCSAccess().getRule();
	}

	//MultiplicityBoundsCS returns base::MultiplicityBoundsCS:
	//	lowerBound=LOWER (".." upperBound=UPPER)?;
	public EssentialOCLGrammarAccess.MultiplicityBoundsCSElements getMultiplicityBoundsCSAccess() {
		return gaEssentialOCL.getMultiplicityBoundsCSAccess();
	}
	
	public ParserRule getMultiplicityBoundsCSRule() {
		return getMultiplicityBoundsCSAccess().getRule();
	}

	//MultiplicityCS returns base::MultiplicityCS:
	//	"[" (MultiplicityBoundsCS | MultiplicityStringCS) "]";
	public EssentialOCLGrammarAccess.MultiplicityCSElements getMultiplicityCSAccess() {
		return gaEssentialOCL.getMultiplicityCSAccess();
	}
	
	public ParserRule getMultiplicityCSRule() {
		return getMultiplicityCSAccess().getRule();
	}

	//MultiplicityStringCS returns base::MultiplicityStringCS:
	//	stringBounds=("*" | "+" | "?");
	public EssentialOCLGrammarAccess.MultiplicityStringCSElements getMultiplicityStringCSAccess() {
		return gaEssentialOCL.getMultiplicityStringCSAccess();
	}
	
	public ParserRule getMultiplicityStringCSRule() {
		return getMultiplicityStringCSAccess().getRule();
	}

	//TupleTypeCS returns base::TupleTypeCS:
	//	name="Tuple" ("(" (ownedParts+=TuplePartCS ("," ownedParts+=TuplePartCS)*)? ")")?;
	public EssentialOCLGrammarAccess.TupleTypeCSElements getTupleTypeCSAccess() {
		return gaEssentialOCL.getTupleTypeCSAccess();
	}
	
	public ParserRule getTupleTypeCSRule() {
		return getTupleTypeCSAccess().getRule();
	}

	//TuplePartCS returns base::TuplePartCS:
	//	name=UnrestrictedName ":" ownedType=TypeExpCS;
	public EssentialOCLGrammarAccess.TuplePartCSElements getTuplePartCSAccess() {
		return gaEssentialOCL.getTuplePartCSAccess();
	}
	
	public ParserRule getTuplePartCSRule() {
		return getTuplePartCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	////  Literals
	////---------------------------------------------------------------------
	//CollectionLiteralExpCS:
	//	ownedType=CollectionTypeCS "{" (ownedParts+=CollectionLiteralPartCS ("," ownedParts+=CollectionLiteralPartCS)*)? "}";
	public EssentialOCLGrammarAccess.CollectionLiteralExpCSElements getCollectionLiteralExpCSAccess() {
		return gaEssentialOCL.getCollectionLiteralExpCSAccess();
	}
	
	public ParserRule getCollectionLiteralExpCSRule() {
		return getCollectionLiteralExpCSAccess().getRule();
	}

	//CollectionLiteralPartCS:
	//	expressionCS=ExpCS (".." lastExpressionCS=ExpCS)?;
	public EssentialOCLGrammarAccess.CollectionLiteralPartCSElements getCollectionLiteralPartCSAccess() {
		return gaEssentialOCL.getCollectionLiteralPartCSAccess();
	}
	
	public ParserRule getCollectionLiteralPartCSRule() {
		return getCollectionLiteralPartCSAccess().getRule();
	}

	//ConstructorPartCS:
	//	property=[pivot::Property|UnrestrictedName] "=" initExpression=ExpCS;
	public EssentialOCLGrammarAccess.ConstructorPartCSElements getConstructorPartCSAccess() {
		return gaEssentialOCL.getConstructorPartCSAccess();
	}
	
	public ParserRule getConstructorPartCSRule() {
		return getConstructorPartCSAccess().getRule();
	}

	//PrimitiveLiteralExpCS:
	//	NumberLiteralExpCS | StringLiteralExpCS | BooleanLiteralExpCS | UnlimitedNaturalLiteralExpCS | InvalidLiteralExpCS |
	//	NullLiteralExpCS;
	public EssentialOCLGrammarAccess.PrimitiveLiteralExpCSElements getPrimitiveLiteralExpCSAccess() {
		return gaEssentialOCL.getPrimitiveLiteralExpCSAccess();
	}
	
	public ParserRule getPrimitiveLiteralExpCSRule() {
		return getPrimitiveLiteralExpCSAccess().getRule();
	}

	//TupleLiteralExpCS:
	//	"Tuple" "{" ownedParts+=TupleLiteralPartCS ("," ownedParts+=TupleLiteralPartCS)* "}";
	public EssentialOCLGrammarAccess.TupleLiteralExpCSElements getTupleLiteralExpCSAccess() {
		return gaEssentialOCL.getTupleLiteralExpCSAccess();
	}
	
	public ParserRule getTupleLiteralExpCSRule() {
		return getTupleLiteralExpCSAccess().getRule();
	}

	//TupleLiteralPartCS:
	//	name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS;
	public EssentialOCLGrammarAccess.TupleLiteralPartCSElements getTupleLiteralPartCSAccess() {
		return gaEssentialOCL.getTupleLiteralPartCSAccess();
	}
	
	public ParserRule getTupleLiteralPartCSRule() {
		return getTupleLiteralPartCSAccess().getRule();
	}

	//NumberLiteralExpCS:
	//	name=NUMBER_LITERAL;
	public EssentialOCLGrammarAccess.NumberLiteralExpCSElements getNumberLiteralExpCSAccess() {
		return gaEssentialOCL.getNumberLiteralExpCSAccess();
	}
	
	public ParserRule getNumberLiteralExpCSRule() {
		return getNumberLiteralExpCSAccess().getRule();
	}

	//StringLiteralExpCS:
	//	name+=StringLiteral+;
	public EssentialOCLGrammarAccess.StringLiteralExpCSElements getStringLiteralExpCSAccess() {
		return gaEssentialOCL.getStringLiteralExpCSAccess();
	}
	
	public ParserRule getStringLiteralExpCSRule() {
		return getStringLiteralExpCSAccess().getRule();
	}

	//BooleanLiteralExpCS:
	//	name="true" | name="false";
	public EssentialOCLGrammarAccess.BooleanLiteralExpCSElements getBooleanLiteralExpCSAccess() {
		return gaEssentialOCL.getBooleanLiteralExpCSAccess();
	}
	
	public ParserRule getBooleanLiteralExpCSRule() {
		return getBooleanLiteralExpCSAccess().getRule();
	}

	//UnlimitedNaturalLiteralExpCS:
	//	{UnlimitedNaturalLiteralExpCS} "*";
	public EssentialOCLGrammarAccess.UnlimitedNaturalLiteralExpCSElements getUnlimitedNaturalLiteralExpCSAccess() {
		return gaEssentialOCL.getUnlimitedNaturalLiteralExpCSAccess();
	}
	
	public ParserRule getUnlimitedNaturalLiteralExpCSRule() {
		return getUnlimitedNaturalLiteralExpCSAccess().getRule();
	}

	//InvalidLiteralExpCS:
	//	{InvalidLiteralExpCS} "invalid";
	public EssentialOCLGrammarAccess.InvalidLiteralExpCSElements getInvalidLiteralExpCSAccess() {
		return gaEssentialOCL.getInvalidLiteralExpCSAccess();
	}
	
	public ParserRule getInvalidLiteralExpCSRule() {
		return getInvalidLiteralExpCSAccess().getRule();
	}

	//NullLiteralExpCS:
	//	{NullLiteralExpCS} "null";
	public EssentialOCLGrammarAccess.NullLiteralExpCSElements getNullLiteralExpCSAccess() {
		return gaEssentialOCL.getNullLiteralExpCSAccess();
	}
	
	public ParserRule getNullLiteralExpCSRule() {
		return getNullLiteralExpCSAccess().getRule();
	}

	//TypeLiteralCS returns base::TypedRefCS:
	//	PrimitiveTypeCS | CollectionTypeCS | TupleTypeCS;
	public EssentialOCLGrammarAccess.TypeLiteralCSElements getTypeLiteralCSAccess() {
		return gaEssentialOCL.getTypeLiteralCSAccess();
	}
	
	public ParserRule getTypeLiteralCSRule() {
		return getTypeLiteralCSAccess().getRule();
	}

	//TypeLiteralWithMultiplicityCS returns base::TypedRefCS:
	//	TypeLiteralCS multiplicity=MultiplicityCS?;
	public EssentialOCLGrammarAccess.TypeLiteralWithMultiplicityCSElements getTypeLiteralWithMultiplicityCSAccess() {
		return gaEssentialOCL.getTypeLiteralWithMultiplicityCSAccess();
	}
	
	public ParserRule getTypeLiteralWithMultiplicityCSRule() {
		return getTypeLiteralWithMultiplicityCSAccess().getRule();
	}

	//TypeLiteralExpCS:
	//	ownedType=TypeLiteralWithMultiplicityCS;
	public EssentialOCLGrammarAccess.TypeLiteralExpCSElements getTypeLiteralExpCSAccess() {
		return gaEssentialOCL.getTypeLiteralExpCSAccess();
	}
	
	public ParserRule getTypeLiteralExpCSRule() {
		return getTypeLiteralExpCSAccess().getRule();
	}

	//TypeNameExpCS:
	//	pathName=PathNameCS;
	public EssentialOCLGrammarAccess.TypeNameExpCSElements getTypeNameExpCSAccess() {
		return gaEssentialOCL.getTypeNameExpCSAccess();
	}
	
	public ParserRule getTypeNameExpCSRule() {
		return getTypeNameExpCSAccess().getRule();
	}

	//TypeExpCS returns base::TypedRefCS:
	//	(TypeNameExpCS | TypeLiteralCS) multiplicity=MultiplicityCS?;
	public EssentialOCLGrammarAccess.TypeExpCSElements getTypeExpCSAccess() {
		return gaEssentialOCL.getTypeExpCSAccess();
	}
	
	public ParserRule getTypeExpCSRule() {
		return getTypeExpCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	////  Expressions
	////---------------------------------------------------------------------
	//// An ExpCS permits a LetExpCS only in the final term to ensure
	////  that let is right associative, whereas infix operators are left associative.
	////   a = 64 / 16 / let b : Integer in 8 / let c : Integer in 4 
	//// is
	////   a = (64 / 16) / (let b : Integer in 8 / (let c : Integer in 4 ))
	//ExpCS:
	//	PrefixedExpCS ({InfixExpCS.ownedExpression+=current} ownedOperator+=BinaryOperatorCS (ownedExpression+=PrefixedExpCS
	//	(ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)* (ownedOperator+=BinaryOperatorCS
	//	ownedExpression+=LetExpCS)? | ownedExpression+=LetExpCS))? | {PrefixExpCS} ownedOperator+=UnaryOperatorCS+
	//	ownedExpression=LetExpCS | LetExpCS;
	public EssentialOCLGrammarAccess.ExpCSElements getExpCSAccess() {
		return gaEssentialOCL.getExpCSAccess();
	}
	
	public ParserRule getExpCSRule() {
		return getExpCSAccess().getRule();
	}

	//PrefixedExpCS returns ExpCS:
	//	{PrefixExpCS} ownedOperator+=UnaryOperatorCS+ ownedExpression=PrimaryExpCS | PrimaryExpCS;
	public EssentialOCLGrammarAccess.PrefixedExpCSElements getPrefixedExpCSAccess() {
		return gaEssentialOCL.getPrefixedExpCSAccess();
	}
	
	public ParserRule getPrefixedExpCSRule() {
		return getPrefixedExpCSAccess().getRule();
	}

	//PrimaryExpCS returns ExpCS:
	//	NestedExpCS | IfExpCS | SelfExpCS | PrimitiveLiteralExpCS | TupleLiteralExpCS | CollectionLiteralExpCS |
	//	TypeLiteralExpCS | {NameExpCS} pathName=PathNameCS ({IndexExpCS.nameExp=current} "[" firstIndexes+=ExpCS (","
	//	firstIndexes+=ExpCS)* "]" ("[" secondIndexes+=ExpCS ("," secondIndexes+=ExpCS)* "]")? (atPre?="@" "pre")? |
	//	{ConstructorExpCS.nameExp=current} "{" ((ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? |
	//	value=StringLiteral) "}" | (atPre?="@" "pre")? ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS
	//	argument+=NavigatingCommaArgCS* (argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)?
	//	(argument+=NavigatingBarArgCS argument+=NavigatingCommaArgCS*)?)? ")")?);
	public EssentialOCLGrammarAccess.PrimaryExpCSElements getPrimaryExpCSAccess() {
		return gaEssentialOCL.getPrimaryExpCSAccess();
	}
	
	public ParserRule getPrimaryExpCSRule() {
		return getPrimaryExpCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	//NavigatingArgCS:
	//	name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public EssentialOCLGrammarAccess.NavigatingArgCSElements getNavigatingArgCSAccess() {
		return gaEssentialOCL.getNavigatingArgCSAccess();
	}
	
	public ParserRule getNavigatingArgCSRule() {
		return getNavigatingArgCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	//NavigatingBarArgCS returns NavigatingArgCS:
	//	prefix="|" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public EssentialOCLGrammarAccess.NavigatingBarArgCSElements getNavigatingBarArgCSAccess() {
		return gaEssentialOCL.getNavigatingBarArgCSAccess();
	}
	
	public ParserRule getNavigatingBarArgCSRule() {
		return getNavigatingBarArgCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	//NavigatingCommaArgCS returns NavigatingArgCS:
	//	prefix="," name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public EssentialOCLGrammarAccess.NavigatingCommaArgCSElements getNavigatingCommaArgCSAccess() {
		return gaEssentialOCL.getNavigatingCommaArgCSAccess();
	}
	
	public ParserRule getNavigatingCommaArgCSRule() {
		return getNavigatingCommaArgCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	//NavigatingSemiArgCS returns NavigatingArgCS:
	//	prefix=";" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public EssentialOCLGrammarAccess.NavigatingSemiArgCSElements getNavigatingSemiArgCSAccess() {
		return gaEssentialOCL.getNavigatingSemiArgCSAccess();
	}
	
	public ParserRule getNavigatingSemiArgCSRule() {
		return getNavigatingSemiArgCSAccess().getRule();
	}

	//// Intended to be overridden
	////	'?'	-- defined by Complete OCL
	//NavigatingArgExpCS returns ExpCS:
	//	ExpCS;
	public EssentialOCLGrammarAccess.NavigatingArgExpCSElements getNavigatingArgExpCSAccess() {
		return gaEssentialOCL.getNavigatingArgExpCSAccess();
	}
	
	public ParserRule getNavigatingArgExpCSRule() {
		return getNavigatingArgExpCSAccess().getRule();
	}

	//IfExpCS:
	//	"if" condition=ExpCS "then" thenExpression=ExpCS "else" elseExpression=ExpCS "endif";
	public EssentialOCLGrammarAccess.IfExpCSElements getIfExpCSAccess() {
		return gaEssentialOCL.getIfExpCSAccess();
	}
	
	public ParserRule getIfExpCSRule() {
		return getIfExpCSAccess().getRule();
	}

	//LetExpCS:
	//	"let" variable+=LetVariableCS ("," variable+=LetVariableCS)* "in" in=ExpCS;
	public EssentialOCLGrammarAccess.LetExpCSElements getLetExpCSAccess() {
		return gaEssentialOCL.getLetExpCSAccess();
	}
	
	public ParserRule getLetExpCSRule() {
		return getLetExpCSAccess().getRule();
	}

	//LetVariableCS:
	//	name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS;
	public EssentialOCLGrammarAccess.LetVariableCSElements getLetVariableCSAccess() {
		return gaEssentialOCL.getLetVariableCSAccess();
	}
	
	public ParserRule getLetVariableCSRule() {
		return getLetVariableCSAccess().getRule();
	}

	//NestedExpCS:
	//	"(" source=ExpCS ")";
	public EssentialOCLGrammarAccess.NestedExpCSElements getNestedExpCSAccess() {
		return gaEssentialOCL.getNestedExpCSAccess();
	}
	
	public ParserRule getNestedExpCSRule() {
		return getNestedExpCSAccess().getRule();
	}

	//SelfExpCS:
	//	{SelfExpCS} "self";
	public EssentialOCLGrammarAccess.SelfExpCSElements getSelfExpCSAccess() {
		return gaEssentialOCL.getSelfExpCSAccess();
	}
	
	public ParserRule getSelfExpCSRule() {
		return getSelfExpCSAccess().getRule();
	}
}
