/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.evaluator;

import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugCore;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.utils.ASTBindingHelper;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.examples.debug.vm.utils.VMStackTraceBuilder;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.qvtd.debug.evaluator.IQVTiVMEvaluationEnvironment;
import org.eclipse.qvtd.debug.evaluator.QVTiVMModelManager;
import org.eclipse.qvtd.debug.evaluator.QVTiVMRootEvaluationEnvironment;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.IQVTiEvaluationEnvironment;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiNestedEvaluationEnvironment;

public class QVTiVMNestedEvaluationEnvironment
extends QVTiNestedEvaluationEnvironment
implements IQVTiVMEvaluationEnvironment {
    @NonNull
    private Element myCurrentIP;
    @NonNull
    private NamedElement myOperation;
    private final int myStackDepth;
    private final long id;
    @NonNull
    private final Stack<IVMEvaluationEnvironment.StepperEntry> stepperStack = new Stack();

    public QVTiVMNestedEvaluationEnvironment(@NonNull IQVTiVMEvaluationEnvironment evaluationEnvironment, long id, @NonNull NamedElement operation) {
        super((IQVTiEvaluationEnvironment)evaluationEnvironment);
        this.myStackDepth = evaluationEnvironment.getDepth() + 1;
        this.id = id;
        this.myOperation = operation;
        this.myCurrentIP = operation;
    }

    @Override
    @NonNull
    public IQVTiVMEvaluationEnvironment createClonedEvaluationEnvironment() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Element getCurrentIP() {
        return this.myCurrentIP;
    }

    @Override
    @NonNull
    public UnitLocation getCurrentLocation() {
        int startPosition = ASTBindingHelper.getStartPosition((Element)this.myCurrentIP);
        int endPosition = ASTBindingHelper.getEndPosition((Element)this.myCurrentIP);
        return new UnitLocation(startPosition, endPosition, (IVMEvaluationEnvironment)this, this.myCurrentIP);
    }

    @NonNull
    public VMDebugCore getDebugCore() {
        return this.getRootEvaluationEnvironment().getDebugCore();
    }

    @NonNull
    public Transformation getDebuggableElement() {
        return this.getRootEvaluationEnvironment().getDebuggableElement();
    }

    public int getDepth() {
        return this.myStackDepth;
    }

    public long getID() {
        return this.id;
    }

    @Override
    @NonNull
    public QVTiVMModelManager getModelManager() {
        return (QVTiVMModelManager)super.getModelManager();
    }

    @NonNull
    public Map<String, Resource> getModelParameterVariables() {
        return this.getRootEvaluationEnvironment().getModelParameterVariables();
    }

    @NonNull
    public NamedElement getOperation() {
        return this.myOperation;
    }

    @NonNull
    public Variable getPCVariable() {
        return this.getRootEvaluationEnvironment().getPCVariable();
    }

    @Override
    @Nullable
    public IQVTiVMEvaluationEnvironment getParentEvaluationEnvironment() {
        return (IQVTiVMEvaluationEnvironment)super.getParentEvaluationEnvironment();
    }

    @Override
    @NonNull
    public QVTiVMRootEvaluationEnvironment getRootEvaluationEnvironment() {
        return (QVTiVMRootEvaluationEnvironment)this.rootEvaluationEnvironment;
    }

    @NonNull
    public Stack<IVMEvaluationEnvironment.StepperEntry> getStepperStack() {
        return this.stepperStack;
    }

    public boolean isDeferredExecution() {
        return this.getRootEvaluationEnvironment().isDeferredExecution();
    }

    @Override
    public void processDeferredTasks() {
        this.getRootEvaluationEnvironment().processDeferredTasks();
    }

    @Override
    @NonNull
    public Element setCurrentIP(@NonNull Element element) {
        Element prevValue = this.myCurrentIP;
        this.myCurrentIP = element;
        return prevValue;
    }

    public void setOperation(@NonNull NamedElement operation) {
        this.myCurrentIP = operation;
        this.myOperation = operation;
    }

    @Override
    public void throwVMException(@NonNull VMRuntimeException exception) throws VMRuntimeException {
        try {
            this.getRootEvaluationEnvironment().saveThrownException(exception);
            exception.setStackVMTrace(new VMStackTraceBuilder((IVMEvaluationEnvironment)this).buildStackTrace());
        }
        catch (Exception e) {
            this.getDebugCore().error("Failed to build QVT stack trace", (Throwable)e);
        }
        throw exception;
    }
}

