/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.EmftvmPackage;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Field;
import org.eclipse.m2m.atl.emftvm.LocalVariable;
import org.eclipse.m2m.atl.emftvm.Metamodel;
import org.eclipse.m2m.atl.emftvm.Model;
import org.eclipse.m2m.atl.emftvm.Operation;
import org.eclipse.m2m.atl.emftvm.Parameter;
import org.eclipse.m2m.atl.emftvm.trace.TracePackage;
import org.eclipse.m2m.atl.emftvm.util.EnumConversionList;
import org.eclipse.m2m.atl.emftvm.util.EnumConversionListOnList;
import org.eclipse.m2m.atl.emftvm.util.EnumConversionSetOnSet;
import org.eclipse.m2m.atl.emftvm.util.EnumLiteral;
import org.eclipse.m2m.atl.emftvm.util.LazyCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.LazyListOnCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyListOnList;
import org.eclipse.m2m.atl.emftvm.util.LazySetOnSet;
import org.eclipse.m2m.atl.emftvm.util.MethodSignature;
import org.eclipse.m2m.atl.emftvm.util.NativeTypes;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.Tuple;
import org.eclipse.m2m.atl.emftvm.util.VMException;
import org.eclipse.m2m.atl.emftvm.util.WorkspaceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EMFTVMUtil {
    public static final String NATIVE = "#native";
    public static final String NS_DELIM = "::";
    public static final Pattern DELIM_PATTERN = Pattern.compile("::");
    public static final String MAIN_OP_NAME = "main";
    public static final String INIT_OP_NAME = "init";
    public static final String XMI_ID_FEATURE = "__xmiID__";
    private static final String WORKSPACE_UTIL_IMPL = "org.eclipse.m2m.atl.emftvm.util.WorkspaceUtilImpl";
    private static final ConcurrentMap<MethodSignature, WeakReference<Method>> METHOD_CACHE = new ConcurrentHashMap<MethodSignature, WeakReference<Method>>();
    private static final WeakReference<Method> NULL_METHOD_REFERENCE = new WeakReference<Object>(null);
    private static final Map<Method, WeakReference<Method>> ROOT_METHOD_CACHE = Collections.synchronizedMap(new WeakHashMap());
    private static final RegistryTypeSwitch REGISTRY_TYPE_SWITCH = new RegistryTypeSwitch();
    private static final int CUT_OFF = 31;
    private static Metamodel ecoreMetamodel;
    private static Metamodel emfTvmMetamodel;
    private static Metamodel traceMetamodel;
    private static volatile int MethodCacheAccesses;
    private static volatile int MethodCacheHits;
    private static volatile int RootMethodCacheAccesses;
    private static volatile int RootMethodCacheHits;

    private EMFTVMUtil() {
    }

    public static String getTypeName(ExecEnv env, Object type) {
        if (type instanceof EClass) {
            EClass eCls = (EClass)type;
            Metamodel mm = env.getMetaModel(eCls.eResource());
            if (mm != null) {
                return String.valueOf(env.getMetaModelID(mm)) + '!' + eCls.getName();
            }
            return eCls.getName();
        }
        if (type instanceof Class) {
            Class cls = (Class)type;
            String nativeTypeName = NativeTypes.typeName(cls);
            return cls.getName().equals(nativeTypeName) ? "#native!" + nativeTypeName : nativeTypeName;
        }
        return type.toString();
    }

    public static String getTypeNames(ExecEnv env, Object[] types) {
        StringBuffer names = new StringBuffer();
        boolean notFirst = false;
        Object[] objectArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Object type = objectArray[n2];
            if (notFirst) {
                names.append(", ");
            }
            names.append(EMFTVMUtil.getTypeName(env, type));
            notFirst = true;
            ++n2;
        }
        return names.toString();
    }

    public static Object getRegistryType(Object type) throws IllegalArgumentException {
        if (type instanceof EClassifier) {
            return REGISTRY_TYPE_SWITCH.doSwitch((EObject)((EClassifier)type));
        }
        return type;
    }

    public static synchronized Metamodel getEcoreMetamodel() {
        if (ecoreMetamodel == null) {
            ecoreMetamodel = EmftvmFactory.eINSTANCE.createMetamodel();
            ecoreMetamodel.setResource(EcorePackage.eINSTANCE.eResource());
        }
        return ecoreMetamodel;
    }

    public static synchronized Metamodel getEmfTvmMetamodel() {
        if (emfTvmMetamodel == null) {
            emfTvmMetamodel = EmftvmFactory.eINSTANCE.createMetamodel();
            emfTvmMetamodel.setResource(EmftvmPackage.eINSTANCE.eResource());
        }
        return emfTvmMetamodel;
    }

    public static synchronized Metamodel getTraceMetamodel() {
        if (traceMetamodel == null) {
            traceMetamodel = EmftvmFactory.eINSTANCE.createMetamodel();
            traceMetamodel.setResource(TracePackage.eINSTANCE.eResource());
        }
        return traceMetamodel;
    }

    public static LazyList<EObject> findAllInstances(EClass type, ExecEnv env) {
        LazyList<EObject> allInst = new LazyList<EObject>();
        for (Model model : env.getInputModels().values()) {
            allInst = allInst.union(model.allInstancesOf(type));
        }
        for (Model model : env.getInoutModels().values()) {
            allInst = allInst.union(model.allInstancesOf(type));
        }
        return allInst;
    }

    public static LazyList<EObject> findAllInstIn(Object modelname, EClass type, ExecEnv env) {
        Model model = env.getInputModels().get(modelname);
        if (model == null) {
            model = env.getInoutModels().get(modelname);
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("No input/inout model found with name %s", modelname));
        }
        return model.allInstancesOf(type);
    }

    public static String toPrettyString(Object object, ExecEnv env) {
        if (object instanceof EClassifier) {
            Model model;
            StringBuffer sb = new StringBuffer();
            if (env != null && (model = env.getModelOf((EObject)((EClassifier)object))) != null) {
                sb.append(env.getModelID(model));
                sb.append('!');
            }
            sb.append(((EClassifier)object).getName());
            return sb.toString();
        }
        if (object instanceof EObject) {
            StringBuffer buf = new StringBuffer();
            EObject eo = (EObject)object;
            EAttribute sf = eo.eClass().getEIDAttribute();
            if (sf == null) {
                sf = eo.eClass().getEStructuralFeature("name");
            }
            if (sf != null && eo.eGet((EStructuralFeature)sf) != null) {
                buf.append(eo.eGet((EStructuralFeature)sf));
            } else {
                buf.append(Integer.toHexString(eo.hashCode()));
            }
            buf.append(':');
            buf.append(EMFTVMUtil.toPrettyString(eo.eClass(), env));
            return buf.toString();
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        if (object instanceof String) {
            return new StringBuffer().append('\'').append(object.toString()).append('\'').toString();
        }
        if (object instanceof LazyCollection) {
            return ((LazyCollection)object).asString(env);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            StringBuilder buf = new StringBuilder("Map{");
            EMFTVMUtil.appendMapEntries(env, map, buf);
            buf.append('}');
            return buf.toString();
        }
        if (object instanceof Tuple) {
            Tuple tuple = (Tuple)object;
            StringBuilder buf = new StringBuilder("Tuple{");
            EMFTVMUtil.appendMapEntries(env, tuple.asMap(), buf);
            buf.append('}');
            return buf.toString();
        }
        if (object != null) {
            return object.toString();
        }
        return "OclUndefined";
    }

    private static void appendMapEntries(ExecEnv env, Map<?, ?> map, StringBuilder buf) {
        int index = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (index > 31) {
                buf.append(", ...");
                break;
            }
            if (index++ > 0) {
                buf.append(", ");
            }
            buf.append(EMFTVMUtil.toPrettyString(entry.getKey(), env));
            buf.append('=');
            buf.append(EMFTVMUtil.toPrettyString(entry.getValue(), env));
        }
    }

    public static String toPrettyString(Collection<?> coll, ExecEnv env) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        boolean first = true;
        for (Object object : coll) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(EMFTVMUtil.toPrettyString(object, env));
        }
        sb.append(']');
        return sb.toString();
    }

    public static <T> String toPrettyString(T[] array, ExecEnv env) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        boolean first = true;
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T object = TArray[n2];
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(EMFTVMUtil.toPrettyString(object, env));
            ++n2;
        }
        sb.append(']');
        return sb.toString();
    }

    public static Object get(ExecEnv env, EObject eo, EStructuralFeature sf) {
        if (env.getOutputModelOf(eo) != null) {
            throw new IllegalArgumentException(String.format("Cannot read properties of %s, as it is contained in an output model", EMFTVMUtil.toPrettyString(eo, env)));
        }
        return EMFTVMUtil.uncheckedGet(env, eo, sf);
    }

    public static Object uncheckedGet(ExecEnv env, EObject eo, EStructuralFeature sf) {
        if (sf instanceof EReference) {
            Object value = eo.eGet(sf);
            if (!(value instanceof Collection) || value instanceof LazyCollection) {
                return value;
            }
            if (value instanceof List) {
                if (eo != null && env.getInoutModelOf(eo) != null) {
                    return new LazyListOnList(new ArrayList((List)value));
                }
                return new LazyListOnList((List)value);
            }
            if (value instanceof Set) {
                if (eo != null && env.getInoutModelOf(eo) != null) {
                    return new LazySetOnSet(new LinkedHashSet((Set)value));
                }
                return new LazySetOnSet((Set)value);
            }
            if (eo != null && env.getInoutModelOf(eo) != null) {
                return new LazyListOnCollection(new ArrayList((Collection)value));
            }
            return new LazyListOnCollection((Collection)value);
        }
        return EMFTVMUtil.emf2vm(env, eo, eo.eGet(sf));
    }

    public static Object emf2vm(ExecEnv env, EObject eo, Object value) {
        if (value instanceof Enumerator) {
            return new EnumLiteral(value.toString());
        }
        if (value instanceof Collection) {
            if (value instanceof LazyCollection) {
                return value;
            }
            if (value instanceof List) {
                if (eo != null && env.getInoutModelOf(eo) != null) {
                    return new EnumConversionListOnList((List)value).cache();
                }
                return new EnumConversionListOnList((List)value);
            }
            if (value instanceof Set) {
                if (eo != null && env.getInoutModelOf(eo) != null) {
                    return new EnumConversionSetOnSet((Set)value).cache();
                }
                return new EnumConversionSetOnSet((Set)value);
            }
            if (eo != null && env.getInoutModelOf(eo) != null) {
                return new EnumConversionList((Collection)value).cache();
            }
            return new EnumConversionList((Collection)value);
        }
        if (value != null && value.getClass().isArray()) {
            if (Object.class.isAssignableFrom(value.getClass().getComponentType())) {
                return new LazyListOnList<Object>(Arrays.asList((Object[])value));
            }
            return value;
        }
        assert (eo == null || !(value instanceof Collection));
        return value;
    }

    public static void set(ExecEnv env, EObject eo, EStructuralFeature sf, Object value) {
        if (!sf.isChangeable()) {
            throw new IllegalArgumentException(String.format("Field %s::%s is not changeable", EMFTVMUtil.toPrettyString(sf.getEContainingClass(), env), sf.getName()));
        }
        if (env.getInputModelOf(eo) != null) {
            throw new IllegalArgumentException(String.format("Cannot set properties of %s, as it is contained in an input model", EMFTVMUtil.toPrettyString(eo, env)));
        }
        if (sf.isMany()) {
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException(String.format("Cannot assign %s to multi-valued field %s::%s", EMFTVMUtil.toPrettyString(value, env), sf.getEContainingClass().getName(), sf.getName()));
            }
            EMFTVMUtil.setMany(env, eo, sf, (Collection)value);
        } else {
            EMFTVMUtil.setSingle(env, eo, sf, value, -1);
        }
        assert (eo.eResource() != null);
    }

    public static void add(ExecEnv env, EObject eo, EStructuralFeature sf, Object value, int index) {
        if (!sf.isChangeable()) {
            throw new IllegalArgumentException(String.format("Field %s::%s is not changeable", EMFTVMUtil.toPrettyString(sf.getEContainingClass(), env), sf.getName()));
        }
        if (env.getInputModelOf(eo) != null) {
            throw new IllegalArgumentException(String.format("Cannot add properties to %s, as it is contained in an input model", EMFTVMUtil.toPrettyString(eo, env)));
        }
        if (sf.isMany()) {
            if (value instanceof Collection) {
                EMFTVMUtil.addMany(env, eo, sf, (Collection)value, index);
            } else {
                EMFTVMUtil.addMany(env, eo, sf, value, index);
            }
        } else {
            if (eo.eIsSet(sf)) {
                throw new IllegalArgumentException(String.format("Cannot add more than one value to %s::%s", EMFTVMUtil.toPrettyString(eo.eClass(), env), sf.getName()));
            }
            EMFTVMUtil.setSingle(env, eo, sf, value, index);
        }
        assert (eo.eResource() != null);
    }

    public static void remove(ExecEnv env, EObject eo, EStructuralFeature sf, Object value) {
        if (!sf.isChangeable()) {
            throw new IllegalArgumentException(String.format("Field %s::%s is not changeable", EMFTVMUtil.toPrettyString(sf.getEContainingClass(), env), sf.getName()));
        }
        if (env.getInputModelOf(eo) != null) {
            throw new IllegalArgumentException(String.format("Cannot remove properties of %s, as it is contained in an input model", EMFTVMUtil.toPrettyString(eo, env)));
        }
        if (sf.isMany()) {
            if (value instanceof Collection) {
                EMFTVMUtil.removeMany(env, eo, sf, (Collection)value);
            } else {
                EMFTVMUtil.removeMany(env, eo, sf, value);
            }
        } else {
            Object oldValue = eo.eGet(sf);
            EClassifier sfType = sf.getEType();
            if (sfType instanceof EEnum && value instanceof EnumLiteral) {
                EEnum eEnum = (EEnum)sfType;
                if (oldValue != null && oldValue.equals(((EnumLiteral)value).getEnumerator(eEnum))) {
                    EMFTVMUtil.setSingle(env, eo, sf, sf.getDefaultValue(), -1);
                }
            } else if (oldValue == null ? value == null : oldValue.equals(value)) {
                EMFTVMUtil.setSingle(env, eo, sf, sf.getDefaultValue(), -1);
            }
        }
        assert (eo.eResource() != null);
    }

    private static void setSingle(ExecEnv env, EObject eo, EStructuralFeature sf, Object value, int index) {
        assert (!sf.isMany());
        if (index > 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        if (sf instanceof EReference) {
            EReference ref = (EReference)sf;
            if (EMFTVMUtil.checkValue(env, eo, ref, value, EMFTVMUtil.isAllowInterModelReferences(env, eo))) {
                EObject oldValue = (EObject)eo.eGet(sf);
                assert (eo.eResource() != null);
                assert (value == null || ((EObject)value).eResource() != null);
                assert (oldValue == null || oldValue.eResource() != null);
                eo.eSet(sf, value);
                if (ref.isContainment() || ref.isContainer()) {
                    if (value != null) {
                        EMFTVMUtil.updateResource(eo, (EObject)value);
                    }
                    if (oldValue != null) {
                        EMFTVMUtil.updateResource(eo, oldValue);
                    }
                }
                assert (eo.eResource() != null);
                assert (value == null || ((EObject)value).eResource() != null);
                assert (oldValue == null || oldValue.eResource() != null);
            }
        } else {
            EClassifier sfType = sf.getEType();
            if (sfType instanceof EEnum) {
                EEnum eEnum = (EEnum)sfType;
                if (value instanceof EnumLiteral) {
                    eo.eSet(sf, (Object)((EnumLiteral)value).getEnumerator(eEnum));
                } else {
                    eo.eSet(sf, value);
                }
            } else {
                eo.eSet(sf, value);
            }
        }
    }

    private static void setMany(ExecEnv env, EObject eo, EStructuralFeature sf, Collection<?> value) {
        assert (sf.isMany());
        Collection values = (Collection)eo.eGet(sf);
        if (!values.isEmpty()) {
            if (sf instanceof EReference) {
                ArrayList vCopy = new ArrayList(values);
                for (EObject v : vCopy) {
                    EMFTVMUtil.removeRefValue((EReference)sf, eo, values, v);
                }
            } else {
                values.clear();
            }
        }
        EMFTVMUtil.addMany(env, eo, sf, value, -1);
    }

    private static void addMany(ExecEnv env, EObject eo, EStructuralFeature sf, Object value, int index) {
        assert (sf.isMany());
        Collection values = (Collection)eo.eGet(sf);
        if (sf instanceof EReference) {
            EReference ref = (EReference)sf;
            EMFTVMUtil.addRefValue(env, ref, eo, values, (EObject)value, index, EMFTVMUtil.isAllowInterModelReferences(env, eo));
        } else {
            EClassifier sfType = sf.getEType();
            if (sfType instanceof EEnum) {
                EMFTVMUtil.addEnumValue((EEnum)sfType, values, value, index);
            } else if (index > -1) {
                ((List)values).add(index, value);
            } else {
                values.add(value);
            }
        }
    }

    private static void addMany(ExecEnv env, EObject eo, EStructuralFeature sf, Collection<?> value, int index) {
        assert (sf.isMany());
        Collection values = (Collection)eo.eGet(sf);
        if (sf instanceof EReference) {
            ArrayList srcValues;
            EReference ref = (EReference)sf;
            boolean allowInterModelReferences = EMFTVMUtil.isAllowInterModelReferences(env, eo);
            ArrayList arrayList = srcValues = ref.isContainment() ? new ArrayList(value) : value;
            if (index > -1) {
                int currentIndex = index;
                for (Object v : srcValues) {
                    EMFTVMUtil.checkValueTypeIsEObject(env, ref, v);
                    EMFTVMUtil.addRefValue(env, ref, eo, values, (EObject)v, currentIndex++, allowInterModelReferences);
                }
            } else {
                for (Object v : srcValues) {
                    EMFTVMUtil.checkValueTypeIsEObject(env, ref, v);
                    EMFTVMUtil.addRefValue(env, ref, eo, values, (EObject)v, -1, allowInterModelReferences);
                }
            }
        } else {
            EClassifier sfType = sf.getEType();
            if (sfType instanceof EEnum) {
                EEnum eEnum = (EEnum)sfType;
                if (index > -1) {
                    int currentIndex = index;
                    for (Object v : value) {
                        EMFTVMUtil.addEnumValue(eEnum, values, v, currentIndex++);
                    }
                } else {
                    for (Object v : value) {
                        EMFTVMUtil.addEnumValue(eEnum, values, v, -1);
                    }
                }
            } else if (index > -1) {
                ((List)values).addAll(index, value);
            } else {
                values.addAll(value);
            }
        }
    }

    private static void checkValueTypeIsEObject(ExecEnv env, EReference ref, Object v) {
        if (!(v instanceof EObject)) {
            String message = v == null ? String.format("Cannot add/remove OclUndefined to/from multi-valued field %s::%s", ref.getEContainingClass().getName(), ref.getName()) : String.format("Cannot add/remove values of type %s to/from multi-valued field %s::%s", EMFTVMUtil.getTypeName(env, v.getClass()), ref.getEContainingClass().getName(), ref.getName());
            throw new IllegalArgumentException(message);
        }
    }

    private static void removeMany(ExecEnv env, EObject eo, EStructuralFeature sf, Object value) {
        assert (sf.isMany());
        Collection values = (Collection)eo.eGet(sf);
        if (sf instanceof EReference) {
            EReference ref = (EReference)sf;
            EMFTVMUtil.removeRefValue(ref, eo, values, (EObject)value);
        } else {
            EClassifier sfType = sf.getEType();
            if (sfType instanceof EEnum) {
                EEnum eEnum = (EEnum)sfType;
                EMFTVMUtil.removeEnumValue(eEnum, values, value);
            } else {
                values.remove(value);
            }
        }
    }

    private static void removeMany(ExecEnv env, EObject eo, EStructuralFeature sf, Collection<?> value) {
        assert (sf.isMany());
        Collection values = (Collection)eo.eGet(sf);
        if (sf instanceof EReference) {
            EReference ref = (EReference)sf;
            ArrayList srcValues = ref.isContainment() ? new ArrayList(value) : value;
            for (Object v : srcValues) {
                EMFTVMUtil.checkValueTypeIsEObject(env, ref, v);
                EMFTVMUtil.removeRefValue(ref, eo, values, (EObject)v);
            }
        } else {
            EClassifier sfType = sf.getEType();
            if (sfType instanceof EEnum) {
                EEnum eEnum = (EEnum)sfType;
                for (Object v : value) {
                    EMFTVMUtil.removeEnumValue(eEnum, values, v);
                }
            } else {
                values.removeAll(value);
            }
        }
    }

    private static void addEnumValue(EEnum eEnum, Collection<Object> values, Object v, int index) {
        Object v2 = v instanceof EnumLiteral ? ((EnumLiteral)v).getEnumerator(eEnum) : v;
        if (index > -1) {
            ((List)values).add(index, v2);
        } else {
            values.add(v2);
        }
    }

    private static void removeEnumValue(EEnum eEnum, Collection<Object> values, Object v) {
        if (v instanceof EnumLiteral) {
            values.remove(((EnumLiteral)v).getEnumerator(eEnum));
        } else {
            values.remove(v);
        }
    }

    private static void addRefValue(ExecEnv env, EReference ref, EObject eo, Collection<Object> values, EObject v, int index, boolean allowInterModelReferences) {
        assert (eo.eResource() != null);
        assert (v == null || v.eResource() != null);
        if (EMFTVMUtil.checkValue(env, eo, ref, v, allowInterModelReferences)) {
            if (index > -1) {
                ((List)values).add(index, v);
            } else {
                values.add(v);
            }
            if (ref.isContainment() || ref.isContainer()) {
                EMFTVMUtil.updateResource(eo, v);
            }
        }
        assert (eo.eResource() != null);
        assert (v.eResource() != null);
    }

    private static void removeRefValue(EReference ref, EObject eo, Collection<Object> values, EObject v) {
        assert (eo.eResource() != null);
        assert (v.eResource() != null);
        if (values.remove(v) && (ref.isContainment() || ref.isContainer())) {
            EMFTVMUtil.updateResource(eo, v);
        }
        assert (eo.eResource() != null);
        assert (v.eResource() != null);
    }

    private static void updateResource(EObject eo, EObject v) {
        if (eo.eResource() == null) {
            assert (eo.eContainer() == null);
            v.eResource().getContents().add((Object)eo);
        } else if (v.eResource() == null) {
            assert (v.eContainer() == null);
            eo.eResource().getContents().add((Object)v);
        }
        if (eo.eContainer() != null) {
            eo.eResource().getContents().remove((Object)eo);
        }
        if (v.eContainer() != null) {
            v.eResource().getContents().remove((Object)v);
        }
    }

    private static boolean isAllowInterModelReferences(ExecEnv env, EObject eo) {
        Model eoModel = env.getModelOf(eo);
        if (eoModel != null) {
            return eoModel.isAllowInterModelReferences();
        }
        return true;
    }

    private static boolean checkValue(ExecEnv env, EObject eo, EReference ref, Object value, boolean allowInterModelReferences) {
        if (value instanceof EObject) {
            assert (eo.eResource() != null);
            EObject ev = (EObject)value;
            if (eo.eResource() == ev.eResource() || ev.eResource() == null) {
                return true;
            }
            assert (ev.eResource() != null);
            if (!allowInterModelReferences) {
                ATLLogger.warning((String)String.format("Cannot set %s::%s to %s for %s: inter-model references are not allowed for this model", EMFTVMUtil.toPrettyString(ref.getEContainingClass(), env), ref.getName(), EMFTVMUtil.toPrettyString(value, env), EMFTVMUtil.toPrettyString(eo, env)));
                return false;
            }
            if (ref.isContainer() || ref.isContainment()) {
                ATLLogger.warning((String)String.format("Cannot set %s::%s to %s for %s: containment references cannot span across models", EMFTVMUtil.toPrettyString(ref.getEContainingClass(), env), ref.getName(), EMFTVMUtil.toPrettyString(value, env), EMFTVMUtil.toPrettyString(eo, env)));
                return false;
            }
            EReference opposite = ref.getEOpposite();
            if (opposite != null) {
                Model oppositeModel;
                Model evModel = env.getInputModelOf(ev);
                if (evModel != null) {
                    ATLLogger.warning((String)String.format("Cannot set %s::%s to %s for %s: inter-model reference with opposite causes changes in input model %s", EMFTVMUtil.toPrettyString(ref.getEContainingClass(), env), ref.getName(), EMFTVMUtil.toPrettyString(value, env), EMFTVMUtil.toPrettyString(eo, env), env.getModelID(evModel)));
                    return false;
                }
                if (!opposite.isMany() && (oppositeModel = env.getInputModelOf((EObject)ev.eGet((EStructuralFeature)opposite))) != null) {
                    ATLLogger.warning((String)String.format("Cannot set %s::%s to %s for %s: inter-model reference with single-valued opposite causes changes in input model %s", EMFTVMUtil.toPrettyString(ref.getEContainingClass(), env), ref.getName(), EMFTVMUtil.toPrettyString(value, env), EMFTVMUtil.toPrettyString(eo, env), env.getModelID(oppositeModel)));
                    return false;
                }
            }
        }
        return true;
    }

    public static Object[] getArgumentTypes(Object[] args) {
        int argcount = args.length;
        Object[] argTypes = new Object[argcount];
        int i = 0;
        while (i < argcount) {
            argTypes[i] = EMFTVMUtil.getArgumentType(args[i]);
            ++i;
        }
        return argTypes;
    }

    public static Object getArgumentType(Object arg) {
        if (arg instanceof EObject) {
            return ((EObject)arg).eClass();
        }
        if (arg != null) {
            return arg.getClass();
        }
        return Void.TYPE;
    }

    public static Object invokeNative(StackFrame frame, Object self, String opname, Object[] args) {
        Method method = EMFTVMUtil.findNativeMethod(self == null ? Void.TYPE : self.getClass(), opname, EMFTVMUtil.getArgumentClasses(args), false);
        if (method != null) {
            return EMFTVMUtil.invokeNative(frame, self, method, args);
        }
        throw new UnsupportedOperationException(String.format("%s::%s(%s)", EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(self)), opname, EMFTVMUtil.getTypeNames(frame.getEnv(), EMFTVMUtil.getArgumentTypes(args))));
    }

    public static Object invokeNative(StackFrame frame, Object self, Method method, Object[] args) {
        method = EMFTVMUtil.findRootMethod(method);
        StackFrame subFrame = frame.prepareNativeArgs(method, self, args);
        try {
            return EMFTVMUtil.emf2vm(frame.getEnv(), self instanceof EObject ? (EObject)self : null, method.invoke(self, args));
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof VMException) {
                throw (VMException)target;
            }
            throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
        }
        catch (VMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
        }
    }

    public static Object invokeNative(StackFrame frame, Object self, String opname, Object arg) {
        Method method = EMFTVMUtil.findNativeMethod(self == null ? Void.TYPE : self.getClass(), opname, arg == null ? Void.TYPE : arg.getClass(), false);
        if (method != null) {
            return EMFTVMUtil.invokeNative(frame, self, method, arg);
        }
        throw new UnsupportedOperationException(String.format("%s::%s(%s)", EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(self)), opname, EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(arg))));
    }

    public static Object invokeNative(StackFrame frame, Object self, Method method, Object arg) {
        method = EMFTVMUtil.findRootMethod(method);
        StackFrame subFrame = frame.prepareNativeContext(method, self);
        if (arg instanceof CodeBlock) {
            if (subFrame == null) {
                subFrame = new StackFrame(frame, method);
            }
            ((CodeBlock)arg).setParentFrame(subFrame);
        } else if (arg instanceof EnumLiteral) {
            arg = EMFTVMUtil.convertEnumLiteral((EnumLiteral)arg, method.getParameterTypes()[0]);
        }
        try {
            return EMFTVMUtil.emf2vm(frame.getEnv(), self instanceof EObject ? (EObject)self : null, method.invoke(self, arg));
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof VMException) {
                throw (VMException)target;
            }
            throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
        }
        catch (VMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
        }
    }

    public static Object invokeNative(StackFrame frame, Object self, String opname) {
        Method method = EMFTVMUtil.findNativeMethod(self == null ? Void.TYPE : self.getClass(), opname, false);
        if (method != null) {
            return EMFTVMUtil.invokeNative(frame, self, method);
        }
        throw new UnsupportedOperationException(String.format("%s::%s()", EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(self)), opname));
    }

    public static Object invokeNative(StackFrame frame, Object self, Method method) {
        method = EMFTVMUtil.findRootMethod(method);
        StackFrame subFrame = frame.prepareNativeContext(method, self);
        try {
            return EMFTVMUtil.emf2vm(frame.getEnv(), self instanceof EObject ? (EObject)self : null, method.invoke(self, new Object[0]));
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof VMException) {
                throw (VMException)target;
            }
            throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
        }
        catch (VMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
        }
    }

    public static Object invokeNativeStatic(StackFrame frame, Class<?> type, String opname, Object[] args) {
        Method method = EMFTVMUtil.findNativeMethod(type, opname, EMFTVMUtil.getArgumentClasses(args), true);
        if (method != null) {
            StackFrame subFrame = frame.prepareNativeArgs(method, args);
            try {
                return EMFTVMUtil.emf2vm(frame.getEnv(), null, method.invoke(type, args));
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof VMException) {
                    throw (VMException)target;
                }
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(String.format("static %s::%s(%s)", EMFTVMUtil.getTypeName(frame.getEnv(), type), opname, EMFTVMUtil.getTypeNames(frame.getEnv(), EMFTVMUtil.getArgumentTypes(args))));
    }

    public static Object invokeNativeStatic(StackFrame frame, Class<?> type, String opname, Object arg) {
        Method method = EMFTVMUtil.findNativeMethod(type, opname, arg == null ? Void.TYPE : arg.getClass(), true);
        if (method != null) {
            StackFrame subFrame = null;
            if (arg instanceof CodeBlock) {
                subFrame = new StackFrame(frame, method);
                ((CodeBlock)arg).setParentFrame(subFrame);
            } else if (arg instanceof EnumLiteral) {
                arg = EMFTVMUtil.convertEnumLiteral((EnumLiteral)arg, method.getParameterTypes()[0]);
            }
            try {
                return EMFTVMUtil.emf2vm(frame.getEnv(), null, method.invoke(type, arg));
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof VMException) {
                    throw (VMException)target;
                }
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(String.format("static %s::%s(%s)", EMFTVMUtil.getTypeName(frame.getEnv(), type), opname, EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(arg))));
    }

    public static Object invokeNativeStatic(StackFrame frame, Class<?> type, String opname) {
        Method method = EMFTVMUtil.findNativeMethod(type, opname, true);
        if (method != null) {
            try {
                return EMFTVMUtil.emf2vm(frame.getEnv(), null, method.invoke(type, new Object[0]));
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof VMException) {
                    throw (VMException)target;
                }
                throw new VMException(new StackFrame(frame, method), target);
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VMException(new StackFrame(frame, method), (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(String.format("static %s::%s()", EMFTVMUtil.getTypeName(frame.getEnv(), type), opname));
    }

    public static Method findNativeMethod(Class<?> context, String opname, Class<?>[] argTypes, boolean isStatic) {
        Method ret;
        if (context == Void.TYPE) {
            return null;
        }
        MethodSignature sig = EMFTVMUtil.getMethodSignature(context, opname, argTypes, isStatic);
        ++MethodCacheAccesses;
        WeakReference methodRef = (WeakReference)METHOD_CACHE.get(sig);
        Method method = ret = methodRef != null ? (Method)methodRef.get() : null;
        if (ret != null || methodRef == NULL_METHOD_REFERENCE) {
            ++MethodCacheHits;
            return (Method)methodRef.get();
        }
        return EMFTVMUtil.findNativeMethodInternal(context, opname, argTypes, isStatic, sig);
    }

    public static Method findNativeMethod(Class<?> context, String opname, Class<?> argType, boolean isStatic) {
        Method ret;
        if (context == Void.TYPE) {
            return null;
        }
        MethodSignature sig = EMFTVMUtil.getMethodSignature(context, opname, argType, isStatic);
        ++MethodCacheAccesses;
        WeakReference methodRef = (WeakReference)METHOD_CACHE.get(sig);
        Method method = ret = methodRef != null ? (Method)methodRef.get() : null;
        if (ret != null || methodRef == NULL_METHOD_REFERENCE) {
            ++MethodCacheHits;
            return ret;
        }
        return EMFTVMUtil.findNativeMethodInternal(context, opname, argType, isStatic, sig);
    }

    public static Method findNativeMethod(Class<?> context, String opname, boolean isStatic) {
        Method ret;
        if (context == Void.TYPE) {
            return null;
        }
        MethodSignature sig = EMFTVMUtil.getMethodSignature(context, opname, isStatic);
        ++MethodCacheAccesses;
        WeakReference methodRef = (WeakReference)METHOD_CACHE.get(sig);
        Method method = ret = methodRef != null ? (Method)methodRef.get() : null;
        if (ret != null || methodRef == NULL_METHOD_REFERENCE) {
            ++MethodCacheHits;
            return ret;
        }
        return EMFTVMUtil.findNativeMethodInternal(context, opname, isStatic, sig);
    }

    private static Method findNativeMethodInternal(Class<?> context, String opname, Class<?>[] argTypes, boolean isStatic, MethodSignature sig) {
        Method ret = null;
        Method[] methods = context.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Class<?>[] pts;
            Method method = methods[i];
            if (Modifier.isStatic(method.getModifiers()) == isStatic && method.getName().equals(opname) && (pts = method.getParameterTypes()).length == argTypes.length) {
                boolean ok = true;
                int j = 0;
                while (j < pts.length && ok) {
                    if (!EMFTVMUtil.checkParameterType(argTypes[j], pts[j])) {
                        ok = false;
                        break;
                    }
                    ++j;
                }
                if (ok) {
                    ret = method;
                    break;
                }
            }
            ++i;
        }
        if (ret == null && !isStatic && context.getSuperclass() != null) {
            ret = EMFTVMUtil.findNativeMethodInternal(context.getSuperclass(), opname, argTypes, isStatic, sig);
        } else {
            METHOD_CACHE.put(sig, (WeakReference<Method>)(ret != null ? new WeakReference<Object>(ret) : NULL_METHOD_REFERENCE));
        }
        return ret;
    }

    private static Method findNativeMethodInternal(Class<?> context, String opname, Class<?> argType, boolean isStatic, MethodSignature sig) {
        Method ret = null;
        Method[] methods = context.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Class<?>[] pts;
            Method method = methods[i];
            if (Modifier.isStatic(method.getModifiers()) == isStatic && method.getName().equals(opname) && (pts = method.getParameterTypes()).length == 1 && EMFTVMUtil.checkParameterType(argType, pts[0])) {
                ret = method;
                break;
            }
            ++i;
        }
        if (ret == null && !isStatic && context.getSuperclass() != null) {
            ret = EMFTVMUtil.findNativeMethodInternal(context.getSuperclass(), opname, argType, isStatic, sig);
        } else {
            METHOD_CACHE.put(sig, (WeakReference<Method>)(ret != null ? new WeakReference<Object>(ret) : NULL_METHOD_REFERENCE));
        }
        return ret;
    }

    private static Method findNativeMethodInternal(Class<?> context, String opname, boolean isStatic, MethodSignature sig) {
        Method ret = null;
        Method[] methods = context.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (Modifier.isStatic(method.getModifiers()) == isStatic && method.getName().equals(opname) && method.getParameterTypes().length == 0) {
                ret = method;
                break;
            }
            ++i;
        }
        if (ret == null && !isStatic && context.getSuperclass() != null) {
            ret = EMFTVMUtil.findNativeMethodInternal(context.getSuperclass(), opname, isStatic, sig);
        } else {
            METHOD_CACHE.put(sig, (WeakReference<Method>)(ret != null ? new WeakReference<Object>(ret) : NULL_METHOD_REFERENCE));
        }
        return ret;
    }

    private static boolean checkParameterType(Class<?> argType, Class<?> pt) {
        if (argType == EnumLiteral.class && Enumerator.class.isAssignableFrom(pt)) {
            return true;
        }
        if (pt.isAssignableFrom(argType)) {
            return true;
        }
        if (pt == Boolean.TYPE) {
            return argType == Boolean.class;
        }
        if (pt == Integer.TYPE) {
            return argType == Integer.class;
        }
        if (pt == Character.TYPE) {
            return argType == Character.class;
        }
        if (pt == Long.TYPE) {
            return argType == Long.class;
        }
        if (pt == Float.TYPE) {
            return argType == Float.class;
        }
        if (pt == Double.TYPE) {
            return argType == Double.class;
        }
        return argType == Void.TYPE;
    }

    private static Method compareNativeMethod0(Operation op, Method method) {
        if (op != null && method != null) {
            Class opCtx = op.getEContext().getInstanceClass();
            Class<?> methCtx = NativeTypes.boxedType(method.getDeclaringClass());
            if (opCtx == null || methCtx.isAssignableFrom(opCtx) || !opCtx.isAssignableFrom(methCtx)) {
                return null;
            }
        }
        return method;
    }

    private static Method compareNativeMethod1(Operation op, Method method) {
        if (op != null && method != null) {
            Class opCtx = op.getEContext().getInstanceClass();
            Class<?> methCtx = NativeTypes.boxedType(method.getDeclaringClass());
            if (opCtx == null) {
                return null;
            }
            if (methCtx.isAssignableFrom(opCtx) || !opCtx.isAssignableFrom(methCtx)) {
                if (!methCtx.equals(opCtx)) {
                    return null;
                }
                Class opArgType = ((Parameter)op.getParameters().get(0)).getEType().getInstanceClass();
                Class<?> methArgType = NativeTypes.boxedType(method.getParameterTypes()[0]);
                if (opArgType == null || methArgType.isAssignableFrom(opArgType) || !opArgType.isAssignableFrom(methArgType)) {
                    return null;
                }
            }
        }
        return method;
    }

    private static Method compareNativeMethodN(Operation op, Method method) {
        if (op != null && method != null) {
            Class opCtx = op.getEContext().getInstanceClass();
            Class<?> methCtx = NativeTypes.boxedType(method.getDeclaringClass());
            if (opCtx == null) {
                return null;
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            EList<Parameter> parameters = op.getParameters();
            int len = parameterTypes.length;
            int i = -1;
            while (methCtx.isAssignableFrom(opCtx) || !opCtx.isAssignableFrom(methCtx)) {
                if (!methCtx.equals(opCtx) || ++i == len) {
                    return null;
                }
                opCtx = ((Parameter)parameters.get(i)).getEType().getInstanceClass();
                if (opCtx == null) {
                    return null;
                }
                methCtx = NativeTypes.boxedType(parameterTypes[i]);
            }
        }
        return method;
    }

    public static Method findNativeMethod(Operation op, Object self, String opname) {
        return EMFTVMUtil.compareNativeMethod0(op, EMFTVMUtil.findNativeMethod(self == null ? Void.TYPE : self.getClass(), opname, false));
    }

    public static Method findNativeMethod(Operation op, Object self, String opname, Object arg) {
        return EMFTVMUtil.compareNativeMethod1(op, EMFTVMUtil.findNativeMethod(self == null ? Void.TYPE : self.getClass(), opname, arg == null ? Void.TYPE : arg.getClass(), false));
    }

    public static Method findNativeMethod(Operation op, Object self, String opname, Object[] args) {
        return EMFTVMUtil.compareNativeMethodN(op, EMFTVMUtil.findNativeMethod(self == null ? Void.TYPE : self.getClass(), opname, EMFTVMUtil.getArgumentClasses(args), false));
    }

    private static Class<?>[] getSuperTypes(Class<?> type) {
        Class[] superTypes;
        if (type == null || type == Void.TYPE) {
            return new Class[]{Void.TYPE};
        }
        Class<?>[] interfaces = type.getInterfaces();
        Class<?> superClass = type.getSuperclass();
        if (superClass != null) {
            superTypes = new Class[interfaces.length + 1];
            superTypes[0] = superClass;
            System.arraycopy(interfaces, 0, superTypes, 1, interfaces.length);
        } else {
            superTypes = new Class[interfaces.length];
            System.arraycopy(interfaces, 0, superTypes, 0, interfaces.length);
        }
        return superTypes;
    }

    private static Method compareNativeMethod0(Method method1, Method method2) {
        if (method2 == null) {
            return method1;
        }
        if (method1 != null) {
            Class<?> meth1Ctx = NativeTypes.boxedType(method1.getDeclaringClass());
            Class<?> meth2Ctx = NativeTypes.boxedType(method2.getDeclaringClass());
            if (meth2Ctx.isAssignableFrom(meth1Ctx) || !meth1Ctx.isAssignableFrom(meth2Ctx)) {
                return method1;
            }
        }
        return method2;
    }

    private static Method compareNativeMethod1(Method method1, Method method2) {
        if (method2 == null) {
            return method1;
        }
        if (method1 != null) {
            Class<?> meth1Ctx = NativeTypes.boxedType(method1.getDeclaringClass());
            Class<?> meth2Ctx = NativeTypes.boxedType(method2.getDeclaringClass());
            if (meth2Ctx.isAssignableFrom(meth1Ctx) || !meth1Ctx.isAssignableFrom(meth2Ctx)) {
                if (!meth2Ctx.equals(meth1Ctx)) {
                    return method1;
                }
                Class<?> meth1ArgType = NativeTypes.boxedType(method1.getParameterTypes()[0]);
                Class<?> meth2ArgType = NativeTypes.boxedType(method2.getParameterTypes()[0]);
                if (meth2ArgType.isAssignableFrom(meth1ArgType) || !meth1ArgType.isAssignableFrom(meth2ArgType)) {
                    return method1;
                }
            }
        }
        return method2;
    }

    private static Method compareNativeMethodN(Method method1, Method method2) {
        if (method2 == null) {
            return method1;
        }
        if (method1 != null) {
            Class<?> meth1Ctx = NativeTypes.boxedType(method1.getDeclaringClass());
            Class<?> meth2Ctx = NativeTypes.boxedType(method2.getDeclaringClass());
            Class<?>[] parameterTypes1 = method1.getParameterTypes();
            Class<?>[] parameterTypes2 = method2.getParameterTypes();
            int len = parameterTypes1.length;
            int i = -1;
            while (meth2Ctx.isAssignableFrom(meth1Ctx) || !meth1Ctx.isAssignableFrom(meth2Ctx)) {
                if (!meth2Ctx.equals(meth1Ctx) || ++i == len) {
                    return method1;
                }
                meth1Ctx = NativeTypes.boxedType(parameterTypes1[i]);
                meth2Ctx = NativeTypes.boxedType(parameterTypes2[i]);
            }
        }
        return method2;
    }

    public static Method findNativeSuperMethod(Operation op, Class<?> context, String opname) {
        Method method = null;
        Class<?>[] classArray = EMFTVMUtil.getSuperTypes(context);
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> superCtx = classArray[n2];
            method = EMFTVMUtil.compareNativeMethod0(method, EMFTVMUtil.findNativeMethod(superCtx, opname, false));
            ++n2;
        }
        return EMFTVMUtil.compareNativeMethod0(op, method);
    }

    public static Method findNativeSuperMethod(Operation op, Class<?> context, String opname, Object arg) {
        Class<Void> argType = arg == null ? Void.TYPE : arg.getClass();
        Method method = null;
        Class<?>[] classArray = EMFTVMUtil.getSuperTypes(context);
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> superCtx = classArray[n2];
            method = EMFTVMUtil.compareNativeMethod1(method, EMFTVMUtil.findNativeMethod(superCtx, opname, argType, false));
            ++n2;
        }
        return EMFTVMUtil.compareNativeMethod1(op, method);
    }

    public static Method findNativeSuperMethod(Operation op, Class<?> context, String opname, Object[] args) {
        Class<?>[] argTypes = EMFTVMUtil.getArgumentClasses(args);
        Method method = null;
        Class<?>[] classArray = EMFTVMUtil.getSuperTypes(context);
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> superCtx = classArray[n2];
            method = EMFTVMUtil.compareNativeMethodN(method, EMFTVMUtil.findNativeMethod(superCtx, opname, argTypes, false));
            ++n2;
        }
        return EMFTVMUtil.compareNativeMethodN(op, method);
    }

    public static Constructor<?> findConstructor(Class<?> context, Class<?>[] argTypes) {
        if (context == Void.TYPE) {
            return null;
        }
        Constructor<?> ret = null;
        Constructor<?>[] constructors = context.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            Constructor<?> constructor = constructors[i];
            Class<?>[] pts = constructor.getParameterTypes();
            if (pts.length == argTypes.length) {
                boolean ok = true;
                int j = 0;
                while (j < pts.length && ok) {
                    if (!(argTypes[j] == EnumLiteral.class && Enumerator.class.isAssignableFrom(pts[j]) || pts[j].isAssignableFrom(argTypes[j]))) {
                        ok = pts[j] == Boolean.TYPE ? argTypes[j] == Boolean.class : (pts[j] == Integer.TYPE ? argTypes[j] == Integer.class : (pts[j] == Character.TYPE ? argTypes[j] == Character.class : (pts[j] == Long.TYPE ? argTypes[j] == Long.class : (pts[j] == Float.TYPE ? argTypes[j] == Float.class : (pts[j] == Double.TYPE ? argTypes[j] == Double.class : argTypes[j] == Void.TYPE)))));
                    }
                    ++j;
                }
                if (ok) {
                    ret = constructor;
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    private static MethodSignature getMethodSignature(Class<?> context, String name, Class<?>[] argumentTypes, boolean isStatic) {
        return new MethodSignature(context, name, argumentTypes, isStatic);
    }

    private static MethodSignature getMethodSignature(Class<?> context, String name, Class<?> argumentType, boolean isStatic) {
        return new MethodSignature(context, name, new Class[]{argumentType}, isStatic);
    }

    private static MethodSignature getMethodSignature(Class<?> context, String name, boolean isStatic) {
        return new MethodSignature(context, name, null, isStatic);
    }

    public static Class<?>[] getArgumentClasses(Object[] args) {
        int argcount = args.length;
        Class[] argTypes = new Class[argcount];
        int i = 0;
        while (i < argcount) {
            argTypes[i] = args[i] == null ? Void.TYPE : args[i].getClass();
            ++i;
        }
        return argTypes;
    }

    public static boolean writeToWithCharset(String string, String path, String charset) throws IOException {
        File file = EMFTVMUtil.getFile(path);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintStream out = charset == null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(file)), true) : new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), true, charset);
        out.print(string);
        out.close();
        return true;
    }

    public static File getFile(String path) {
        try {
            WorkspaceUtil wsUtil = (WorkspaceUtil)Class.forName(WORKSPACE_UTIL_IMPL).newInstance();
            String wsPath = wsUtil.getWorkspaceLocation(path);
            if (wsPath != null) {
                return new File(wsPath);
            }
        }
        catch (InstantiationException e) {
            ATLLogger.fine((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            ATLLogger.fine((String)e.getMessage());
        }
        catch (ClassNotFoundException e) {
            ATLLogger.fine((String)e.getMessage());
        }
        ATLLogger.info((String)"Could not find workspace root; falling back to native java.io.File path resolution");
        return new File(path);
    }

    public static Operation createOperation(boolean isStatic, String name, String[] context, String[] returnType, String[][][] parameters, CodeBlock body) {
        EmftvmFactory factory = EmftvmFactory.eINSTANCE;
        Operation op = factory.createOperation();
        op.setStatic(isStatic);
        op.setName(name);
        op.setContextModel(context[0]);
        op.setContext(context[1]);
        op.setTypeModel(returnType[0]);
        op.setType(returnType[1]);
        EList<Parameter> pars = op.getParameters();
        EList<LocalVariable> locals = body.getLocalVariables();
        if (!isStatic) {
            LocalVariable self = factory.createLocalVariable();
            self.setName("self");
            self.setTypeModel(context[0]);
            self.setType(context[1]);
            locals.add((Object)self);
        }
        String[][][] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String[][] par = stringArray[n2];
            Parameter p = factory.createParameter();
            p.setName(par[0][0]);
            p.setTypeModel(par[1][0]);
            p.setType(par[1][1]);
            pars.add((Object)p);
            LocalVariable lv = factory.createLocalVariable();
            lv.setName(par[0][0]);
            lv.setTypeModel(par[1][0]);
            lv.setType(par[1][1]);
            locals.add((Object)lv);
            ++n2;
        }
        op.setBody(body);
        return op;
    }

    public static Field createField(String name, boolean isStatic, String[] context, String[] type, CodeBlock initialiser) {
        Field f = EmftvmFactory.eINSTANCE.createField();
        f.setName(name);
        f.setContextModel(context[0]);
        f.setContext(context[1]);
        f.setTypeModel(type[0]);
        f.setType(type[1]);
        f.setInitialiser(initialiser);
        f.setStatic(isStatic);
        return f;
    }

    public static LazyList<Object> getTrans(Object object, Field field, StackFrame frame, LazyList<Object> result) {
        LazyList<Object> newResult = result;
        Object value = field.getValue(object, frame);
        if (value instanceof List) {
            List cvalue = (List)value;
            newResult = newResult.union(new LazyListOnList(cvalue));
            for (Object v : cvalue) {
                newResult = EMFTVMUtil.getTrans(v, field, frame, newResult);
            }
        } else if (value instanceof Collection) {
            Collection cvalue = (Collection)value;
            newResult = newResult.union(new LazyListOnCollection(cvalue));
            for (Object v : cvalue) {
                newResult = EMFTVMUtil.getTrans(v, field, frame, newResult);
            }
        } else if (value != null) {
            newResult = newResult.append(value);
            newResult = EMFTVMUtil.getTrans(value, field, frame, newResult);
        }
        return newResult;
    }

    public static LazyList<Object> getTrans(EObject object, EStructuralFeature sf, ExecEnv env, LazyList<Object> result) {
        if (!sf.getEContainingClass().isSuperTypeOf(object.eClass())) {
            return result;
        }
        LazyList<Object> newResult = result;
        Object value = EMFTVMUtil.get(env, object, sf);
        if (value instanceof LazyList) {
            LazyList cvalue = (LazyList)value;
            newResult = newResult.union(cvalue);
            for (Object v : cvalue) {
                if (!(v instanceof EObject)) continue;
                newResult = EMFTVMUtil.getTrans((EObject)v, sf, env, newResult);
            }
        } else if (value != null) {
            assert (!(value instanceof Collection));
            if (value instanceof Enumerator) {
                newResult = newResult.append(new EnumLiteral(value.toString()));
            } else {
                newResult = newResult.append(value);
                if (value instanceof EObject) {
                    newResult = EMFTVMUtil.getTrans((EObject)value, sf, env, newResult);
                }
            }
        }
        return newResult;
    }

    public static LazyList<Object> getTrans(Object object, java.lang.reflect.Field field, LazyList<Object> result) throws IllegalArgumentException, IllegalAccessException {
        if (!field.getDeclaringClass().isAssignableFrom(object.getClass())) {
            return result;
        }
        LazyList<Object> newResult = result;
        Object value = field.get(object);
        if (value instanceof LazyList) {
            LazyList cvalue = (LazyList)value;
            newResult = newResult.union(cvalue);
            for (Object v : cvalue) {
                newResult = EMFTVMUtil.getTrans(v, field, newResult);
            }
        } else if (value instanceof List) {
            List cvalue = (List)value;
            newResult = newResult.union(new LazyListOnList(cvalue));
            for (Object v : cvalue) {
                newResult = EMFTVMUtil.getTrans(v, field, newResult);
            }
        } else if (value instanceof Collection) {
            Collection cvalue = (Collection)value;
            newResult = newResult.union(new LazyListOnCollection(cvalue));
            for (Object v : cvalue) {
                newResult = EMFTVMUtil.getTrans(v, field, newResult);
            }
        } else if (value != null) {
            newResult = newResult.append(value);
            newResult = EMFTVMUtil.getTrans(value, field, newResult);
        }
        return newResult;
    }

    static Object convertEnumLiteral(EnumLiteral literal, Class<?> type) {
        if (Enumerator.class.isAssignableFrom(type)) {
            try {
                String litName = literal.getName();
                java.lang.reflect.Field valuesField = type.getDeclaredField("VALUES");
                Object values = valuesField.get(null);
                if (values instanceof Collection) {
                    for (Object value : (Collection)values) {
                        if (!(value instanceof Enumerator) || !litName.equals(((Enumerator)value).getName()) && !litName.equals(value.toString())) continue;
                        return value;
                    }
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return literal;
    }

    public static Locale getLocale(String locale) {
        StringTokenizer st = new StringTokenizer(locale, "_");
        String language = st.nextToken();
        if (st.hasMoreTokens()) {
            String country = st.nextToken();
            if (st.hasMoreTokens()) {
                String variant = st.nextToken("\n");
                return new Locale(language, country, variant);
            }
            return new Locale(language, country);
        }
        return new Locale(language);
    }

    public static void registerEPackages(ResourceSet rs) {
        EPackage.Registry registry = rs.getPackageRegistry();
        TreeIterator i = EcoreUtil.getAllContents((ResourceSet)rs, (boolean)true);
        while (i.hasNext()) {
            Object object = i.next();
            if (object instanceof EPackage) {
                EPackage p = (EPackage)object;
                String nsURI = p.getNsURI();
                if (nsURI == null) {
                    nsURI = p.getName();
                    p.setNsURI(nsURI);
                }
                registry.put((Object)nsURI, (Object)p);
                continue;
            }
            if (!(object instanceof EDataType)) continue;
            EMFTVMUtil.adaptDataType((EDataType)object);
        }
    }

    private static void adaptDataType(EDataType dt) {
        String icn = dt.getInstanceClassName();
        if (icn == null) {
            String tname = dt.getName();
            if (tname.equals("Boolean")) {
                icn = "boolean";
            } else if (tname.equals("Double") || tname.equals("Real")) {
                icn = "java.lang.Double";
            } else if (tname.equals("Float")) {
                icn = "java.lang.Float";
            } else if (tname.equals("Integer")) {
                icn = "java.lang.Integer";
            } else if (tname.equals("String")) {
                icn = "java.lang.String";
            }
            if (icn != null) {
                dt.setInstanceClassName(icn);
            }
        }
    }

    public static Method findRootMethod(Method method) {
        Method rootMethod;
        if (method == null) {
            return null;
        }
        ++RootMethodCacheAccesses;
        WeakReference<Method> rootMethodReference = ROOT_METHOD_CACHE.get(method);
        Method method2 = rootMethod = rootMethodReference != null ? (Method)rootMethodReference.get() : null;
        if (rootMethod != null) {
            ++RootMethodCacheHits;
            return rootMethod;
        }
        rootMethod = EMFTVMUtil.findRootMethodInner(method);
        ROOT_METHOD_CACHE.put(method, new WeakReference<Method>(rootMethod));
        return rootMethod;
    }

    private static Method findRootMethodInner(Method method) {
        int methodModifiers = EMFTVMUtil.getRelevantModifiers(method);
        Class<?> dc = method.getDeclaringClass();
        LinkedHashSet<Class<?>> dis = new LinkedHashSet(Arrays.asList(dc.getInterfaces()));
        while ((dc = dc.getSuperclass()) != null) {
            try {
                Method superMethod = dc.getDeclaredMethod(method.getName(), method.getParameterTypes());
                if (EMFTVMUtil.getRelevantModifiers(superMethod) != methodModifiers) break;
                method = superMethod;
            }
            catch (SecurityException superMethod) {
            }
            catch (NoSuchMethodException superMethod) {
                // empty catch block
            }
            dis.addAll(Arrays.asList(dc.getInterfaces()));
        }
        while (!dis.isEmpty()) {
            LinkedHashSet newDis = new LinkedHashSet();
            for (Class clazz : dis) {
                try {
                    if (clazz.isAssignableFrom(method.getDeclaringClass())) {
                        method = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                newDis.addAll(Arrays.asList(clazz.getInterfaces()));
            }
            newDis.removeAll(dis);
            dis = newDis;
        }
        return method;
    }

    private static int getRelevantModifiers(Method method) {
        int methodModifiers = method.getModifiers();
        return methodModifiers & 0xF;
    }

    public static double getMethodCacheHitRate() {
        return MethodCacheAccesses > 0 ? (double)MethodCacheHits / (double)MethodCacheAccesses : -1.0;
    }

    public static double getRootMethodCacheHitRate() {
        return RootMethodCacheAccesses > 0 ? (double)RootMethodCacheHits / (double)RootMethodCacheAccesses : -1.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RegistryTypeSwitch
    extends EcoreSwitch<Object> {
        public Object defaultCase(EObject object) {
            throw new IllegalArgumentException("Unsupported type: " + object);
        }

        public Object caseEClass(EClass object) {
            return object;
        }

        public Object caseEClassifier(EClassifier object) {
            Class ic = object.getInstanceClass();
            if (ic == null) {
                throw new IllegalArgumentException(String.format("Primitive EMF type without instance class %s", object));
            }
            return ic;
        }

        public Object caseEEnum(EEnum object) {
            return EnumLiteral.class;
        }
    }
}

