/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.emftvm.ModelFactory;
import org.eclipse.m2m.atl.emftvm.util.PluginExtensionUtil;
import org.eclipse.m2m.atl.emftvm.util.TypeHashMap;
import org.eclipse.m2m.atl.emftvm.util.TypeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginExtensionUtilImpl
implements PluginExtensionUtil {
    private static final String MODELFACTORY_EXTENSION_POINT = "org.eclipse.m2m.atl.emftvm.modelfactory";

    @Override
    public TypeMap<Class<?>, ModelFactory> createModelFactoryRegistry() {
        TypeHashMap modelFactoryRegistry = new TypeHashMap();
        if (Platform.isRunning()) {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(MODELFACTORY_EXTENSION_POINT).getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String resourceType = configElements[j].getAttribute("resourceType");
                    if (resourceType != null && resourceType.length() > 0) {
                        try {
                            Class<?> resourceClass = Class.forName(resourceType);
                            ModelFactory modelFactory = (ModelFactory)configElements[j].createExecutableExtension("class");
                            modelFactoryRegistry.put(resourceClass, modelFactory);
                        }
                        catch (ClassNotFoundException e) {
                            ATLLogger.log((Level)Level.WARNING, (String)"Cannot find specified resourceType", (Throwable)e);
                        }
                        catch (CoreException e) {
                            ATLLogger.log((Level)Level.WARNING, (String)"Cannot create instance of specified class", (Throwable)e);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return modelFactoryRegistry;
    }
}

