/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlEditorUI;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlModelAnalyser;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.BagType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.BooleanType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.CollectionType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Feature;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.IntegerType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.MapType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.ModelElementType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.ModuleType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclAnyType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Operation;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OrderedSetType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.RealType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.SequenceType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.SetType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.StringType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.TupleType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.UnitType;
import org.eclipse.m2m.atl.engine.parser.AtlSourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlTypesProcessor {
    private UnitType unit;
    private AtlModelAnalyser analyser;

    public void update(IFile file, AtlModelAnalyser analyser, AtlSourceManager manager) {
        this.analyser = analyser;
        this.unit = UnitType.create(file, manager);
    }

    public OclAnyType getType(EObject element) throws BadLocationException {
        OclAnyType res = OclAnyType.getInstance();
        if (AtlTypesProcessor.oclIsKindOf(element, "OclModelElement")) {
            res = OclAnyType.create(this.unit.getSourceManager(), element).getOclType();
        } else if (AtlTypesProcessor.oclIsKindOf(element, "Binding")) {
            Feature feature = this.getBindingFeature(element);
            if (feature != null) {
                res = feature.getType();
            }
        } else if (AtlTypesProcessor.oclIsKindOf(element, "StringExp")) {
            res = StringType.getInstance();
        } else if (AtlTypesProcessor.oclIsKindOf(element, "IntegerExp")) {
            res = IntegerType.getInstance();
        } else if (AtlTypesProcessor.oclIsKindOf(element, "RealExp")) {
            res = RealType.getInstance();
        } else if (AtlTypesProcessor.oclIsKindOf(element, "BooleanExp")) {
            res = BooleanType.getInstance();
        } else if (AtlTypesProcessor.oclIsKindOf(element, "SequenceExp")) {
            res = new SequenceType(this.getCollectionExpType(element));
        } else if (AtlTypesProcessor.oclIsKindOf(element, "BagExp")) {
            res = new BagType(this.getCollectionExpType(element));
        } else if (AtlTypesProcessor.oclIsKindOf(element, "SetExp")) {
            res = new SetType(this.getCollectionExpType(element));
        } else if (AtlTypesProcessor.oclIsKindOf(element, "OrderedSetExp")) {
            res = new OrderedSetType(this.getCollectionExpType(element));
        } else if (AtlTypesProcessor.oclIsKindOf(element, "MapExp")) {
            res = MapType.getInstance();
        } else if (AtlTypesProcessor.oclIsKindOf(element, "TupleExp")) {
            res = TupleType.getInstance();
        } else if (AtlTypesProcessor.oclIsKindOf(element, "VariableExp")) {
            res = this.getVariableExpType(element);
        } else if (AtlTypesProcessor.oclIsKindOf(element, "NavigationOrAttributeCallExp")) {
            Feature feature = this.getFeature(element);
            if (feature != null) {
                res = feature.getType();
            }
        } else if (AtlTypesProcessor.oclIsKindOf(element, "OperatorCallExp")) {
            res = this.getOperatorCallExpType(element);
        } else if (AtlTypesProcessor.oclIsKindOf(element, "OperationCallExp")) {
            res = this.getOperationCallExpType(element);
        } else if (AtlTypesProcessor.oclIsKindOf(element, "IteratorExp")) {
            res = this.getIteratorExpType(element);
        } else if (AtlTypesProcessor.oclIsKindOf(element, "Iterator")) {
            res = this.getIteratorType(element);
        } else if (AtlTypesProcessor.oclIsKindOf(element, "VariableDeclaration")) {
            res = this.getVariableDeclarationType(element);
        }
        return res;
    }

    public String getInformation(EObject locatedElement) throws BadLocationException {
        if (AtlTypesProcessor.oclIsKindOf(locatedElement, "OclModelElement")) {
            OclAnyType type = OclAnyType.create(this.unit.getSourceManager(), locatedElement);
            if (type instanceof ModelElementType) {
                return ((ModelElementType)type).getInformation();
            }
        } else if (AtlTypesProcessor.oclIsKindOf(locatedElement, "Binding")) {
            Feature feature = this.getBindingFeature(locatedElement);
            if (feature != null) {
                return feature.getInformation();
            }
        } else {
            if (AtlTypesProcessor.oclIsKindOf(locatedElement, "VariableExp")) {
                String code = this.analyser.getText(locatedElement);
                String name = AtlTypesProcessor.analyzeVariableExp(code)[0];
                return String.valueOf(name) + " : " + this.getType(locatedElement);
            }
            if (AtlTypesProcessor.oclIsKindOf(locatedElement, "NavigationOrAttributeCallExp")) {
                Feature feature = this.getFeature(locatedElement);
                if (feature != null) {
                    String atlDoc = feature.getDocumentation();
                    if (atlDoc != null) {
                        return atlDoc;
                    }
                    return feature.getInformation();
                }
            } else {
                if (AtlTypesProcessor.oclIsKindOf(locatedElement, "OperationCallExp")) {
                    return this.getOperationCallExpInformation(locatedElement);
                }
                if (AtlTypesProcessor.oclIsKindOf(locatedElement, "VariableDeclaration")) {
                    String name = (String)AtlTypesProcessor.eGet(locatedElement, "varName");
                    return String.valueOf(name) + " : " + this.getType(locatedElement);
                }
                if (AtlTypesProcessor.oclIsKindOf(locatedElement, "IteratorExp")) {
                    String elementName = (String)AtlTypesProcessor.eGet(locatedElement, "name");
                    return this.getTemplateInformation(elementName, locatedElement);
                }
                if (AtlTypesProcessor.oclIsKindOf(locatedElement, "IterateExp")) {
                    String elementName = "iterate";
                    return this.getTemplateInformation(elementName, locatedElement);
                }
                if (AtlTypesProcessor.oclIsKindOf(locatedElement, "Operation")) {
                    return this.getOperationInformation(locatedElement);
                }
                if (AtlTypesProcessor.oclIsKindOf(locatedElement, "Attribute")) {
                    return this.getAttributeInformation(locatedElement);
                }
                if (AtlTypesProcessor.oclIsKindOf(locatedElement, "Rule") || AtlTypesProcessor.oclIsKindOf(locatedElement, "Query")) {
                    String name = (String)AtlTypesProcessor.eGet(locatedElement, "name");
                    return name;
                }
            }
        }
        return null;
    }

    public String getTemplateInformation(String elementName, EObject element) throws BadLocationException {
        Template template = AtlEditorUI.getDefault().getTemplateStore().findTemplate(elementName);
        if (template != null) {
            String name = template.getPattern();
            name = name.replaceAll("\\$\\{([\\w]*)\\}", "$1");
            String type = this.getType(element).toString();
            String desc = template.getDescription();
            String cutDesc = AtlTypesProcessor.cutString(desc);
            return String.valueOf(name) + " : " + type + "\n\n" + cutDesc;
        }
        return null;
    }

    public static String cutString(String s) {
        StringBuffer sb = new StringBuffer(s);
        int frameLength = 55;
        int i = 0;
        while (i < sb.length() / frameLength) {
            int offset;
            int end = (i + 1) * frameLength + i;
            if (end > sb.length()) {
                end = sb.length();
            }
            if ((offset = sb.substring(0, end).lastIndexOf(32)) != -1) {
                sb.replace(offset, offset + 1, "\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public Object getDeclaration(EObject element) throws BadLocationException {
        Object res = null;
        if (AtlTypesProcessor.oclIsKindOf(element, "VariableExp")) {
            res = this.getVariableExpDeclaration(element);
        } else if (AtlTypesProcessor.oclIsKindOf(element, "OclModelElement")) {
            res = OclAnyType.create(this.unit.getSourceManager(), element).getOclType().getClassifier();
        } else if (AtlTypesProcessor.oclIsKindOf(element, "Binding")) {
            res = this.getBindingFeature(element);
        } else if (AtlTypesProcessor.oclIsKindOf(element, "NavigationOrAttributeCallExp")) {
            res = this.getFeature(element);
        } else if (AtlTypesProcessor.oclIsKindOf(element, "OperationCallExp")) {
            res = this.getOperationCallExpDeclaration(element);
        } else if (AtlTypesProcessor.oclIsKindOf(element, "VariableDeclaration")) {
            res = element;
        } else if (AtlTypesProcessor.oclIsKindOf(element, "OclModel")) {
            res = this.getMetamodelDeclaration(element);
        } else {
            AtlTypesProcessor.oclIsKindOf(element, "EnumLiteralExp");
        }
        return res;
    }

    public Map<String, OclAnyType> getVariables(EObject element) throws BadLocationException {
        HashMap<String, OclAnyType> variables = new HashMap<String, OclAnyType>();
        variables.putAll(this.getRootVariables(element));
        for (EObject container : this.analyser.getContainers(element)) {
            variables.putAll(this.getLocalVariableDeclarations(container));
        }
        return variables;
    }

    private Object getMetamodelDeclaration(EObject element) {
        Collection outModels;
        EObject res = null;
        String name = (String)AtlTypesProcessor.eGet(element, "name");
        Collection inModels = (Collection)AtlTypesProcessor.eGet(this.unit.getSourceManager().getModel(), "inModels");
        if (inModels != null) {
            for (EObject model : inModels) {
                EObject metamodel = (EObject)AtlTypesProcessor.eGet(model, "metamodel");
                if (!name.equals(AtlTypesProcessor.eGet(metamodel, "name"))) continue;
                res = metamodel;
            }
        }
        if (res == null && (outModels = (Collection)AtlTypesProcessor.eGet(this.unit.getSourceManager().getModel(), "outModels")) != null) {
            for (EObject model : outModels) {
                EObject metamodel = (EObject)AtlTypesProcessor.eGet(model, "metamodel");
                if (!name.equals(AtlTypesProcessor.eGet(metamodel, "name"))) continue;
                res = metamodel;
            }
        }
        return res;
    }

    private Object getVariableExpDeclaration(EObject element) {
        EObject referredVariable = (EObject)AtlTypesProcessor.eGet(element, "referredVariable");
        if (referredVariable != null) {
            return referredVariable;
        }
        return null;
    }

    private OclAnyType getVariableExpType(EObject element) throws BadLocationException {
        String code = this.analyser.getText(element);
        String name = AtlTypesProcessor.analyzeVariableExp(code)[0];
        Map<String, OclAnyType> rootVariables = this.getRootVariables(element);
        if (rootVariables.containsKey(name)) {
            return rootVariables.get(name);
        }
        EObject referredVariable = (EObject)AtlTypesProcessor.eGet(element, "referredVariable");
        if (referredVariable != null) {
            return this.getType(referredVariable);
        }
        EObject previousIterator = this.analyser.getPreviousElement(element, "VariableDeclaration");
        while (previousIterator != null) {
            String varName = (String)AtlTypesProcessor.eGet(previousIterator, "varName");
            if (name.equals(varName)) {
                return this.getType(previousIterator);
            }
            previousIterator = this.analyser.getPreviousElement(previousIterator, "Iterator");
        }
        return OclAnyType.getInstance();
    }

    private OclAnyType getVariableDeclarationType(EObject element) {
        EObject atlType = (EObject)AtlTypesProcessor.eGet(element, "type");
        if (atlType != null) {
            return OclAnyType.create(this.unit.getSourceManager(), atlType);
        }
        return OclAnyType.getInstance();
    }

    private Feature getBindingFeature(EObject element) throws BadLocationException {
        OclAnyType sourceType;
        EObject source;
        String navigation = (String)AtlTypesProcessor.eGet(element, "propertyName");
        if (navigation != null && (source = (EObject)AtlTypesProcessor.eGet(element, "outPatternElement")) != null && !(sourceType = this.getType(source)).equals(OclAnyType.getInstance())) {
            return AtlTypesProcessor.getFeature(sourceType, this.unit, navigation);
        }
        return null;
    }

    private Feature getFeature(EObject element) throws BadLocationException {
        OclAnyType sourceType;
        EObject source;
        String navigation = (String)AtlTypesProcessor.eGet(element, "name");
        if (navigation != null && (source = (EObject)AtlTypesProcessor.eGet(element, "source")) != null && !(sourceType = this.getType(source)).equals(OclAnyType.getInstance())) {
            return AtlTypesProcessor.getFeature(sourceType, this.unit, navigation);
        }
        return null;
    }

    private Object getOperationCallExpDeclaration(EObject element) throws BadLocationException {
        OclAnyType sourceType;
        String operationName = (String)AtlTypesProcessor.eGet(element, "operationName");
        EObject source = (EObject)AtlTypesProcessor.eGet(element, "source");
        if (source != null && (sourceType = this.getType(source)) != null) {
            ArrayList<OclAnyType> argumentTypes = new ArrayList<OclAnyType>();
            Collection arguments = (Collection)AtlTypesProcessor.eGet(element, "arguments");
            if (arguments != null) {
                for (EObject eObject : arguments) {
                    argumentTypes.add(this.getType(eObject));
                }
            }
            if (argumentTypes.isEmpty()) {
                return AtlTypesProcessor.getOperation(sourceType, this.unit, operationName, new OclAnyType[0]);
            }
            return AtlTypesProcessor.getOperation(sourceType, this.unit, operationName, argumentTypes.toArray(new OclAnyType[argumentTypes.size()]));
        }
        return null;
    }

    private String getOperationCallExpInformation(EObject element) throws BadLocationException {
        OclAnyType sourceType;
        String operationName = (String)AtlTypesProcessor.eGet(element, "operationName");
        EObject source = (EObject)AtlTypesProcessor.eGet(element, "source");
        if (source != null && (sourceType = this.getType(source)) != null) {
            ArrayList<OclAnyType> argumentTypes = new ArrayList<OclAnyType>();
            Collection arguments = (Collection)AtlTypesProcessor.eGet(element, "arguments");
            if (arguments != null) {
                for (EObject eObject : arguments) {
                    argumentTypes.add(this.getType(eObject));
                }
            }
            Operation operation = null;
            operation = argumentTypes.isEmpty() ? AtlTypesProcessor.getOperation(sourceType, this.unit, operationName, new OclAnyType[0]) : AtlTypesProcessor.getOperation(sourceType, this.unit, operationName, argumentTypes.toArray(new OclAnyType[argumentTypes.size()]));
            if (operation != null) {
                String information = operation.getInformation(sourceType);
                String atlDoc = operation.getDocumentation(sourceType, new Object[0]);
                if (atlDoc != null && information != null) {
                    String cutAtlDoc = AtlTypesProcessor.cutString(atlDoc);
                    return String.valueOf(information) + "\n\n" + cutAtlDoc;
                }
                return operation.getInformation(sourceType);
            }
        }
        return null;
    }

    private String getOperationInformation(EObject element) throws BadLocationException {
        String name = (String)AtlTypesProcessor.eGet(element, "name");
        Collection arguments = (Collection)AtlTypesProcessor.eGet(element, "parameters");
        int i = 0;
        name = String.valueOf(name) + "(";
        if (arguments != null) {
            for (EObject eObject : arguments) {
                String argName = (String)AtlTypesProcessor.eGet(eObject, "varName");
                name = String.valueOf(name) + argName + " : " + this.getType(eObject);
                if (++i >= arguments.size()) continue;
                name = String.valueOf(name) + ", ";
            }
        }
        name = String.valueOf(name) + ")";
        EObject returnType = (EObject)AtlTypesProcessor.eGet(element, "returnType");
        OclType oclType = OclAnyType.create(this.unit.getSourceManager(), returnType).getOclType();
        name = String.valueOf(name) + " : " + oclType;
        EObject eContainer = element.eContainer();
        if (eContainer == null) {
            return name;
        }
        if ((eContainer = eContainer.eContainer()) == null) {
            return name;
        }
        return String.valueOf(name) + "\n\n" + Operation.getDocumentation(eContainer);
    }

    private String getAttributeInformation(EObject element) throws BadLocationException {
        String name = (String)AtlTypesProcessor.eGet(element, "name");
        EObject eContainer = element.eContainer();
        EObject type = (EObject)AtlTypesProcessor.eGet(element, "type");
        OclType oclType = OclAnyType.create(this.unit.getSourceManager(), type).getOclType();
        name = String.valueOf(name) + " : " + oclType;
        if (eContainer == null) {
            return name;
        }
        if ((eContainer = eContainer.eContainer()) == null) {
            return name;
        }
        return String.valueOf(name) + "\n\n" + Feature.getDocumentation(eContainer);
    }

    private OclAnyType getOperationCallExpType(EObject element) throws BadLocationException {
        OclAnyType sourceType;
        String operationName = (String)AtlTypesProcessor.eGet(element, "operationName");
        EObject source = (EObject)AtlTypesProcessor.eGet(element, "source");
        if (source != null && (sourceType = this.getType(source)) != null) {
            ArrayList<OclAnyType> argumentTypes = new ArrayList<OclAnyType>();
            Collection arguments = (Collection)AtlTypesProcessor.eGet(element, "arguments");
            if (arguments != null) {
                for (EObject eObject : arguments) {
                    argumentTypes.add(this.getType(eObject));
                }
            }
            Operation operation = null;
            operation = argumentTypes.isEmpty() ? AtlTypesProcessor.getOperation(sourceType, this.unit, operationName, new OclAnyType[0]) : AtlTypesProcessor.getOperation(sourceType, this.unit, operationName, argumentTypes.toArray(new OclAnyType[argumentTypes.size()]));
            if (operation != null) {
                return operation.getType(sourceType, new Object[0]);
            }
            return OclAnyType.getInstance();
        }
        return OclAnyType.getInstance();
    }

    private OclAnyType getOperatorCallExpType(EObject element) throws BadLocationException {
        OclAnyType res = OclAnyType.getInstance();
        String operatorName = (String)AtlTypesProcessor.eGet(element, "operationName");
        if (operatorName.equals("=") || operatorName.equals("<>") || operatorName.equals(">") || operatorName.equals("<") || operatorName.equals("=>") || operatorName.equals("=<") || operatorName.equals("and") || operatorName.equals("or") || operatorName.equals("xor") || operatorName.equals("not")) {
            return BooleanType.getInstance();
        }
        if (operatorName.equals("+") || operatorName.equals("-") || operatorName.equals("*")) {
            Collection arguments = (Collection)AtlTypesProcessor.eGet(element, "arguments");
            if (arguments != null) {
                for (EObject eObject : arguments) {
                    OclAnyType argumentType = this.getType(eObject);
                    if (argumentType.equals(OclAnyType.getInstance()) || res.equals(RealType.getInstance()) || res.equals(StringType.getInstance())) continue;
                    res = argumentType;
                }
            }
        } else if (operatorName.equals("/")) {
            return RealType.getInstance();
        }
        return res;
    }

    private OclAnyType getIteratorExpType(EObject element) throws BadLocationException {
        String iteratorName = (String)AtlTypesProcessor.eGet(element, "name");
        EObject source = (EObject)AtlTypesProcessor.eGet(element, "source");
        if (source != null) {
            if (iteratorName.equals("select")) {
                return this.getType(source);
            }
            if (iteratorName.equals("collect")) {
                EObject body = (EObject)AtlTypesProcessor.eGet(element, "body");
                return new SequenceType(this.getType(body));
            }
            if (iteratorName.equals("reject")) {
                return this.getType(source);
            }
            if (iteratorName.equals("exists")) {
                return BooleanType.getInstance();
            }
            if (iteratorName.equals("forAll")) {
                return BooleanType.getInstance();
            }
            if (iteratorName.equals("isUnique")) {
                return BooleanType.getInstance();
            }
            if (iteratorName.equals("one")) {
                return BooleanType.getInstance();
            }
            if (iteratorName.equals("any")) {
                OclAnyType sourceType = this.getType(source);
                if (sourceType instanceof CollectionType) {
                    return ((CollectionType)sourceType).getParameterType();
                }
            } else {
                if (iteratorName.equals("sortedBy")) {
                    return this.getType(source);
                }
                if (iteratorName.equals("iterate")) {
                    return this.getType(source);
                }
                if (iteratorName.equals("let")) {
                    return this.getType(source);
                }
            }
        }
        return OclAnyType.getInstance();
    }

    private OclAnyType getIteratorType(EObject element) throws BadLocationException {
        EObject loopExpr = (EObject)AtlTypesProcessor.eGet(element, "loopExpr");
        if (loopExpr != null) {
            EObject source = (EObject)AtlTypesProcessor.eGet(loopExpr, "source");
            OclAnyType atlType = null;
            if (source != null) {
                atlType = this.getType(source);
            } else {
                EObject previous = this.analyser.getPreviousElement(element, "OclExpression");
                if (previous != null) {
                    atlType = this.getType(previous);
                }
            }
            if (atlType instanceof CollectionType) {
                return ((CollectionType)atlType).getParameterType();
            }
        }
        return OclAnyType.getInstance();
    }

    private OclAnyType getCollectionExpType(EObject element) throws BadLocationException {
        Collection elements = (Collection)AtlTypesProcessor.eGet(element, "elements");
        if (elements != null) {
            OclAnyType tmp = null;
            for (EObject eObject : elements) {
                OclAnyType elementType = this.getType(eObject);
                if (tmp == null) {
                    tmp = elementType;
                    continue;
                }
                if (elementType.equals(tmp)) continue;
                return OclAnyType.getInstance();
            }
            if (tmp != null) {
                return tmp;
            }
        }
        return OclAnyType.getInstance();
    }

    private EObject getRoot(EObject element) throws BadLocationException {
        for (EObject container : this.analyser.getContainers(element)) {
            if (!AtlTypesProcessor.oclIsKindOf(container, "Rule") && !AtlTypesProcessor.oclIsKindOf(container, "Helper") && !AtlTypesProcessor.oclIsKindOf(container, "Unit")) continue;
            return container;
        }
        return this.analyser.getRoot();
    }

    private Map<String, OclAnyType> getRootVariables(EObject element) throws BadLocationException {
        EObject root = this.getRoot(element);
        HashMap<String, OclAnyType> variables = new HashMap<String, OclAnyType>();
        if (this.unit.getSourceManager().getATLFileType() == 1) {
            variables.put("thisModule", this.unit);
            variables.put("OclUndefined", OclAnyType.getInstance());
        }
        ArrayList declarations = new ArrayList();
        if (this.unit != null) {
            EObject definition;
            if (AtlTypesProcessor.oclIsKindOf(root, "Rule")) {
                ModuleType module;
                EObject savedRule;
                Collection outElements;
                EObject outPattern;
                Collection variableDeclarations;
                Collection inElements;
                EObject inPattern;
                Collection parameterDeclarations = (Collection)AtlTypesProcessor.eGet(root, "parameters");
                if (parameterDeclarations != null) {
                    declarations.addAll(parameterDeclarations);
                }
                if ((inPattern = (EObject)AtlTypesProcessor.eGet(root, "inPattern")) == null) {
                    inPattern = this.analyser.getLastLostElementByType("InPattern");
                }
                if (inPattern != null && (inElements = (Collection)AtlTypesProcessor.eGet(inPattern, "elements")) != null) {
                    declarations.addAll(inElements);
                }
                if ((variableDeclarations = (Collection)AtlTypesProcessor.eGet(root, "variables")) != null) {
                    declarations.addAll(variableDeclarations);
                }
                if ((outPattern = (EObject)AtlTypesProcessor.eGet(root, "outPattern")) == null) {
                    outPattern = this.analyser.getLastLostElementByType("OutPattern");
                }
                if (outPattern != null && (outElements = (Collection)AtlTypesProcessor.eGet(outPattern, "elements")) != null) {
                    declarations.addAll(outElements);
                }
                String ruleName = (String)AtlTypesProcessor.eGet(root, "name");
                if (this.unit instanceof ModuleType && (savedRule = (module = (ModuleType)this.unit).getRule(ruleName)) != null) {
                    Collection savedOutElements;
                    EObject savedOutPattern;
                    Collection savedVariableDeclarations;
                    Collection savedInElements;
                    EObject savedInPattern;
                    Collection savedParameterDeclarations = (Collection)AtlTypesProcessor.eGet(savedRule, "parameters");
                    if (savedParameterDeclarations != null) {
                        declarations.addAll(savedParameterDeclarations);
                    }
                    if ((savedInPattern = (EObject)AtlTypesProcessor.eGet(savedRule, "inPattern")) != null && (savedInElements = (Collection)AtlTypesProcessor.eGet(savedInPattern, "elements")) != null) {
                        declarations.addAll(savedInElements);
                    }
                    if ((savedVariableDeclarations = (Collection)AtlTypesProcessor.eGet(savedRule, "variables")) != null) {
                        declarations.addAll(savedVariableDeclarations);
                    }
                    if ((savedOutPattern = (EObject)AtlTypesProcessor.eGet(savedRule, "outPattern")) != null && (savedOutElements = (Collection)AtlTypesProcessor.eGet(savedOutPattern, "elements")) != null) {
                        declarations.addAll(savedOutElements);
                    }
                }
            } else if (AtlTypesProcessor.oclIsKindOf(root, "Helper") && (definition = (EObject)AtlTypesProcessor.eGet(root, "definition")) != null) {
                EObject contextDefinition;
                EObject context;
                Collection parametersDeclarations;
                EObject feature = (EObject)AtlTypesProcessor.eGet(definition, "feature");
                if (feature != null && (parametersDeclarations = (Collection)AtlTypesProcessor.eGet(feature, "parameters")) != null) {
                    declarations.addAll(parametersDeclarations);
                }
                if ((context = (EObject)AtlTypesProcessor.eGet(definition, "context_")) != null && (contextDefinition = (EObject)AtlTypesProcessor.eGet(context, "context_")) != null) {
                    variables.put("self", OclAnyType.create(this.unit.getSourceManager(), contextDefinition));
                }
            }
        }
        for (EObject eObject : declarations) {
            String variableName = AtlTypesProcessor.eGet(eObject, "varName").toString();
            EObject variableType = (EObject)AtlTypesProcessor.eGet(eObject, "type");
            OclAnyType type = OclAnyType.create(this.unit.getSourceManager(), variableType);
            variables.put(variableName, type);
        }
        return variables;
    }

    private Map<String, OclAnyType> getLocalVariableDeclarations(EObject element) throws BadLocationException {
        HashMap<String, OclAnyType> variables = new HashMap<String, OclAnyType>();
        if (AtlTypesProcessor.oclIsKindOf(element, "LetExp")) {
            EObject declaration = (EObject)AtlTypesProcessor.eGet(element, "variable");
            if (declaration != null) {
                String variableName = AtlTypesProcessor.eGet(declaration, "varName").toString();
                EObject variableType = (EObject)AtlTypesProcessor.eGet(declaration, "type");
                OclAnyType type = OclAnyType.create(this.unit.getSourceManager(), variableType);
                variables.put(variableName, type);
            }
        } else if (AtlTypesProcessor.oclIsKindOf(element, "IteratorExp")) {
            Collection iterators = (Collection)AtlTypesProcessor.eGet(element, "iterators");
            if (iterators != null) {
                for (EObject declaration : iterators) {
                    String variableName = AtlTypesProcessor.eGet(declaration, "varName").toString();
                    EObject variableType = (EObject)AtlTypesProcessor.eGet(declaration, "type");
                    OclAnyType type = null;
                    type = variableType != null ? OclAnyType.create(this.unit.getSourceManager(), variableType) : this.getType(declaration);
                    variables.put(variableName, type);
                }
            }
        } else if (AtlTypesProcessor.oclIsKindOf(element, "InPattern")) {
            Collection inElements = (Collection)AtlTypesProcessor.eGet(element, "elements");
            if (inElements != null) {
                for (EObject eObject : inElements) {
                    String variableName = AtlTypesProcessor.eGet(eObject, "varName").toString();
                    EObject variableType = (EObject)AtlTypesProcessor.eGet(eObject, "type");
                    OclAnyType type = OclAnyType.create(this.unit.getSourceManager(), variableType);
                    variables.put(variableName, type);
                }
            }
        } else if (AtlTypesProcessor.oclIsKindOf(element, "IterateExp")) {
            EObject result;
            Collection iterators = (Collection)AtlTypesProcessor.eGet(element, "iterators");
            if (iterators != null) {
                for (EObject declaration : iterators) {
                    String variableName = AtlTypesProcessor.eGet(declaration, "varName").toString();
                    EObject variableType = (EObject)AtlTypesProcessor.eGet(declaration, "type");
                    OclAnyType type = null;
                    type = variableType != null ? OclAnyType.create(this.unit.getSourceManager(), variableType) : this.getType(declaration);
                    variables.put(variableName, type);
                }
            }
            if ((result = (EObject)AtlTypesProcessor.eGet(element, "result")) != null) {
                String variableName = AtlTypesProcessor.eGet(result, "varName").toString();
                EObject variableType = (EObject)AtlTypesProcessor.eGet(result, "type");
                OclAnyType type = OclAnyType.create(this.unit.getSourceManager(), variableType);
                variables.put(variableName, type);
            }
        }
        return variables;
    }

    public UnitType getUnit() {
        return this.unit;
    }

    private static String[] analyzeVariableExp(String code) {
        String currentPrefix = code;
        currentPrefix = currentPrefix.replaceFirst("<-", "");
        String varName = "";
        String lastPrefix = "";
        if (currentPrefix.indexOf(".") > 0) {
            String[] splittedPrefix = currentPrefix.split("\\.");
            if (splittedPrefix.length > 0) {
                if (currentPrefix.endsWith(".")) {
                    varName = splittedPrefix[splittedPrefix.length - 1];
                    lastPrefix = "";
                } else {
                    varName = splittedPrefix[splittedPrefix.length - 2];
                    lastPrefix = splittedPrefix[splittedPrefix.length - 1];
                }
            }
        } else {
            lastPrefix = currentPrefix;
            varName = currentPrefix;
        }
        return new String[]{varName, lastPrefix};
    }

    public static boolean oclIsKindOf(EObject element, String testedElementName) {
        if (element != null) {
            if (element.eClass().getName().equals(testedElementName)) {
                return true;
            }
            EList types = element.eClass().getEAllSuperTypes();
            for (EClass object : types) {
                if (!object.getName().equals(testedElementName)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object eGet(EObject self, String featureName) {
        if (self == null) {
            return null;
        }
        EStructuralFeature feature = self.eClass().getEStructuralFeature(featureName);
        if (feature != null) {
            return self.eGet(feature);
        }
        return null;
    }

    public static Feature getFeature(OclAnyType context, UnitType module, String featureName) {
        ArrayList<Feature> allFeatures = new ArrayList<Feature>();
        allFeatures.addAll(context.getFeatures());
        if (module != null) {
            allFeatures.addAll(module.getAttributes(context));
        }
        if (context instanceof ModuleType || context instanceof OclAnyType) {
            allFeatures.addAll(module.getAllAttributes());
        }
        for (Feature feature : allFeatures) {
            if (!feature.getName().equals(featureName)) continue;
            return feature;
        }
        return null;
    }

    public static Operation getOperation(OclAnyType context, UnitType module, String operationName, OclAnyType ... parameters) {
        Operation res = null;
        ArrayList<Operation> allOperations = new ArrayList<Operation>();
        allOperations.addAll(context.getOperations());
        if (module != null) {
            allOperations.addAll(module.getHelpers(context));
        }
        if (context instanceof ModuleType || context instanceof OclAnyType) {
            allOperations.addAll(module.getAllHelpers());
        }
        for (Operation operation : allOperations) {
            if (!operation.getName().equals(operationName)) continue;
            boolean check = true;
            int index = 0;
            for (OclAnyType oclAnyType : operation.getParameters().values()) {
                check = check && parameters != null && parameters.length > index;
                ++index;
            }
            if (!check) continue;
            res = operation;
        }
        return res;
    }
}

