/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.editor.formatter.AtlCodeFormatterPreferences;
import org.eclipse.m2m.atl.adt.ui.preferences.AbstractPropertyAndPreferencePage;
import org.eclipse.m2m.atl.adt.ui.preferences.AtlCodeFormatterProfileManager;
import org.eclipse.m2m.atl.adt.ui.preferences.AtlCodeFormatterProfilesTabPage;
import org.eclipse.m2m.atl.adt.ui.preferences.AtlCodeFormatterPropertiesTabPage;
import org.eclipse.m2m.atl.adt.ui.preferences.AtlPreferencesMessages;
import org.eclipse.m2m.atl.adt.ui.preferences.AtlPreview;
import org.eclipse.m2m.atl.adt.ui.preferences.IModifyDialogTabPage;
import org.eclipse.m2m.atl.adt.ui.preferences.ModifyDialogTabPage;
import org.eclipse.m2m.atl.adt.ui.preferences.PreferencesAccess;
import org.eclipse.m2m.atl.adt.ui.preferences.ProfileManager;
import org.eclipse.m2m.atl.adt.ui.preferences.ProfileStore;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlCodeFormatterPropertyPage
extends AbstractPropertyAndPreferencePage
implements IWorkbenchPreferencePage,
Observer,
SelectionListener {
    private ProfileManager.Profile activeProfile;
    private AtlCodeFormatterProfilesTabPage profilesTabPage;
    private AtlCodeFormatterPropertiesTabPage propertiesTabPage;
    private ProfileManager manager;
    private ModifyListener fPropertyTableListener;
    private SelectionListener fPropertyTableListener2;
    private TabFolder fTabFolder;
    private final List<IModifyDialogTabPage> fTabPages = new ArrayList<IModifyDialogTabPage>();
    public static final String PREVIEW = "-- @nsURI MM1 = http://www.my.site/path/to/my/MM1\n-- @path MM2 = /MyProject/MM2.ecore\n\nmodule MyModule;\n\ncreate OUT: MM1 from IN: MM2;\n\n--- This is a special helper comment\nhelper def: simpleHelper: String =\nlet letVar : String = 'A first let variable' in\nlet letVar2 : String = 'Another let variable' in\n\tif true then\n\t\t\tletVar\n\t\telse\n\t\t\tletVar2\n\t\tendif\n\tand\n\ttrue;\n\nhelper def: simpleParametersHelper(t1: String, t2: Integer, t3: Integer):\n\t\tSequence(TupleType(a: Integer, b: String)) =\n\tt1 <= 'This is a string'\n\tand\n\tt2 = 5 / 1-- A comment\n\t; -- Another comment\n\nhelper context String def: simpleContextHelper(t1: String, t2: Integer): OclAny =\n\tt1 = 't1'\n\tand\n\tt2 = 5 + 1;\n\n-- This is a normal comment\n--- This is a special rule comment\nrule MyRule {\n\tfrom\n\t\tinput2: MM1!MyClass in IN (\n\t\t\ttrue\n\t\t)\n\tto\n\t\toutput: MM2!MyClass2 (\n\t\t\tname <- input.name -> toString(),\n\t\t\tabstract <- false\n\t\t),\n\t\toutput2: MM2!MyClass2 (\n\t\t\tname <- 'Test'\n\t\t)\n\tdo {\n\t\t\n\t}\n}\n";
    public static final String PROFILES_KEY = String.valueOf(AtlUIPlugin.getPluginId()) + ".preferences.formatter.profiles";
    public static final String CURRENT_PROFILE_KEY = String.valueOf(AtlUIPlugin.getPluginId()) + ".preferences.formatter.current_profile";
    public static final String LAST_TAB_FOCUS = String.valueOf(AtlUIPlugin.getPluginId()) + ".preferences.formatter.last_tab_focus";
    public static final String SHOW_INVISIBLE_PREFERENCE_KEY = String.valueOf(AtlUIPlugin.getPluginId()) + ".preferences.formatter.show_invisible";
    public static final String PROJECT_SPECIFIC_SETTINGS_ENABLED = String.valueOf(AtlUIPlugin.getPluginId()) + ".preferences.formatter.project_specific_settings_enabled";
    public static final String DIALOG_STORE_LAST_LOAD_PATH = String.valueOf(AtlUIPlugin.getPluginId()) + ".preferences.formatter.lastloadpath";
    public static final String DIALOG_STORE_LAST_SAVE_PATH = String.valueOf(AtlUIPlugin.getPluginId()) + ".preferences.formatter.lastsavepath";
    private ProfileStore fProfileStore;
    private IScopeContext fCurrContext;
    private IScopeContext fInstanceScope;
    private IProject fProject;
    private final IDialogSettings fDialogSettings = AtlUIPlugin.getDefault().getDialogSettings();

    public AtlCodeFormatterPropertyPage() {
        super(AtlPreferencesMessages.getString("CodeFormatterPreferencePage.description"));
        this.properties = new String[][]{{AtlPreferencesMessages.getString("CodeFormatterPreferencePage.linesBetween"), "Atl.CodeFormatter.LinesBetween", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.linesAfterModule"), "Atl.CodeFormatter.LinesAfterModule", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.linesAfterCreateFrom"), "Atl.CodeFormatter.LinesAfterCreateFrom", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.linesAfterSpecialTags"), "Atl.CodeFormatter.LinesAfterSpecialTags", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.lineMaxLength"), "Atl.CodeFormatter.LineMaxLength", "5"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesInsideBraces"), "Atl.CodeFormatter.SpacesInsideBraces", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesOutsideBraces"), "Atl.CodeFormatter.SpacesOutsideBraces", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesBeforeArrows"), "Atl.CodeFormatter.SpacesBeforeArrows", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesAfterArrows"), "Atl.CodeFormatter.SpacesAfterArrows", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesBeforeSemi"), "Atl.CodeFormatter.SpacesBeforeSemi", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesAfterSemi"), "Atl.CodeFormatter.SpacesAfterSemi", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesBeforeComa"), "Atl.CodeFormatter.SpacesBeforeComa", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesAfterComa"), "Atl.CodeFormatter.SpacesAfterComa", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesBeforeColon"), "Atl.CodeFormatter.SpacesBeforeColon", "5"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesAfterColon"), "Atl.CodeFormatter.SpacesAfterColon", "5"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesBeforePoint"), "Atl.CodeFormatter.SpacesBeforePoint", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesAfterPoint"), "Atl.CodeFormatter.SpacesAfterPoint", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesBeforeOperator"), "Atl.CodeFormatter.SpacesBeforeOperator", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesAfterOperator"), "Atl.CodeFormatter.SpacesAfterOperator", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesBeforeEqual"), "Atl.CodeFormatter.SpacesBeforeEqual", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesAfterEqual"), "Atl.CodeFormatter.SpacesAfterEqual", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesBeforePipe"), "Atl.CodeFormatter.SpacesBeforePipe", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesAfterPipe"), "Atl.CodeFormatter.SpacesAfterPipe", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesBeforeExclamation"), "Atl.CodeFormatter.SpacesBeforeExclamation", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesAfterExclamation"), "Atl.CodeFormatter.SpacesAfterExclamation", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesBeforeRuleBrace"), "Atl.CodeFormatter.SpacesBeforeRuleBrace", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesBeforeEndingSemi"), "Atl.CodeFormatter.SpacesBeforeEndingSemi", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.cutAfterPoint"), "Atl.CodeFormatter.CutAfterPoint", "5"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesAfterComment"), "Atl.CodeFormatter.SpacesAfterComment", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesOutsideCollectionBrace"), "Atl.CodeFormatter.SpacesOutsideCollectionBrace", "3"}, {AtlPreferencesMessages.getString("CodeFormatterPreferencePage.spacesInsideCollectionBrace"), "Atl.CodeFormatter.SpacesInsideCollectionBrace", "3"}};
    }

    protected Control createContents(Composite parent) {
        PreferencesAccess access = PreferencesAccess.getOriginalPreferences();
        this.fInstanceScope = access.getInstanceScope();
        boolean isProjectSpecific = false;
        if (this.fProject != null) {
            this.fCurrContext = access.getProjectScope(this.fProject);
            isProjectSpecific = true;
        } else {
            this.fCurrContext = this.fInstanceScope;
        }
        this.initializeSettings();
        this.fProfileStore = new ProfileStore(PROFILES_KEY);
        this.manager = AtlCodeFormatterProfileManager.getCurrentProfileManager(this.fCurrContext, access, this.fProfileStore);
        this.activeProfile = this.manager.getSelected();
        this.fillPreferenceeStore(this.activeProfile.getSettings());
        new StoreUpdater();
        Composite composite = this.newComposite(parent, 1);
        Composite nameComposite = new Composite(composite, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        nameComposite.setLayout((Layout)new GridLayout(3, false));
        this.fTabFolder = new TabFolder(composite, 0);
        this.fTabFolder.setFont(composite.getFont());
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TabItem tabItem = (TabItem)e.item;
                ModifyDialogTabPage page = (ModifyDialogTabPage)tabItem.getData();
                if (page != null) {
                    AtlCodeFormatterPropertyPage.this.updateTab(page);
                }
                if (AtlCodeFormatterPropertyPage.this.fTabPages.indexOf(page) != -1) {
                    AtlCodeFormatterPropertyPage.this.fDialogSettings.put(LAST_TAB_FOCUS, AtlCodeFormatterPropertyPage.this.fTabPages.indexOf(page));
                }
            }
        });
        int lastTab = this.fDialogSettings.getInt(LAST_TAB_FOCUS);
        Map<String, String> options = this.activeProfile.getSettings();
        this.profilesTabPage = new AtlCodeFormatterProfilesTabPage(this.manager, this.fProfileStore, isProjectSpecific);
        this.addTabPage("Profiles", this.profilesTabPage);
        this.newProfilesList(this.profilesTabPage.getPreview());
        if (this.profilesTabPage.getfEnableProjectSpecificSettings() != null) {
            this.profilesTabPage.getfEnableProjectSpecificSettings().addSelectionListener((SelectionListener)this);
        }
        this.updateTab(this.profilesTabPage);
        this.manager.addObserver(this);
        this.manager.addObserver(this.profilesTabPage.getPreview());
        this.propertiesTabPage = new AtlCodeFormatterPropertiesTabPage(options);
        this.addTabPage("Edition", this.propertiesTabPage);
        this.newPropertiesTable(this.propertiesTabPage.getPreview(), this.propertiesTabPage.getEditableColumns());
        this.updateTab(this.propertiesTabPage);
        this.manager.addObserver(this.propertiesTabPage.getPreview());
        this.fTabFolder.setSelection(lastTab);
        this.applyDialogFont(composite);
        return composite;
    }

    protected void initializeSettings() {
        if (this.fDialogSettings.get(LAST_TAB_FOCUS) == null) {
            this.fDialogSettings.put(LAST_TAB_FOCUS, 0);
        }
        if (this.fDialogSettings.get(SHOW_INVISIBLE_PREFERENCE_KEY) == null) {
            this.fDialogSettings.put(SHOW_INVISIBLE_PREFERENCE_KEY, false);
        }
    }

    protected void updateTab(ModifyDialogTabPage page) {
        this.preview = page.getPreview();
        this.preview.setWorkingValues(AtlCodeFormatterPreferences.getOptions(this.fPreferenceeStore));
        boolean enabled = this.isProjectSpecificSettingsEnabled() || this.fCurrContext.equals(this.fInstanceScope);
        page.updateTab(enabled);
    }

    protected final void addTabPage(String title, IModifyDialogTabPage tabPage) {
        TabItem tabItem = new TabItem(this.fTabFolder, 0);
        tabItem.setText(title);
        tabItem.setData((Object)tabPage);
        tabItem.setControl((Control)tabPage.createContents((Composite)this.fTabFolder));
        this.fTabPages.add(tabPage);
    }

    protected void newPropertiesTable(AtlPreview atlPreview, TableColumn ... editableColumns) {
        this.preview = atlPreview;
        this.updatePropertiesTable();
        TableEditor tableEditor = new TableEditor(this.propertiesTabPage.getPreferencesTable());
        tableEditor.horizontalAlignment = 16384;
        tableEditor.grabHorizontal = true;
        this.propertiesTabPage.getPreferencesTable().addListener(3, (Listener)new PropertiesTableListener(tableEditor, editableColumns));
        this.fPropertyTableListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                TableItem item = (TableItem)text.getData();
                Map<String, String> workingValues = AtlCodeFormatterPropertyPage.this.preview.getWorkingValues();
                String value = text.getText();
                String key = (String)AtlCodeFormatterPropertyPage.this.tableProperties.get(item);
                workingValues.put(key, value);
                AtlCodeFormatterPropertyPage.this.fPreferenceeStore.setValue(key, value);
            }
        };
        this.fPropertyTableListener2 = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Combo list = (Combo)e.widget;
                TableItem item = (TableItem)list.getData();
                Map<String, String> workingValues = AtlCodeFormatterPropertyPage.this.preview.getWorkingValues();
                String value = list.getText();
                String key = (String)AtlCodeFormatterPropertyPage.this.tableProperties.get(item);
                workingValues.put(key, value);
                AtlCodeFormatterPropertyPage.this.fPreferenceeStore.setValue(key, value);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    protected void newProfilesList(AtlPreview atlPreview) {
        this.preview = atlPreview;
        SelectionListener profileChangedListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)e.widget;
                AtlCodeFormatterPropertyPage.this.setSelectedProfile(list);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.updateProfilesList();
        this.profilesTabPage.getProfilesList().addSelectionListener(profileChangedListener);
    }

    public void setSelectedProfile(org.eclipse.swt.widgets.List list) {
        ProfileManager.Profile selectedProfile;
        String selectionText = list.getItem(list.getSelectionIndex());
        this.activeProfile = selectedProfile = (ProfileManager.Profile)list.getData(selectionText);
        this.manager.setSelected(this.activeProfile);
        this.preview.setWorkingValues(this.activeProfile.getSettings());
        for (String key : this.activeProfile.getSettings().keySet()) {
            String value = this.activeProfile.getSettings().get(key);
            this.fPreferenceeStore.setValue(key, value);
        }
        this.preview.updateEditor();
    }

    public void updateProfilesList() {
        this.profilesTabPage.getProfilesList().removeAll();
        int i = 0;
        for (ProfileManager.Profile profile : this.manager.getSortedProfiles()) {
            this.profilesTabPage.getProfilesList().add(profile.getName());
            this.profilesTabPage.getProfilesList().setData(profile.getName(), (Object)profile);
            if (profile == this.manager.getSelected()) {
                this.profilesTabPage.getProfilesList().setSelection(i);
            }
            ++i;
        }
    }

    public void updatePropertiesTable() {
        Map<String, String> workingValues = this.manager.getSelected().getSettings();
        Map<String, String> defaultSettings = AtlCodeFormatterPreferences.getDefaultOptions();
        this.propertiesTabPage.getPreferencesTable().removeAll();
        this.tableProperties.clear();
        int i = 0;
        while (i < this.properties.length) {
            TableItem item = new TableItem(this.propertiesTabPage.getPreferencesTable(), 0);
            String key = this.properties[i][1];
            this.tableProperties.put(item, key);
            String value = workingValues.get(key);
            if (value == null) {
                value = defaultSettings.get(key);
                this.fPreferenceeStore.setToDefault(key);
            }
            if (value.trim().equals("")) {
                value = "0";
            }
            item.setText(new String[]{this.properties[i][0], value});
            ++i;
        }
        TableColumn[] tableColumnArray = this.propertiesTabPage.getPreferencesTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    @Override
    protected void performDefaults() {
        if (this.isProjectSpecificSettingsEnabled() || this.fCurrContext.equals(this.fInstanceScope)) {
            super.performDefaults();
        }
        this.updateTab(this.profilesTabPage);
    }

    @Override
    public boolean performOk() {
        this.activeProfile.setSettings(AtlCodeFormatterPreferences.getOptions(this.fPreferenceeStore));
        if (!this.isProjectSpecificSettingsEnabled() && !this.fCurrContext.equals(this.fInstanceScope)) {
            PreferencesAccess access = PreferencesAccess.getOriginalPreferences();
            this.manager = AtlCodeFormatterProfileManager.getCurrentProfileManager(this.fInstanceScope, access, this.fProfileStore);
            this.fillPreferenceeStore(this.manager.getSelected().getSettings());
        }
        return super.performOk();
    }

    public void fillPreferenceeStore(Map<String, String> settings) {
        for (String key : settings.keySet()) {
            this.fPreferenceeStore.setValue(key, settings.get(key));
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.activeProfile = this.manager.getSelected();
        this.updateProfilesList();
        this.updatePropertiesTable();
    }

    public void setElement(IAdaptable element) {
        this.fProject = (IProject)element.getAdapter(IResource.class);
    }

    public void widgetSelected(SelectionEvent e) {
        IEclipsePreferences uiPreferences = this.fCurrContext.getNode(AtlUIPlugin.getPluginId());
        uiPreferences.put(PROJECT_SPECIFIC_SETTINGS_ENABLED, "" + ((Button)e.widget).getSelection());
        try {
            uiPreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean isProjectSpecificSettingsEnabled() {
        return this.fCurrContext.getNode(AtlUIPlugin.getPluginId()).getBoolean(PROJECT_SPECIFIC_SETTINGS_ENABLED, false);
    }

    private class PropertiesTableListener
    implements Listener {
        private List<TableColumn> editableColumns = new ArrayList<TableColumn>();
        private TableEditor editor;

        public PropertiesTableListener(TableEditor editor, TableColumn ... editableColumns) {
            TableColumn[] tableColumnArray = editableColumns;
            int n = editableColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn col = tableColumnArray[n2];
                this.editableColumns.add(col);
                ++n2;
            }
            this.editor = editor;
        }

        public boolean isEditableColumn(Table table, int i) {
            for (TableColumn col : this.editableColumns) {
                if (!table.getColumn(i).equals(col)) continue;
                return true;
            }
            return false;
        }

        public void handleEvent(Event event) {
            if (AtlCodeFormatterPropertyPage.this.activeProfile instanceof ProfileManager.BuiltInProfile) {
                return;
            }
            Table table = (Table)event.widget;
            Rectangle clientArea = table.getClientArea();
            Point pt = new Point(event.x, event.y);
            int index = table.getTopIndex();
            while (index < table.getItemCount()) {
                boolean visible = false;
                TableItem item = table.getItem(index);
                int i = 0;
                while (i < table.getColumnCount()) {
                    Rectangle rect = item.getBounds(i);
                    if (rect.contains(pt)) {
                        if (!this.isEditableColumn(table, i)) {
                            return;
                        }
                        table.setSelection(index);
                        String text = item.getText(i);
                        if (!text.equals("true") && !text.equals("false")) {
                            this.createTextFieldAt(i, table, item);
                        } else {
                            this.createBooleanListAt(i, table, item);
                        }
                        return;
                    }
                    if (!visible && rect.intersects(clientArea)) {
                        visible = true;
                    }
                    ++i;
                }
                if (!visible) {
                    return;
                }
                ++index;
            }
        }

        private void createBooleanListAt(final int i, Table table, final TableItem item) {
            final Combo booleanList = new Combo((Composite)table, 2060);
            booleanList.add("true");
            booleanList.add("false");
            booleanList.setData((Object)item);
            Listener listListener = new Listener(){

                public void handleEvent(Event e) {
                    String value = booleanList.getText();
                    switch (e.type) {
                        case 16: {
                            item.setText(i, value);
                            booleanList.dispose();
                            ((PropertiesTableListener)PropertiesTableListener.this).AtlCodeFormatterPropertyPage.this.preview.updateEditor();
                            break;
                        }
                        case 31: {
                            switch (e.detail) {
                                case 4: {
                                    item.setText(i, value);
                                    ((PropertiesTableListener)PropertiesTableListener.this).AtlCodeFormatterPropertyPage.this.preview.updateEditor();
                                }
                                case 2: {
                                    e.doit = false;
                                    booleanList.dispose();
                                }
                            }
                        }
                    }
                }
            };
            booleanList.addListener(16, listListener);
            booleanList.addListener(31, listListener);
            booleanList.addSelectionListener(AtlCodeFormatterPropertyPage.this.fPropertyTableListener2);
            this.editor.setEditor((Control)booleanList, item, i);
            int selection = 0;
            if (item.getText(i).equals("false")) {
                selection = 1;
            }
            booleanList.select(selection);
            booleanList.setFocus();
        }

        private void createTextFieldAt(final int i, Table table, final TableItem item) {
            final Text textField = new Text((Composite)table, 0);
            textField.addListener(25, new Listener(){

                public void handleEvent(Event e) {
                    String string = e.text;
                    char[] chars = new char[string.length()];
                    string.getChars(0, chars.length, chars, 0);
                    int i = 0;
                    while (i < chars.length) {
                        if (('0' > chars[i] || chars[i] > '9') && chars[i] != '-') {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
            textField.setData((Object)item);
            Listener textListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 16: {
                            item.setText(i, textField.getText());
                            textField.dispose();
                            ((PropertiesTableListener)PropertiesTableListener.this).AtlCodeFormatterPropertyPage.this.preview.updateEditor();
                            break;
                        }
                        case 31: {
                            switch (e.detail) {
                                case 4: {
                                    item.setText(i, textField.getText());
                                    ((PropertiesTableListener)PropertiesTableListener.this).AtlCodeFormatterPropertyPage.this.preview.updateEditor();
                                }
                                case 2: {
                                    textField.dispose();
                                    e.doit = false;
                                }
                            }
                        }
                    }
                }
            };
            textField.addListener(16, textListener);
            textField.addListener(31, textListener);
            textField.addModifyListener(AtlCodeFormatterPropertyPage.this.fPropertyTableListener);
            this.editor.setEditor((Control)textField, item, i);
            textField.setText(item.getText(i));
            textField.selectAll();
            textField.setFocus();
        }
    }

    private class StoreUpdater
    implements Observer {
        public StoreUpdater() {
            AtlCodeFormatterPropertyPage.this.manager.addObserver(this);
        }

        public void update(Observable o, Object arg) {
            int value = (Integer)arg;
            switch (value) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    try {
                        AtlCodeFormatterPropertyPage.this.fProfileStore.writeProfiles(AtlCodeFormatterPropertyPage.this.manager.getSortedProfiles(), AtlCodeFormatterPropertyPage.this.fInstanceScope);
                        AtlCodeFormatterPropertyPage.this.manager.commitChanges(AtlCodeFormatterPropertyPage.this.fCurrContext);
                        if (AtlCodeFormatterPropertyPage.this.fCurrContext.equals(AtlCodeFormatterPropertyPage.this.fInstanceScope)) break;
                        try {
                            AtlCodeFormatterPropertyPage.this.fCurrContext.getNode(AtlUIPlugin.getPluginId()).flush();
                        }
                        catch (BackingStoreException backingStoreException) {
                        }
                    }
                    catch (CoreException coreException) {}
                    break;
                }
                case 1: {
                    AtlCodeFormatterPropertyPage.this.manager.commitChanges(AtlCodeFormatterPropertyPage.this.fCurrContext);
                    if (AtlCodeFormatterPropertyPage.this.fCurrContext.equals(AtlCodeFormatterPropertyPage.this.fInstanceScope)) break;
                    try {
                        AtlCodeFormatterPropertyPage.this.fCurrContext.getNode(AtlUIPlugin.getPluginId()).flush();
                        break;
                    }
                    catch (BackingStoreException backingStoreException) {}
                }
            }
        }
    }
}

