/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.impl.resource;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.ConstantTag;
import org.eclipse.m2m.atl.emftvm.Feature;
import org.eclipse.m2m.atl.emftvm.Field;
import org.eclipse.m2m.atl.emftvm.FieldInstruction;
import org.eclipse.m2m.atl.emftvm.Findtype;
import org.eclipse.m2m.atl.emftvm.InputRuleElement;
import org.eclipse.m2m.atl.emftvm.Instruction;
import org.eclipse.m2m.atl.emftvm.InvokeOperationInstruction;
import org.eclipse.m2m.atl.emftvm.LocalVariable;
import org.eclipse.m2m.atl.emftvm.Match;
import org.eclipse.m2m.atl.emftvm.ModelDeclaration;
import org.eclipse.m2m.atl.emftvm.Module;
import org.eclipse.m2m.atl.emftvm.NamedElement;
import org.eclipse.m2m.atl.emftvm.New;
import org.eclipse.m2m.atl.emftvm.Operation;
import org.eclipse.m2m.atl.emftvm.Parameter;
import org.eclipse.m2m.atl.emftvm.Push;
import org.eclipse.m2m.atl.emftvm.Rule;
import org.eclipse.m2m.atl.emftvm.RuleElement;
import org.eclipse.m2m.atl.emftvm.TypedElement;
import org.eclipse.m2m.atl.emftvm.util.EmftvmSwitch;
import org.eclipse.m2m.atl.emftvm.util.EnumLiteral;

public class ConstantPool {
    protected CreateConstantsSwitch createConstants = new CreateConstantsSwitch();
    private ArrayList<Object> constants;

    public ConstantPool() {
        this.constants = new ArrayList();
    }

    public ConstantPool(int size) {
        this.constants = new ArrayList(size);
    }

    public Object get(int i) {
        return this.constants.get(i);
    }

    public int indexOf(Object value) throws IllegalArgumentException {
        int index = this.constants.indexOf(value);
        if (index == -1) {
            throw new IllegalArgumentException("Element not found");
        }
        return index;
    }

    public int size() {
        return this.constants.size();
    }

    public void add(Object value) {
        if (!this.constants.contains(value)) {
            this.constants.add(value);
        }
    }

    public void read(DataInputStream in) throws IOException {
        int cpcount = in.readInt();
        this.constants.clear();
        this.constants.ensureCapacity(cpcount);
        int i = 0;
        while (i < cpcount) {
            this.readConstant(in);
            ++i;
        }
    }

    private void readConstant(DataInputStream in) throws IOException {
        Object value;
        int tag = in.readInt();
        switch (tag) {
            case 0: {
                value = in.readUTF();
                break;
            }
            case 1: {
                value = in.readInt();
                break;
            }
            case 2: {
                value = in.readDouble();
                break;
            }
            case 3: {
                value = in.readByte();
                break;
            }
            case 4: {
                value = Character.valueOf(in.readChar());
                break;
            }
            case 5: {
                value = Float.valueOf(in.readFloat());
                break;
            }
            case 6: {
                value = in.readShort();
                break;
            }
            case 7: {
                value = in.readLong();
                break;
            }
            case 8: {
                value = new EnumLiteral(in.readUTF());
                break;
            }
            case 9: {
                value = null;
                break;
            }
            default: {
                throw new UnsupportedEncodingException(String.format("Unsupported constant type: %d", tag));
            }
        }
        this.constants.add(value);
    }

    public void createConstants(Module module) {
        this.createConstants.doSwitch(module);
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.constants.size());
        for (Object constant : this.constants) {
            ConstantPool.writeConstant(out, constant);
        }
    }

    private static void writeConstant(DataOutputStream out, Object constant) throws IOException {
        if (constant == null) {
            out.writeInt(9);
            return;
        }
        ConstantTag tag = ConstantTag.get(constant.getClass().getSimpleName());
        if (tag == null) {
            throw new UnsupportedEncodingException(String.format("Unsupported constant type: %s", constant.getClass().getName()));
        }
        out.writeInt(tag.getValue());
        switch (tag) {
            case STRING: {
                out.writeUTF((String)constant);
                break;
            }
            case INTEGER: {
                out.writeInt((Integer)constant);
                break;
            }
            case DOUBLE: {
                out.writeDouble((Double)constant);
                break;
            }
            case BYTE: {
                out.writeByte(((Byte)constant).byteValue());
                break;
            }
            case CHARACTER: {
                out.writeChar(((Character)constant).charValue());
                break;
            }
            case FLOAT: {
                out.writeFloat(((Float)constant).floatValue());
                break;
            }
            case SHORT: {
                out.writeShort(((Short)constant).shortValue());
                break;
            }
            case LONG: {
                out.writeLong((Long)constant);
                break;
            }
            case ENUM_LITERAL: {
                if (constant instanceof EnumLiteral) {
                    out.writeUTF(((EnumLiteral)constant).getName());
                    break;
                }
                out.writeUTF(constant.toString());
                break;
            }
            default: {
                throw new UnsupportedEncodingException(String.format("Unsupported constant type: %s", constant.getClass().getName()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CreateConstantsSwitch
    extends EmftvmSwitch<Object> {
        @Override
        public Object caseNamedElement(NamedElement object) {
            ConstantPool.this.add(object.getName());
            return super.caseNamedElement(object);
        }

        @Override
        public Object caseTypedElement(TypedElement object) {
            ConstantPool.this.add(object.getTypeModel());
            ConstantPool.this.add(object.getType());
            return super.caseTypedElement(object);
        }

        @Override
        public Object caseFeature(Feature object) {
            ConstantPool.this.add(object.getContextModel());
            ConstantPool.this.add(object.getContext());
            return super.caseFeature(object);
        }

        @Override
        public Object caseCodeBlock(CodeBlock object) {
            for (LocalVariable lv : object.getLocalVariables()) {
                this.doSwitch(lv);
            }
            for (Instruction instr : object.getCode()) {
                this.doSwitch(instr);
            }
            for (CodeBlock nestedcode : object.getNested()) {
                this.doSwitch(nestedcode);
            }
            return super.caseCodeBlock(object);
        }

        @Override
        public Object caseModule(Module object) {
            for (Rule r : object.getRules()) {
                this.doSwitch(r);
            }
            for (Feature f : object.getFeatures()) {
                this.doSwitch(f);
            }
            for (String imp : object.getImports()) {
                ConstantPool.this.add(imp);
            }
            for (ModelDeclaration m : object.getInputModels()) {
                this.doSwitch(m);
            }
            for (ModelDeclaration m : object.getInoutModels()) {
                this.doSwitch(m);
            }
            for (ModelDeclaration m : object.getOutputModels()) {
                this.doSwitch(m);
            }
            ConstantPool.this.add(object.getSourceName());
            return super.caseModule(object);
        }

        @Override
        public Object caseOperation(Operation object) {
            for (Parameter par : object.getParameters()) {
                this.doSwitch(par);
            }
            if (object.getBody() != null) {
                this.doSwitch(object.getBody());
            }
            return super.caseOperation(object);
        }

        @Override
        public Object caseRule(Rule object) {
            for (String sr : object.getSuperRules()) {
                ConstantPool.this.add(sr);
            }
            for (RuleElement re : object.getInputElements()) {
                this.doSwitch(re);
            }
            for (RuleElement re : object.getOutputElements()) {
                this.doSwitch(re);
            }
            for (Field f : object.getFields()) {
                this.doSwitch(f);
            }
            if (object.getMatcher() != null) {
                this.doSwitch(object.getMatcher());
            }
            if (object.getApplier() != null) {
                this.doSwitch(object.getApplier());
            }
            if (object.getPostApply() != null) {
                this.doSwitch(object.getPostApply());
            }
            return super.caseRule(object);
        }

        @Override
        public Object caseRuleElement(RuleElement object) {
            for (String model : object.getModels()) {
                ConstantPool.this.add(model);
            }
            return super.caseRuleElement(object);
        }

        @Override
        public Object caseInputRuleElement(InputRuleElement object) {
            if (object.getBinding() != null) {
                this.doSwitch(object.getBinding());
            }
            return super.caseInputRuleElement(object);
        }

        @Override
        public Object caseFieldInstruction(FieldInstruction object) {
            ConstantPool.this.add(object.getFieldname());
            return super.caseFieldInstruction(object);
        }

        @Override
        public Object caseFindtype(Findtype object) {
            ConstantPool.this.add(object.getModelname());
            ConstantPool.this.add(object.getTypename());
            return super.caseFindtype(object);
        }

        @Override
        public Object caseInvokeOperationInstruction(InvokeOperationInstruction object) {
            ConstantPool.this.add(object.getOpname());
            return super.caseInvokeOperationInstruction(object);
        }

        @Override
        public Object caseNew(New object) {
            ConstantPool.this.add(object.getModelname());
            return super.caseNew(object);
        }

        @Override
        public Object casePush(Push object) {
            ConstantPool.this.add(object.getValue());
            return super.casePush(object);
        }

        @Override
        public Object caseMatch(Match object) {
            ConstantPool.this.add(object.getRulename());
            return super.caseMatch(object);
        }

        @Override
        public Object caseModelDeclaration(ModelDeclaration object) {
            ConstantPool.this.add(object.getModelName());
            ConstantPool.this.add(object.getMetaModelName());
            return super.caseModelDeclaration(object);
        }

        @Override
        public Object caseField(Field object) {
            if (object.getInitialiser() != null) {
                this.doSwitch(object.getInitialiser());
            }
            return super.caseField(object);
        }
    }
}

