/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;
import org.eclipse.m2m.atl.emftvm.util.LazyBag;
import org.eclipse.m2m.atl.emftvm.util.LazyCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.LazyOrderedSet;
import org.eclipse.m2m.atl.emftvm.util.LazySet;
import org.eclipse.m2m.atl.emftvm.util.Tuple;
import org.eclipse.m2m.atl.emftvm.util.TypeHashMap;
import org.eclipse.m2m.atl.emftvm.util.TypeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeTypes {
    private static final Map<String, NativeType> typeNames = new HashMap<String, NativeType>();
    private static final TypeMap<Class<?>, NativeType> types = new TypeHashMap();

    static {
        NativeType[] nativeTypeArray = NativeType.values();
        int n = nativeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NativeType type = nativeTypeArray[n2];
            typeNames.put(type.getName(), type);
            types.put(type.getType(), type);
            ++n2;
        }
    }

    private NativeTypes() {
    }

    public static Class<?> findType(String typeName) throws ClassNotFoundException {
        if (typeNames.containsKey(typeName)) {
            switch (typeNames.get(typeName)) {
                case OBJECT: {
                    return Object.class;
                }
                case COLLECTION: {
                    return LazyCollection.class;
                }
                case BAG: {
                    return LazyBag.class;
                }
                case SEQUENCE: {
                    return LazyList.class;
                }
                case SET: {
                    return LazySet.class;
                }
                case ORDERED_SET: {
                    return LazyOrderedSet.class;
                }
                case MAP: {
                    return Map.class;
                }
                case TUPLE: {
                    return Tuple.class;
                }
                case BOOLEAN: {
                    return Boolean.class;
                }
                case INTEGER: {
                    return Integer.class;
                }
                case REAL: {
                    return Double.class;
                }
                case STRING: {
                    return String.class;
                }
            }
            throw new ClassNotFoundException(typeName);
        }
        Matcher m = EMFTVMUtil.DELIM_PATTERN.matcher(typeName);
        return Class.forName(m.replaceAll("."));
    }

    public static Object newInstance(Class<?> type) throws InstantiationException, IllegalAccessException {
        if (types.containsKey(type)) {
            switch ((NativeType)((Object)types.get(type))) {
                case BAG: {
                    return new LazyBag();
                }
                case SEQUENCE: {
                    return new LazyList();
                }
                case SET: {
                    return new LazySet();
                }
                case ORDERED_SET: {
                    return new LazyOrderedSet();
                }
                case MAP: {
                    return new HashMap();
                }
                case TUPLE: {
                    return new Tuple();
                }
                case BOOLEAN: {
                    return Boolean.FALSE;
                }
                case INTEGER: {
                    return new Integer(0);
                }
                case REAL: {
                    return new Double(0.0);
                }
                case STRING: {
                    return new String();
                }
            }
            throw new InstantiationException(type.getName());
        }
        return type.newInstance();
    }

    public static String typeName(Class<?> type) {
        Object key = types.findKey(type);
        if (key != null) {
            return ((NativeType)((Object)types.get(key))).getName();
        }
        return type.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NativeType {
        OBJECT("Object", Object.class),
        COLLECTION("Collection", LazyCollection.class),
        BAG("Bag", LazyBag.class),
        SEQUENCE("Sequence", LazyList.class),
        SET("Set", LazySet.class),
        ORDERED_SET("OrderedSet", LazyOrderedSet.class),
        MAP("Map", Map.class),
        TUPLE("Tuple", Tuple.class),
        BOOLEAN("Boolean", Boolean.class),
        INTEGER("Integer", Integer.class),
        REAL("Real", Double.class),
        STRING("String", String.class);

        private final String name;
        private final Class<?> type;

        private NativeType(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

