/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.BooleanType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.IntegerType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.ModelElementType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclAnyType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.RealType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.StringType;
import org.eclipse.m2m.atl.engine.parser.AtlSourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlCompletionDataSource {
    private AtlSourceManager manager;

    public AtlCompletionDataSource(AtlSourceManager manager) {
        this.manager = manager;
    }

    public String getATLFileContext() {
        return AtlCompletionDataSource.getATLFileContext(this.manager);
    }

    public static String getATLFileContext(AtlSourceManager manager) {
        String context = "atl_context";
        if (manager != null) {
            int type = manager.getATLFileType();
            switch (type) {
                case 1: {
                    context = "module_context";
                    break;
                }
                case 3: {
                    context = "query_context";
                    break;
                }
                case 4: {
                    context = "library_context";
                    break;
                }
                default: {
                    context = "atl_context";
                }
            }
        }
        return context;
    }

    public static String[] getURIs() {
        Set uris = EPackage.Registry.INSTANCE.keySet();
        return uris.toArray(new String[uris.size()]);
    }

    public static IPath[] getPaths() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        ArrayList<IPath> allFiles = new ArrayList<IPath>();
        try {
            AtlCompletionDataSource.getWorkspaceEcoreFilePaths((IResource[])projects, allFiles);
        }
        catch (CoreException coreException) {}
        return allFiles.toArray(new IPath[allFiles.size()]);
    }

    private static void getWorkspaceEcoreFilePaths(IResource[] resources, List<IPath> filePaths) throws CoreException {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.isAccessible()) {
                if (resource instanceof IFile) {
                    if ("ecore".equals(resource.getFileExtension())) {
                        filePaths.add(resource.getFullPath());
                    }
                } else if (resource instanceof IProject) {
                    AtlCompletionDataSource.getWorkspaceEcoreFilePaths(((IProject)resource).members(), filePaths);
                } else if (resource instanceof IFolder) {
                    AtlCompletionDataSource.getWorkspaceEcoreFilePaths(((IFolder)resource).members(), filePaths);
                }
            }
            ++i;
        }
    }

    public String[] getMetamodels() {
        HashSet res = new HashSet();
        if (this.manager != null) {
            res.addAll(this.manager.getInputModels().values());
            res.addAll(this.manager.getOutputModels().values());
        }
        return res.toArray(new String[res.size()]);
    }

    public Map<String, OclAnyType[]> getClassifiers(int filter) {
        HashMap<String, OclAnyType[]> res = new HashMap<String, OclAnyType[]>();
        if (this.manager != null) {
            Map metamodelPackages = this.manager.getMetamodelPackages(filter);
            for (Map.Entry entry : metamodelPackages.entrySet()) {
                String metamodelName = entry.getKey().toString();
                List packages = (List)entry.getValue();
                HashSet<EClassifier> classifiers = new HashSet<EClassifier>();
                if (packages != null) {
                    for (EPackage metamodel : packages) {
                        classifiers.addAll(this.getClassifiers(metamodel));
                    }
                }
                OclAnyType[] types = new OclAnyType[classifiers.size()];
                int i = 0;
                for (EClassifier eClassifier : classifiers) {
                    types[i] = ModelElementType.create(eClassifier, metamodelName);
                    ++i;
                }
                res.put(metamodelName, types);
            }
        }
        return res;
    }

    private Collection<EClassifier> getClassifiers(EPackage metamodel) {
        LinkedHashSet<EClassifier> classifiers = new LinkedHashSet<EClassifier>();
        classifiers.addAll(AtlCompletionDataSource.computeAllClassifiersList(metamodel));
        Iterator iterator = classifiers.iterator();
        while (iterator.hasNext()) {
            classifiers.add((EClassifier)iterator.next());
        }
        return classifiers;
    }

    private static List<EClassifier> computeAllClassifiersList(EPackage ePackage) {
        BasicEList classifiers = new BasicEList();
        if (ePackage != null) {
            AtlCompletionDataSource.computeAllClassifiersList(ePackage, (List<EClassifier>)classifiers);
        }
        return classifiers;
    }

    private static void computeAllClassifiersList(EPackage ePackage, List<EClassifier> all) {
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!(classifier instanceof EClass) || ((EClass)classifier).isInterface()) continue;
            all.add(classifier);
        }
        Iterator packages = ePackage.getESubpackages().iterator();
        while (packages.hasNext()) {
            AtlCompletionDataSource.computeAllClassifiersList((EPackage)packages.next(), all);
        }
    }

    public Map<String, OclAnyType[]> getAtlPrimitiveTypes() {
        return new HashMap<String, OclAnyType[]>(){
            {
                this.put("", new OclAnyType[]{OclAnyType.getInstance(), StringType.getInstance(), IntegerType.getInstance(), BooleanType.getInstance(), RealType.getInstance()});
            }
        };
    }
}

