/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.EmftvmPackage;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Field;
import org.eclipse.m2m.atl.emftvm.LocalVariable;
import org.eclipse.m2m.atl.emftvm.Metamodel;
import org.eclipse.m2m.atl.emftvm.Model;
import org.eclipse.m2m.atl.emftvm.Operation;
import org.eclipse.m2m.atl.emftvm.Parameter;
import org.eclipse.m2m.atl.emftvm.trace.TracePackage;
import org.eclipse.m2m.atl.emftvm.util.EnumConversionList;
import org.eclipse.m2m.atl.emftvm.util.EnumLiteral;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.LazyListOnCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyListOnList;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.VMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EMFTVMUtil {
    public static final String NATIVE = "#native";
    public static final String NS_DELIM = "::";
    public static final Pattern DELIM_PATTERN = Pattern.compile("::");
    public static final String MAIN_OP_NAME = "main";
    public static final String XMI_ID_FEATURE = "__xmiID__";
    private static final Map<Class<?>, Map<Integer, Method>> METHOD_CACHE = new WeakHashMap();
    private static Metamodel ecoreMetamodel;
    private static Metamodel emfTvmMetamodel;
    private static Metamodel traceMetamodel;

    private EMFTVMUtil() {
    }

    public static String getTypeName(ExecEnv env, Object type) {
        if (type instanceof EClass) {
            EClass eCls = (EClass)type;
            Metamodel mm = env.getMetaModel(eCls.eResource());
            if (mm != null) {
                return String.valueOf(env.getMetaModelID(mm)) + '!' + eCls.getName();
            }
            return eCls.getName();
        }
        if (type instanceof Class) {
            return "#native!" + ((Class)type).getName();
        }
        return type.toString();
    }

    public static String getTypeNames(ExecEnv env, Object[] types) {
        StringBuffer names = new StringBuffer();
        boolean notFirst = false;
        Object[] objectArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Object type = objectArray[n2];
            if (notFirst) {
                names.append(", ");
            }
            names.append(EMFTVMUtil.getTypeName(env, type));
            notFirst = true;
            ++n2;
        }
        return names.toString();
    }

    public static Object getRegistryType(Object type) throws IllegalArgumentException {
        if (type instanceof EClassifier && !(type instanceof EClass)) {
            Class ic = ((EClassifier)type).getInstanceClass();
            if (ic == null) {
                throw new IllegalArgumentException(String.format("Primitive EMF type without instance class %s", type));
            }
            return ic;
        }
        return type;
    }

    public static Metamodel getEcoreMetamodel() {
        if (ecoreMetamodel == null) {
            ecoreMetamodel = EmftvmFactory.eINSTANCE.createMetamodel();
            ecoreMetamodel.setResource(EcorePackage.eINSTANCE.eResource());
        }
        return ecoreMetamodel;
    }

    public static Metamodel getEmfTvmMetamodel() {
        if (emfTvmMetamodel == null) {
            emfTvmMetamodel = EmftvmFactory.eINSTANCE.createMetamodel();
            emfTvmMetamodel.setResource(EmftvmPackage.eINSTANCE.eResource());
        }
        return emfTvmMetamodel;
    }

    public static Metamodel getTraceMetamodel() {
        if (traceMetamodel == null) {
            traceMetamodel = EmftvmFactory.eINSTANCE.createMetamodel();
            traceMetamodel.setResource(TracePackage.eINSTANCE.eResource());
        }
        return traceMetamodel;
    }

    public static LazyList<EObject> findAllInstances(EClass type, ExecEnv env) {
        LazyList<EObject> allInst = new LazyList<EObject>();
        for (Model model : env.getInputModels().values()) {
            allInst = allInst.union(model.allInstancesOf(type));
        }
        for (Model model : env.getInoutModels().values()) {
            allInst = allInst.union(model.allInstancesOf(type));
        }
        return allInst;
    }

    public static LazyList<EObject> findAllInstIn(Object modelname, EClass type, ExecEnv env) {
        Model model = env.getInputModels().get(modelname);
        if (model == null) {
            model = env.getInoutModels().get(modelname);
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("No input/inout model found with name %s", modelname));
        }
        return model.allInstancesOf(type);
    }

    public static String toPrettyString(Object object, ExecEnv env) {
        if (object instanceof EClass) {
            Model model;
            StringBuffer sb = new StringBuffer();
            if (env != null && (model = env.getModelOf((EObject)((EClass)object))) != null) {
                sb.append(env.getModelID(model));
                sb.append('!');
            }
            sb.append(((EClass)object).getName());
            return sb.toString();
        }
        if (object instanceof EObject) {
            StringBuffer buf = new StringBuffer();
            EObject eo = (EObject)object;
            EAttribute sf = eo.eClass().getEIDAttribute();
            if (sf == null) {
                sf = eo.eClass().getEStructuralFeature("name");
            }
            if (sf != null && eo.eGet((EStructuralFeature)sf) != null) {
                buf.append(eo.eGet((EStructuralFeature)sf));
            } else {
                buf.append(Integer.toHexString(eo.hashCode()));
            }
            buf.append(':');
            buf.append(EMFTVMUtil.toPrettyString(eo.eClass(), env));
            return buf.toString();
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        if (object != null) {
            return object.toString();
        }
        return "null";
    }

    public static String toPrettyString(Collection<?> coll, ExecEnv env) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        boolean first = true;
        for (Object object : coll) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(EMFTVMUtil.toPrettyString(object, env));
        }
        sb.append(']');
        return sb.toString();
    }

    public static <T> String toPrettyString(T[] array, ExecEnv env) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        boolean first = true;
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T object = TArray[n2];
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(EMFTVMUtil.toPrettyString(object, env));
            ++n2;
        }
        sb.append(']');
        return sb.toString();
    }

    public static Object get(ExecEnv env, EObject eo, EStructuralFeature sf) {
        if (env.getOutputModelOf(eo) != null) {
            throw new IllegalArgumentException(String.format("Cannot read properties of %s, as it is contained in an output model", EMFTVMUtil.toPrettyString(eo, env)));
        }
        return EMFTVMUtil.uncheckedGet(env, eo, sf);
    }

    public static Object uncheckedGet(ExecEnv env, EObject eo, EStructuralFeature sf) {
        if (sf instanceof EReference) {
            Object value = eo.eGet(sf);
            if (value instanceof EList) {
                return new LazyListOnList((EList)value);
            }
            assert (!(value instanceof Collection));
            return value;
        }
        return EMFTVMUtil.emf2vm(env, eo, eo.eGet(sf));
    }

    public static Object emf2vm(ExecEnv env, EObject eo, Object value) {
        if (value instanceof Enumerator) {
            return new EnumLiteral(value.toString());
        }
        if (value instanceof EList) {
            if (eo != null && env.getInoutModelOf(eo) != null) {
                return new EnumConversionList((List<Object>)((EList)value)).cache();
            }
            return new EnumConversionList((List<Object>)((EList)value));
        }
        if (value != null && value.getClass().isArray()) {
            return new LazyListOnList<Object>(Arrays.asList((Object[])value));
        }
        assert (eo == null || !(value instanceof Collection));
        return value;
    }

    public static void set(ExecEnv env, EObject eo, EStructuralFeature sf, Object value) {
        if (!sf.isChangeable()) {
            throw new IllegalArgumentException(String.format("Field %s::%s is not changeable", EMFTVMUtil.toPrettyString(sf.getEContainingClass(), env), sf.getName()));
        }
        if (env.getInputModelOf(eo) != null) {
            throw new IllegalArgumentException(String.format("Cannot set properties of %s, as it is contained in an input model", EMFTVMUtil.toPrettyString(eo, env)));
        }
        if (sf.isMany()) {
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException(String.format("Cannot assign %s to multi-valued field %s::%s", value, sf.getEContainingClass().getName(), sf.getName()));
            }
            EMFTVMUtil.setMany(env, eo, sf, (Collection)value);
        } else {
            EMFTVMUtil.setSingle(env, eo, sf, value, -1);
        }
        assert (eo.eResource() != null);
    }

    public static void add(ExecEnv env, EObject eo, EStructuralFeature sf, Object value, int index) {
        if (!sf.isChangeable()) {
            throw new IllegalArgumentException(String.format("Field %s::%s is not changeable", EMFTVMUtil.toPrettyString(sf.getEContainingClass(), env), sf.getName()));
        }
        if (env.getInputModelOf(eo) != null) {
            throw new IllegalArgumentException(String.format("Cannot add properties to %s, as it is contained in an input model", EMFTVMUtil.toPrettyString(eo, env)));
        }
        if (sf.isMany()) {
            if (value instanceof Collection) {
                EMFTVMUtil.addMany(env, eo, sf, (Collection)value, index);
            } else {
                EMFTVMUtil.addMany(env, eo, sf, value, index);
            }
        } else {
            if (eo.eIsSet(sf)) {
                throw new IllegalArgumentException(String.format("Cannot add more than one value to %s::%s", EMFTVMUtil.toPrettyString(eo.eClass(), env), sf.getName()));
            }
            EMFTVMUtil.setSingle(env, eo, sf, value, index);
        }
        assert (eo.eResource() != null);
    }

    public static void remove(ExecEnv env, EObject eo, EStructuralFeature sf, Object value) {
        if (!sf.isChangeable()) {
            throw new IllegalArgumentException(String.format("Field %s::%s is not changeable", EMFTVMUtil.toPrettyString(sf.getEContainingClass(), env), sf.getName()));
        }
        if (env.getInputModelOf(eo) != null) {
            throw new IllegalArgumentException(String.format("Cannot remove properties of %s, as it is contained in an input model", EMFTVMUtil.toPrettyString(eo, env)));
        }
        EClassifier sfType = sf.getEType();
        if (sf.isMany()) {
            if (value instanceof Collection) {
                EMFTVMUtil.removeMany(env, eo, sf, (Collection)value);
            } else {
                EMFTVMUtil.removeMany(env, eo, sf, value);
            }
        } else {
            Object oldValue = eo.eGet(sf);
            if (sfType instanceof EEnum && value instanceof EnumLiteral) {
                EEnum eEnum = (EEnum)sfType;
                if (oldValue != null && oldValue.equals(((EnumLiteral)value).getEnumerator(eEnum))) {
                    EMFTVMUtil.setSingle(env, eo, sf, sf.getDefaultValue(), -1);
                }
            } else if (oldValue == null ? value == null : oldValue.equals(value)) {
                EMFTVMUtil.setSingle(env, eo, sf, sf.getDefaultValue(), -1);
            }
        }
        assert (eo.eResource() != null);
    }

    private static void setSingle(ExecEnv env, EObject eo, EStructuralFeature sf, Object value, int index) {
        assert (!sf.isMany());
        if (index > 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        EClassifier sfType = sf.getEType();
        boolean allowInterModelReferences = EMFTVMUtil.isAllowInterModelReferences(env, eo);
        if (sfType instanceof EEnum) {
            EEnum eEnum = (EEnum)sfType;
            if (value instanceof EnumLiteral) {
                eo.eSet(sf, (Object)((EnumLiteral)value).getEnumerator(eEnum));
            } else {
                eo.eSet(sf, value);
            }
        } else if (sf instanceof EReference) {
            EReference ref = (EReference)sf;
            if (EMFTVMUtil.checkValue(env, eo, ref, value, allowInterModelReferences)) {
                EObject oldValue = (EObject)eo.eGet(sf);
                assert (eo.eResource() != null);
                assert (value == null || ((EObject)value).eResource() != null);
                assert (oldValue == null || oldValue.eResource() != null);
                eo.eSet(sf, value);
                if (value != null) {
                    EMFTVMUtil.updateResource(eo, (EObject)value);
                }
                if (oldValue != null) {
                    EMFTVMUtil.updateResource(eo, oldValue);
                }
                assert (eo.eResource() != null);
                assert (value == null || ((EObject)value).eResource() != null);
                assert (oldValue == null || oldValue.eResource() != null);
            }
        } else {
            eo.eSet(sf, value);
        }
    }

    private static void setMany(ExecEnv env, EObject eo, EStructuralFeature sf, Collection<?> value) {
        assert (sf.isMany());
        EList values = (EList)eo.eGet(sf);
        if (!values.isEmpty()) {
            if (sf instanceof EReference) {
                ArrayList vCopy = new ArrayList(values);
                for (EObject v : vCopy) {
                    EMFTVMUtil.removeRefValue((EReference)sf, eo, (EList<Object>)values, v);
                }
            } else {
                values.clear();
            }
        }
        EMFTVMUtil.addMany(env, eo, sf, value, -1);
    }

    private static void addMany(ExecEnv env, EObject eo, EStructuralFeature sf, Object value, int index) {
        assert (sf.isMany());
        EClassifier sfType = sf.getEType();
        EList values = (EList)eo.eGet(sf);
        if (sfType instanceof EEnum) {
            EMFTVMUtil.addEnumValue((EEnum)sfType, (EList<Object>)values, value, index);
        } else if (sf instanceof EReference) {
            EReference ref = (EReference)sf;
            EMFTVMUtil.addRefValue(env, ref, eo, (EList<Object>)values, (EObject)value, index, EMFTVMUtil.isAllowInterModelReferences(env, eo));
        } else if (index > -1) {
            values.add(index, value);
        } else {
            values.add(value);
        }
    }

    private static void addMany(ExecEnv env, EObject eo, EStructuralFeature sf, Collection<?> value, int index) {
        assert (sf.isMany());
        EClassifier sfType = sf.getEType();
        EList values = (EList)eo.eGet(sf);
        if (sfType instanceof EEnum) {
            EEnum eEnum = (EEnum)sfType;
            if (index > -1) {
                int currentIndex = index;
                for (Object v : value) {
                    EMFTVMUtil.addEnumValue(eEnum, (EList<Object>)values, v, currentIndex++);
                }
            } else {
                for (Object v : value) {
                    EMFTVMUtil.addEnumValue(eEnum, (EList<Object>)values, v, -1);
                }
            }
        } else if (sf instanceof EReference) {
            EReference ref = (EReference)sf;
            boolean allowInterModelReferences = EMFTVMUtil.isAllowInterModelReferences(env, eo);
            if (index > -1) {
                int currentIndex = index;
                for (Object v : value) {
                    EMFTVMUtil.addRefValue(env, ref, eo, (EList<Object>)values, (EObject)v, currentIndex++, allowInterModelReferences);
                }
            } else {
                for (Object v : value) {
                    EMFTVMUtil.addRefValue(env, ref, eo, (EList<Object>)values, (EObject)v, -1, allowInterModelReferences);
                }
            }
        } else if (index > -1) {
            values.addAll(index, value);
        } else {
            values.addAll(value);
        }
    }

    private static void removeMany(ExecEnv env, EObject eo, EStructuralFeature sf, Object value) {
        assert (sf.isMany());
        EClassifier sfType = sf.getEType();
        EList values = (EList)eo.eGet(sf);
        if (sfType instanceof EEnum) {
            EEnum eEnum = (EEnum)sfType;
            EMFTVMUtil.removeEnumValue(eEnum, (EList<Object>)values, value);
        } else if (sf instanceof EReference) {
            EReference ref = (EReference)sf;
            EMFTVMUtil.removeRefValue(ref, eo, (EList<Object>)values, (EObject)value);
        } else {
            values.remove(value);
        }
    }

    private static void removeMany(ExecEnv env, EObject eo, EStructuralFeature sf, Collection<?> value) {
        assert (sf.isMany());
        EClassifier sfType = sf.getEType();
        EList values = (EList)eo.eGet(sf);
        if (sfType instanceof EEnum) {
            EEnum eEnum = (EEnum)sfType;
            for (Object v : value) {
                EMFTVMUtil.removeEnumValue(eEnum, (EList<Object>)values, v);
            }
        } else if (sf instanceof EReference) {
            EReference ref = (EReference)sf;
            for (Object v : value) {
                EMFTVMUtil.removeRefValue(ref, eo, (EList<Object>)values, (EObject)v);
            }
        } else {
            values.removeAll(value);
        }
    }

    private static void addEnumValue(EEnum eEnum, EList<Object> values, Object v, int index) {
        Object v2 = v instanceof EnumLiteral ? ((EnumLiteral)v).getEnumerator(eEnum) : v;
        if (index > -1) {
            values.add(index, v2);
        } else {
            values.add(v2);
        }
    }

    private static void removeEnumValue(EEnum eEnum, EList<Object> values, Object v) {
        if (v instanceof EnumLiteral) {
            values.remove((Object)((EnumLiteral)v).getEnumerator(eEnum));
        } else {
            values.remove(v);
        }
    }

    private static void addRefValue(ExecEnv env, EReference ref, EObject eo, EList<Object> values, EObject v, int index, boolean allowInterModelReferences) {
        assert (eo.eResource() != null);
        assert (v.eResource() != null);
        if (EMFTVMUtil.checkValue(env, eo, ref, v, allowInterModelReferences)) {
            if (index > -1) {
                values.add(index, (Object)v);
            } else {
                values.add((Object)v);
            }
            EMFTVMUtil.updateResource(eo, v);
        }
        assert (eo.eResource() != null);
        assert (v.eResource() != null);
    }

    private static void removeRefValue(EReference ref, EObject eo, EList<Object> values, EObject v) {
        assert (eo.eResource() != null);
        assert (v.eResource() != null);
        if (values.remove((Object)v)) {
            EMFTVMUtil.updateResource(eo, v);
        }
        assert (eo.eResource() != null);
        assert (v.eResource() != null);
    }

    private static void updateResource(EObject eo, EObject v) {
        if (eo.eResource() == null) {
            assert (eo.eContainer() == null);
            v.eResource().getContents().add((Object)eo);
        } else if (v.eResource() == null) {
            assert (v.eContainer() == null);
            eo.eResource().getContents().add((Object)v);
        }
        if (eo.eContainer() != null) {
            eo.eResource().getContents().remove((Object)eo);
        }
        if (v.eContainer() != null) {
            v.eResource().getContents().remove((Object)v);
        }
    }

    private static boolean isAllowInterModelReferences(ExecEnv env, EObject eo) {
        Model eoModel = env.getModelOf(eo);
        if (eoModel != null) {
            return eoModel.isAllowInterModelReferences();
        }
        return true;
    }

    private static boolean checkValue(ExecEnv env, EObject eo, EReference ref, Object value, boolean allowInterModelReferences) {
        if (value instanceof EObject) {
            assert (eo.eResource() != null);
            EObject ev = (EObject)value;
            if (eo.eResource() == ev.eResource() || ev.eResource() == null) {
                return true;
            }
            assert (ev.eResource() != null);
            if (!allowInterModelReferences) {
                ATLLogger.warning((String)String.format("Cannot set %s::%s to %s for %s: inter-model references are not allowed for this model", EMFTVMUtil.toPrettyString(ref.getEContainingClass(), env), ref.getName(), EMFTVMUtil.toPrettyString(value, env), EMFTVMUtil.toPrettyString(eo, env)));
                return false;
            }
            if (ref.isContainer() || ref.isContainment()) {
                ATLLogger.warning((String)String.format("Cannot set %s::%s to %s for %s: containment references cannot span across models", EMFTVMUtil.toPrettyString(ref.getEContainingClass(), env), ref.getName(), EMFTVMUtil.toPrettyString(value, env), EMFTVMUtil.toPrettyString(eo, env)));
                return false;
            }
            EReference opposite = ref.getEOpposite();
            if (opposite != null) {
                Model oppositeModel;
                Model evModel = env.getInputModelOf(ev);
                if (evModel != null) {
                    ATLLogger.warning((String)String.format("Cannot set %s::%s to %s for %s: inter-model reference with opposite causes changes in input model %s", EMFTVMUtil.toPrettyString(ref.getEContainingClass(), env), ref.getName(), EMFTVMUtil.toPrettyString(value, env), EMFTVMUtil.toPrettyString(eo, env), env.getModelID(evModel)));
                    return false;
                }
                if (!opposite.isMany() && (oppositeModel = env.getInputModelOf((EObject)ev.eGet((EStructuralFeature)opposite))) != null) {
                    ATLLogger.warning((String)String.format("Cannot set %s::%s to %s for %s: inter-model reference with single-valued opposite causes changes in input model %s", EMFTVMUtil.toPrettyString(ref.getEContainingClass(), env), ref.getName(), EMFTVMUtil.toPrettyString(value, env), EMFTVMUtil.toPrettyString(eo, env), env.getModelID(oppositeModel)));
                    return false;
                }
            }
        }
        return true;
    }

    public static Object[] getArgumentTypes(Object[] args) {
        int argcount = args.length;
        Object[] argTypes = new Object[argcount];
        int i = 0;
        while (i < argcount) {
            argTypes[i] = EMFTVMUtil.getArgumentType(args[i]);
            ++i;
        }
        return argTypes;
    }

    public static Object getArgumentType(Object arg) {
        if (arg instanceof EObject) {
            return ((EObject)arg).eClass();
        }
        if (arg != null) {
            return arg.getClass();
        }
        return Void.TYPE;
    }

    public static Object invokeNative(StackFrame frame, Object self, String opname, Object[] args) {
        Method method = EMFTVMUtil.findNativeMethod(self == null ? Void.TYPE : self.getClass(), opname, EMFTVMUtil.getArgumentClasses(args), false);
        if (method != null) {
            StackFrame subFrame = frame.prepareNativeArgs(method, self, args);
            try {
                return EMFTVMUtil.emf2vm(frame.getEnv(), self instanceof EObject ? (EObject)self : null, method.invoke(self, args));
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof VMException) {
                    throw (VMException)target;
                }
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(String.format("%s::%s(%s)", EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(self)), opname, EMFTVMUtil.getTypeNames(frame.getEnv(), EMFTVMUtil.getArgumentTypes(args))));
    }

    public static Object invokeNative(StackFrame frame, Object self, Method method, Object[] args) {
        StackFrame subFrame = frame.prepareNativeArgs(method, self, args);
        try {
            return EMFTVMUtil.emf2vm(frame.getEnv(), self instanceof EObject ? (EObject)self : null, method.invoke(self, args));
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof VMException) {
                throw (VMException)target;
            }
            throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
        }
        catch (VMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
        }
    }

    public static Object invokeNative(StackFrame frame, Object self, String opname, Object arg) {
        Method method = EMFTVMUtil.findNativeMethod(self == null ? Void.TYPE : self.getClass(), opname, arg == null ? Void.TYPE : arg.getClass(), false);
        if (method != null) {
            StackFrame subFrame = frame.prepareNativeContext(method, self);
            if (arg instanceof CodeBlock) {
                if (subFrame == null) {
                    subFrame = new StackFrame(frame, method);
                }
                ((CodeBlock)arg).setParentFrame(subFrame);
            } else if (arg instanceof EnumLiteral) {
                arg = EMFTVMUtil.convertEnumLiteral((EnumLiteral)arg, method.getParameterTypes()[0]);
            }
            try {
                return EMFTVMUtil.emf2vm(frame.getEnv(), self instanceof EObject ? (EObject)self : null, method.invoke(self, arg));
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof VMException) {
                    throw (VMException)target;
                }
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(String.format("%s::%s(%s)", EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(self)), opname, EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(arg))));
    }

    public static Object invokeNative(StackFrame frame, Object self, Method method, Object arg) {
        StackFrame subFrame = frame.prepareNativeContext(method, self);
        if (arg instanceof CodeBlock) {
            if (subFrame == null) {
                subFrame = new StackFrame(frame, method);
            }
            ((CodeBlock)arg).setParentFrame(subFrame);
        } else if (arg instanceof EnumLiteral) {
            arg = EMFTVMUtil.convertEnumLiteral((EnumLiteral)arg, method.getParameterTypes()[0]);
        }
        try {
            return EMFTVMUtil.emf2vm(frame.getEnv(), self instanceof EObject ? (EObject)self : null, method.invoke(self, arg));
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof VMException) {
                throw (VMException)target;
            }
            throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
        }
        catch (VMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
        }
    }

    public static Object invokeNative(StackFrame frame, Object self, String opname) {
        Method method = EMFTVMUtil.findNativeMethod(self == null ? Void.TYPE : self.getClass(), opname, false);
        if (method != null) {
            StackFrame subFrame = frame.prepareNativeContext(method, self);
            try {
                return EMFTVMUtil.emf2vm(frame.getEnv(), self instanceof EObject ? (EObject)self : null, method.invoke(self, new Object[0]));
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof VMException) {
                    throw (VMException)target;
                }
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(String.format("%s::%s()", EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(self)), opname));
    }

    public static Object invokeNative(StackFrame frame, Object self, Method method) {
        StackFrame subFrame = frame.prepareNativeContext(method, self);
        try {
            return EMFTVMUtil.emf2vm(frame.getEnv(), self instanceof EObject ? (EObject)self : null, method.invoke(self, new Object[0]));
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof VMException) {
                throw (VMException)target;
            }
            throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
        }
        catch (VMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
        }
    }

    public static Object invokeNativeStatic(StackFrame frame, Class<?> type, String opname, Object[] args) {
        Method method = EMFTVMUtil.findNativeMethod(type, opname, EMFTVMUtil.getArgumentClasses(args), true);
        if (method != null) {
            StackFrame subFrame = frame.prepareNativeArgs(method, args);
            try {
                return EMFTVMUtil.emf2vm(frame.getEnv(), null, method.invoke(type, args));
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof VMException) {
                    throw (VMException)target;
                }
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(String.format("static %s::%s(%s)", EMFTVMUtil.getTypeName(frame.getEnv(), type), opname, EMFTVMUtil.getTypeNames(frame.getEnv(), EMFTVMUtil.getArgumentTypes(args))));
    }

    public static Object invokeNativeStatic(StackFrame frame, Class<?> type, String opname, Object arg) {
        Method method = EMFTVMUtil.findNativeMethod(type, opname, arg == null ? Void.TYPE : arg.getClass(), true);
        if (method != null) {
            StackFrame subFrame = null;
            if (arg instanceof CodeBlock) {
                subFrame = new StackFrame(frame, method);
                ((CodeBlock)arg).setParentFrame(subFrame);
            } else if (arg instanceof EnumLiteral) {
                arg = EMFTVMUtil.convertEnumLiteral((EnumLiteral)arg, method.getParameterTypes()[0]);
            }
            try {
                return EMFTVMUtil.emf2vm(frame.getEnv(), null, method.invoke(type, arg));
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof VMException) {
                    throw (VMException)target;
                }
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(String.format("static %s::%s(%s)", EMFTVMUtil.getTypeName(frame.getEnv(), type), opname, EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(arg))));
    }

    public static Object invokeNativeStatic(StackFrame frame, Class<?> type, String opname) {
        Method method = EMFTVMUtil.findNativeMethod(type, opname, true);
        if (method != null) {
            try {
                return EMFTVMUtil.emf2vm(frame.getEnv(), null, method.invoke(type, new Object[0]));
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof VMException) {
                    throw (VMException)target;
                }
                throw new VMException(new StackFrame(frame, method), target);
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VMException(new StackFrame(frame, method), (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(String.format("static %s::%s()", EMFTVMUtil.getTypeName(frame.getEnv(), type), opname));
    }

    public static Object invokeNativeSuper(StackFrame frame, Class<?> context, Object self, String opname, Object[] args) {
        assert (context.isAssignableFrom(self.getClass()));
        Method method = EMFTVMUtil.findNativeMethod(context.getSuperclass(), opname, EMFTVMUtil.getArgumentClasses(args), false);
        if (method != null) {
            StackFrame subFrame = frame.prepareNativeArgs(method, self, args);
            try {
                return EMFTVMUtil.emf2vm(frame.getEnv(), self instanceof EObject ? (EObject)self : null, method.invoke(self, args));
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof VMException) {
                    throw (VMException)target;
                }
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(String.format("super %s::%s(%s)", EMFTVMUtil.getTypeName(frame.getEnv(), self.getClass()), opname, EMFTVMUtil.getTypeNames(frame.getEnv(), EMFTVMUtil.getArgumentTypes(args))));
    }

    public static Object invokeNativeSuper(StackFrame frame, Class<?> context, Object self, String opname, Object arg) {
        assert (context.isAssignableFrom(self.getClass()));
        Method method = EMFTVMUtil.findNativeMethod(context.getSuperclass(), opname, arg == null ? Void.TYPE : arg.getClass(), false);
        if (method != null) {
            StackFrame subFrame = frame.prepareNativeContext(method, self);
            if (arg instanceof CodeBlock) {
                if (subFrame == null) {
                    subFrame = new StackFrame(frame, method);
                }
                ((CodeBlock)arg).setParentFrame(subFrame);
            } else if (arg instanceof EnumLiteral) {
                arg = EMFTVMUtil.convertEnumLiteral((EnumLiteral)arg, method.getParameterTypes()[0]);
            }
            try {
                return EMFTVMUtil.emf2vm(frame.getEnv(), self instanceof EObject ? (EObject)self : null, method.invoke(self, arg));
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof VMException) {
                    throw (VMException)target;
                }
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(String.format("super %s::%s(%s)", EMFTVMUtil.getTypeName(frame.getEnv(), self.getClass()), opname, EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(arg))));
    }

    public static Object invokeNativeSuper(StackFrame frame, Class<?> context, Object self, String opname) {
        assert (context.isAssignableFrom(self.getClass()));
        Method method = EMFTVMUtil.findNativeMethod(context.getSuperclass(), opname, false);
        if (method != null) {
            StackFrame subFrame = frame.prepareNativeContext(method, self);
            try {
                return EMFTVMUtil.emf2vm(frame.getEnv(), self instanceof EObject ? (EObject)self : null, method.invoke(self, new Object[0]));
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof VMException) {
                    throw (VMException)target;
                }
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, target);
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VMException(subFrame == null ? new StackFrame(frame, method) : subFrame, (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(String.format("super %s::%s()", EMFTVMUtil.getTypeName(frame.getEnv(), self.getClass()), opname));
    }

    public static Method findNativeMethod(Class<?> context, String opname, Class<?>[] argTypes, boolean isStatic) {
        if (context == Void.TYPE) {
            return null;
        }
        int sig = EMFTVMUtil.getMethodSignature(opname, argTypes, isStatic);
        Method ret = EMFTVMUtil.findCachedMethod(context, sig);
        if (ret != null) {
            return ret;
        }
        Method[] methods = context.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Class<?>[] pts;
            Method method = methods[i];
            if (Modifier.isStatic(method.getModifiers()) == isStatic && method.getName().equals(opname) && (pts = method.getParameterTypes()).length == argTypes.length) {
                boolean ok = true;
                int j = 0;
                while (j < pts.length && ok) {
                    if (!(argTypes[j] == EnumLiteral.class && Enumerator.class.isAssignableFrom(pts[j]) || pts[j].isAssignableFrom(argTypes[j]))) {
                        ok = pts[j] == Boolean.TYPE ? argTypes[j] == Boolean.class : (pts[j] == Integer.TYPE ? argTypes[j] == Integer.class : (pts[j] == Character.TYPE ? argTypes[j] == Character.class : (pts[j] == Long.TYPE ? argTypes[j] == Long.class : (pts[j] == Float.TYPE ? argTypes[j] == Float.class : (pts[j] == Double.TYPE ? argTypes[j] == Double.class : argTypes[j] == Void.TYPE)))));
                    }
                    ++j;
                }
                if (ok) {
                    ret = method;
                    break;
                }
            }
            ++i;
        }
        if (ret == null && !isStatic && context.getSuperclass() != null) {
            ret = EMFTVMUtil.findNativeMethod(context.getSuperclass(), opname, argTypes, isStatic);
        }
        EMFTVMUtil.cacheMethod(context, sig, ret);
        return ret;
    }

    public static Method findNativeMethod(Class<?> context, String opname, Class<?> argType, boolean isStatic) {
        if (context == Void.TYPE) {
            return null;
        }
        int sig = EMFTVMUtil.getMethodSignature(opname, argType, isStatic);
        Method ret = EMFTVMUtil.findCachedMethod(context, sig);
        if (ret != null) {
            return ret;
        }
        Method[] methods = context.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Class<?>[] pts;
            Method method = methods[i];
            if (Modifier.isStatic(method.getModifiers()) == isStatic && method.getName().equals(opname) && (pts = method.getParameterTypes()).length == 1) {
                Class<?> pt = pts[0];
                if (argType == EnumLiteral.class && Enumerator.class.isAssignableFrom(pt)) {
                    ret = method;
                    break;
                }
                boolean ok = true;
                if (!pt.isAssignableFrom(argType)) {
                    if (pt == Boolean.TYPE) {
                        ok = argType == Boolean.class;
                    } else if (pt == Integer.TYPE) {
                        ok = argType == Integer.class;
                    } else if (pt == Character.TYPE) {
                        ok = argType == Character.class;
                    } else if (pt == Long.TYPE) {
                        ok = argType == Long.class;
                    } else if (pt == Float.TYPE) {
                        ok = argType == Float.class;
                    } else if (pt == Double.TYPE) {
                        ok = argType == Double.class;
                    } else {
                        boolean bl = ok = argType == Void.TYPE;
                    }
                }
                if (ok) {
                    ret = method;
                    break;
                }
            }
            ++i;
        }
        if (ret == null && !isStatic && context.getSuperclass() != null) {
            ret = EMFTVMUtil.findNativeMethod(context.getSuperclass(), opname, argType, isStatic);
        }
        EMFTVMUtil.cacheMethod(context, sig, ret);
        return ret;
    }

    public static Method findNativeMethod(Class<?> context, String opname, boolean isStatic) {
        if (context == Void.TYPE) {
            return null;
        }
        int sig = EMFTVMUtil.getMethodSignature(opname, isStatic);
        Method ret = EMFTVMUtil.findCachedMethod(context, sig);
        if (ret != null) {
            return ret;
        }
        Method[] methods = context.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (Modifier.isStatic(method.getModifiers()) == isStatic && method.getName().equals(opname) && method.getParameterTypes().length == 0) {
                ret = method;
                break;
            }
            ++i;
        }
        if (ret == null && !isStatic && context.getSuperclass() != null) {
            ret = EMFTVMUtil.findNativeMethod(context.getSuperclass(), opname, isStatic);
        }
        EMFTVMUtil.cacheMethod(context, sig, ret);
        return ret;
    }

    private static Method findCachedMethod(Class<?> caller, int signature) {
        Method ret = null;
        Map<Integer, Method> sigMap = METHOD_CACHE.get(caller);
        if (sigMap != null) {
            ret = sigMap.get(signature);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheMethod(Class<?> caller, int signature, Method method) {
        Map<Class<?>, Map<Integer, Method>> map = METHOD_CACHE;
        synchronized (map) {
            Map<Integer, Method> sigMap = METHOD_CACHE.get(caller);
            if (sigMap == null) {
                sigMap = new HashMap<Integer, Method>();
                METHOD_CACHE.put(caller, sigMap);
            }
            sigMap.put(signature, method);
        }
    }

    private static int getMethodSignature(String name, Class<?>[] argumentTypes, boolean isStatic) {
        int sig = (isStatic ? 31 : 0) + name.hashCode();
        int i = 0;
        while (i < argumentTypes.length) {
            sig = sig * 31 + argumentTypes[i].hashCode();
            ++i;
        }
        return sig;
    }

    private static int getMethodSignature(String name, Class<?> argumentType, boolean isStatic) {
        return ((isStatic ? 31 : 0) + name.hashCode()) * 31 + argumentType.hashCode();
    }

    private static int getMethodSignature(String name, boolean isStatic) {
        return (isStatic ? 31 : 0) + name.hashCode();
    }

    public static Class<?>[] getArgumentClasses(Object[] args) {
        int argcount = args.length;
        Class[] argTypes = new Class[argcount];
        int i = 0;
        while (i < argcount) {
            argTypes[i] = args[i] == null ? Void.TYPE : args[i].getClass();
            ++i;
        }
        return argTypes;
    }

    public static boolean writeToWithCharset(String string, String path, String charset) throws IOException {
        File file = EMFTVMUtil.getFile(path);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        PrintStream out = charset == null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(file)), true) : new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), true, charset);
        out.print(string);
        out.close();
        return true;
    }

    public static File getFile(String path) {
        String newPath = path;
        if (Platform.isRunning()) {
            IPath location = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path)).getLocation();
            if (location != null) {
                newPath = location.toString();
            } else {
                ATLLogger.info((String)String.format("Could not find a workspace location for %s; falling back to native java.io.File path resolution", path));
            }
        } else {
            ATLLogger.info((String)"Could not find workspace root; falling back to native java.io.File path resolution");
        }
        return new File(newPath);
    }

    public static Operation createOperation(boolean isStatic, String name, String[] context, String[] returnType, String[][][] parameters, CodeBlock body) {
        EmftvmFactory factory = EmftvmFactory.eINSTANCE;
        Operation op = factory.createOperation();
        op.setStatic(isStatic);
        op.setName(name);
        op.setContextModel(context[0]);
        op.setContext(context[1]);
        op.setTypeModel(returnType[0]);
        op.setType(returnType[1]);
        EList<Parameter> pars = op.getParameters();
        EList<LocalVariable> locals = body.getLocalVariables();
        if (!isStatic) {
            LocalVariable self = factory.createLocalVariable();
            self.setName("self");
            self.setTypeModel(context[0]);
            self.setType(context[1]);
            locals.add((Object)self);
        }
        String[][][] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String[][] par = stringArray[n2];
            Parameter p = factory.createParameter();
            p.setName(par[0][0]);
            p.setTypeModel(par[1][0]);
            p.setType(par[1][1]);
            pars.add((Object)p);
            LocalVariable lv = factory.createLocalVariable();
            lv.setName(par[0][0]);
            lv.setTypeModel(par[1][0]);
            lv.setType(par[1][1]);
            locals.add((Object)lv);
            ++n2;
        }
        op.setBody(body);
        return op;
    }

    public static Field createField(String name, boolean isStatic, String[] context, String[] type, CodeBlock initialiser) {
        Field f = EmftvmFactory.eINSTANCE.createField();
        f.setName(name);
        f.setContextModel(context[0]);
        f.setContext(context[1]);
        f.setTypeModel(type[0]);
        f.setType(type[1]);
        f.setInitialiser(initialiser);
        f.setStatic(isStatic);
        return f;
    }

    public static LazyList<Object> getTrans(Object object, Field field, StackFrame frame, LazyList<Object> result) {
        LazyList<Object> newResult = result;
        Object value = field.getValue(object, frame);
        if (value instanceof List) {
            List cvalue = (List)value;
            newResult = newResult.union(new LazyListOnList(cvalue));
            for (Object v : cvalue) {
                newResult = EMFTVMUtil.getTrans(v, field, frame, newResult);
            }
        } else if (value instanceof Collection) {
            Collection cvalue = (Collection)value;
            newResult = newResult.union(new LazyListOnCollection(cvalue));
            for (Object v : cvalue) {
                newResult = EMFTVMUtil.getTrans(v, field, frame, newResult);
            }
        } else if (value != null) {
            newResult = newResult.append(value);
            newResult = EMFTVMUtil.getTrans(value, field, frame, newResult);
        }
        return newResult;
    }

    public static LazyList<Object> getTrans(EObject object, EStructuralFeature sf, ExecEnv env, LazyList<Object> result) {
        if (!sf.getEContainingClass().isSuperTypeOf(object.eClass())) {
            return result;
        }
        LazyList<Object> newResult = result;
        Object value = EMFTVMUtil.get(env, object, sf);
        if (value instanceof LazyList) {
            LazyList cvalue = (LazyList)value;
            newResult = newResult.union(cvalue);
            for (Object v : cvalue) {
                if (!(v instanceof EObject)) continue;
                newResult = EMFTVMUtil.getTrans((EObject)v, sf, env, newResult);
            }
        } else if (value != null) {
            assert (!(value instanceof Collection));
            if (value instanceof Enumerator) {
                newResult = newResult.append(new EnumLiteral(value.toString()));
            } else {
                newResult = newResult.append(value);
                if (value instanceof EObject) {
                    newResult = EMFTVMUtil.getTrans((EObject)value, sf, env, newResult);
                }
            }
        }
        return newResult;
    }

    public static LazyList<Object> getTrans(Object object, java.lang.reflect.Field field, LazyList<Object> result) throws IllegalArgumentException, IllegalAccessException {
        if (!field.getDeclaringClass().isAssignableFrom(object.getClass())) {
            return result;
        }
        LazyList<Object> newResult = result;
        Object value = field.get(object);
        if (value instanceof LazyList) {
            LazyList cvalue = (LazyList)value;
            newResult = newResult.union(cvalue);
            for (Object v : cvalue) {
                newResult = EMFTVMUtil.getTrans(v, field, newResult);
            }
        } else if (value instanceof List) {
            List cvalue = (List)value;
            newResult = newResult.union(new LazyListOnList(cvalue));
            for (Object v : cvalue) {
                newResult = EMFTVMUtil.getTrans(v, field, newResult);
            }
        } else if (value instanceof Collection) {
            Collection cvalue = (Collection)value;
            newResult = newResult.union(new LazyListOnCollection(cvalue));
            for (Object v : cvalue) {
                newResult = EMFTVMUtil.getTrans(v, field, newResult);
            }
        } else if (value != null) {
            newResult = newResult.append(value);
            newResult = EMFTVMUtil.getTrans(value, field, newResult);
        }
        return newResult;
    }

    static Object convertEnumLiteral(EnumLiteral literal, Class<?> type) {
        if (Enumerator.class.isAssignableFrom(type)) {
            try {
                String litName = literal.getName();
                java.lang.reflect.Field valuesField = type.getDeclaredField("VALUES");
                Object values = valuesField.get(null);
                if (values instanceof Collection) {
                    for (Object value : (Collection)values) {
                        if (!(value instanceof Enumerator) || !litName.equals(((Enumerator)value).getName()) && !litName.equals(value.toString())) continue;
                        return value;
                    }
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return literal;
    }
}

