/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.tests.unit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.m2m.atl.common.ATLExecutionException;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.m2m.atl.core.service.LauncherService;
import org.eclipse.m2m.atl.engine.compiler.AtlCompiler;
import org.eclipse.m2m.atl.engine.compiler.CompilerNotFoundException;
import org.eclipse.m2m.atl.tests.unit.TestNonRegression;
import org.eclipse.m2m.atl.tests.util.LaunchParser;
import org.eclipse.m2m.atl.tests.util.ModelUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestNonRegressionTransfo
extends TestNonRegression {
    protected static boolean recompileBeforeLaunch;
    protected static boolean applyCompilation;
    protected LaunchParser launchParser = new LaunchParser();
    private double totalTime;
    private double executionTotalTime;

    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void singleTest(File directory) {
        String buildURI = directory + File.separator + directory.getName() + ".launch";
        if (!new File(buildURI).exists()) {
            TestNonRegressionTransfo.info("Launch configuration file " + buildURI + "not found. Skipped.");
            return;
        }
        try {
            this.launchParser.parseConfiguration(this.baseDirectory, buildURI);
        }
        catch (IOException e) {
            TestNonRegressionTransfo.fail("Error accessing launch configuration " + buildURI, e);
        }
        catch (ParserConfigurationException e) {
            TestNonRegressionTransfo.fail("Error configuring launch configuration parser for:" + buildURI, e);
        }
        catch (SAXException e) {
            TestNonRegressionTransfo.fail("Error parsing launch configuration " + buildURI, e);
        }
        String outName = "";
        if (recompileBeforeLaunch) {
            URL atlUrl = this.launchParser.getAtlUrl();
            String atlFilePath = atlUrl.getFile();
            InputStream is = null;
            try {
                if (applyCompilation) {
                    outName = String.valueOf(atlFilePath.substring(0, atlFilePath.lastIndexOf(46))) + ".asm";
                } else {
                    try {
                        outName = String.valueOf(atlFilePath.substring(0, atlFilePath.lastIndexOf(46))) + ".temp.asm";
                        this.launchParser.setAsmUrl(new URL("file:" + outName));
                    }
                    catch (MalformedURLException e) {
                        TestNonRegressionTransfo.fail("URL problem: " + atlUrl, e);
                    }
                }
                is = atlUrl.openStream();
                try {
                    AtlCompiler.compile((InputStream)is, (String)outName);
                }
                catch (CompilerNotFoundException e) {
                    TestNonRegressionTransfo.fail("Compiler not found", e);
                }
                try {
                    is.close();
                }
                catch (IOException e) {
                    TestNonRegressionTransfo.fail(atlUrl + " compilation failed", e);
                }
            }
            catch (IOException e) {
                TestNonRegressionTransfo.fail("File not found: " + atlUrl, e);
            }
        }
        double executionTime = 0.0;
        double pureExecutionTime = 0.0;
        try {
            long startTime = System.currentTimeMillis();
            pureExecutionTime = this.launch();
            long endTime = System.currentTimeMillis();
            executionTime = (double)(endTime - startTime) / 1000.0;
        }
        catch (Exception e) {
            TestNonRegressionTransfo.fail(String.valueOf(directory.getName()) + ": " + e.getMessage(), e);
        }
        TestNonRegressionTransfo.info(String.valueOf(directory.getName()) + ": " + executionTime + "s (pure execution: " + pureExecutionTime + "s)");
        Map<String, String> output = this.launchParser.getOutput();
        for (String metaid : output.values()) {
            String metapath = this.launchParser.getPath().get(metaid);
            try {
                if (metapath.startsWith("uri:")) continue;
                if (metapath.startsWith("ext:")) {
                    metapath = metapath.substring(4);
                }
                ModelUtils.registerMetamodel(URI.createFileURI((String)metapath));
            }
            catch (IOException ex) {
                TestNonRegressionTransfo.fail((String)("Unable to register output metamodel " + metaid + " for comparison: " + ex));
            }
        }
        for (String outputid : output.keySet()) {
            String outputPath = this.launchParser.getPath().get(outputid);
            if (outputPath.startsWith("ext:")) {
                outputPath = outputPath.substring(4);
            }
            String expectedPath = outputPath.replaceFirst("inputs", "expected");
            try {
                DiffModel diff = ModelUtils.compareModels(new File(outputPath), new File(expectedPath), true, true);
                TestNonRegressionTransfo.assertEquals((int)0, (int)((DiffGroup)diff.getOwnedElements().get(0)).getSubchanges());
            }
            catch (IOException ex) {
                TestNonRegressionTransfo.fail((String)ex.getMessage());
            }
            catch (InterruptedException ex) {
                TestNonRegressionTransfo.fail((String)ex.getMessage());
            }
        }
        this.totalTime += executionTime;
        this.executionTotalTime += pureExecutionTime;
        if (recompileBeforeLaunch && !applyCompilation) {
            File tempAsm = new File(outName);
            tempAsm.delete();
        }
    }

    protected void tearDown() throws Exception {
        TestNonRegressionTransfo.info("total time : " + this.totalTime + "s (pure execution: " + this.executionTotalTime + "s)");
        super.tearDown();
    }

    protected double launch() throws ATLCoreException, IOException {
        String launcherName = this.getVMName();
        URL asmURL = this.launchParser.getAsmUrl();
        Map<String, String> unsortedSourceModels = this.launchParser.getInput();
        Map<String, String> unsortedTargetModels = this.launchParser.getOutput();
        Map<String, String> modelPaths = this.launchParser.getPath();
        Map<String, URL> libs = this.launchParser.getLibsFromConfig();
        List<URL> superimps = this.launchParser.getSuperimpose();
        Map<String, Object> options = this.launchParser.getOptions();
        boolean isRefiningTraceMode = false;
        Object refiningOption = options.get("IS_REFINING");
        if (refiningOption != null) {
            isRefiningTraceMode = new Boolean(refiningOption.toString());
        }
        options.put("isRefiningTraceMode", new Boolean(isRefiningTraceMode).toString());
        Map<String, String> modelHandlers = this.launchParser.getModelHandler();
        options.put("modelHandlers", modelHandlers);
        ILauncher launcher = CoreService.getLauncher((String)launcherName);
        InputStream asmInputStream = asmURL.openStream();
        InputStream[] modules = new InputStream[superimps.size() + 1];
        modules[0] = asmInputStream;
        int i = 1;
        while (i < modules.length) {
            URL url = superimps.get(i - 1);
            try {
                modules[i] = url.openStream();
            }
            catch (IOException e) {
                TestNonRegressionTransfo.fail((String)e.getLocalizedMessage());
            }
            ++i;
        }
        HashMap<String, InputStream> libraries = new HashMap<String, InputStream>();
        for (String libName : libs.keySet()) {
            libraries.put(libName, libs.get(libName).openStream());
        }
        long startTime = System.currentTimeMillis();
        Map<String, String> sourceModels = unsortedSourceModels;
        List<String> orderedInput = this.launchParser.getOrderedInput();
        if (!orderedInput.isEmpty()) {
            sourceModels = TestNonRegressionTransfo.sort(unsortedSourceModels, orderedInput);
        }
        Map<String, String> targetModels = unsortedTargetModels;
        List<String> orderedOutput = this.launchParser.getOrderedOutput();
        if (!orderedOutput.isEmpty()) {
            targetModels = TestNonRegressionTransfo.sort(unsortedTargetModels, orderedOutput);
        }
        if (isRefiningTraceMode) {
            Iterator<String> sourceIterator = sourceModels.keySet().iterator();
            Iterator<String> targetIterator = targetModels.keySet().iterator();
            HashMap<String, String> newTargetModels = new HashMap<String, String>();
            newTargetModels.putAll(targetModels);
            ArrayList<String> targetToRemove = new ArrayList<String>();
            block8: while (sourceIterator.hasNext()) {
                String sourceModelName = sourceIterator.next();
                String sourceMetamodelName = sourceModels.get(sourceModelName);
                while (targetIterator.hasNext()) {
                    String targetModelName = targetIterator.next();
                    String targetMetamodelName = targetModels.get(targetModelName);
                    if (!targetMetamodelName.equals(sourceMetamodelName) || targetToRemove.contains(targetModelName)) continue;
                    String targetModelPath = modelPaths.get(targetModelName);
                    String refinedModelPathName = LauncherService.getRefinedModelName((String)sourceModelName);
                    modelPaths.put(refinedModelPathName, targetModelPath);
                    targetToRemove.add(targetModelName);
                    continue block8;
                }
            }
            for (String key : targetToRemove) {
                newTargetModels.remove(key);
            }
            try {
                LauncherService.launch((String)"run", (IProgressMonitor)new NullProgressMonitor(), (ILauncher)launcher, Collections.emptyMap(), sourceModels, newTargetModels, TestNonRegressionTransfo.convertPaths(modelPaths), options, libraries, (InputStream[])modules);
            }
            catch (ATLExecutionException e) {
                TestNonRegressionTransfo.fail(asmURL.toString(), e);
            }
        } else {
            try {
                LauncherService.launch((String)"run", (IProgressMonitor)new NullProgressMonitor(), (ILauncher)launcher, sourceModels, Collections.emptyMap(), targetModels, TestNonRegressionTransfo.convertPaths(modelPaths), options, libraries, (InputStream[])modules);
            }
            catch (ATLExecutionException e) {
                TestNonRegressionTransfo.fail(asmURL.toString(), e);
            }
        }
        long endTime = System.currentTimeMillis();
        return (double)(endTime - startTime) / 1000.0;
    }

    private static Map<String, String> sort(Map<String, String> mapToSort, List<String> orderedKeys) {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        for (String key : orderedKeys) {
            res.put(key, mapToSort.get(key));
        }
        return res;
    }

    protected abstract String getVMName();

    public static Map<String, String> convertPaths(Map<String, String> modelPaths) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String modelName : modelPaths.keySet()) {
            String modelPath = modelPaths.get(modelName);
            result.put(modelName, TestNonRegressionTransfo.convertPath(modelPath));
        }
        return result;
    }

    public static String convertPath(String path) {
        if (path.startsWith("ext:")) {
            return path.replaceFirst("ext:", "file:/");
        }
        if (path.startsWith("uri:")) {
            return path.substring(4);
        }
        if (path.startsWith("#") || path.startsWith("platform:") || path.startsWith("pathmap")) {
            return path;
        }
        return "platform:/resource" + path;
    }
}

