/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.trace.tests;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.m2m.atl.emftvm.trace.TraceFactory;
import org.eclipse.m2m.atl.emftvm.trace.TraceLinkSet;
import org.eclipse.m2m.atl.emftvm.trace.TracePackage;

public class TraceExample {
    public static void main(String[] args) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/m2m/atl/emftvm/2011/Trace", (Object)TracePackage.eINSTANCE);
        if (args.length == 0) {
            System.out.println("Enter a list of file paths or URIs that have content like this:");
            try {
                Resource resource = resourceSet.createResource(URI.createURI((String)"http:///My.trace"));
                TraceLinkSet root = TraceFactory.eINSTANCE.createTraceLinkSet();
                resource.getContents().add((Object)root);
                resource.save((OutputStream)System.out, null);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        } else {
            int i = 0;
            while (i < args.length) {
                File file = new File(args[i]);
                URI uri = file.isFile() ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createURI((String)args[i]);
                try {
                    Resource resource = resourceSet.getResource(uri, true);
                    System.out.println("Loaded " + uri);
                    for (EObject eObject : resource.getContents()) {
                        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
                        if (diagnostic.getSeverity() == 0) continue;
                        TraceExample.printDiagnostic(diagnostic, "");
                    }
                }
                catch (RuntimeException exception) {
                    System.out.println("Problem loading " + uri);
                    exception.printStackTrace();
                }
                ++i;
            }
        }
    }

    protected static void printDiagnostic(Diagnostic diagnostic, String indent) {
        System.out.print(indent);
        System.out.println(diagnostic.getMessage());
        for (Diagnostic child : diagnostic.getChildren()) {
            TraceExample.printDiagnostic(child, String.valueOf(indent) + "  ");
        }
    }
}

