/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.inferrer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mita.base.expressions.Argument;
import org.eclipse.mita.base.expressions.AssignmentExpression;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.expressions.PrimitiveValueExpression;
import org.eclipse.mita.base.types.AnonymousProductType;
import org.eclipse.mita.base.types.ComplexType;
import org.eclipse.mita.base.types.Declaration;
import org.eclipse.mita.base.types.ExceptionTypeDeclaration;
import org.eclipse.mita.base.types.GeneratedType;
import org.eclipse.mita.base.types.NamedProductType;
import org.eclipse.mita.base.types.Parameter;
import org.eclipse.mita.base.types.PrimitiveType;
import org.eclipse.mita.base.types.StructureType;
import org.eclipse.mita.base.types.SumAlternative;
import org.eclipse.mita.base.types.SumType;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.SystemResourceAlias;
import org.eclipse.mita.program.ArrayAccessExpression;
import org.eclipse.mita.program.FunctionDefinition;
import org.eclipse.mita.program.NewInstanceExpression;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ReturnStatement;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.ValueRange;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.inferrer.ElementSizeInferenceResult;
import org.eclipse.mita.program.inferrer.InvalidElementSizeInferenceResult;
import org.eclipse.mita.program.inferrer.ProgramDslTypeInferrer;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.inferrer.ValidElementSizeInferenceResult;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.mita.program.resource.PluginResourceLoader;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ElementSizeInferrer {
    @Inject
    protected ProgramDslTypeInferrer typeInferrer;
    @Inject
    protected PluginResourceLoader loader;

    public ElementSizeInferenceResult infer(EObject obj) {
        return this.doInfer(obj);
    }

    public static ElementSizeInferrer orElse(ElementSizeInferrer i1, ElementSizeInferrer i2) {
        if (i1 != null && i2 != null) {
            return new Combination(i1, i2);
        }
        ElementSizeInferrer _elvis = null;
        _elvis = i1 != null ? i1 : i2;
        return _elvis;
    }

    protected ElementSizeInferenceResult _doInfer(final FunctionDefinition obj) {
        Functions.Function0<ElementSizeInferenceResult> _function = new Functions.Function0<ElementSizeInferenceResult>(){

            public ElementSizeInferenceResult apply() {
                Functions.Function1<ReturnStatement, ElementSizeInferenceResult> _function = new Functions.Function1<ReturnStatement, ElementSizeInferenceResult>(){

                    public ElementSizeInferenceResult apply(ReturnStatement x) {
                        return ElementSizeInferrer.this.infer(x);
                    }
                };
                List allReturnSizes = IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)obj.eAllContents(), ReturnStatement.class), (Functions.Function1)_function));
                ElementSizeInferenceResult _xifexpression = null;
                boolean _isEmpty = allReturnSizes.isEmpty();
                if (_isEmpty) {
                    _xifexpression = ElementSizeInferrer.this.inferFromType((EObject)obj);
                } else {
                    boolean _equals;
                    ElementSizeInferenceResult _xifexpression_1 = null;
                    int _size = allReturnSizes.size();
                    boolean bl = _equals = _size == 1;
                    if (_equals) {
                        _xifexpression_1 = (ElementSizeInferenceResult)IterableExtensions.head((Iterable)allReturnSizes);
                    } else {
                        boolean _not;
                        ElementSizeInferenceResult _xblockexpression = null;
                        Iterable invalidResults = Iterables.filter((Iterable)allReturnSizes, InvalidElementSizeInferenceResult.class);
                        ElementSizeInferenceResult _xifexpression_2 = null;
                        boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)invalidResults);
                        boolean bl2 = _not = !_isEmpty_1;
                        if (_not) {
                            _xifexpression_2 = (ElementSizeInferenceResult)IterableExtensions.head((Iterable)invalidResults);
                        } else {
                            Functions.Function1<ValidElementSizeInferenceResult, Integer> _function_1 = new Functions.Function1<ValidElementSizeInferenceResult, Integer>(){

                                public Integer apply(ValidElementSizeInferenceResult x) {
                                    return x.getElementCount();
                                }
                            };
                            _xifexpression_2 = ElementSizeInferrer.this.newValidResult((EObject)obj, (Integer)IterableExtensions.max((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)allReturnSizes, ValidElementSizeInferenceResult.class), (Functions.Function1)_function_1)));
                        }
                        _xifexpression_1 = _xblockexpression = _xifexpression_2;
                    }
                    _xifexpression = _xifexpression_1;
                }
                ElementSizeInferenceResult result = _xifexpression;
                return result;
            }
        };
        Functions.Function0<ElementSizeInferenceResult> _function_1 = new Functions.Function0<ElementSizeInferenceResult>(){

            public ElementSizeInferenceResult apply() {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Function \"");
                String _name = obj.getName();
                _builder.append(_name);
                _builder.append("\" is recursive. Cannot infer size.");
                return ElementSizeInferrer.this.newInvalidResult((EObject)obj, _builder.toString());
            }
        };
        return ModelUtils.preventRecursion((EObject)obj, _function, _function_1);
    }

    protected ElementSizeInferenceResult _doInfer(ArrayAccessExpression obj) {
        Expression accessor = obj.getArraySelector();
        if (accessor instanceof ValueRange) {
            ElementSizeInferenceResult maxResult = this.infer((EObject)obj.getOwner());
            if (maxResult instanceof ValidElementSizeInferenceResult) {
                Expression _upperBound;
                boolean _tripleNotEquals_1;
                boolean _tripleNotEquals;
                int elementCount = ((ValidElementSizeInferenceResult)maxResult).getElementCount();
                Expression _lowerBound = ((ValueRange)accessor).getLowerBound();
                boolean bl = _tripleNotEquals = _lowerBound != null;
                if (_tripleNotEquals) {
                    Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                        public void apply(EObject x) {
                        }
                    };
                    Object lowerBound = StaticValueInferrer.infer((EObject)((ValueRange)accessor).getLowerBound(), (Procedures.Procedure1<? super EObject>)_function);
                    int _elementCount = elementCount;
                    Integer _elvis = null;
                    _elvis = (Integer)lowerBound != null ? (Integer)lowerBound : Integer.valueOf(0);
                    elementCount = _elementCount - _elvis;
                }
                boolean bl2 = _tripleNotEquals_1 = (_upperBound = ((ValueRange)accessor).getUpperBound()) != null;
                if (_tripleNotEquals_1) {
                    Procedures.Procedure1<EObject> _function_1 = new Procedures.Procedure1<EObject>(){

                        public void apply(EObject x) {
                        }
                    };
                    Object upperBound = StaticValueInferrer.infer((EObject)((ValueRange)accessor).getUpperBound(), (Procedures.Procedure1<? super EObject>)_function_1);
                    int _elementCount_1 = elementCount;
                    int _elementCount_2 = ((ValidElementSizeInferenceResult)maxResult).getElementCount();
                    Integer _elvis_1 = null;
                    _elvis_1 = (Integer)upperBound != null ? (Integer)upperBound : Integer.valueOf(0);
                    int _minus = _elementCount_2 - _elvis_1;
                    elementCount = _elementCount_1 - _minus;
                }
                EObject _root = ((ValidElementSizeInferenceResult)maxResult).getRoot();
                TypeSpecifier _typeOf = ((ValidElementSizeInferenceResult)maxResult).getTypeOf();
                ValidElementSizeInferenceResult result = new ValidElementSizeInferenceResult(_root, _typeOf, elementCount);
                List<ElementSizeInferenceResult> _children = result.getChildren();
                List<ElementSizeInferenceResult> _children_1 = ((ValidElementSizeInferenceResult)maxResult).getChildren();
                Iterables.addAll(_children, _children_1);
                return result;
            }
            return maxResult;
        }
        return this.inferFromType((EObject)obj);
    }

    protected ElementSizeInferenceResult _doInfer(ElementReferenceExpression obj) {
        ElementSizeInferenceResult inferredSize = this.inferFromType((EObject)obj);
        if (inferredSize instanceof ValidElementSizeInferenceResult) {
            return inferredSize;
        }
        return this.infer(obj.getReference());
    }

    protected ElementSizeInferenceResult _doInfer(ReturnStatement obj) {
        boolean _tripleEquals;
        Expression _value = obj.getValue();
        boolean bl = _tripleEquals = _value == null;
        if (_tripleEquals) {
            return this.newInvalidResult(obj, "Return statements without values do not have a size");
        }
        return this.infer((EObject)obj.getValue());
    }

    protected ElementSizeInferenceResult _doInfer(NewInstanceExpression obj) {
        return this.inferFromType((EObject)obj);
    }

    protected ElementSizeInferenceResult _doInfer(final VariableDeclaration variable) {
        ElementSizeInferenceResult _xblockexpression = null;
        TypeSpecifier typeSpec = ModelUtils.toSpecifier(this.typeInferrer.infer(variable));
        Program variableRoot = (Program)EcoreUtil2.getContainerOfType((EObject)variable, Program.class);
        Functions.Function1<EStructuralFeature.Setting, EObject> _function = new Functions.Function1<EStructuralFeature.Setting, EObject>(){

            public EObject apply(EStructuralFeature.Setting e) {
                return e.getEObject();
            }
        };
        Iterable referencesToVariable = IterableExtensions.map((Iterable)EcoreUtil.UsageCrossReferencer.find((EObject)variable, (EObject)variableRoot), (Functions.Function1)_function);
        Expression _elvis = null;
        Expression _initialization = variable.getInitialization();
        if (_initialization != null) {
            _elvis = _initialization;
        } else {
            Expression _head;
            Functions.Function1<EObject, EObject> _function_1 = new Functions.Function1<EObject, EObject>(){

                public EObject apply(EObject it) {
                    return it.eContainer();
                }
            };
            Functions.Function1<AssignmentExpression, Boolean> _function_2 = new Functions.Function1<AssignmentExpression, Boolean>(){

                public Boolean apply(AssignmentExpression ae) {
                    boolean _xblockexpression = false;
                    Expression left = ae.getVarRef();
                    _xblockexpression = left instanceof ElementReferenceExpression && ((ElementReferenceExpression)left).getReference() == variable;
                    return _xblockexpression;
                }
            };
            Functions.Function1<AssignmentExpression, Expression> _function_3 = new Functions.Function1<AssignmentExpression, Expression>(){

                public Expression apply(AssignmentExpression it) {
                    return it.getExpression();
                }
            };
            _elvis = _head = (Expression)IterableExtensions.head((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)referencesToVariable, (Functions.Function1)_function_1), AssignmentExpression.class), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
        }
        Expression initialization = _elvis;
        ElementSizeInferenceResult _xifexpression = null;
        if (initialization != null) {
            return this.infer((EObject)initialization);
        }
        _xifexpression = this.inferFromType(variable, typeSpec);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ElementSizeInferenceResult _doInfer(PrimitiveValueExpression obj) {
        return this.infer((EObject)obj.getValue());
    }

    protected ElementSizeInferenceResult _doInfer(EObject obj) {
        return this.inferFromType(obj);
    }

    protected ElementSizeInferenceResult _doInfer(Void obj) {
        return this.newInvalidResult(null, "Unable to infer size from nothing");
    }

    protected ElementSizeInferenceResult inferFromType(Void type) {
        return this.newInvalidResult(null, "Unable to infer size from unknown type");
    }

    protected ElementSizeInferenceResult inferFromType(EObject obj) {
        ITypeSystemInferrer.InferenceResult typeInf = this.typeInferrer.infer(obj);
        VariableDeclaration _elvis = null;
        VariableDeclaration _containerOfType = (VariableDeclaration)EcoreUtil2.getContainerOfType((EObject)obj, VariableDeclaration.class);
        if (_containerOfType != null) {
            _elvis = _containerOfType;
        } else {
            VariableDeclaration _underlyingVariableDeclaration;
            AssignmentExpression _containerOfType_1 = (AssignmentExpression)EcoreUtil2.getContainerOfType((EObject)obj, AssignmentExpression.class);
            Expression _varRef = null;
            if (_containerOfType_1 != null) {
                _varRef = _containerOfType_1.getVarRef();
            }
            _elvis = _underlyingVariableDeclaration = ModelUtils.getUnderlyingVariableDeclaration(_varRef);
        }
        VariableDeclaration parentVarDecl = _elvis;
        if (parentVarDecl != null) {
            typeInf = this.typeInferrer.replace(typeInf, parentVarDecl);
        }
        return this.inferFromType(obj, ModelUtils.toSpecifier(typeInf));
    }

    protected ElementSizeInferenceResult inferFromType(EObject obj, TypeSpecifier typeSpec) {
        Type _type = null;
        if (typeSpec != null) {
            _type = typeSpec.getType();
        }
        Type type = _type;
        return this.inferFromType(obj, typeSpec, type);
    }

    protected ElementSizeInferenceResult inferFromType(final EObject obj, final TypeSpecifier typeSpec, final Type type) {
        if (type instanceof PrimitiveType || type instanceof ExceptionTypeDeclaration) {
            return new ValidElementSizeInferenceResult(obj, typeSpec, 1);
        }
        if (type instanceof GeneratedType) {
            ElementSizeInferrer finalInferrer;
            Object loadedTypeInferrer;
            Expression resourceRef;
            ElementSizeInferrer inferrer = null;
            Expression _xifexpression = null;
            if (obj instanceof ElementReferenceExpression) {
                Expression _xifexpression_1 = null;
                if (((ElementReferenceExpression)obj).isOperationCall() && ((ElementReferenceExpression)obj).getArguments().size() > 0) {
                    _xifexpression_1 = ((Argument)IterableExtensions.head((Iterable)((ElementReferenceExpression)obj).getArguments())).getValue();
                }
                _xifexpression = _xifexpression_1;
            } else {
                Expression _xifexpression_2 = null;
                if (obj instanceof FeatureCall) {
                    _xifexpression_2 = ((FeatureCall)obj).getOwner();
                }
                _xifexpression = _xifexpression_2;
            }
            Expression instance = _xifexpression;
            if (instance != null && instance instanceof FeatureCall && (resourceRef = ((FeatureCall)instance).getOwner()) instanceof ElementReferenceExpression) {
                EObject resourceSetup = ((ElementReferenceExpression)resourceRef).getReference();
                Object loadedInferrer = null;
                if (resourceSetup instanceof SystemResourceAlias) {
                    resourceSetup = ((SystemResourceAlias)resourceSetup).getDelegate();
                }
                if (resourceSetup instanceof SystemResourceSetup) {
                    AbstractSystemResource resource = ((SystemResourceSetup)resourceSetup).getType();
                    loadedInferrer = this.loader.loadFromPlugin(resource.eResource(), resource.getSizeInferrer());
                } else if (resourceSetup instanceof AbstractSystemResource) {
                    loadedInferrer = this.loader.loadFromPlugin(((AbstractSystemResource)resourceSetup).eResource(), ((AbstractSystemResource)resourceSetup).getSizeInferrer());
                }
                if (loadedInferrer instanceof ElementSizeInferrer) {
                    inferrer = (ElementSizeInferrer)loadedInferrer;
                } else if (loadedInferrer != null) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("[WARNING] Expected an instance of ElementSizeInferrer, got: ");
                    String _simpleName = loadedInferrer.getClass().getSimpleName();
                    _builder.append(_simpleName);
                    InputOutput.println((Object)_builder.toString());
                }
            }
            if ((loadedTypeInferrer = this.loader.loadFromPlugin(((GeneratedType)type).eResource(), ((GeneratedType)type).getSizeInferrer())) instanceof ElementSizeInferrer) {
                inferrer = ElementSizeInferrer.orElse(inferrer, (ElementSizeInferrer)loadedTypeInferrer);
            }
            if ((finalInferrer = inferrer) == null) {
                return new InvalidElementSizeInferenceResult(obj, typeSpec, "Type has no size inferrer");
            }
            Functions.Function0<ElementSizeInferenceResult> _function = new Functions.Function0<ElementSizeInferenceResult>(){

                public ElementSizeInferenceResult apply() {
                    return finalInferrer.infer(obj);
                }
            };
            Functions.Function0<ElementSizeInferenceResult> _function_1 = new Functions.Function0<ElementSizeInferenceResult>(){

                public ElementSizeInferenceResult apply() {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Cannot infer size of \"");
                    String _simpleName = obj.getClass().getSimpleName();
                    _builder.append(_simpleName);
                    _builder.append("\" of type \"");
                    _builder.append((Object)((GeneratedType)type));
                    _builder.append("\".");
                    return ElementSizeInferrer.this.newInvalidResult(obj, _builder.toString());
                }
            };
            return ModelUtils.preventRecursion(obj, _function, _function_1);
        }
        if (type instanceof StructureType) {
            Functions.Function0<ValidElementSizeInferenceResult> _function_2 = new Functions.Function0<ValidElementSizeInferenceResult>(){

                public ValidElementSizeInferenceResult apply() {
                    ValidElementSizeInferenceResult result = new ValidElementSizeInferenceResult(obj, typeSpec, 1);
                    Functions.Function1<Parameter, ElementSizeInferenceResult> _function = new Functions.Function1<Parameter, ElementSizeInferenceResult>(){

                        public ElementSizeInferenceResult apply(Parameter x) {
                            return ElementSizeInferrer.this.infer((EObject)x);
                        }
                    };
                    result.getChildren().addAll(ListExtensions.map((List)((StructureType)type).getParameters(), (Functions.Function1)_function));
                    return result;
                }
            };
            Functions.Function0<ElementSizeInferenceResult> _function_3 = new Functions.Function0<ElementSizeInferenceResult>(){

                public ElementSizeInferenceResult apply() {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Type \"");
                    String _name = ((StructureType)type).getName();
                    _builder.append(_name);
                    _builder.append("\" is recursive. Cannot infer size.");
                    return ElementSizeInferrer.this.newInvalidResult(obj, _builder.toString());
                }
            };
            return ModelUtils.preventRecursion((EObject)type, _function_2, _function_3);
        }
        if (type instanceof SumType) {
            Functions.Function0<ElementSizeInferenceResult> _function_4 = new Functions.Function0<ElementSizeInferenceResult>(){

                public ElementSizeInferenceResult apply() {
                    Functions.Function1<SumAlternative, ElementSizeInferenceResult> _function = new Functions.Function1<SumAlternative, ElementSizeInferenceResult>(){

                        public ElementSizeInferenceResult apply(SumAlternative it) {
                            return ElementSizeInferrer.this.infer((EObject)it);
                        }
                    };
                    List childs = ListExtensions.map((List)((SumType)type).getAlternatives(), (Functions.Function1)_function);
                    ElementSizeInferenceResult _xifexpression = null;
                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)childs, InvalidElementSizeInferenceResult.class));
                    if (_isEmpty) {
                        _xifexpression = new ValidElementSizeInferenceResult(obj, typeSpec, 1);
                    } else {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Cannot infer size of \"\"");
                        String _simpleName = obj.getClass().getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append("\" of type\"");
                        _builder.append((Object)((SumType)type));
                        _builder.append("\".");
                        _xifexpression = new InvalidElementSizeInferenceResult(obj, typeSpec, _builder.toString());
                    }
                    ValidElementSizeInferenceResult result = _xifexpression;
                    Functions.Function1<ValidElementSizeInferenceResult, Integer> _function_1 = new Functions.Function1<ValidElementSizeInferenceResult, Integer>(){

                        public Integer apply(ValidElementSizeInferenceResult it) {
                            return it.getByteCount();
                        }
                    };
                    ValidElementSizeInferenceResult maxChild = (ValidElementSizeInferenceResult)IterableExtensions.maxBy((Iterable)Iterables.filter((Iterable)childs, ValidElementSizeInferenceResult.class), (Functions.Function1)_function_1);
                    Iterable invalidChilds = Iterables.filter((Iterable)childs, InvalidElementSizeInferenceResult.class);
                    result.getChildren().add(maxChild);
                    List<ElementSizeInferenceResult> _children = result.getChildren();
                    Iterables.addAll(_children, (Iterable)invalidChilds);
                    return result;
                }
            };
            Functions.Function0<ElementSizeInferenceResult> _function_5 = new Functions.Function0<ElementSizeInferenceResult>(){

                public ElementSizeInferenceResult apply() {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Type \"");
                    String _name = ((SumType)type).getName();
                    _builder.append(_name);
                    _builder.append("\" is recursive. Cannot infer size.");
                    return ElementSizeInferrer.this.newInvalidResult(obj, _builder.toString());
                }
            };
            return ModelUtils.preventRecursion((EObject)type, _function_4, _function_5);
        }
        if (type instanceof NamedProductType) {
            Functions.Function0<ValidElementSizeInferenceResult> _function_6 = new Functions.Function0<ValidElementSizeInferenceResult>(){

                public ValidElementSizeInferenceResult apply() {
                    Functions.Function1<Parameter, ElementSizeInferenceResult> _function = new Functions.Function1<Parameter, ElementSizeInferenceResult>(){

                        public ElementSizeInferenceResult apply(Parameter x) {
                            return ElementSizeInferrer.this.infer((EObject)x);
                        }
                    };
                    List childs = ListExtensions.map((List)((NamedProductType)type).getParameters(), (Functions.Function1)_function);
                    ValidElementSizeInferenceResult result = new ValidElementSizeInferenceResult(obj, typeSpec, 1);
                    result.getChildren().addAll(childs);
                    return result;
                }
            };
            Functions.Function0<ElementSizeInferenceResult> _function_7 = new Functions.Function0<ElementSizeInferenceResult>(){

                public ElementSizeInferenceResult apply() {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Type \"");
                    String _name = ((NamedProductType)type).getName();
                    _builder.append(_name);
                    _builder.append("\" is recursive. Cannot infer size.");
                    return ElementSizeInferrer.this.newInvalidResult(obj, _builder.toString());
                }
            };
            return ModelUtils.preventRecursion((EObject)type, _function_6, _function_7);
        }
        if (type instanceof AnonymousProductType) {
            Functions.Function0<ValidElementSizeInferenceResult> _function_8 = new Functions.Function0<ValidElementSizeInferenceResult>(){

                public ValidElementSizeInferenceResult apply() {
                    Functions.Function1<TypeSpecifier, ElementSizeInferenceResult> _function = new Functions.Function1<TypeSpecifier, ElementSizeInferenceResult>(){

                        public ElementSizeInferenceResult apply(TypeSpecifier x) {
                            return ElementSizeInferrer.this.inferFromType(obj, x);
                        }
                    };
                    List childs = ListExtensions.map((List)((AnonymousProductType)type).getTypeSpecifiers(), (Functions.Function1)_function);
                    ValidElementSizeInferenceResult result = new ValidElementSizeInferenceResult(obj, typeSpec, 1);
                    result.getChildren().addAll(childs);
                    return result;
                }
            };
            Functions.Function0<ElementSizeInferenceResult> _function_9 = new Functions.Function0<ElementSizeInferenceResult>(){

                public ElementSizeInferenceResult apply() {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Type \"");
                    String _name = ((AnonymousProductType)type).getName();
                    _builder.append(_name);
                    _builder.append("\" is recursive. Cannot infer size.");
                    return ElementSizeInferrer.this.newInvalidResult(obj, _builder.toString());
                }
            };
            return ModelUtils.preventRecursion((EObject)type, _function_8, _function_9);
        }
        if (type instanceof ComplexType) {
            Functions.Function0<ValidElementSizeInferenceResult> _function_10 = new Functions.Function0<ValidElementSizeInferenceResult>(){

                public ValidElementSizeInferenceResult apply() {
                    ValidElementSizeInferenceResult result = new ValidElementSizeInferenceResult(obj, typeSpec, 1);
                    Functions.Function1<Declaration, ElementSizeInferenceResult> _function = new Functions.Function1<Declaration, ElementSizeInferenceResult>(){

                        public ElementSizeInferenceResult apply(Declaration x) {
                            return ElementSizeInferrer.this.infer((EObject)x);
                        }
                    };
                    result.getChildren().addAll(ListExtensions.map((List)((ComplexType)type).getFeatures(), (Functions.Function1)_function));
                    return result;
                }
            };
            Functions.Function0<ElementSizeInferenceResult> _function_11 = new Functions.Function0<ElementSizeInferenceResult>(){

                public ElementSizeInferenceResult apply() {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Type \"");
                    String _name = ((ComplexType)type).getName();
                    _builder.append(_name);
                    _builder.append("\" is recursive. Cannot infer size.");
                    return ElementSizeInferrer.this.newInvalidResult(obj, _builder.toString());
                }
            };
            return ModelUtils.preventRecursion((EObject)type, _function_10, _function_11);
        }
        if (type == null) {
            return this.newValidResult(obj, 0);
        }
        String _name = type.getName();
        String _plus = "Unable to infer size from type " + _name;
        return this.newInvalidResult(obj, _plus);
    }

    protected ValidElementSizeInferenceResult newValidResult(EObject root, int size) {
        TypeSpecifier type = ModelUtils.toSpecifier(this.typeInferrer.infer(root));
        return new ValidElementSizeInferenceResult(root, type, size);
    }

    protected InvalidElementSizeInferenceResult newInvalidResult(EObject root, String message) {
        TypeSpecifier type = ModelUtils.toSpecifier(this.typeInferrer.infer(root));
        return new InvalidElementSizeInferenceResult(root, type, message);
    }

    protected ElementSizeInferenceResult doInfer(EObject obj) {
        if (obj instanceof FunctionDefinition) {
            return this._doInfer((FunctionDefinition)obj);
        }
        if (obj instanceof VariableDeclaration) {
            return this._doInfer((VariableDeclaration)obj);
        }
        if (obj instanceof NewInstanceExpression) {
            return this._doInfer((NewInstanceExpression)obj);
        }
        if (obj instanceof ElementReferenceExpression) {
            return this._doInfer((ElementReferenceExpression)obj);
        }
        if (obj instanceof PrimitiveValueExpression) {
            return this._doInfer((PrimitiveValueExpression)obj);
        }
        if (obj instanceof ArrayAccessExpression) {
            return this._doInfer((ArrayAccessExpression)obj);
        }
        if (obj instanceof ReturnStatement) {
            return this._doInfer((ReturnStatement)obj);
        }
        if (obj != null) {
            return this._doInfer(obj);
        }
        if (obj == null) {
            return this._doInfer((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(obj).toString());
    }

    private static class Combination
    extends ElementSizeInferrer {
        private final ElementSizeInferrer i1;
        private final ElementSizeInferrer i2;

        public Combination(ElementSizeInferrer i1, ElementSizeInferrer i2) {
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public ElementSizeInferenceResult infer(final EObject obj) {
            Functions.Function0<ElementSizeInferenceResult> _function = new Functions.Function0<ElementSizeInferenceResult>(){

                public ElementSizeInferenceResult apply() {
                    return i2.infer(obj);
                }
            };
            return this.i1.infer(obj).orElse((Functions.Function0<? extends ElementSizeInferenceResult>)_function);
        }
    }
}

