/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mita.base.types.ExceptionTypeDeclaration;
import org.eclipse.mita.base.types.GeneratedType;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeParameter;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.Platform;
import org.eclipse.mita.program.CatchStatement;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.ThrowExceptionStatement;
import org.eclipse.mita.program.TimeIntervalEvent;
import org.eclipse.mita.program.TryStatement;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.generator.internal.IResourceGraph;
import org.eclipse.mita.program.generator.internal.ResourceGraphBuilder;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class CompilationContext {
    protected Iterable<Program> units;
    protected Iterable<Program> stdlib;
    protected Iterable<SystemResourceSetup> systemResourceSetups;
    protected Iterable<EventHandlerDeclaration> eventHandler;
    protected Platform platform;
    protected IResourceGraph<EObject> resourceGraph;
    @Inject
    protected Provider<ResourceGraphBuilder> resourceGraphBuilderProvider;
    @Inject
    protected ModelUtils modelUtils;
    @Accessors
    protected String mitaVersion = "0.1.0";
    private Boolean isInited = false;

    public Platform init(Iterable<Program> compilationUnits, Iterable<Program> stdLib) {
        Platform _xblockexpression = null;
        if (this.isInited.booleanValue()) {
            throw new IllegalStateException("CompilationContext.init was called twice");
        }
        this.isInited = true;
        this.units = compilationUnits;
        this.buildResourceGraph();
        this.stdlib = stdLib;
        Functions.Function1<Program, EList<SystemResourceSetup>> _function = new Functions.Function1<Program, EList<SystemResourceSetup>>(){

            public EList<SystemResourceSetup> apply(Program it) {
                return it.getSetup();
            }
        };
        this.systemResourceSetups = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map(compilationUnits, (Functions.Function1)_function)));
        Functions.Function1<Program, EList<EventHandlerDeclaration>> _function_1 = new Functions.Function1<Program, EList<EventHandlerDeclaration>>(){

            public EList<EventHandlerDeclaration> apply(Program x) {
                return x.getEventHandlers();
            }
        };
        this.eventHandler = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map(compilationUnits, (Functions.Function1)_function_1)));
        _xblockexpression = this.platform = this.modelUtils.getPlatform((Program)IterableExtensions.head(compilationUnits));
        return _xblockexpression;
    }

    private void assertInited() {
        if (!this.isInited.booleanValue()) {
            throw new IllegalStateException("CompilationContext.init was not called");
        }
    }

    protected IResourceGraph<EObject> buildResourceGraph() {
        boolean _not;
        IResourceGraph<EObject> _xblockexpression = null;
        this.assertInited();
        final ResourceGraphBuilder resourceGraphBuilder = (ResourceGraphBuilder)this.resourceGraphBuilderProvider.get();
        Consumer<Program> _function = new Consumer<Program>(){

            @Override
            public void accept(Program it) {
                resourceGraphBuilder.addNode((EObject)it);
            }
        };
        this.getAllUnits().forEach(_function);
        IResourceGraph<EObject> resourceGraph = resourceGraphBuilder.build();
        boolean _isDAG = resourceGraph.isDAG();
        boolean bl = _not = !_isDAG;
        if (_not) {
            throw new UnsupportedOperationException("Cannot initialize resources with circular dependencies");
        }
        this.resourceGraph = resourceGraph;
        _xblockexpression = this.resourceGraph;
        return _xblockexpression;
    }

    public Iterable<Program> getAllUnits() {
        this.assertInited();
        return this.units;
    }

    public Iterable<SystemResourceSetup> getAllSystemResourceSetup() {
        this.assertInited();
        return this.systemResourceSetups;
    }

    public SystemResourceSetup getSetupFor(final AbstractSystemResource resource) {
        this.assertInited();
        Functions.Function1<SystemResourceSetup, Boolean> _function = new Functions.Function1<SystemResourceSetup, Boolean>(){

            public Boolean apply(SystemResourceSetup it) {
                String _iD = EcoreUtil.getID((EObject)it.getType());
                String _iD_1 = EcoreUtil.getID((EObject)resource);
                return Objects.equal((Object)_iD, (Object)_iD_1);
            }
        };
        return (SystemResourceSetup)IterableExtensions.findFirst(this.getAllSystemResourceSetup(), (Functions.Function1)_function);
    }

    public Iterable<EventHandlerDeclaration> getAllEventHandlers() {
        this.assertInited();
        return this.eventHandler;
    }

    public boolean hasTimeEvents() {
        this.assertInited();
        Functions.Function1<Program, Boolean> _function = new Functions.Function1<Program, Boolean>(){

            public Boolean apply(Program unit) {
                Functions.Function1<EventHandlerDeclaration, Boolean> _function = new Functions.Function1<EventHandlerDeclaration, Boolean>(){

                    public Boolean apply(EventHandlerDeclaration e) {
                        EventSource _event = e.getEvent();
                        return _event instanceof TimeIntervalEvent;
                    }
                };
                return IterableExtensions.exists(unit.getEventHandlers(), (Functions.Function1)_function);
            }
        };
        return IterableExtensions.exists(this.units, (Functions.Function1)_function);
    }

    public boolean hasGlobalVariables() {
        this.assertInited();
        Functions.Function1<Program, Boolean> _function = new Functions.Function1<Program, Boolean>(){

            public Boolean apply(Program it) {
                boolean _isEmpty = it.getGlobalVariables().isEmpty();
                return !_isEmpty;
            }
        };
        return IterableExtensions.exists(this.units, (Functions.Function1)_function);
    }

    public Iterable<ExceptionTypeDeclaration> getAllExceptionsUsed() {
        this.assertInited();
        Functions.Function1<Program, Iterable<ExceptionTypeDeclaration>> _function = new Functions.Function1<Program, Iterable<ExceptionTypeDeclaration>>(){

            public Iterable<ExceptionTypeDeclaration> apply(Program program) {
                Iterable _iterable = IteratorExtensions.toIterable((Iterator)Iterators.filter((Iterator)program.eAllContents(), ExceptionTypeDeclaration.class));
                Functions.Function1<ThrowExceptionStatement, ExceptionTypeDeclaration> _function = new Functions.Function1<ThrowExceptionStatement, ExceptionTypeDeclaration>(){

                    public ExceptionTypeDeclaration apply(ThrowExceptionStatement it) {
                        return it.getExceptionType();
                    }
                };
                Iterable _iterable_1 = IteratorExtensions.toIterable((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)program.eAllContents(), ThrowExceptionStatement.class), (Functions.Function1)_function));
                Iterable _plus = Iterables.concat((Iterable)_iterable, (Iterable)_iterable_1);
                Functions.Function1<TryStatement, Iterator<ExceptionTypeDeclaration>> _function_1 = new Functions.Function1<TryStatement, Iterator<ExceptionTypeDeclaration>>(){

                    public Iterator<ExceptionTypeDeclaration> apply(TryStatement x) {
                        Functions.Function1<CatchStatement, ExceptionTypeDeclaration> _function = new Functions.Function1<CatchStatement, ExceptionTypeDeclaration>(){

                            public ExceptionTypeDeclaration apply(CatchStatement it) {
                                return it.getExceptionType();
                            }
                        };
                        return ListExtensions.map(x.getCatchStatements(), (Functions.Function1)_function).iterator();
                    }
                };
                Iterable _iterable_2 = IteratorExtensions.toIterable((Iterator)IteratorExtensions.flatMap((Iterator)Iterators.filter((Iterator)program.eAllContents(), TryStatement.class), (Functions.Function1)_function_1));
                return Iterables.concat((Iterable)_plus, (Iterable)_iterable_2);
            }
        };
        Iterable unitAndStdlibExceptions = IterableExtensions.flatMap((Iterable)Iterables.concat(this.units, this.stdlib), (Functions.Function1)_function);
        Iterable platformExceptions = IteratorExtensions.toIterable((Iterator)Iterators.filter((Iterator)this.platform.eResource().getAllContents(), ExceptionTypeDeclaration.class));
        Functions.Function1<ExceptionTypeDeclaration, String> _function_1 = new Functions.Function1<ExceptionTypeDeclaration, String>(){

            public String apply(ExceptionTypeDeclaration it) {
                return it.getName();
            }
        };
        Functions.Function1<Map.Entry<String, List<ExceptionTypeDeclaration>>, ExceptionTypeDeclaration> _function_2 = new Functions.Function1<Map.Entry<String, List<ExceptionTypeDeclaration>>, ExceptionTypeDeclaration>(){

            public ExceptionTypeDeclaration apply(Map.Entry<String, List<ExceptionTypeDeclaration>> it) {
                return (ExceptionTypeDeclaration)IterableExtensions.head((Iterable)it.getValue());
            }
        };
        return IterableExtensions.map(IterableExtensions.groupBy((Iterable)Iterables.concat((Iterable)unitAndStdlibExceptions, (Iterable)platformExceptions), (Functions.Function1)_function_1).entrySet(), (Functions.Function1)_function_2);
    }

    public Iterable<TypeSpecifier> getAllGeneratedTypesUsed(final ITypeSystemInferrer typeInferrer) {
        this.assertInited();
        Functions.Function1<Program, Iterable<TypeSpecifier>> _function = new Functions.Function1<Program, Iterable<TypeSpecifier>>(){

            public Iterable<TypeSpecifier> apply(Program program) {
                UnmodifiableIterator _filter = Iterators.filter((Iterator)program.eAllContents(), TypeSpecifier.class);
                Functions.Function1<VariableDeclaration, TypeSpecifier> _function = new Functions.Function1<VariableDeclaration, TypeSpecifier>(){

                    public TypeSpecifier apply(VariableDeclaration it) {
                        return ModelUtils.toSpecifier(typeInferrer.infer((EObject)it));
                    }
                };
                Iterator _map = IteratorExtensions.map((Iterator)Iterators.filter((Iterator)program.eAllContents(), VariableDeclaration.class), (Functions.Function1)_function);
                Functions.Function1<TypeSpecifier, Boolean> _function_1 = new Functions.Function1<TypeSpecifier, Boolean>(){

                    public Boolean apply(TypeSpecifier it) {
                        return it.getType() != null && it.getType() instanceof GeneratedType && CompilationContext.this.noUnboundTypeParameters(it) != false;
                    }
                };
                return IteratorExtensions.toIterable((Iterator)IteratorExtensions.filter((Iterator)IteratorExtensions.filterNull((Iterator)Iterators.concat((Iterator)_filter, (Iterator)_map)), (Functions.Function1)_function_1));
            }
        };
        Functions.Function1<TypeSpecifier, String> _function_1 = new Functions.Function1<TypeSpecifier, String>(){

            public String apply(TypeSpecifier it) {
                return ModelUtils.typeSpecifierIdentifier(it);
            }
        };
        Functions.Function1<Map.Entry<String, List<TypeSpecifier>>, TypeSpecifier> _function_2 = new Functions.Function1<Map.Entry<String, List<TypeSpecifier>>, TypeSpecifier>(){

            public TypeSpecifier apply(Map.Entry<String, List<TypeSpecifier>> it) {
                return (TypeSpecifier)IterableExtensions.head((Iterable)it.getValue());
            }
        };
        return IterableExtensions.map(IterableExtensions.groupBy((Iterable)IterableExtensions.flatMap((Iterable)Iterables.concat(this.units, this.stdlib), (Functions.Function1)_function), (Functions.Function1)_function_1).entrySet(), (Functions.Function1)_function_2);
    }

    public IResourceGraph<EObject> getResourceGraph() {
        this.assertInited();
        return this.resourceGraph;
    }

    private Boolean noUnboundTypeParameters(TypeSpecifier specifier) {
        this.assertInited();
        Type _type = specifier.getType();
        if (_type instanceof TypeParameter) {
            return false;
        }
        Functions.Function1<TypeSpecifier, Boolean> _function = new Functions.Function1<TypeSpecifier, Boolean>(){

            public Boolean apply(TypeSpecifier it) {
                return CompilationContext.this.noUnboundTypeParameters(it);
            }
        };
        Functions.Function2<Boolean, Boolean, Boolean> _function_1 = new Functions.Function2<Boolean, Boolean, Boolean>(){

            public Boolean apply(Boolean x, Boolean y) {
                return x != false && y != false;
            }
        };
        return (Boolean)IterableExtensions.fold((Iterable)ListExtensions.map((List)specifier.getTypeArguments(), (Functions.Function1)_function), (Object)true, (Functions.Function2)_function_1);
    }

    @Pure
    public String getMitaVersion() {
        return this.mitaVersion;
    }

    public void setMitaVersion(String mitaVersion) {
        this.mitaVersion = mitaVersion;
    }
}

