/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.arduino.sensors;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.SystemEventSource;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ButtonGenerator
extends AbstractSystemResourceGenerator {
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;

    public CodeFragment generateSetup() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"return Button_Connect();");
                _builder.newLine();
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                for (EventHandlerDeclaration handler : ButtonGenerator.this.eventHandler) {
                    _builder.append((Object)"bool get");
                    String _handlerName = ButtonGenerator.this._generatorUtils.getHandlerName((EObject)handler);
                    _builder.append((Object)_handlerName);
                    _builder.append((Object)"_flag(){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return ");
                    String _handlerName_1 = ButtonGenerator.this._generatorUtils.getHandlerName((EObject)handler);
                    _builder.append((Object)_handlerName_1, "\t");
                    _builder.append((Object)"_flag;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"void set");
                    String _handlerName_2 = ButtonGenerator.this._generatorUtils.getHandlerName((EObject)handler);
                    _builder.append((Object)_handlerName_2);
                    _builder.append((Object)"_flag(bool val){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _handlerName_3 = ButtonGenerator.this._generatorUtils.getHandlerName((EObject)handler);
                    _builder.append((Object)_handlerName_3, "\t");
                    _builder.append((Object)"_flag = val;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            }
        };
        return _create.setPreamble(_client_1).addHeader("Button.h", false).addHeader("MitaEvents.h", false);
    }

    public CodeFragment generateEnable() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Exception_T exception = STATUS_OK;");
                _builder.newLine();
                _builder.newLine();
                for (EventHandlerDeclaration handler : ButtonGenerator.this.eventHandler) {
                    _builder.append((Object)"exception = Button_Enable((uint32_t) BUTTON_");
                    int _buttonNumber = ButtonGenerator.this.getButtonNumber(ButtonGenerator.this.getSensorInstance(handler));
                    _builder.append((Object)_buttonNumber);
                    _builder.append((Object)", set");
                    String _handlerName = ButtonGenerator.this._generatorUtils.getHandlerName((EObject)handler);
                    _builder.append((Object)_handlerName);
                    _builder.append((Object)"_flag, ");
                    boolean _contains = ButtonGenerator.this._generatorUtils.getBaseName((Object)handler).contains("Pressed");
                    if (_contains) {
                        _builder.append((Object)"true");
                    } else {
                        _builder.append((Object)"false");
                    }
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if(exception != STATUS_OK) return exception;");
                    _builder.newLine();
                    _builder.newLine();
                }
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    private AbstractSystemResource getSensorInstance(EventHandlerDeclaration declaration) {
        EventSource _event = declaration.getEvent();
        SystemEventSource event = (SystemEventSource)_event;
        AbstractSystemResource _origin = event.getOrigin();
        return _origin;
    }

    private String getButtonName(AbstractSystemResource origin) {
        return (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)origin.getName().split("_"))));
    }

    private int getButtonNumber(AbstractSystemResource declaration) {
        int _xifexpression = 0;
        String _buttonName = this.getButtonName(declaration);
        boolean _tripleEquals = _buttonName == "one";
        _xifexpression = _tripleEquals ? 1 : 2;
        return _xifexpression;
    }
}

