/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.library.stdlib;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.AssignmentExpression;
import org.eclipse.mita.base.expressions.AssignmentOperator;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.expressions.Literal;
import org.eclipse.mita.base.expressions.PrimitiveValueExpression;
import org.eclipse.mita.base.expressions.StringLiteral;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.library.stdlib.StringGenerator;
import org.eclipse.mita.program.AbstractLoopStatement;
import org.eclipse.mita.program.ArrayAccessExpression;
import org.eclipse.mita.program.FunctionDefinition;
import org.eclipse.mita.program.InterpolatedStringExpression;
import org.eclipse.mita.program.NewInstanceExpression;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ReturnStatement;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.inferrer.ElementSizeInferenceResult;
import org.eclipse.mita.program.inferrer.ElementSizeInferrer;
import org.eclipse.mita.program.inferrer.InvalidElementSizeInferenceResult;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.inferrer.ValidElementSizeInferenceResult;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class StringSizeInferrer
extends ElementSizeInferrer {
    protected ElementSizeInferenceResult _doInfer(final StringLiteral expression) {
        Functions.Function1<EObject, ElementSizeInferenceResult> _function = new Functions.Function1<EObject, ElementSizeInferenceResult>(){

            public ElementSizeInferenceResult apply(EObject it) {
                return StringSizeInferrer.this.isolatedDoInfer((EObject)expression);
            }
        };
        return this.inferContainerIfVariableDeclaration((EObject)expression, (Functions.Function1<? super EObject, ? extends ElementSizeInferenceResult>)_function);
    }

    protected ElementSizeInferenceResult _doInfer(final PrimitiveValueExpression expression) {
        Functions.Function1<EObject, ElementSizeInferenceResult> _function = new Functions.Function1<EObject, ElementSizeInferenceResult>(){

            public ElementSizeInferenceResult apply(EObject it) {
                return StringSizeInferrer.this.isolatedDoInfer((EObject)expression);
            }
        };
        return this.inferContainerIfVariableDeclaration((EObject)expression, (Functions.Function1<? super EObject, ? extends ElementSizeInferenceResult>)_function);
    }

    protected ElementSizeInferenceResult _doInfer(final InterpolatedStringExpression expr) {
        Functions.Function1<EObject, ElementSizeInferenceResult> _function = new Functions.Function1<EObject, ElementSizeInferenceResult>(){

            public ElementSizeInferenceResult apply(EObject it) {
                return StringSizeInferrer.this.isolatedDoInfer((EObject)expr);
            }
        };
        return this.inferContainerIfVariableDeclaration((EObject)expr, (Functions.Function1<? super EObject, ? extends ElementSizeInferenceResult>)_function);
    }

    protected ElementSizeInferenceResult _doInfer(final NewInstanceExpression expr) {
        Functions.Function1<EObject, ElementSizeInferenceResult> _function = new Functions.Function1<EObject, ElementSizeInferenceResult>(){

            public ElementSizeInferenceResult apply(EObject it) {
                return StringSizeInferrer.this.inferFixedSize(expr);
            }
        };
        return this.inferContainerIfVariableDeclaration((EObject)expr, (Functions.Function1<? super EObject, ? extends ElementSizeInferenceResult>)_function);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ElementSizeInferenceResult _doInfer(final VariableDeclaration variable) {
        Program variableRoot = (Program)EcoreUtil2.getContainerOfType((EObject)variable, Program.class);
        Functions.Function1<EStructuralFeature.Setting, EObject> _function = new Functions.Function1<EStructuralFeature.Setting, EObject>(){

            public EObject apply(EStructuralFeature.Setting e) {
                return e.getEObject();
            }
        };
        Iterable referencesToVariable = IterableExtensions.map((Iterable)EcoreUtil.UsageCrossReferencer.find((EObject)variable, (EObject)variableRoot), (Functions.Function1)_function);
        Expression _elvis = null;
        Expression _initialization = variable.getInitialization();
        if (_initialization != null) {
            _elvis = _initialization;
        } else {
            Expression _head;
            Functions.Function1<EObject, EObject> _function_1 = new Functions.Function1<EObject, EObject>(){

                public EObject apply(EObject it) {
                    return it.eContainer();
                }
            };
            Functions.Function1<AssignmentExpression, Boolean> _function_2 = new Functions.Function1<AssignmentExpression, Boolean>(){

                public Boolean apply(AssignmentExpression ae) {
                    boolean _xblockexpression = false;
                    Expression left = ae.getVarRef();
                    _xblockexpression = left instanceof ElementReferenceExpression && ((ElementReferenceExpression)left).getReference() == variable;
                    return _xblockexpression;
                }
            };
            Functions.Function1<AssignmentExpression, Expression> _function_3 = new Functions.Function1<AssignmentExpression, Expression>(){

                public Expression apply(AssignmentExpression it) {
                    return it.getExpression();
                }
            };
            _elvis = _head = (Expression)IterableExtensions.head((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)referencesToVariable, (Functions.Function1)_function_1), AssignmentExpression.class), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
        }
        Expression initialization = _elvis;
        boolean stringHasFixedSize = false;
        InvalidElementSizeInferenceResult _xifexpression = null;
        if (initialization != null) {
            ElementSizeInferenceResult _xifexpression_1 = null;
            if (initialization instanceof NewInstanceExpression) {
                ElementSizeInferenceResult _xblockexpression = null;
                stringHasFixedSize = true;
                _xifexpression_1 = _xblockexpression = this.inferFixedSize((NewInstanceExpression)initialization);
            } else {
                _xifexpression_1 = this.isolatedDoInfer((EObject)initialization);
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = this.newInvalidResult((EObject)variable, "Cannot infer size of initialization");
        }
        InvalidElementSizeInferenceResult initialLength = _xifexpression;
        if (initialLength instanceof InvalidElementSizeInferenceResult) {
            return initialLength;
        }
        int length = ((ValidElementSizeInferenceResult)initialLength).getElementCount();
        Functions.Function1<EObject, Expression> _function_4 = new Functions.Function1<EObject, Expression>(){

            public Expression apply(EObject ref) {
                FeatureCall _xblockexpression = null;
                EObject refContainer = ref.eContainer();
                FeatureCall _xifexpression = null;
                if (refContainer instanceof AssignmentExpression) {
                    AssignmentExpression _xifexpression_1 = null;
                    Expression _varRef = ((AssignmentExpression)refContainer).getVarRef();
                    boolean _equals = Objects.equal((Object)_varRef, (Object)ref);
                    _xifexpression_1 = _equals ? (AssignmentExpression)refContainer : null;
                    _xifexpression = _xifexpression_1;
                } else {
                    FeatureCall _xifexpression_2 = null;
                    _xifexpression_2 = refContainer instanceof FeatureCall ? (FeatureCall)refContainer : null;
                    _xifexpression = _xifexpression_2;
                }
                _xblockexpression = _xifexpression;
                return _xblockexpression;
            }
        };
        Iterable modifyingExpressions = IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)referencesToVariable, (Functions.Function1)_function_4));
        for (Expression expr : modifyingExpressions) {
            AbstractLoopStatement loopContainer;
            boolean allowedInLoop = stringHasFixedSize;
            if (expr instanceof AssignmentExpression) {
                AssignmentOperator _operator = ((AssignmentExpression)expr).getOperator();
                boolean _equals = Objects.equal((Object)_operator, (Object)AssignmentOperator.ADD_ASSIGN);
                if (_equals) {
                    boolean _not;
                    ElementSizeInferenceResult additionLength = this.infer((EObject)((AssignmentExpression)expr).getExpression());
                    boolean _isValid = additionLength.isValid();
                    boolean bl = _not = !_isValid;
                    if (_not) {
                        return additionLength;
                    }
                    int _length = length;
                    int _elementCount = ((ValidElementSizeInferenceResult)additionLength).getElementCount();
                    length = _length + _elementCount;
                } else {
                    boolean _not_1;
                    AssignmentOperator _operator_1 = ((AssignmentExpression)expr).getOperator();
                    boolean _equals_1 = Objects.equal((Object)_operator_1, (Object)AssignmentOperator.ASSIGN);
                    if (!_equals_1) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Cannot infer size when using the ");
                        String _name = ((AssignmentExpression)expr).getOperator().getName();
                        _builder.append(_name);
                        _builder.append(" operator");
                        return this.newInvalidResult((EObject)expr, _builder.toString());
                    }
                    ElementSizeInferenceResult additionLength_1 = this.infer((EObject)((AssignmentExpression)expr).getExpression());
                    boolean _isValid_1 = additionLength_1.isValid();
                    boolean bl = _not_1 = !_isValid_1;
                    if (_not_1) {
                        return additionLength_1;
                    }
                    allowedInLoop = true;
                    length = Math.max(length, ((ValidElementSizeInferenceResult)additionLength_1).getElementCount());
                }
            } else if (expr instanceof FeatureCall) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Cannot infer size of feature calls yet");
                return this.newInvalidResult((EObject)expr, _builder_1.toString());
            }
            if (allowedInLoop || (loopContainer = StringSizeInferrer.getSharedLoopContainer((EObject)expr, (EObject)variable)) == null) continue;
            return this.newInvalidResult((EObject)expr, "Cannot infer string length in loops");
        }
        return this.newValidResult((EObject)variable, length);
    }

    protected ElementSizeInferenceResult _isolatedDoInfer(StringLiteral expression) {
        return this.newValidResult((EObject)expression, expression.getValue().length());
    }

    protected ElementSizeInferenceResult _isolatedDoInfer(PrimitiveValueExpression expression) {
        ElementSizeInferenceResult _xblockexpression = null;
        Literal value = expression.getValue();
        Object _xifexpression = null;
        _xifexpression = value instanceof StringLiteral ? this.isolatedDoInfer((EObject)value) : this.newInvalidResult((EObject)expression, "Cannot infer string length of " + value);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ElementSizeInferenceResult _isolatedDoInfer(InterpolatedStringExpression expr) {
        int length = this.sumTextParts(expr);
        EList _content = expr.getContent();
        for (Expression subexpr : _content) {
            Integer typeLengthInBytes;
            ITypeSystemInferrer.InferenceResult _infer = this.typeInferrer.infer((EObject)subexpr);
            Type _type = null;
            if (_infer != null) {
                _type = _infer.getType();
            }
            Type type = _type;
            Integer _switchResult = null;
            String _name = null;
            if (type != null) {
                _name = type.getName();
            }
            boolean _matched = false;
            if (Objects.equal((Object)_name, (Object)"uint32")) {
                _matched = true;
                _switchResult = 10;
            }
            if (!_matched && Objects.equal((Object)_name, (Object)"uint16")) {
                _matched = true;
                _switchResult = 5;
            }
            if (!_matched && Objects.equal((Object)_name, (Object)"uint8")) {
                _matched = true;
                _switchResult = 3;
            }
            if (!_matched && Objects.equal((Object)_name, (Object)"int32")) {
                _matched = true;
                _switchResult = 11;
            }
            if (!_matched && Objects.equal((Object)_name, (Object)"int16")) {
                _matched = true;
                _switchResult = 6;
            }
            if (!_matched && Objects.equal((Object)_name, (Object)"int8")) {
                _matched = true;
                _switchResult = 4;
            }
            if (!_matched && Objects.equal((Object)_name, (Object)"bool")) {
                _matched = true;
                _switchResult = 1;
            }
            if (!_matched && Objects.equal((Object)_name, (Object)"double")) {
                _matched = true;
                _switchResult = 14;
            }
            if (!_matched && Objects.equal((Object)_name, (Object)"float")) {
                _matched = true;
                _switchResult = 14;
            }
            if (!_matched && Objects.equal((Object)_name, (Object)"string")) {
                _matched = true;
                int _xblockexpression = 0;
                ElementSizeInferenceResult stringSize = super.infer((EObject)subexpr);
                int _xifexpression = 0;
                if (!(stringSize instanceof ValidElementSizeInferenceResult)) {
                    return stringSize;
                }
                _xifexpression = ((ValidElementSizeInferenceResult)stringSize).getElementCount();
                _xblockexpression = _xifexpression;
                _switchResult = _xblockexpression;
            }
            if (!_matched) {
                _switchResult = null;
            }
            if ((typeLengthInBytes = _switchResult) == null) {
                return this.newInvalidResult((EObject)subexpr, "Cannot interpolate expressions of type " + type);
            }
            int _length = length;
            length = _length + typeLengthInBytes;
        }
        return this.newValidResult((EObject)expr, length);
    }

    protected ElementSizeInferenceResult _isolatedDoInfer(ElementReferenceExpression expr) {
        EObject _reference = null;
        if (expr != null) {
            _reference = expr.getReference();
        }
        ElementSizeInferenceResult _infer = null;
        if (_reference != null) {
            _infer = this.infer(_reference);
        }
        return _infer;
    }

    protected ElementSizeInferenceResult _isolatedDoInfer(EObject expr) {
        return this.newInvalidResult(expr, "Cannot infer string length");
    }

    protected int sumTextParts(InterpolatedStringExpression expr) {
        Integer _xblockexpression = null;
        List<String> texts = StringGenerator.getOriginalTexts(expr);
        Integer _xifexpression = null;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(texts);
        if (_isNullOrEmpty) {
            _xifexpression = 0;
        } else {
            Functions.Function1<String, Integer> _function = new Functions.Function1<String, Integer>(){

                public Integer apply(String x) {
                    return x.length();
                }
            };
            Functions.Function2<Integer, Integer, Integer> _function_1 = new Functions.Function2<Integer, Integer, Integer>(){

                public Integer apply(Integer x1, Integer x2) {
                    return x1 + x2;
                }
            };
            _xifexpression = (Integer)IterableExtensions.reduce((Iterable)ListExtensions.map(texts, (Functions.Function1)_function), (Functions.Function2)_function_1);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ElementSizeInferenceResult inferContainerIfVariableDeclaration(EObject obj, Functions.Function1<? super EObject, ? extends ElementSizeInferenceResult> alternative) {
        boolean _tripleNotEquals;
        InterpolatedStringExpression _containerOfType = (InterpolatedStringExpression)EcoreUtil2.getContainerOfType((EObject)obj, InterpolatedStringExpression.class);
        boolean bl = _tripleNotEquals = _containerOfType != null;
        if (_tripleNotEquals) {
            return (ElementSizeInferenceResult)alternative.apply((Object)obj);
        }
        VariableDeclaration container = (VariableDeclaration)EcoreUtil2.getContainerOfType((EObject)obj, VariableDeclaration.class);
        ElementSizeInferenceResult _xifexpression = null;
        if (container == null) {
            return (ElementSizeInferenceResult)alternative.apply((Object)obj);
        }
        _xifexpression = this.infer((EObject)container);
        return _xifexpression;
    }

    protected ElementSizeInferenceResult inferFixedSize(NewInstanceExpression initialization) {
        EObject _reference = initialization.getReference();
        Expression rawSizeValue = ModelUtils.getArgumentValue((Operation)((Operation)_reference), (ArgumentExpression)initialization, (String)"size");
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject x) {
            }
        };
        Object staticSizeValue = StaticValueInferrer.infer((EObject)rawSizeValue, (Procedures.Procedure1)_function);
        Object _xifexpression = null;
        _xifexpression = staticSizeValue instanceof Integer ? this.newValidResult((EObject)initialization, (Integer)staticSizeValue) : this.newInvalidResult((EObject)initialization, "No explicit maximum string size was given");
        return _xifexpression;
    }

    private static AbstractLoopStatement getSharedLoopContainer(EObject expr, EObject other) {
        AbstractLoopStatement loopContainer = (AbstractLoopStatement)EcoreUtil2.getContainerOfType((EObject)expr, AbstractLoopStatement.class);
        if (loopContainer != null) {
            final EObject variableContainer = other.eContainer();
            Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

                public Boolean apply(EObject c) {
                    return Objects.equal((Object)c, (Object)variableContainer);
                }
            };
            EObject sharedAncestor = (EObject)IterableExtensions.findFirst((Iterable)EcoreUtil2.getAllContainers((EObject)loopContainer), (Functions.Function1)_function);
            if (Objects.equal((Object)variableContainer, (Object)loopContainer) || sharedAncestor != null) {
                return loopContainer;
            }
        }
        return null;
    }

    protected ElementSizeInferenceResult doInfer(EObject variable) {
        if (variable instanceof FunctionDefinition) {
            return this._doInfer((FunctionDefinition)variable);
        }
        if (variable instanceof VariableDeclaration) {
            return this._doInfer((VariableDeclaration)variable);
        }
        if (variable instanceof NewInstanceExpression) {
            return this._doInfer((NewInstanceExpression)variable);
        }
        if (variable instanceof ElementReferenceExpression) {
            return this._doInfer((ElementReferenceExpression)variable);
        }
        if (variable instanceof PrimitiveValueExpression) {
            return this._doInfer((PrimitiveValueExpression)variable);
        }
        if (variable instanceof StringLiteral) {
            return this._doInfer((StringLiteral)variable);
        }
        if (variable instanceof ArrayAccessExpression) {
            return this._doInfer((ArrayAccessExpression)variable);
        }
        if (variable instanceof InterpolatedStringExpression) {
            return this._doInfer((InterpolatedStringExpression)variable);
        }
        if (variable instanceof ReturnStatement) {
            return this._doInfer((ReturnStatement)variable);
        }
        if (variable != null) {
            return this._doInfer(variable);
        }
        if (variable == null) {
            return this._doInfer(null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(variable).toString());
    }

    protected ElementSizeInferenceResult isolatedDoInfer(EObject expr) {
        if (expr instanceof ElementReferenceExpression) {
            return this._isolatedDoInfer((ElementReferenceExpression)expr);
        }
        if (expr instanceof PrimitiveValueExpression) {
            return this._isolatedDoInfer((PrimitiveValueExpression)expr);
        }
        if (expr instanceof StringLiteral) {
            return this._isolatedDoInfer((StringLiteral)expr);
        }
        if (expr instanceof InterpolatedStringExpression) {
            return this._isolatedDoInfer((InterpolatedStringExpression)expr);
        }
        if (expr != null) {
            return this._isolatedDoInfer(expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }
}

