/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.base.util.BaseUtils;
import org.eclipse.mita.program.ConfigurationItemValue;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.validation.IResourceValidator;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class LoraValidator
implements IResourceValidator {
    protected final Map<String, Map<String, Functions.Function1<Integer, String>>> rangeChecks = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"EU", Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"bandFrequency", (Object)new Functions.Function1<Integer, String>(){

        public String apply(Integer it) {
            boolean _not;
            String _xifexpression = null;
            boolean _contains = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{433, 868})).contains((int)it);
            boolean bl = _not = !_contains;
            if (_not) {
                _xifexpression = "one of 433, 868";
            }
            return _xifexpression;
        }
    }), Pair.of((Object)"rx2Frequency", (Object)new Functions.Function1<Integer, String>(){

        public String apply(Integer it) {
            String _xifexpression = null;
            if (!(433050 <= it && it <= 434790 || 863000 <= it && it <= 870000)) {
                _xifexpression = "either between 433050 and 434790 or between 863000 and 870000";
            }
            return _xifexpression;
        }
    }), Pair.of((Object)"rx2DataRate", (Object)new Functions.Function1<Integer, String>(){

        public String apply(Integer it) {
            String _xifexpression = null;
            if (it < 0 || it > 7) {
                _xifexpression = "between 0 and 7";
            }
            return _xifexpression;
        }
    }), Pair.of((Object)"dataRate", (Object)new Functions.Function1<Integer, String>(){

        public String apply(Integer it) {
            String _xifexpression = null;
            if (it < 0 || it > 7) {
                _xifexpression = "between 0 and 7";
            }
            return _xifexpression;
        }
    })}))), Pair.of((Object)"US", Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"bandFrequency", (Object)new Functions.Function1<Integer, String>(){

        public String apply(Integer it) {
            String _xifexpression = null;
            if (it != 915) {
                _xifexpression = "exactly 915";
            }
            return _xifexpression;
        }
    }), Pair.of((Object)"rx2Frequency", (Object)new Functions.Function1<Integer, String>(){

        public String apply(Integer it) {
            String _xifexpression = null;
            if (923300 > it || it > 927500) {
                _xifexpression = "between 923300 and 927500";
            }
            return _xifexpression;
        }
    }), Pair.of((Object)"rx2DataRate", (Object)new Functions.Function1<Integer, String>(){

        public String apply(Integer it) {
            String _xifexpression = null;
            if (8 > it || it > 13) {
                _xifexpression = "between 8 and 13";
            }
            return _xifexpression;
        }
    }), Pair.of((Object)"dataRate", (Object)new Functions.Function1<Integer, String>(){

        public String apply(Integer it) {
            String _xifexpression = null;
            if (it < 0 || it > 4) {
                _xifexpression = "between 0 and 4";
            }
            return _xifexpression;
        }
    })})))}));
    protected final Map<String, Functions.Function2<Integer, Integer, Boolean>> bandAndRx2Checks = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"EU", (Object)new Functions.Function2<Integer, Integer, Boolean>(){

        public Boolean apply(Integer fBand, Integer fRx2) {
            return fBand / 100 == fRx2 / 100000;
        }
    }), Pair.of((Object)"US", (Object)new Functions.Function2<Integer, Integer, Boolean>(){

        public Boolean apply(Integer a, Integer b) {
            return true;
        }
    })}));

    public void validate(Program program, final EObject context, final ValidationMessageAcceptor acceptor) {
        if (context instanceof SystemResourceSetup) {
            String region;
            Map<String, Functions.Function1<Integer, String>> checks;
            Functions.Function1<ConfigurationItemValue, Boolean> _function = new Functions.Function1<ConfigurationItemValue, Boolean>(){

                public Boolean apply(ConfigurationItemValue it) {
                    String _name = it.getItem().getName();
                    return Objects.equal((Object)_name, (Object)"loraAppKey");
                }
            };
            ConfigurationItemValue loraAppKey = (ConfigurationItemValue)IterableExtensions.findFirst((Iterable)((SystemResourceSetup)context).getConfigurationItemValues(), (Functions.Function1)_function);
            Functions.Function1<ConfigurationItemValue, Boolean> _function_1 = new Functions.Function1<ConfigurationItemValue, Boolean>(){

                public Boolean apply(ConfigurationItemValue it) {
                    String _name = it.getItem().getName();
                    return Objects.equal((Object)_name, (Object)"loraAppEui");
                }
            };
            ConfigurationItemValue loraAppEui = (ConfigurationItemValue)IterableExtensions.findFirst((Iterable)((SystemResourceSetup)context).getConfigurationItemValues(), (Functions.Function1)_function_1);
            Functions.Function1<ConfigurationItemValue, Boolean> _function_2 = new Functions.Function1<ConfigurationItemValue, Boolean>(){

                public Boolean apply(ConfigurationItemValue it) {
                    String _name = it.getItem().getName();
                    return Objects.equal((Object)_name, (Object)"loraDeviceEui");
                }
            };
            ConfigurationItemValue loraDeviceEui = (ConfigurationItemValue)IterableExtensions.findFirst((Iterable)((SystemResourceSetup)context).getConfigurationItemValues(), (Functions.Function1)_function_2);
            Pair _mappedTo = Pair.of((Object)loraAppKey, (Object)16);
            Pair _mappedTo_1 = Pair.of((Object)loraAppEui, (Object)8);
            Pair _mappedTo_2 = Pair.of((Object)loraDeviceEui, (Object)8);
            Functions.Function1<Pair<ConfigurationItemValue, Integer>, Boolean> _function_3 = new Functions.Function1<Pair<ConfigurationItemValue, Integer>, Boolean>(){

                public Boolean apply(Pair<ConfigurationItemValue, Integer> it) {
                    ConfigurationItemValue _key = (ConfigurationItemValue)it.getKey();
                    return _key != null;
                }
            };
            Iterable _filter = IterableExtensions.filter(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2})), (Functions.Function1)_function_3);
            for (Pair k_v : _filter) {
                Procedures.Procedure1<EObject> _function_4 = new Procedures.Procedure1<EObject>(){

                    public void apply(EObject it) {
                    }
                };
                Object obj = StaticValueInferrer.infer((EObject)((ConfigurationItemValue)k_v.getKey()).getValue(), (Procedures.Procedure1)_function_4);
                Integer length = (Integer)k_v.getValue();
                if (obj instanceof List) {
                    boolean _notEquals;
                    int _size = ((List)obj).size();
                    boolean bl = _notEquals = _size != length;
                    if (!_notEquals) continue;
                    String _name = ((ConfigurationItemValue)k_v.getKey()).getItem().getName();
                    String _plus = String.valueOf(_name) + " needs exactly ";
                    String _plus_1 = String.valueOf(_plus) + length;
                    String _plus_2 = String.valueOf(_plus_1) + " bytes";
                    acceptor.acceptError(_plus_2, (EObject)((ConfigurationItemValue)k_v.getKey()).getValue(), null, 0, "", new String[0]);
                    continue;
                }
                acceptor.acceptError("Configured value must be an array", (EObject)((ConfigurationItemValue)k_v.getKey()).getValue(), null, 0, "", new String[0]);
            }
            Functions.Function1<ConfigurationItemValue, Boolean> _function_4 = new Functions.Function1<ConfigurationItemValue, Boolean>(){

                public Boolean apply(ConfigurationItemValue it) {
                    String _name = it.getItem().getName();
                    return Objects.equal((Object)_name, (Object)"region");
                }
            };
            Procedures.Procedure1<EObject> _function_5 = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            };
            Enumerator _castOrNull = (Enumerator)BaseUtils.castOrNull((Object)StaticValueInferrer.infer((EObject)((EObject)IterableExtensions.findFirst((Iterable)((SystemResourceSetup)context).getConfigurationItemValues(), (Functions.Function1)_function_4)), (Procedures.Procedure1)_function_5), Enumerator.class);
            String _name = null;
            if (_castOrNull != null) {
                _name = _castOrNull.getName();
            }
            if ((checks = this.rangeChecks.get(region = _name)) != null) {
                Consumer<Map.Entry<String, Functions.Function1<Integer, String>>> _function_6 = new Consumer<Map.Entry<String, Functions.Function1<Integer, String>>>(){

                    @Override
                    public void accept(Map.Entry<String, Functions.Function1<Integer, String>> name_check) {
                        String msg;
                        Procedures.Procedure1<EObject> _function_1;
                        final String name = name_check.getKey();
                        Functions.Function1<Integer, String> check = name_check.getValue();
                        Functions.Function1<ConfigurationItemValue, Boolean> _function = new Functions.Function1<ConfigurationItemValue, Boolean>(){

                            public Boolean apply(ConfigurationItemValue it) {
                                String _name = it.getItem().getName();
                                return Objects.equal((Object)_name, (Object)name);
                            }
                        };
                        ConfigurationItemValue configItemValue = (ConfigurationItemValue)IterableExtensions.findFirst((Iterable)((SystemResourceSetup)context).getConfigurationItemValues(), (Functions.Function1)_function);
                        Integer value = (Integer)BaseUtils.castOrNull((Object)StaticValueInferrer.infer((EObject)configItemValue, (Procedures.Procedure1)(_function_1 = new Procedures.Procedure1<EObject>(){

                            public void apply(EObject it) {
                            }
                        })), Integer.class);
                        if (value != null && (msg = (String)check.apply((Object)value)) != null) {
                            String _plus = value + " not in range for region ";
                            String _plus_1 = String.valueOf(_plus) + region;
                            String _plus_2 = String.valueOf(_plus_1) + ". Should be ";
                            String _plus_3 = String.valueOf(_plus_2) + msg;
                            acceptor.acceptError(_plus_3, (EObject)configItemValue, null, 0, "", new String[0]);
                        }
                    }
                };
                checks.entrySet().forEach(_function_6);
            }
            Functions.Function2<Integer, Integer, Boolean> bandRx2Check = this.bandAndRx2Checks.get(region);
            Functions.Function1<ConfigurationItemValue, Boolean> _function_7 = new Functions.Function1<ConfigurationItemValue, Boolean>(){

                public Boolean apply(ConfigurationItemValue it) {
                    String _name = it.getItem().getName();
                    return Objects.equal((Object)_name, (Object)"bandFrequency");
                }
            };
            ConfigurationItemValue fBandItem = (ConfigurationItemValue)IterableExtensions.findFirst((Iterable)((SystemResourceSetup)context).getConfigurationItemValues(), (Functions.Function1)_function_7);
            Functions.Function1<ConfigurationItemValue, Boolean> _function_8 = new Functions.Function1<ConfigurationItemValue, Boolean>(){

                public Boolean apply(ConfigurationItemValue it) {
                    String _name = it.getItem().getName();
                    return Objects.equal((Object)_name, (Object)"rx2Frequency");
                }
            };
            ConfigurationItemValue fRx2Item = (ConfigurationItemValue)IterableExtensions.findFirst((Iterable)((SystemResourceSetup)context).getConfigurationItemValues(), (Functions.Function1)_function_8);
            Procedures.Procedure1<EObject> _function_9 = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            };
            Integer fBand = (Integer)BaseUtils.castOrNull((Object)StaticValueInferrer.infer((EObject)fBandItem, (Procedures.Procedure1)_function_9), Integer.class);
            Procedures.Procedure1<EObject> _function_10 = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            };
            Integer fRx2 = (Integer)BaseUtils.castOrNull((Object)StaticValueInferrer.infer((EObject)fRx2Item, (Procedures.Procedure1)_function_10), Integer.class);
            if (bandRx2Check != null && fBand != null && fRx2 != null && !((Boolean)bandRx2Check.apply((Object)fBand, (Object)fRx2)).booleanValue()) {
                String msg = "bandFrequency and rx2Frequency don't fit together";
                acceptor.acceptError("bandFrequency and rx2Frequency don't fit together", (EObject)fBandItem, null, 0, "", new String[0]);
                acceptor.acceptError("bandFrequency and rx2Frequency don't fit together", (EObject)fRx2Item, null, 0, "", new String[0]);
            }
        }
    }
}

