/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.common.base.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.program.ConfigurationItemValue;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.mita.program.validation.IResourceValidator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class AdcValidator
implements IResourceValidator {
    public void validate(Program program, EObject context, final ValidationMessageAcceptor acceptor) {
        if (context instanceof SystemResourceSetup) {
            boolean _equals;
            AbstractSystemResource _type = ((SystemResourceSetup)context).getType();
            String _name = null;
            if (_type != null) {
                _name = _type.getName();
            }
            if (_equals = Objects.equal((Object)_name, (Object)"ADC")) {
                final ConfigurationItemValue refVoltageConfig = this.getReferenceVoltageConfig((SystemResourceSetup)context);
                Functions.Function2<Boolean, SignalInstance, Boolean> _function = new Functions.Function2<Boolean, SignalInstance, Boolean>(){

                    public Boolean apply(Boolean uev, SignalInstance sigInst) {
                        return AdcValidator.this.validateSigInst(sigInst, refVoltageConfig, acceptor) || uev != false;
                    }
                };
                Boolean usesExternalVoltage = (Boolean)IterableExtensions.fold((Iterable)((SystemResourceSetup)context).getSignalInstances(), (Object)false, (Functions.Function2)_function);
                if (!usesExternalVoltage.booleanValue() && refVoltageConfig != null) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Setting the external reference voltage has no effect unless you configure a signal with referenceVoltage set to an external reference voltage");
                    acceptor.acceptWarning(_builder.toString(), (EObject)refVoltageConfig, null, 0, "", new String[0]);
                }
            }
        }
    }

    public boolean validateSigInst(SignalInstance context, ConfigurationItemValue refVoltageConfig, ValidationMessageAcceptor acceptor) {
        Procedures.Procedure1<EObject> _function;
        Expression arg = ModelUtils.getArgumentValue((SignalInstance)context, (String)"referenceVoltage");
        Object refVoltageEnum = StaticValueInferrer.infer((EObject)arg, (Procedures.Procedure1)(_function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        }));
        if (refVoltageEnum instanceof Enumerator) {
            String refVoltage = ((Enumerator)refVoltageEnum).getName();
            boolean isExternal = refVoltage.contains("Ext");
            if (isExternal && refVoltageConfig == null) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("You need to set externalReferenceVoltage if you use referenceVoltage=");
                _builder.append(refVoltage);
                acceptor.acceptError(_builder.toString(), arg.eContainer(), null, 0, "", new String[0]);
            }
            return isExternal;
        }
        return false;
    }

    public ConfigurationItemValue getReferenceVoltageConfig(SystemResourceSetup setup) {
        Functions.Function1<ConfigurationItemValue, Boolean> _function = new Functions.Function1<ConfigurationItemValue, Boolean>(){

            public Boolean apply(ConfigurationItemValue configItem) {
                String _name = configItem.getItem().getName();
                return Objects.equal((Object)_name, (Object)"externalReferenceVoltage");
            }
        };
        return (ConfigurationItemValue)IterableExtensions.findFirst((Iterable)setup.getConfigurationItemValues(), (Functions.Function1)_function);
    }
}

