/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.rest;

import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.net.URL;
import org.eclipse.microprofile.telemetry.tracing.tck.BasicHttpClient;
import org.eclipse.microprofile.telemetry.tracing.tck.TestLibraries;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporter;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporterProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RestSpanDefaultTest
extends Arquillian {
    @ArquillianResource
    private URL url;
    @Inject
    private InMemorySpanExporter spanExporter;
    private BasicHttpClient basicClient;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemorySpanExporter.class, InMemorySpanExporterProvider.class, BasicHttpClient.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsServiceProvider(ConfigurableSpanExporterProvider.class, new Class[]{InMemorySpanExporterProvider.class})).addAsResource((Asset)new StringAsset("otel.traces.exporter=in-memory\notel.metrics.exporter=none"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.spanExporter != null) {
            this.spanExporter.reset();
            this.basicClient = new BasicHttpClient(this.url);
        }
    }

    @Test
    void span() {
        Assert.assertEquals((int)this.basicClient.get("/span"), (int)200);
        this.spanExporter.getFinishedSpanItems(0);
    }

    @Test
    void spanName() {
        Assert.assertEquals((int)this.basicClient.get("/span/1"), (int)200);
        this.spanExporter.getFinishedSpanItems(0);
    }

    @Test
    void spanNameWithoutQueryString() {
        Assert.assertEquals((int)this.basicClient.get("/span/1?id=1"), (int)200);
        this.spanExporter.getFinishedSpanItems(0);
    }

    @ApplicationPath(value="/")
    public static class RestApplication
    extends Application {
    }

    @Path(value="/")
    public static class SpanResource {
        @GET
        @Path(value="/span")
        public Response span() {
            return Response.ok().build();
        }

        @GET
        @Path(value="/span/{name}")
        public Response spanName(@PathParam(value="name") String name) {
            return Response.ok().build();
        }
    }
}

