/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.async;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Function;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.telemetry.tracing.tck.ConfigAsset;
import org.eclipse.microprofile.telemetry.tracing.tck.TestLibraries;
import org.eclipse.microprofile.telemetry.tracing.tck.async.JaxRsServerAsyncTestEndpoint;
import org.eclipse.microprofile.telemetry.tracing.tck.async.JaxRsServerAsyncTestEndpointClient;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporter;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporterProvider;
import org.eclipse.microprofile.telemetry.tracing.tck.porting.PropertiesBasedConfigurationBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JaxRsServerAsyncTest
extends Arquillian {
    private static final String TEST_VALUE = "test.value";
    public static final String QUERY_VALUE = "bar";
    @Inject
    private InMemorySpanExporter spanExporter;
    @ArquillianResource
    private URL url;

    @Deployment
    public static WebArchive createDeployment() {
        ConfigAsset config = new ConfigAsset().add("otel.bsp.schedule.delay", "100").add("otel.sdk.disabled", "false").add("otel.metrics.exporter", "none").add("otel.traces.exporter", "in-memory");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemorySpanExporter.class, InMemorySpanExporterProvider.class, JaxRsServerAsyncTestEndpointClient.class, JaxRsServerAsyncTestEndpoint.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addPackages(true, new Package[]{PropertiesBasedConfigurationBuilder.class.getPackage()})).addAsServiceProvider(ConfigurableSpanExporterProvider.class, new Class[]{InMemorySpanExporterProvider.class})).addAsResource((Asset)config, "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.spanExporter != null) {
            this.spanExporter.reset();
        }
    }

    @Test
    public void testJaxRsServerAsyncCompletionStage() {
        this.doAsyncTest(client -> client.getCompletionStage(QUERY_VALUE));
    }

    @Test
    public void testJaxRsServerAsyncCompletionStageError() {
        this.doErrorAsyncTest(client -> client.getCompletionStageError(QUERY_VALUE));
    }

    @Test
    public void testJaxRsServerAsyncSuspend() {
        this.doAsyncTest(client -> client.getSuspend(QUERY_VALUE));
    }

    @Test
    public void testJaxRsServerAsyncSuspendError() {
        this.doErrorAsyncTest(client -> client.getSuspendError(QUERY_VALUE));
    }

    private void doAsyncTest(Function<JaxRsServerAsyncTestEndpointClient, String> requestFunction) {
        Baggage baggage = Baggage.builder().put("test.baggage.key", TEST_VALUE).build();
        try (Scope s = baggage.makeCurrent();){
            try {
                JaxRsServerAsyncTestEndpointClient client = (JaxRsServerAsyncTestEndpointClient)RestClientBuilder.newBuilder().baseUri(this.url.toURI()).build(JaxRsServerAsyncTestEndpointClient.class);
                String response = requestFunction.apply(client);
                Assert.assertEquals((String)response, (String)"OK");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        this.spanExporter.assertSpanCount(3);
        SpanData subtaskSpan = this.spanExporter.getFirst(SpanKind.INTERNAL);
        SpanData clientSpan = this.spanExporter.getFirst(SpanKind.CLIENT);
        SpanData serverSpan = this.spanExporter.getFirst(SpanKind.SERVER);
        Assert.assertEquals((String)serverSpan.getSpanId(), (String)subtaskSpan.getParentSpanId());
        Assert.assertEquals((String)clientSpan.getSpanId(), (String)serverSpan.getParentSpanId());
        Assert.assertTrue((boolean)((String)serverSpan.getAttributes().get(JaxRsServerAsyncTestEndpoint.BAGGAGE_VALUE_ATTR)).contains(TEST_VALUE));
        Assert.assertTrue((boolean)((String)subtaskSpan.getAttributes().get(JaxRsServerAsyncTestEndpoint.BAGGAGE_VALUE_ATTR)).contains(TEST_VALUE));
        Assert.assertTrue((boolean)((String)serverSpan.getAttributes().get(SemanticAttributes.URL_QUERY)).contains(QUERY_VALUE));
        Assert.assertTrue((serverSpan.getEndEpochNanos() >= subtaskSpan.getEndEpochNanos() ? 1 : 0) != 0);
    }

    private void doErrorAsyncTest(Function<JaxRsServerAsyncTestEndpointClient, String> requestFunction) {
        Baggage baggage = Baggage.builder().put("test.baggage.key", TEST_VALUE).build();
        try (Scope s = baggage.makeCurrent();){
            try {
                JaxRsServerAsyncTestEndpointClient client = (JaxRsServerAsyncTestEndpointClient)RestClientBuilder.newBuilder().baseUri(this.url.toURI()).build(JaxRsServerAsyncTestEndpointClient.class);
                try {
                    requestFunction.apply(client);
                    Assert.fail((String)"Client did not throw an exception");
                }
                catch (WebApplicationException e) {
                    Assert.assertEquals((int)e.getResponse().getStatus(), (int)400, (String)("expected 400 but got " + e.getResponse().getStatus() + " full output: " + (String)e.getResponse().readEntity(String.class)));
                    this.readErrorSpans();
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void readErrorSpans() {
        this.spanExporter.assertSpanCount(3);
        SpanData subtaskSpan = this.spanExporter.getFirst(SpanKind.INTERNAL);
        SpanData clientSpan = this.spanExporter.getFirst(SpanKind.CLIENT);
        SpanData serverSpan = this.spanExporter.getFirst(SpanKind.SERVER);
        Assert.assertEquals((String)serverSpan.getSpanId(), (String)subtaskSpan.getParentSpanId());
        Assert.assertEquals((String)clientSpan.getSpanId(), (String)serverSpan.getParentSpanId());
        Assert.assertEquals((int)((Long)serverSpan.getAttributes().get(SemanticAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)400);
        Assert.assertEquals((int)((Long)clientSpan.getAttributes().get(SemanticAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)400);
        Assert.assertTrue((boolean)((String)serverSpan.getAttributes().get(JaxRsServerAsyncTestEndpoint.BAGGAGE_VALUE_ATTR)).contains(TEST_VALUE));
        Assert.assertTrue((boolean)((String)subtaskSpan.getAttributes().get(JaxRsServerAsyncTestEndpoint.BAGGAGE_VALUE_ATTR)).contains(TEST_VALUE));
        Assert.assertTrue((boolean)((String)serverSpan.getAttributes().get(SemanticAttributes.URL_QUERY)).contains(QUERY_VALUE));
        Assert.assertTrue((serverSpan.getEndEpochNanos() >= subtaskSpan.getEndEpochNanos() ? 1 : 0) != 0);
    }
}

