/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.cditests;

import jakarta.inject.Inject;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.ConfigKeyClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.ConfigKeyClient2;
import org.eclipse.microprofile.rest.client.tck.providers.ReturnWithURLRequestFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigKeyTest
extends Arquillian {
    @Inject
    @RestClient
    private ConfigKeyClient client1;
    @Inject
    @RestClient
    private ConfigKeyClient2 client2;

    @Deployment
    public static WebArchive createDeployment() {
        String uriPropertyName = "myConfigKey/mp-rest/uri";
        String uriValue = "http://localhost:1234/configKeyUri";
        String overridePropName = ConfigKeyClient2.class.getName() + "/mp-rest/uri";
        String overridePropValue = "http://localhost:5678/FQCNUri";
        String simpleName = ConfigKeyTest.class.getSimpleName();
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(simpleName + ".jar"))).addClasses(new Class[]{ConfigKeyClient.class, ConfigKeyClient2.class, ReturnWithURLRequestFilter.class})).addAsManifestResource((Asset)new StringAsset(String.format(uriPropertyName + "=" + uriValue + "%n" + overridePropName + "=" + overridePropValue, new Object[0])), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addAsLibrary((Archive)jar)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testConfigKeyUsedForUri() throws Exception {
        Assert.assertEquals((String)this.client1.get(), (String)"GET http://localhost:1234/configKeyUri/hello");
    }

    @Test
    public void testFullyQualifiedClassnamePropTakesPrecedenceOverConfigKey() throws Exception {
        Assert.assertEquals((String)this.client2.get2(), (String)"GET http://localhost:5678/FQCNUri/hello2");
    }
}

