/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.stream.LongStream;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OfStageVerification
extends AbstractStageVerification {
    OfStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void iterableStageShouldEmitManyElements() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new String[]{"a", "b", "c"}).toList().run(this.getEngine()))), Arrays.asList("a", "b", "c"));
    }

    @Test
    public void emptyIterableStageShouldEmitNoElements() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.empty().toList().run(this.getEngine()))), Collections.emptyList());
    }

    @Test
    public void singleIterableStageShouldEmitOneElement() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object)"a").toList().run(this.getEngine()))), Collections.singletonList("a"));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void ofStageShouldHandleExceptionsInIterableIterateMethod() {
        CompletionStage result;
        try {
            result = this.rs.fromIterable(() -> {
                throw new QuietRuntimeException("failed");
            }).toList().run(this.getEngine());
        }
        catch (QuietRuntimeException e) {
            throw new AssertionError("Exception was thrown directly, should have been part of the redeemed completion stage", e);
        }
        this.await(result);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void ofStageShouldHandleExceptionsInIteratorHasNextMethod() {
        this.await(this.rs.fromIterable(() -> new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                throw new QuietRuntimeException("failed");
            }

            @Override
            public Object next() {
                return null;
            }
        }).toList().run(this.getEngine()));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void ofStageShouldHandleExceptionsInIteratorNextMethod() {
        this.await(this.rs.fromIterable(() -> new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Object next() {
                throw new QuietRuntimeException("failed");
            }
        }).toList().run(this.getEngine()));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void ofStageShouldFailIfNullProduced() {
        this.await(this.rs.fromIterable(Arrays.asList(null, null)).toList().run(this.getEngine()));
    }

    @Test
    public void ofStageShouldBeReusable() {
        PublisherBuilder publisher = this.rs.of((Object[])new Integer[]{1, 2, 3});
        Assert.assertEquals((Collection)((Collection)this.await(publisher.toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
        Assert.assertEquals((Collection)((Collection)this.await(publisher.toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new PublisherVerification());
    }

    public class PublisherVerification
    extends AbstractStageVerification.StagePublisherVerification<Long> {
        public Publisher<Long> createPublisher(long elements) {
            return OfStageVerification.this.rs.fromIterable(() -> LongStream.rangeClosed(1L, elements).boxed().iterator()).buildRs(OfStageVerification.this.getEngine());
        }
    }
}

