/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;

public class DefaultMetadata
implements Metadata {
    private final String name;
    private final String description;
    private final MetricType type;
    private final String unit;

    protected DefaultMetadata(String name, String description, MetricType type, String unit) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.unit = unit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description().orElse("");
    }

    @Override
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public String getType() {
        return Optional.ofNullable(this.type).orElse(MetricType.INVALID).toString();
    }

    @Override
    public MetricType getTypeRaw() {
        return Optional.ofNullable(this.type).orElse(MetricType.INVALID);
    }

    @Override
    public String getUnit() {
        return this.unit().orElse("none");
    }

    @Override
    public Optional<String> unit() {
        return Optional.ofNullable(this.unit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)o;
        return Objects.equals(this.name, that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getUnit(), that.getUnit()) && Objects.equals((Object)this.getTypeRaw(), (Object)that.getTypeRaw());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.unit, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultMetadata{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", type=").append((Object)this.type);
        sb.append(", unit='").append(this.unit).append('\'');
        if (this.description != null) {
            sb.append(", description='").append(this.description).append('\'');
        } else {
            sb.append(", description=null");
        }
        sb.append('}');
        return sb.toString();
    }
}

