/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.api;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import org.eclipse.microprofile.lra.annotation.AfterLRA;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;
import org.eclipse.microprofile.lra.tck.service.LRATestService;

@ApplicationScoped
public class ResourceParent {
    @Inject
    private LRATestService lraTestService;
    @Inject
    private LRAMetricService lraMetricService;
    @Context
    private UriInfo context;

    @PUT
    @Path(value="/after")
    @AfterLRA
    public Response afterLRA(@HeaderParam(value="Long-Running-Action-Ended") URI endedLRAId, LRAStatus status) {
        Response response = this.lraTestService.processAfterLRAInfo(endedLRAId, status, this.getClass(), this.context.getPath());
        this.lraMetricService.incrementMetric(LRAMetricType.AfterLRA, endedLRAId, this.getClass());
        return response;
    }
}

