/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.nonjaxrs.valid;

import java.net.URI;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.annotation.AfterLRA;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.Forget;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.annotation.ParticipantStatus;
import org.eclipse.microprofile.lra.annotation.Status;
import org.eclipse.microprofile.lra.annotation.ws.rs.LRA;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;

@ApplicationScoped
@Path(value="valid-nonjaxrs")
public class ValidLRAParticipant {
    private static final Logger LOGGER = Logger.getLogger(ValidLRAParticipant.class.getName());
    public static final String RESOURCE_PATH = "valid-nonjaxrs";
    public static final String ENLIST_WITH_COMPLETE = "nonjaxrs-enlist-complete";
    private int recoveryPasses;
    @Inject
    private LRAMetricService lraMetricService;
    public static final String ENLIST_WITH_COMPENSATE = "nonjaxrs-enlist-compensate";

    @GET
    @Path(value="nonjaxrs-enlist-complete")
    @LRA(value=LRA.Type.REQUIRED)
    public Response enlistWithComplete(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.ok((Object)lraId).build();
    }

    @GET
    @Path(value="nonjaxrs-enlist-compensate")
    @LRA(value=LRA.Type.REQUIRED, cancelOn={Response.Status.INTERNAL_SERVER_ERROR})
    public Response enlistWithCompensate(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)lraId).build();
    }

    @AfterLRA
    public void onLRAEnd(URI lraId, LRAStatus status) {
        this.verifyLRAId(lraId);
        this.lraMetricService.incrementMetric(LRAMetricType.AfterLRA, lraId, ValidLRAParticipant.class);
        LOGGER.fine(String.format("LRA id '%s' was finished with status %s", lraId.toASCIIString(), status.name()));
    }

    @Complete
    public void completeWithException(URI lraId, URI parentId) {
        this.verifyLRAId(lraId);
        this.lraMetricService.incrementMetric(LRAMetricType.Completed, lraId, ValidLRAParticipant.class);
        LOGGER.fine(String.format("LRA id '%s' was completed", lraId.toASCIIString()));
        throw new WebApplicationException(Response.ok().build());
    }

    @Compensate
    public ParticipantStatus compensate(URI lraId) {
        this.verifyLRAId(lraId);
        this.lraMetricService.incrementMetric(LRAMetricType.Compensated, lraId, ValidLRAParticipant.class);
        LOGGER.fine(String.format("LRA id '%s' was compensated", lraId.toASCIIString()));
        return ParticipantStatus.Compensating;
    }

    @Status
    public Response status(URI lraId) {
        this.verifyLRAId(lraId);
        this.lraMetricService.incrementMetric(LRAMetricType.Status, lraId, ValidLRAParticipant.class);
        LOGGER.fine(String.format("LRA id '%s' status called, return FailedToCompensate to get @Forget called", lraId.toASCIIString()));
        return Response.ok((Object)ParticipantStatus.FailedToCompensate).build();
    }

    @Forget
    public void forget(URI lraId) {
        this.verifyLRAId(lraId);
        this.lraMetricService.incrementMetric(LRAMetricType.Forget, lraId, ValidLRAParticipant.class);
        LOGGER.fine(String.format("LRA id '%s' forget called", lraId.toASCIIString()));
    }

    private void verifyLRAId(URI lraId) {
        if (lraId == null) {
            throw new NullPointerException("lraId cannot be null");
        }
    }

    @PUT
    @Path(value="/accept")
    @LRA(value=LRA.Type.REQUIRES_NEW)
    public Response acceptLRA(@QueryParam(value="recoveryCount") @DefaultValue(value="0") Integer recoveryPasses) {
        this.recoveryPasses = recoveryPasses;
        return Response.ok().build();
    }

    @GET
    @Path(value="/accept")
    public Response getAcceptLRA() {
        return Response.ok((Object)this.recoveryPasses).build();
    }
}

