/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.api;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.Forget;
import org.eclipse.microprofile.lra.annotation.ParticipantStatus;
import org.eclipse.microprofile.lra.annotation.Status;
import org.eclipse.microprofile.lra.annotation.ws.rs.LRA;
import org.eclipse.microprofile.lra.annotation.ws.rs.Leave;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;
import org.junit.Assert;

@ApplicationScoped
@Path(value="context-tck-resource")
public class ContextTckResource {
    public static final String TCK_CONTEXT_RESOURCE_PATH = "context-tck-resource";
    public static final String NEW_LRA_PATH = "/new-lra";
    public static final String REQUIRED_LRA_PATH = "/required-lra";
    public static final String NESTED_LRA_PATH = "/nested-lra";
    public static final String NESTED_LRA_PATH_WITH_CLOSE = "/nested-lra-with-close";
    public static final String CONTEXT_CHECK_LRA_PATH = "/context-check-lra";
    public static final String ASYNC_LRA_PATH1 = "async-response-lra";
    public static final String ASYNC_LRA_PATH2 = "completion-stage-lra";
    public static final String ASYNC_LRA_PATH3 = "completion-stage-exceptionally-lra";
    public static final String LEAVE_PATH = "/leave";
    public static final String STATUS_PATH = "/status";
    public static final String CLEAR_STATUS_PATH = "/clear-status";
    public static final String METRIC_PATH = "/count";
    public static final String RESET_PATH = "/reset";
    public static final String LRA_TCK_FAULT_TYPE_HEADER = "Lra-Tck-Fault-Type";
    public static final String LRA_TCK_FAULT_CODE_HEADER = "Lra-Tck-Fault-Status";
    public static final String LRA_TCK_HTTP_CONTEXT_HEADER = "Lra-Tck-Context";
    private static final String REQUIRES_NEW_LRA_PATH = "/requires-new-lra";
    private ExecutorService excecutorService;
    @Inject
    private LRAMetricService lraMetricService;
    private EndPhase endPhase = EndPhase.SUCCESS;
    private Response.Status endPhaseStatus = Response.Status.OK;
    private ParticipantStatus status = ParticipantStatus.Active;
    @Context
    private UriInfo context;

    private void setEndPhase(String faultType, int faultCode) {
        if (faultType == null) {
            this.endPhase = EndPhase.SUCCESS;
            this.endPhaseStatus = Response.Status.OK;
        } else {
            this.endPhase = EndPhase.valueOf(faultType);
            this.endPhaseStatus = Response.Status.fromStatusCode((int)faultCode);
        }
    }

    @PostConstruct
    private void postConstruct() {
        this.excecutorService = Executors.newFixedThreadPool(1);
    }

    @PreDestroy
    private void preDestroy() {
        this.excecutorService.shutdown();
    }

    private ExecutorService getExcecutorService() {
        return this.excecutorService;
    }

    @PUT
    @Path(value="/reset")
    public Response reset(@HeaderParam(value="Lra-Tck-Context") URI lraId) {
        this.status = ParticipantStatus.Active;
        this.endPhase = EndPhase.SUCCESS;
        this.endPhaseStatus = Response.Status.OK;
        this.lraMetricService.clear();
        return Response.ok().build();
    }

    @LRA(value=LRA.Type.REQUIRES_NEW, end=false)
    @PUT
    @Path(value="/new-lra")
    public Response newLRA(@HeaderParam(value="Long-Running-Action") URI lraId, @HeaderParam(value="Lra-Tck-Fault-Type") String tckFaultType, @HeaderParam(value="Lra-Tck-Fault-Status") int tckFaultCode) {
        this.setEndPhase(tckFaultType, tckFaultCode);
        return Response.ok().entity((Object)lraId.toASCIIString()).build();
    }

    @LRA(value=LRA.Type.REQUIRED)
    @PUT
    @Path(value="/required-lra")
    public Response requiredLRA(@HeaderParam(value="Long-Running-Action") URI lraId, @HeaderParam(value="Lra-Tck-Fault-Type") String tckFaultType, @HeaderParam(value="Lra-Tck-Fault-Status") int tckFaultCode) {
        this.setEndPhase(tckFaultType, tckFaultCode);
        return Response.ok().entity((Object)lraId.toASCIIString()).build();
    }

    @LRA(value=LRA.Type.REQUIRES_NEW)
    @PUT
    @Path(value="/requires-new-lra")
    public Response requiresNew(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.ok().entity((Object)lraId.toASCIIString()).build();
    }

    @LRA(value=LRA.Type.NESTED, end=false)
    @PUT
    @Path(value="/nested-lra")
    public Response nestedLRA(@HeaderParam(value="Long-Running-Action") URI nestedLRA, @HeaderParam(value="Long-Running-Action-Parent") URI parentLRA) {
        return Response.ok().entity((Object)(nestedLRA.toASCIIString() + "," + parentLRA.toASCIIString())).build();
    }

    @LRA(value=LRA.Type.NESTED)
    @PUT
    @Path(value="/nested-lra-with-close")
    public Response nestedLRAWithClose(@HeaderParam(value="Long-Running-Action") URI nestedLRA, @HeaderParam(value="Long-Running-Action-Parent") URI parentLRA) {
        return Response.ok().entity((Object)(nestedLRA.toASCIIString() + "," + parentLRA.toASCIIString())).build();
    }

    @LRA(value=LRA.Type.REQUIRED)
    @PUT
    @Path(value="/context-check-lra")
    public Response contextCheck(@HeaderParam(value="Long-Running-Action") URI lraId) {
        String active = this.getActiveLRA();
        Assert.assertEquals((String)"contextCheck1: incoming and active LRAs are different", (Object)lraId.toASCIIString(), (Object)active);
        String remote = this.restPutInvocation(null, REQUIRES_NEW_LRA_PATH, "");
        Assert.assertNotEquals((String)"contextCheck2: the remote service should not have ran with the active context", (Object)remote, (Object)active);
        Assert.assertEquals((String)"contextCheck2: after calling a remote service the active LRAs are different", (Object)active, (Object)this.getActiveLRA());
        remote = this.restPutInvocation(active, REQUIRES_NEW_LRA_PATH, "");
        Assert.assertNotEquals((String)"contextCheck3: the remote service should not have ran with the active context", (Object)remote, (Object)active);
        Assert.assertEquals((String)"contextCheck3: after calling a remote service the active LRAs are different", (Object)active, (Object)this.getActiveLRA());
        remote = this.restPutInvocation(active, "non-participating-tck-resource", "/supports", "");
        Assert.assertEquals((String)"contextCheck4: the remote service should have ran with the active context", (Object)remote, (Object)active);
        Assert.assertEquals((String)"contextCheck4: after calling a remote service the active LRAs is different", (Object)active, (Object)this.getActiveLRA());
        return Response.ok().entity((Object)lraId.toASCIIString()).build();
    }

    @LRA(value=LRA.Type.REQUIRED)
    @PUT
    @Path(value="async-response-lra")
    public void async1LRA(@HeaderParam(value="Long-Running-Action") URI lraId, @Suspended AsyncResponse ar) {
        this.excecutorService.submit(() -> ar.resume((Object)Response.ok().entity((Object)lraId.toASCIIString()).build()));
    }

    @LRA(value=LRA.Type.REQUIRED, end=true, cancelOnFamily={Response.Status.Family.SERVER_ERROR}, cancelOn={Response.Status.NOT_FOUND})
    @PUT
    @Path(value="completion-stage-lra")
    public CompletionStage<Response> asyncInvocationWithLRA(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Thread.sleep(10L);
                return Response.ok().entity((Object)lraId.toASCIIString()).build();
            }
            catch (InterruptedException ex) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)lraId.toASCIIString()).build();
            }
        }, this.getExcecutorService());
    }

    @LRA(value=LRA.Type.REQUIRED)
    @PUT
    @Path(value="completion-stage-exceptionally-lra")
    public CompletionStage<Response> async3LRA(@HeaderParam(value="Long-Running-Action") URI lraId) {
        CompletableFuture<Response> response = new CompletableFuture<Response>();
        this.excecutorService.submit(() -> response.completeExceptionally((Throwable)new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)lraId.toASCIIString()).build())));
        return response;
    }

    @Leave
    @PUT
    @Path(value="/leave")
    public Response leave(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.ok().entity((Object)lraId.toASCIIString()).build();
    }

    @PUT
    @Path(value="/compensate")
    @Compensate
    public Response compensateWork(@HeaderParam(value="Long-Running-Action") URI lraId, @HeaderParam(value="Long-Running-Action-Parent") URI parent) {
        this.lraMetricService.incrementMetric(LRAMetricType.Compensated, lraId, ContextTckResource.class);
        if (parent != null) {
            this.lraMetricService.incrementMetric(LRAMetricType.Nested, parent, ContextTckResource.class);
        }
        return this.getEndPhaseResponse(false);
    }

    @PUT
    @Path(value="/complete")
    @Complete
    public Response completeWork(@HeaderParam(value="Long-Running-Action") URI lraId, @HeaderParam(value="Long-Running-Action-Parent") URI parent) {
        this.lraMetricService.incrementMetric(LRAMetricType.Completed, lraId, ContextTckResource.class);
        if (parent != null) {
            this.lraMetricService.incrementMetric(LRAMetricType.Nested, parent, ContextTckResource.class);
        }
        return this.getEndPhaseResponse(true);
    }

    @GET
    @Path(value="/status")
    @Status
    public Response status(@HeaderParam(value="Long-Running-Action") URI lraId, @HeaderParam(value="Long-Running-Action-Parent") URI parent) {
        this.lraMetricService.incrementMetric(LRAMetricType.Status, lraId, ContextTckResource.class);
        if (parent != null) {
            this.lraMetricService.incrementMetric(LRAMetricType.Nested, parent, ContextTckResource.class);
        }
        return Response.status((Response.Status)this.endPhaseStatus).entity((Object)this.status.name()).build();
    }

    @DELETE
    @Path(value="/forget")
    @Forget
    public Response forget(@HeaderParam(value="Long-Running-Action") URI lraId, @HeaderParam(value="Long-Running-Action-Parent") URI parent) {
        this.lraMetricService.incrementMetric(LRAMetricType.Forget, lraId, ContextTckResource.class);
        if (parent != null) {
            this.lraMetricService.incrementMetric(LRAMetricType.Nested, parent, ContextTckResource.class);
        }
        return Response.status((Response.Status)this.endPhaseStatus).entity((Object)this.status.name()).build();
    }

    @POST
    @Path(value="/clear-status")
    public Response clearStatus(@HeaderParam(value="Lra-Tck-Context") URI lraId, @HeaderParam(value="Lra-Tck-Fault-Type") String tckFaultType) {
        switch (this.status) {
            case Compensating: {
                this.status = ParticipantStatus.Compensated;
                break;
            }
            case Completing: {
                this.status = ParticipantStatus.Completed;
                break;
            }
        }
        this.endPhase = EndPhase.SUCCESS;
        this.endPhaseStatus = Response.Status.OK;
        return Response.ok().entity((Object)this.status.name()).build();
    }

    private Response getEndPhaseResponse(boolean completing) {
        switch (this.endPhase) {
            case ACCEPTED: {
                this.status = completing ? ParticipantStatus.Completing : ParticipantStatus.Compensating;
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)this.status.name()).build();
            }
            case FAILED: {
                this.status = completing ? ParticipantStatus.FailedToComplete : ParticipantStatus.FailedToCompensate;
                return Response.status((Response.Status)this.endPhaseStatus).entity((Object)this.status.name()).build();
            }
        }
        this.status = completing ? ParticipantStatus.Completed : ParticipantStatus.Compensated;
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.status.name()).build();
    }

    private String getActiveLRA() {
        return this.restPutInvocation(null, "non-participating-tck-resource", "/supports", "");
    }

    private String restPutInvocation(String lraURI, String path, String bodyText) {
        return this.restPutInvocation(lraURI, TCK_CONTEXT_RESOURCE_PATH, path, bodyText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String restPutInvocation(String lraURI, String resource, String path, String bodyText) {
        Response response;
        String id = null;
        Invocation.Builder builder = ClientBuilder.newClient().target(this.context.getBaseUri()).path(resource).path(path).request();
        if (lraURI != null) {
            builder.header("Long-Running-Action", (Object)lraURI);
        }
        if ((response = builder.put(Entity.text((Object)bodyText))).hasEntity()) {
            id = (String)response.readEntity(String.class);
        }
        try {
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new WebApplicationException("Error on REST PUT for LRA '" + lraURI + "' at path '" + path + "' and body '" + bodyText + "'", response);
            }
        }
        finally {
            response.close();
        }
        return id;
    }

    public static enum EndPhase {
        ACCEPTED,
        FAILED,
        SUCCESS;

    }
}

