/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.tck.TckTestBase;
import org.eclipse.microprofile.lra.tck.participant.api.LRAUnknownResource;
import org.eclipse.microprofile.lra.tck.participant.api.Scenario;
import org.eclipse.microprofile.lra.tck.service.LRAMetricAssertions;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;
import org.eclipse.microprofile.lra.tck.service.LRATestService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TckUnknownTests
extends TckTestBase {
    @Inject
    private LRAMetricAssertions lraMetric;
    @Inject
    private LRAMetricService lraMetricService;
    @Inject
    private LRATestService lraTestService;

    @Deployment(name="tckunkown")
    public static WebArchive deploy() {
        return TckTestBase.deploy(TckUnknownTests.class.getSimpleName().toLowerCase());
    }

    @Override
    @Before
    public void before() {
        super.before();
    }

    @Test
    public void compensate_immediate() throws WebApplicationException {
        String lraIdString = this.invoke(Scenario.COMPENSATE_IMMEDIATE);
        URI lraId = URI.create(lraIdString);
        this.lraTestService.waitForRecovery(lraId);
        this.lraMetric.assertCompensated("Expect @Compensate was called", lraId, LRAUnknownResource.class);
        this.lraMetric.assertAfterLRA("Expect @AfterLRA was called", lraId, LRAUnknownResource.class);
        this.lraMetric.assertCancelled("Expect final Cancel was called", lraId, LRAUnknownResource.class);
    }

    @Test
    public void compensate_retry() throws WebApplicationException {
        String lraIdString = this.invoke(Scenario.COMPENSATE_RETRY);
        URI lraId = URI.create(lraIdString);
        this.lraTestService.waitForRecovery(lraId);
        int compensatedCalled = this.lraMetricService.getMetric(LRAMetricType.Compensated, lraId, LRAUnknownResource.class);
        MatcherAssert.assertThat((String)"Expect @Compensate was called", (Object)compensatedCalled, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        this.lraMetric.assertAfterLRA("Expect @AfterLRA was called", lraId, LRAUnknownResource.class);
        this.lraMetric.assertCancelled("Expect final Cancel was called", lraId, LRAUnknownResource.class);
    }

    @Test
    public void complete_immediate() throws WebApplicationException {
        String lraIdString = this.invoke(Scenario.COMPLETE_IMMEDIATE);
        URI lraId = URI.create(lraIdString);
        this.lraTestService.waitForRecovery(lraId);
        this.lraMetric.assertCompleted("Expect @Complete was called", lraId, LRAUnknownResource.class);
        this.lraMetric.assertAfterLRA("Expect @AfterLRA was called", lraId, LRAUnknownResource.class);
        this.lraMetric.assertClosed("Expect final Close was called", lraId, LRAUnknownResource.class);
    }

    @Test
    public void complete_retry() throws WebApplicationException {
        String lraIdString = this.invoke(Scenario.COMPLETE_RETRY);
        URI lraId = URI.create(lraIdString);
        this.lraTestService.waitForRecovery(lraId);
        int compensatedCalled = this.lraMetricService.getMetric(LRAMetricType.Completed, lraId, LRAUnknownResource.class);
        MatcherAssert.assertThat((String)"Expect @Compensate was called", (Object)compensatedCalled, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        this.lraMetric.assertAfterLRA("Expect @AfterLRA was called", lraId, LRAUnknownResource.class);
        this.lraMetric.assertClosed("Expect final Close was called", lraId, LRAUnknownResource.class);
    }

    private String invoke(Scenario scenario) {
        WebTarget resourcePath = this.tckSuiteTarget.path("lraUnknownController").path("work").queryParam("scenario", new Object[]{scenario.name()});
        Response response = resourcePath.request().put(Entity.text((Object)""));
        return this.checkStatusReadAndCloseResponse(Response.Status.fromStatusCode((int)scenario.getPathResponseCode()), response, resourcePath);
    }
}

