/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import java.net.URI;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.tck.LRAClientOps;
import org.eclipse.microprofile.lra.tck.TckTestBase;
import org.eclipse.microprofile.lra.tck.participant.nonjaxrs.valid.LongBusinessMethodParticipant;
import org.eclipse.microprofile.lra.tck.participant.nonjaxrs.valid.ValidLRACSParticipant;
import org.eclipse.microprofile.lra.tck.participant.nonjaxrs.valid.ValidLRAParticipant;
import org.eclipse.microprofile.lra.tck.service.LRAMetricAssertions;
import org.eclipse.microprofile.lra.tck.service.LRATestService;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TckParticipantTests
extends TckTestBase {
    private static final String VALID_DEPLOYMENT = "valid-deploy";
    private static final Logger LOGGER = Logger.getLogger(TckParticipantTests.class.getName());
    @Inject
    private LRAMetricAssertions lraMetric;
    @Inject
    private LRATestService lraTestService;

    @Deployment
    public static WebArchive deployValidParticipant() {
        return (WebArchive)TckTestBase.deploy(VALID_DEPLOYMENT).addPackage(ValidLRAParticipant.class.getPackage());
    }

    @Test
    public void validWebApplicationExceptionReturnedTest() {
        WebTarget resourcePath = this.tckSuiteTarget.path("valid-nonjaxrs").path("nonjaxrs-enlist-complete");
        Response response = resourcePath.request().get();
        URI lraId = URI.create(this.checkStatusReadAndCloseResponse(Response.Status.OK, response, resourcePath));
        this.lraMetric.assertCompletedEquals("Non JAX-RS @Complete method throwing WebApplicationException shoud have been called", 1, lraId, ValidLRAParticipant.class);
        this.lraMetric.assertNotCompensated("@Compensate method should not have been called as LRA completed succesfully", lraId, ValidLRAParticipant.class);
        this.lraMetric.assertAfterLRA("@AfterLRA method should have been called", lraId, ValidLRAParticipant.class);
    }

    @Test
    public void validSignaturesChainTest() throws InterruptedException {
        WebTarget resourcePath = this.tckSuiteTarget.path("valid-nonjaxrs").path("nonjaxrs-enlist-compensate");
        Response response = resourcePath.request().get();
        URI lraId = URI.create(this.checkStatusReadAndCloseResponse(Response.Status.INTERNAL_SERVER_ERROR, response, resourcePath));
        this.lraMetric.assertCompensatedEquals("Non JAX-RS @Compensate method should have been called", 1, lraId, ValidLRAParticipant.class);
        this.lraMetric.assertNotCompleted("@Complete method should not have been called as LRA compensated", lraId, ValidLRAParticipant.class);
        this.lraTestService.waitForRecovery(lraId);
        this.lraMetric.assertStatus("Non JAX-RS @Status method should have been called", lraId, ValidLRAParticipant.class);
        this.lraMetric.assertForget("Non JAX-RS @Forget method should have been called", lraId, ValidLRAParticipant.class);
    }

    @Test
    public void testNonJaxRsCompletionStageVoid() throws InterruptedException {
        WebTarget resourcePath = this.tckSuiteTarget.path("valid-cs-participant1").path("enlist-compensate");
        Response response = resourcePath.request().get();
        URI lraId = URI.create(this.checkStatusReadAndCloseResponse(Response.Status.INTERNAL_SERVER_ERROR, response, resourcePath));
        this.lraMetric.assertCompensatedEquals("Non JAX-RS @Compensate method with CompletionStage<Void> should have been called", 1, lraId, ValidLRACSParticipant.class);
        this.lraMetric.assertNotCompleted("Non JAX-RS @Complete method should have not been called", lraId, ValidLRACSParticipant.class);
        this.lraTestService.waitForRecovery(lraId);
    }

    @Test
    public void testNonJaxRsCompletionStageResponseAndParticipantStatus() throws InterruptedException {
        WebTarget resourcePath = this.tckSuiteTarget.path("valid-cs-participant1").path("enlist-complete");
        Response response = resourcePath.request().get();
        URI lraId = URI.create(this.checkStatusReadAndCloseResponse(Response.Status.OK, response, resourcePath));
        this.lraMetric.assertCompletedEquals("Non JAX-RS @Complete method with CompletionStage<Response> should have been called", 1, lraId, ValidLRACSParticipant.class);
        this.lraMetric.assertNotCompensated("Non JAX-RS @Compensate method should have not been called", lraId, ValidLRACSParticipant.class);
        this.lraTestService.waitForRecovery(lraId);
        this.lraMetric.assertStatus("Non JAX-RS @Status method with CompletionStage<ParticipantStatus> should have been called", lraId, ValidLRACSParticipant.class);
        this.lraTestService.waitForRecovery(lraId);
    }

    @Test
    public void cancelLraDuringBusinessMethod() throws InterruptedException, ExecutionException, TimeoutException {
        LRAClientOps lraOps = this.lraTestService.getLRAClient();
        URI lraId = lraOps.startLRA(null, this.lraClientId(), 0L, ChronoUnit.MILLIS);
        LOGGER.info(String.format("Started LRA with URI %s", lraId));
        Future lraFuture = this.tckSuiteTarget.path("long-business-participant").path("business-method").request().header("Long-Running-Action", (Object)lraId).async().put(Entity.text((Object)""));
        Response syncMethodResponse = this.tckSuiteTarget.path("long-business-participant").path("sync-method").request().put(Entity.text((Object)""));
        Assert.assertEquals((String)"Endpoint sync-method failed execution", (long)200L, (long)syncMethodResponse.getStatus());
        this.lraMetric.assertNotCompleted("Business method is in progress and @Complete has not been expected", lraId, LongBusinessMethodParticipant.class);
        this.lraMetric.assertNotCompensated("Business method is in progress and @Compensate can't be called as cancelation has not been invoked yet", lraId, LongBusinessMethodParticipant.class);
        LOGGER.info(String.format("Cancelled LRA with URI %s", lraId));
        lraOps.cancelLRA(lraId);
        this.lraTestService.waitForRecovery(lraId);
        this.lraMetric.assertCompensated("@Compensate method should have been called at least once as cancel was invoked", lraId, LongBusinessMethodParticipant.class);
        Response response = (Response)lraFuture.get(this.lraTimeout(), TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)(LongBusinessMethodParticipant.class.getSimpleName() + "'s business method is expected to finish successfully despite the delay."), (long)200L, (long)response.getStatus());
    }
}

