/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.health.tck;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Optional;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;

public abstract class TCKBase
extends Arquillian {
    private static final Logger LOG = Logger.getLogger(TCKBase.class.getName());
    @ArquillianResource
    private URI uri;

    @BeforeMethod
    public void beforeMethod(Method method) {
        LOG.info(String.format("Running test: %s#%s", method.getDeclaringClass().getSimpleName(), method.getName()));
    }

    Response getUrlHealthContents() {
        return this.getUrlContents(this.uri + "/health", false);
    }

    Response getUrlLiveContents() {
        return this.getUrlContents(this.uri + "/health/live", false);
    }

    Response getUrlReadyContents() {
        return this.getUrlContents(this.uri + "/health/ready", false);
    }

    Response getUrlStartedContents() {
        return this.getUrlContents(this.uri + "/health/started", false);
    }

    private Response getUrlContents(String theUrl, boolean useAuth) {
        return this.getUrlContents(theUrl, useAuth, true);
    }

    private Response getUrlContents(String theUrl, boolean useAuth, boolean followRedirects) {
        int code;
        StringBuilder content = new StringBuilder();
        try {
            HttpClientBuilder builder = HttpClientBuilder.create();
            if (!followRedirects) {
                builder.disableRedirectHandling();
            }
            if (useAuth) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("admin", "password");
                provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            }
            CloseableHttpClient client = builder.build();
            HttpResponse response = client.execute((HttpUriRequest)new HttpGet(theUrl));
            code = response.getStatusLine().getStatusCode();
            if (response.getEntity() != null) {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                while ((line = bufferedReader.readLine()) != null) {
                    content.append(line + "\n");
                }
                bufferedReader.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Response(code, content.toString());
    }

    JsonObject readJson(Response response) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(response.getBody().get()));
        JsonObject json = jsonReader.readObject();
        System.out.println(json);
        return json;
    }

    void assertSuccessfulCheck(JsonObject check, String expectedName) {
        this.assertCheckName(check, expectedName);
        this.verifySuccessStatus(check);
    }

    void assertFailureCheck(JsonObject check, String expectedName) {
        this.assertCheckName(check, expectedName);
        this.verifyFailureStatus(check);
    }

    private void assertCheckName(JsonObject check, String expectedName) {
        Assert.assertEquals((String)check.getString("name"), (String)expectedName, (String)String.format("Expected a CDI health check '%s' to be invoked, but it was not present in the response", expectedName));
    }

    void verifySuccessStatus(JsonObject check) {
        Assert.assertEquals((String)check.getString("status"), (String)"UP", (String)"Expected a successful check result");
    }

    void verifyFailureStatus(JsonObject check) {
        Assert.assertEquals((String)check.getString("status"), (String)"DOWN", (String)"Expected a failed check result");
    }

    void assertOverallSuccess(JsonObject json) {
        Assert.assertEquals((String)json.getString("status"), (String)"UP", (String)"Expected overall status to be successful");
    }

    void assertOverallFailure(JsonObject json) {
        Assert.assertEquals((String)json.getString("status"), (String)"DOWN", (String)"Expected overall status to be unsuccessful");
    }

    public class Response {
        private int status;
        private String body;

        public Response(int status, String body) {
            this.status = status;
            this.body = body;
        }

        public int getStatus() {
            return this.status;
        }

        public Optional<String> getBody() {
            return this.body != null && !this.body.equals("") ? Optional.of(this.body) : Optional.empty();
        }
    }
}

