/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricRegistryProxy;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class GaugeMetric {
    private MetricRegistryProxy registry;
    private MetricID metricId;
    private long baseline;
    private static final Method GET_VALUE_METHOD;

    public GaugeMetric(MetricRegistryProxy registry, MetricID metricId) {
        this.registry = registry;
        this.metricId = metricId;
        this.baseline = 0L;
    }

    public long value() {
        return this.gauge().map(GaugeMetric::getValue).orElse(0L);
    }

    public void baseline() {
        this.baseline = this.value();
    }

    public long delta() {
        return this.value() - this.baseline;
    }

    public Optional<Gauge<Long>> gauge() {
        Gauge gauge = (Gauge)this.registry.getGauges().get(this.metricId);
        if (gauge == null) {
            return Optional.empty();
        }
        MatcherAssert.assertThat(GaugeMetric.getValue(gauge), (Matcher)Matchers.instanceOf(Long.class));
        return Optional.of(gauge);
    }

    private static <T> T getValue(Gauge<T> gauge) {
        try {
            return (T)GET_VALUE_METHOD.invoke(gauge, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            GET_VALUE_METHOD = Gauge.class.getMethod("getValue", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e1) {
            throw new RuntimeException(e1);
        }
    }
}

