/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.config;

import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.config.BulkheadConfigBean;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncTaskManager;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class BulkheadConfigTest
extends Arquillian {
    @Inject
    private BulkheadConfigBean bean;

    @Deployment
    public static WebArchive create() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().set(BulkheadConfigBean.class, "serviceValue", Bulkhead.class, "value", "1").set(BulkheadConfigBean.class, "serviceWaitingTaskQueue", Bulkhead.class, "waitingTaskQueue", "1");
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadConfig.jar")).addClass(BulkheadConfigBean.class)).addPackage(Packages.UTILS)).addAsManifestResource((Asset)config, "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadConfig.war")).addAsLibrary((Archive)jar);
        return war;
    }

    @Test
    public void testConfigValue() throws Exception {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask<Void> taskA = taskManager.runBarrierTask(this.bean::serviceValue);
            taskA.assertAwaits();
            AsyncTaskManager.BarrierTask<Void> taskB = taskManager.runBarrierTask(this.bean::serviceValue);
            taskB.assertThrows(BulkheadException.class);
        }
    }

    @Test
    public void testWaitingTaskQueue() throws Exception {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask taskA = taskManager.runAsyncBarrierTask(this.bean::serviceWaitingTaskQueue);
            taskA.assertAwaits();
            AsyncTaskManager.BarrierTask taskB = taskManager.runAsyncBarrierTask(this.bean::serviceWaitingTaskQueue);
            taskB.assertNotAwaiting();
            AsyncTaskManager.BarrierTask taskC = taskManager.runAsyncBarrierTask(this.bean::serviceWaitingTaskQueue);
            taskC.assertThrows(BulkheadException.class);
        }
    }
}

