/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CDIPropertyExpressionsTest
extends Arquillian {
    @Inject
    PropertyExpressionBean propertyExpressionBean;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"CDIPropertyExpressionsTest.war")).addClasses(new Class[]{PropertyExpressionBean.class})).addAsServiceProvider(ConfigSource.class, new Class[]{PropertyExpressionConfigSource.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void expression() {
        Assert.assertEquals((String)this.propertyExpressionBean.expression, (String)"1234");
        Assert.assertEquals((String)this.propertyExpressionBean.expressionConfigValue.getValue(), (String)"1234");
        Assert.assertEquals((String)this.propertyExpressionBean.expressionConfigValue.getRawValue(), (String)"${expression}");
    }

    @Test
    public void expressionNoDefault() {
        Assert.assertEquals((String)this.propertyExpressionBean.expressionDefault, (String)"${expression}");
    }

    public static class PropertyExpressionConfigSource
    implements ConfigSource {
        private Map<String, String> properties = new HashMap<String, String>();

        public PropertyExpressionConfigSource() {
            this.properties.put("my.prop", "${expression}");
            this.properties.put("expression", "1234");
        }

        public Set<String> getPropertyNames() {
            return this.properties.keySet();
        }

        public String getValue(String propertyName) {
            return this.properties.get(propertyName);
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    @Dependent
    public static class PropertyExpressionBean {
        @Inject
        @ConfigProperty(name="my.prop")
        String expression;
        @Inject
        @ConfigProperty(name="my.prop")
        ConfigValue expressionConfigValue;
        @Inject
        @ConfigProperty(name="another.prop", defaultValue="${expression}")
        String expressionDefault;
    }
}

