/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;
import org.eclipse.microprofile.config.tck.configsources.CustomDbConfigSource;
import org.eclipse.microprofile.config.tck.converters.Pizza;
import org.eclipse.microprofile.config.tck.converters.PizzaConverter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AutoDiscoveredConfigSourceTest
extends Arquillian {
    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"customConfigSourceTest.jar")).addClasses(new Class[]{AutoDiscoveredConfigSourceTest.class, CustomDbConfigSource.class, Pizza.class, PizzaConverter.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsServiceProvider(ConfigSource.class, new Class[]{CustomDbConfigSource.class})).addAsServiceProvider(Converter.class, new Class[]{PizzaConverter.class})).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"customConfigSourceTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testAutoDiscoveredConfigureSources() {
        Config config = ConfigProviderResolver.instance().getBuilder().addDefaultSources().addDiscoveredSources().build();
        Assert.assertEquals((String)((String)config.getValue("tck.config.test.customDbConfig.key1", String.class)), (String)"valueFromDb1");
    }

    @Test
    public void testAutoDiscoveredConverterManuallyAdded() {
        Config config = ConfigProviderResolver.instance().getBuilder().addDefaultSources().addDiscoveredSources().addDiscoveredConverters().build();
        Pizza dVaule = (Pizza)config.getValue("tck.config.test.customDbConfig.key3", Pizza.class);
        Assert.assertEquals((String)dVaule.getSize(), (String)"big");
        Assert.assertEquals((String)dVaule.getFlavor(), (String)"cheese");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAutoDiscoveredConverterNotAddedAutomatically() {
        Config config = ConfigProviderResolver.instance().getBuilder().addDefaultSources().addDiscoveredSources().build();
        Pizza dVaule = (Pizza)config.getValue("tck.config.test.customDbConfig.key3", Pizza.class);
        Assert.fail((String)"The auto discovered converter should not be added automatically.");
    }
}

