/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.util.MessageUtil;

public class QueueInt {
    int[] data;
    int headIdx;
    int tailIdx;
    int size;
    int capacity;

    public QueueInt(int capacity) {
        this.capacity = capacity;
        this.data = new int[capacity];
    }

    public final int get() {
        if (this.size == 0) {
            throw new ArrayIndexOutOfBoundsException(Messages.QueueInt_ZeroSizeQueue);
        }
        int result = this.data[this.headIdx];
        ++this.headIdx;
        --this.size;
        if (this.headIdx == this.capacity) {
            this.headIdx = 0;
        }
        return result;
    }

    public final int size() {
        return this.size;
    }

    public final void put(int x) {
        if (this.tailIdx == this.capacity) {
            this.tailIdx = 0;
        }
        if (this.size == this.capacity) {
            int minCapacity = this.size + 1;
            int newCapacity = this.newCapacity(this.capacity, minCapacity);
            if (newCapacity < minCapacity) {
                throw new OutOfMemoryError(MessageUtil.format(Messages.QueueInt_Error_LengthExceeded, minCapacity, newCapacity));
            }
            this.capacity = newCapacity;
            int[] tmp = new int[this.capacity];
            int headToEnd = this.data.length - this.headIdx;
            System.arraycopy(this.data, this.headIdx, tmp, 0, headToEnd);
            if (this.tailIdx > 0) {
                System.arraycopy(this.data, 0, tmp, headToEnd, this.tailIdx);
            }
            this.headIdx = 0;
            this.tailIdx = this.data.length;
            this.data = tmp;
        }
        this.data[this.tailIdx] = x;
        ++this.size;
        ++this.tailIdx;
    }

    private int newCapacity(int oldCapacity, int minCapacity) {
        int newCapacity = oldCapacity * 3 >>> 1;
        if (newCapacity < minCapacity && (newCapacity = minCapacity * 3 >>> 1) < minCapacity) {
            newCapacity = 0x7FFFFFF7;
        }
        return newCapacity;
    }
}

