/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property.value;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.map.AbstractObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.property.IPropertyObservable;
import org.eclipse.core.databinding.property.value.DelegatingValueProperty;
import org.eclipse.core.internal.databinding.property.value.DelegatingCache;

public class SetDelegatingValueObservableMap<S, K extends S, V>
extends AbstractObservableMap<K, V>
implements IPropertyObservable<DelegatingValueProperty<S, V>> {
    private IObservableSet<K> masterSet;
    private DelegatingValueProperty<S, V> detailProperty;
    private DelegatingCache<S, K, V> cache;
    private Set<Map.Entry<K, V>> entrySet;
    private ISetChangeListener<K> masterListener = new ISetChangeListener<K>(){

        public void handleSetChange(SetChangeEvent<? extends K> event) {
            if (SetDelegatingValueObservableMap.this.isDisposed()) {
                return;
            }
            SetDelegatingValueObservableMap.this.cache.addAll(SetDelegatingValueObservableMap.this.masterSet);
            MapDiff diff = this.convertDiff(event.diff);
            SetDelegatingValueObservableMap.this.cache.retainAll((Collection<?>)SetDelegatingValueObservableMap.this.masterSet);
            SetDelegatingValueObservableMap.this.fireMapChange(diff);
        }

        private MapDiff<K, V> convertDiff(SetDiff<? extends K> diff) {
            HashMap oldValues = new HashMap();
            HashMap newValues = new HashMap();
            for (Object masterElement : diff.getRemovals()) {
                oldValues.put(masterElement, SetDelegatingValueObservableMap.this.cache.get(masterElement));
            }
            for (Object masterElement : diff.getAdditions()) {
                newValues.put(masterElement, SetDelegatingValueObservableMap.this.cache.get(masterElement));
            }
            return Diffs.createMapDiff((Set)diff.getAdditions(), (Set)diff.getRemovals(), Collections.emptySet(), oldValues, newValues);
        }
    };
    private IStaleListener staleListener = staleEvent -> this.fireStale();

    public SetDelegatingValueObservableMap(IObservableSet<K> keySet, DelegatingValueProperty<S, V> valueProperty) {
        super(keySet.getRealm());
        this.masterSet = keySet;
        this.detailProperty = valueProperty;
        this.cache = new DelegatingCache<S, K, V>(this.getRealm(), valueProperty){

            @Override
            void handleValueChange(K masterElement, V oldValue, V newValue) {
                SetDelegatingValueObservableMap.this.fireMapChange(Diffs.createMapDiffSingleChange(masterElement, oldValue, newValue));
            }
        };
        this.cache.addAll((Collection<K>)this.masterSet);
        this.masterSet.addSetChangeListener(this.masterListener);
        this.masterSet.addStaleListener(this.staleListener);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        this.getterCalled();
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private void getterCalled() {
        ObservableTracker.getterCalled((IObservable)this);
    }

    public V get(Object key) {
        this.getterCalled();
        return this.cache.get(key);
    }

    public V put(K key, V value) {
        this.checkRealm();
        return this.cache.put(key, value);
    }

    public boolean isStale() {
        return this.masterSet.isStale();
    }

    public Object getObserved() {
        return this.masterSet;
    }

    @Override
    public DelegatingValueProperty<S, V> getProperty() {
        return this.detailProperty;
    }

    public Object getKeyType() {
        return this.masterSet.getElementType();
    }

    public Object getValueType() {
        return this.detailProperty.getValueType();
    }

    public synchronized void dispose() {
        if (this.masterSet != null) {
            this.masterSet.removeSetChangeListener(this.masterListener);
            this.masterSet.removeStaleListener(this.staleListener);
            this.masterSet = null;
        }
        if (this.cache != null) {
            this.cache.dispose();
            this.cache = null;
        }
        this.masterListener = null;
        this.detailProperty = null;
        super.dispose();
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                final Iterator<K> it;
                {
                    this.it = ((EntrySet)EntrySet.this).SetDelegatingValueObservableMap.this.masterSet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    return new MapEntry(this.it.next());
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public int size() {
            return SetDelegatingValueObservableMap.this.masterSet.size();
        }
    }

    class MapEntry
    implements Map.Entry<K, V> {
        private final K key;

        MapEntry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            SetDelegatingValueObservableMap.this.getterCalled();
            return this.key;
        }

        @Override
        public V getValue() {
            SetDelegatingValueObservableMap.this.getterCalled();
            if (!SetDelegatingValueObservableMap.this.masterSet.contains(this.key)) {
                return null;
            }
            return SetDelegatingValueObservableMap.this.cache.get(this.key);
        }

        @Override
        public V setValue(V value) {
            SetDelegatingValueObservableMap.this.checkRealm();
            if (!SetDelegatingValueObservableMap.this.masterSet.contains(this.key)) {
                return null;
            }
            return SetDelegatingValueObservableMap.this.cache.put(this.key, value);
        }

        @Override
        public boolean equals(Object o) {
            SetDelegatingValueObservableMap.this.getterCalled();
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
        }

        @Override
        public int hashCode() {
            SetDelegatingValueObservableMap.this.getterCalled();
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.getValue());
        }
    }
}

