/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.acquire;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.acquire.HeapDumpProviderDescriptor;
import org.eclipse.mat.internal.acquire.HeapDumpProviderRegistry;
import org.eclipse.mat.internal.acquire.VmInfoDescriptor;
import org.eclipse.mat.query.annotations.descriptors.IAnnotatedObjectDescriptor;
import org.eclipse.mat.query.registry.AnnotatedObjectArgumentsSet;
import org.eclipse.mat.snapshot.acquire.VmInfo;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.acquire.AcquireSnapshotAction;
import org.eclipse.mat.ui.util.Copy;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class AcquireDialog
extends WizardPage {
    private static final String LAST_DIRECTORY_KEY = String.valueOf(AcquireDialog.class.getName()) + ".lastDir";
    private LocalResourceManager resourceManager;
    private Font italicFont;
    private Table localVMsTable;
    private Label saveLocationLabel;
    private Text folderText;
    private Button configureButton;
    private Button refreshButton;
    private Collection<HeapDumpProviderDescriptor> providerDescriptors;
    private List<ProcessSelectionListener> listeners = new ArrayList<ProcessSelectionListener>();
    private int sortpid = 1;
    private int sortproc = 2;
    private List<? extends VmInfo> vms;

    public AcquireDialog(Collection<HeapDumpProviderDescriptor> dumpProviders) {
        super("acq");
        this.providerDescriptors = dumpProviders;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.AcquireDialog_DialogName);
        this.setDescription(Messages.AcquireDialog_DialogDescription);
        final Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(2, false));
        Label l1 = new Label(top, 0);
        l1.setText(Messages.AcquireDialog_ChooseProcess);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)l1);
        Composite tableComposite = new Composite(top, 0);
        GridDataFactory.fillDefaults().grab(true, true).indent(0, 0).applyTo((Control)tableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.localVMsTable = new Table(tableComposite, 68100);
        this.localVMsTable.setHeaderVisible(true);
        this.localVMsTable.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).minSize(0, 100).applyTo((Control)this.localVMsTable);
        this.localVMsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcquireDialog.this.selectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (AcquireDialog.this.getWizard().performFinish()) {
                    AcquireDialog.this.getShell().close();
                }
            }
        });
        int descWidth = 250;
        int pidWidth = 70;
        int provWidth = 200;
        TableColumn column = new TableColumn(this.localVMsTable, 131072);
        column.setText(Messages.AcquireDialog_ColumnDescription);
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100, 250));
        column = new TableColumn(this.localVMsTable, 131072);
        column.setText(Messages.AcquireDialog_ColumnPID);
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(0, 70));
        column.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (AcquireDialog.this.sortpid == 0) {
                    AcquireDialog.this.sortpid = 2;
                } else if (AcquireDialog.this.sortpid > 0) {
                    AcquireDialog.this.sortpid = -2;
                } else {
                    AcquireDialog.this.sortpid = 0;
                }
                if (Math.abs(AcquireDialog.this.sortproc) >= 2) {
                    AcquireDialog acquireDialog = AcquireDialog.this;
                    acquireDialog.sortproc = acquireDialog.sortproc / 2;
                }
                AcquireDialog.this.resort();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        column = new TableColumn(this.localVMsTable, 16384);
        column.setText(Messages.AcquireDialog_HeapDumpProviderColumnHeader);
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(0, 200));
        column.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (AcquireDialog.this.sortproc == 0) {
                    AcquireDialog.this.sortproc = 2;
                } else if (AcquireDialog.this.sortproc > 0) {
                    AcquireDialog.this.sortproc = -2;
                } else {
                    AcquireDialog.this.sortproc = 0;
                }
                if (Math.abs(AcquireDialog.this.sortpid) >= 2) {
                    AcquireDialog acquireDialog = AcquireDialog.this;
                    acquireDialog.sortpid = acquireDialog.sortpid / 2;
                }
                AcquireDialog.this.resort();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.localVMsTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 99 && (e.stateMask & SWT.MOD1) != 0) {
                    Copy.copyToClipboard((Control)AcquireDialog.this.localVMsTable);
                }
            }
        });
        tableComposite.layout();
        tableComposite.pack();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mat.ui.help.acquire_arguments");
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)top);
        this.italicFont = this.resourceManager.createFont(FontDescriptor.createFrom((Font)column.getParent().getFont()).setStyle(2));
        Composite buttons = new Composite(top, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)buttons);
        this.refreshButton = new Button(buttons, 0);
        this.refreshButton.setText(Messages.AcquireDialog_RefreshButtonLabel);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.refreshButton);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcquireDialog.this.refresh();
            }
        });
        this.configureButton = new Button(buttons, 0);
        this.configureButton.setText(Messages.AcquireDialog_ConfigureButtonLabel);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.configureButton);
        this.configureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcquireSnapshotAction.AcquireWizard aw = (AcquireSnapshotAction.AcquireWizard)AcquireDialog.this.getWizard();
                aw.getContainer().showPage((IWizardPage)aw.configPage);
            }
        });
        this.saveLocationLabel = new Label(top, 0);
        this.saveLocationLabel.setText(Messages.AcquireDialog_SaveLocation);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)this.saveLocationLabel);
        this.folderText = new Text(top, 2048);
        GridDataFactory.fillDefaults().minSize(300, 0).grab(true, false).applyTo((Control)this.folderText);
        String lastDir = Platform.getPreferencesService().getString("org.eclipse.mat.ui", LAST_DIRECTORY_KEY, "", null);
        if (lastDir == null || lastDir.trim().equals("")) {
            lastDir = System.getProperty("user.home");
        }
        this.folderText.setText(lastDir);
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcquireDialog.this.getContainer().updateButtons();
                String errorMessage = null;
                int level = 0;
                if (AcquireDialog.this.localVMsTable.getSelectionIndex() != -1 && AcquireDialog.this.folderText.getText().length() > 0) {
                    File f = new File(AcquireDialog.this.getSelectedPath());
                    if (f.isDirectory()) {
                        errorMessage = Messages.AcquireDialog_FileIsDirectory;
                        level = 3;
                    } else if (f.exists()) {
                        errorMessage = Messages.AcquireDialog_FileExists;
                        level = 2;
                    }
                }
                AcquireDialog.this.setMessage(errorMessage, level);
            }
        });
        Button b = new Button(top, 0);
        b.setText(Messages.AcquireDialog_BrowseButton);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String folder;
                if (AcquireDialog.this.localVMsTable.getSelectionIndex() == -1) {
                    DirectoryDialog dialog = new DirectoryDialog(top.getShell());
                    dialog.setFilterPath(AcquireDialog.this.getSelectedDirectory());
                    dialog.setText(Messages.AcquireDialog_ChooseDestinationDirectory);
                    dialog.setMessage(Messages.AcquireDialog_ChooseDestinationDirectoryMessage);
                    folder = dialog.open();
                } else {
                    FileDialog dialog = new FileDialog(top.getShell(), 8192);
                    File f = new File(AcquireDialog.this.getSelectedPath());
                    if (f.isDirectory()) {
                        dialog.setFilterPath(f.getPath());
                    } else {
                        dialog.setFilterPath(f.getParent());
                        dialog.setFileName(f.getName());
                        String name = f.getName();
                        int i = name.lastIndexOf(46);
                        if (i >= 0) {
                            dialog.setFilterExtensions(new String[]{"*" + name.substring(i), "*"});
                        }
                    }
                    dialog.setText(Messages.AcquireDialog_ChooseDestinationDirectoryAndFile);
                    dialog.setOverwrite(true);
                    folder = dialog.open();
                }
                if (folder != null && folder.length() > 0) {
                    AcquireDialog.this.folderText.setText(folder);
                }
            }
        });
        this.localVMsTable.setFocus();
        this.setControl((Control)top);
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AcquireDialog.this.refresh();
            }
        });
    }

    private void refreshTable() {
        this.localVMsTable.removeAll();
        this.vms = this.getAvailableVms();
        this.fillTable();
    }

    private void fillTable() {
        this.localVMsTable.removeAll();
        if (this.vms != null) {
            for (VmInfo vmInfo : this.sort(this.vms)) {
                try {
                    VmInfoDescriptor descriptor = VmInfoDescriptor.createDescriptor((VmInfo)vmInfo);
                    TableItem item = new TableItem(this.localVMsTable, 0);
                    item.setGrayed(!vmInfo.isHeapDumpEnabled());
                    if (!vmInfo.isHeapDumpEnabled()) {
                        item.setFont(this.italicFont);
                    }
                    item.setText(0, vmInfo.getDescription());
                    item.setText(1, Integer.toString(vmInfo.getPid()));
                    item.setText(2, this.getProviderDescriptor(vmInfo).getName());
                    item.setData((Object)new AnnotatedObjectArgumentsSet((IAnnotatedObjectDescriptor)descriptor));
                }
                catch (SnapshotException e) {
                    Logger.getLogger("org.eclipse.mat.ui").log(Level.SEVERE, "Problems refreshing process list", e);
                }
            }
        }
    }

    private List<? extends VmInfo> sort(List<? extends VmInfo> vms) {
        if (this.sortpid == 0 && this.sortproc == 0) {
            return vms;
        }
        ArrayList<? extends VmInfo> vms2 = new ArrayList<VmInfo>(vms);
        Collections.sort(vms2, new Comparator<VmInfo>(){

            private int sort(int a, int b) {
                if (a < b) {
                    return -1;
                }
                if (a > b) {
                    return 1;
                }
                return 0;
            }

            private int signum(int x) {
                return this.sort(x, 0);
            }

            @Override
            public int compare(VmInfo o1, VmInfo o2) {
                return AcquireDialog.this.sortpid * this.sort(o1.getPid(), o2.getPid()) + AcquireDialog.this.sortproc * this.signum(AcquireDialog.this.getProviderDescriptor(o1).getName().compareTo(AcquireDialog.this.getProviderDescriptor(o2).getName()));
            }
        });
        return vms2;
    }

    private List<VmInfo> getAvailableVms() {
        ArrayList<VmInfo> vms = new ArrayList<VmInfo>();
        for (HeapDumpProviderDescriptor providerDescriptor : this.providerDescriptors) {
            List<? extends VmInfo> providerVMs;
            GetVMListRunnable getListOperation = new GetVMListRunnable(providerDescriptor, (IRunnableContext)this.getContainer());
            if (!getListOperation.run().isOK() || (providerVMs = getListOperation.getResult()) == null) continue;
            vms.addAll(providerVMs);
        }
        return vms;
    }

    public boolean isPageComplete() {
        if (this.localVMsTable.getSelectionIndex() == -1) {
            return false;
        }
        boolean isEnabled = !this.localVMsTable.getItem(this.localVMsTable.getSelectionIndex()).getFont().equals((Object)this.italicFont);
        boolean isEnabled2 = ((VmInfoDescriptor)((AnnotatedObjectArgumentsSet)this.localVMsTable.getItem(this.localVMsTable.getSelectionIndex()).getData()).getDescriptor()).getVmInfo().isHeapDumpEnabled();
        if (isEnabled && !isEnabled2) {
            this.localVMsTable.getItem(this.localVMsTable.getSelectionIndex()).setFont(this.italicFont);
            isEnabled = false;
        }
        return this.localVMsTable.getSelectionIndex() != -1 && isEnabled && this.folderText.getText().length() > 0 && !new File(this.getSelectedPath()).isDirectory();
    }

    public AnnotatedObjectArgumentsSet getProcessArgumentsSet() {
        if (this.localVMsTable.getSelectionIndex() == -1) {
            return null;
        }
        AnnotatedObjectArgumentsSet argumentsSet = (AnnotatedObjectArgumentsSet)this.localVMsTable.getSelection()[0].getData();
        return argumentsSet;
    }

    public VmInfo getProcess() {
        if (this.localVMsTable.getSelectionIndex() == -1) {
            return null;
        }
        AnnotatedObjectArgumentsSet argumentsSet = (AnnotatedObjectArgumentsSet)this.localVMsTable.getSelection()[0].getData();
        VmInfoDescriptor descriptor = (VmInfoDescriptor)argumentsSet.getDescriptor();
        return descriptor.getVmInfo();
    }

    public String getSelectedPath() {
        return this.folderText.getText();
    }

    private String getSelectedDirectory() {
        String selectedPath = this.folderText.getText();
        if (selectedPath == null) {
            return "";
        }
        File f = new File(selectedPath);
        if (f.isDirectory()) {
            return selectedPath;
        }
        String dir = f.getParent();
        return dir == null ? selectedPath : dir;
    }

    public void saveSettings() {
        InstanceScope.INSTANCE.getNode("org.eclipse.mat.ui").put(LAST_DIRECTORY_KEY, this.getSelectedDirectory());
    }

    private HeapDumpProviderDescriptor getProviderDescriptor(VmInfo vmInfo) {
        return HeapDumpProviderRegistry.instance().getHeapDumpProvider(vmInfo.getHeapDumpProvider().getClass());
    }

    synchronized void addProcessSelectionListener(ProcessSelectionListener listener) {
        this.listeners.add(listener);
    }

    void clearSelection() {
        this.localVMsTable.deselectAll();
        this.selectionChanged();
    }

    void refresh() {
        this.localVMsTable.deselectAll();
        this.refreshTable();
        this.selectionChanged();
    }

    void resort() {
        this.localVMsTable.deselectAll();
        this.selectionChanged();
        this.fillTable();
    }

    void updateFileName() {
        VmInfo process = this.getProcess();
        if (process == null) {
            this.folderText.setText(this.getSelectedDirectory());
            this.saveLocationLabel.setText(Messages.AcquireDialog_SaveLocation);
            this.saveLocationLabel.pack();
        } else {
            String proposedFilePath;
            File proposedFile;
            String proposedFileName2;
            String proposedFileName = process.getProposedFileName();
            if (proposedFileName == null) {
                proposedFileName = "java_%pid%";
            }
            proposedFileName = proposedFileName.replace("%pid%", String.valueOf(this.getProcess().getPid()));
            int pid = process.getPid();
            Date date = new Date();
            String errorMessage = null;
            int i = 1;
            do {
                try {
                    proposedFileName2 = MessageUtil.format((String)proposedFileName, (Object[])new Object[]{date, pid, i});
                }
                catch (IllegalArgumentException e) {
                    errorMessage = e.getLocalizedMessage();
                    proposedFileName2 = proposedFileName;
                }
                proposedFile = new File(this.getSelectedDirectory(), proposedFileName2);
                proposedFilePath = proposedFile.getPath();
            } while (!proposedFileName2.equals(proposedFileName) && proposedFile.exists() && ++i < 10000);
            this.folderText.setText(proposedFilePath);
            this.saveLocationLabel.setText(Messages.AcquireDialog_SaveFileLocation);
            this.saveLocationLabel.pack();
            if (errorMessage != null) {
                this.setMessage(MessageUtil.format((String)Messages.AcquireDialog_InvalidFilenameTemplate, (Object[])new Object[]{errorMessage, this.getProviderDescriptor(process).getName()}), 2);
            }
        }
    }

    private void selectionChanged() {
        this.updateFileName();
        for (ProcessSelectionListener listener : this.listeners) {
            listener.processSelected(this.getProcessArgumentsSet());
        }
        this.getContainer().updateButtons();
    }

    public void performHelp() {
        AnnotatedObjectArgumentsSet argumentsSet;
        String helpUrl;
        if (this.localVMsTable.getSelectionIndex() >= 0 && (helpUrl = (argumentsSet = (AnnotatedObjectArgumentsSet)this.localVMsTable.getSelection()[0].getData()).getDescriptor().getHelpUrl()) != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(helpUrl);
        }
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.mat.ui.help.acquire_arguments");
    }

    private static class GetVMListRunnable
    implements IRunnableWithProgress {
        private IStatus status;
        private IRunnableContext context;
        private List<? extends VmInfo> result;
        private HeapDumpProviderDescriptor provider;

        public GetVMListRunnable(HeapDumpProviderDescriptor provider, IRunnableContext context) {
            this.provider = provider;
            this.context = context;
        }

        public List<? extends VmInfo> getResult() {
            return this.result;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.status = this.doOperation(monitor);
        }

        private IStatus doOperation(IProgressMonitor monitor) {
            ProgressMonitorWrapper listener = new ProgressMonitorWrapper(monitor);
            try {
                this.result = this.provider.getHeapDumpProvider().getAvailableVMs((IProgressListener)listener);
                if (listener.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
            }
            catch (Exception e) {
                return ErrorHelper.createErrorStatus(e);
            }
            return Status.OK_STATUS;
        }

        public final IStatus run() {
            try {
                this.context.run(true, true, (IRunnableWithProgress)this);
            }
            catch (Exception e) {
                this.status = ErrorHelper.createErrorStatus(Messages.AcquireSnapshotAction_UnexpectedException, e);
            }
            if (!this.status.isOK() && this.status != Status.CANCEL_STATUS) {
                Logger.getLogger("org.eclipse.mat.ui").log(Level.INFO, MessageUtil.format((String)"Error getting list of VMs with [{0}] provider", (Object[])new Object[]{this.provider.getName()}), this.status.getException());
            }
            return this.status;
        }
    }

    static interface ProcessSelectionListener {
        public void processSelected(AnnotatedObjectArgumentsSet var1);
    }
}

