/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.swt.graphics.Image;

public class PaneState {
    private List<PaneState> children = new ArrayList<PaneState>(2);
    private String identifier;
    private boolean reproducable;
    private PaneState originator;
    private Image image;
    private boolean active;
    private PaneType type;

    public PaneState(PaneType type, PaneState originator, String identifier, boolean reproducable) {
        this.identifier = identifier;
        this.reproducable = reproducable;
        this.originator = originator;
        this.type = type;
        this.setActive(true);
    }

    public PaneState getParentPaneState() {
        return this.originator;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean isReproducable() {
        return this.reproducable;
    }

    public List<PaneState> getChildren() {
        return this.children;
    }

    protected void addChild(PaneState child) {
        this.children.add(child);
    }

    protected void removeChild(PaneState paneState) {
        this.children.remove(paneState);
    }

    public Image getImage() {
        return this.image != null ? this.image : MemoryAnalyserPlugin.getImage("$nl$/icons/query_browser.gif");
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public PaneType getType() {
        return this.type;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean hasActiveChildren() {
        if (this.children.isEmpty()) {
            return false;
        }
        for (PaneState child : this.children) {
            if (!child.active) continue;
            return true;
        }
        return false;
    }

    public static enum PaneType {
        QUERY,
        EDITOR,
        COMPOSITE_PARENT,
        COMPOSITE_CHILD;

    }
}

