/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.rcp.actions;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.mat.ui.SnapshotHistoryService;
import org.eclipse.mat.ui.editor.PathEditorInput;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class AddHistoryToMenuAction
extends ContributionItem {
    private IWorkbenchWindow window;
    private boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            AddHistoryToMenuAction.this.dirty = true;
        }
    };
    private static final int MAX_TEXT_LENGTH = 40;
    private static final int MAX_MNEMONIC_SIZE = 9;

    public AddHistoryToMenuAction(IWorkbenchWindow window) {
        super("Reopen Editor");
        this.window = window;
    }

    private String calcText(int index, SnapshotHistoryService.Entry item) {
        Path path;
        StringBuffer sb = new StringBuffer();
        int mnemonic = index + 1;
        sb.append(mnemonic);
        sb.append(" ");
        if (mnemonic <= 9) {
            sb.insert(sb.length() - String.valueOf(mnemonic).length(), '&');
        }
        sb.append(" ");
        String fileName = new Path(item.getFilePath()).lastSegment();
        String pathName = item.getFilePath();
        if (pathName.equals(fileName)) {
            pathName = "";
        }
        if ((path = new Path(pathName)).segmentCount() > 1 && path.segment(path.segmentCount() - 1).equals(fileName)) {
            path = path.removeLastSegments(1);
            pathName = path.toString();
        }
        if (fileName.length() + pathName.length() <= 36) {
            sb.append(fileName);
            if (pathName.length() > 0) {
                sb.append("  [");
                sb.append(pathName);
                sb.append("]");
            }
        } else {
            int length = fileName.length();
            if (length > 40) {
                sb.append(fileName.substring(0, 37));
                sb.append("...");
            } else if (length > 33) {
                sb.append(fileName);
            } else {
                sb.append(fileName);
                int segmentCount = path.segmentCount();
                if (segmentCount > 0) {
                    int i;
                    String segment;
                    length += 7;
                    sb.append("  [");
                    for (i = 0; i < segmentCount && length < 40; length += segment.length() + 1, ++i) {
                        segment = path.segment(i);
                        if (length + segment.length() < 40) {
                            sb.append(segment);
                            sb.append('/');
                            continue;
                        }
                        if (i != 0) break;
                        sb.append(segment.substring(0, 40 - length));
                        length = 40;
                        break;
                    }
                    sb.append("...");
                    i = segmentCount - 1;
                    while (i > 0 && length < 40) {
                        segment = path.segment(i);
                        if (length + segment.length() >= 40) break;
                        sb.append('/');
                        sb.append(segment);
                        length += segment.length() + 1;
                        --i;
                    }
                    sb.append("]");
                }
            }
        }
        return sb.toString();
    }

    public void fill(final Menu menu, int index) {
        if (this.window.getActivePage() == null || this.window.getActivePage().getPerspective() == null) {
            return;
        }
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        List lastHeaps = SnapshotHistoryService.getInstance().getVisitedEntries();
        if (lastHeaps.size() <= 0) {
            return;
        }
        final int[] menuIndex = new int[]{index};
        int i = 0;
        for (final SnapshotHistoryService.Entry entry : lastHeaps) {
            if (i == 10) continue;
            final int historyIndex = i++;
            this.window.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    String text = AddHistoryToMenuAction.this.calcText(historyIndex, entry);
                    MenuItem mi = new MenuItem(menu, 8, menuIndex[0]);
                    menuIndex[0] = menuIndex[0] + 1;
                    mi.setText(text);
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            try {
                                IDE.openEditor((IWorkbenchPage)AddHistoryToMenuAction.this.window.getActivePage(), (IEditorInput)new PathEditorInput((IPath)new Path(entry.getFilePath())), (String)entry.getEditorId(), (boolean)true);
                                if (AddHistoryToMenuAction.this.window.getWorkbench().getIntroManager().getIntro() != null) {
                                    AddHistoryToMenuAction.this.window.getWorkbench().getIntroManager().setIntroStandby(AddHistoryToMenuAction.this.window.getWorkbench().getIntroManager().getIntro(), true);
                                }
                            }
                            catch (PartInitException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                    });
                }
            });
        }
        new MenuItem(menu, 2, i + index);
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }
}

