/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.mat.report.internal.Messages;
import org.osgi.framework.BundleContext;

public class ReportPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.mat.report";
    private static ReportPlugin plugin;
    private IExtensionTracker tracker;
    static List<Runnable> stop;

    static {
        stop = new ArrayList<Runnable>();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.tracker = new ExtensionTracker(Platform.getExtensionRegistry());
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        for (Runnable r : stop) {
            try {
                r.run();
            }
            catch (RuntimeException e) {
                ReportPlugin.log(e);
            }
        }
        stop.clear();
        plugin = null;
        this.tracker.close();
        super.stop(context);
    }

    public static ReportPlugin getDefault() {
        return plugin;
    }

    public IExtensionTracker getExtensionTracker() {
        return this.tracker;
    }

    public static void log(IStatus status) {
        ReportPlugin default1 = ReportPlugin.getDefault();
        if (default1 != null) {
            default1.getLog().log(status);
        } else {
            Level l;
            switch (status.getSeverity()) {
                case 0: 
                case 1: {
                    l = Level.INFO;
                    break;
                }
                case 4: {
                    l = Level.SEVERE;
                    break;
                }
                default: {
                    l = Level.WARNING;
                }
            }
            Logger.getLogger(ReportPlugin.class.getName()).log(l, status.getMessage(), status.getException());
        }
    }

    public static void log(Throwable e) {
        ReportPlugin.log(e, Messages.ReportPlugin_InternalError);
    }

    public static void log(Throwable e, String message) {
        ReportPlugin.log((IStatus)new Status(4, PLUGIN_ID, message, e));
    }

    public static void log(int status, String message) {
        ReportPlugin.log((IStatus)new Status(status, PLUGIN_ID, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onStop(Runnable r) {
        List<Runnable> list = stop;
        synchronized (list) {
            if (!stop.contains(r)) {
                stop.add(r);
            }
        }
    }
}

