/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.registry;

import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.descriptors.IArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentFactory;
import org.eclipse.mat.query.registry.Converters;

public class ArgumentDescriptor
implements IArgumentDescriptor {
    private boolean isMandatory;
    private String name;
    private String flag;
    private String help;
    private Field field;
    private boolean isArray;
    private boolean isList;
    private Class<?> type;
    private Argument.Advice advice;
    private Object defaultValue;

    @Override
    public boolean isMultiple() {
        return this.isArray || this.isList;
    }

    @Override
    public boolean isBoolean() {
        return this.type == Boolean.class || this.type == Boolean.TYPE;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    @Override
    public String getFlag() {
        return this.flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    @Override
    public boolean isList() {
        return this.isList;
    }

    public void setList(boolean isList) {
        this.isList = isList;
    }

    @Override
    public boolean isEnum() {
        return this.type.isEnum();
    }

    @Override
    public boolean isMandatory() {
        return this.isMandatory;
    }

    public void setMandatory(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    @Override
    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    @Override
    public Argument.Advice getAdvice() {
        return this.advice;
    }

    public void setAdvice(Argument.Advice advice) {
        this.advice = advice;
    }

    public String toString() {
        return new StringBuilder(256).append(this.name).append("(isRequired=").append(this.isMandatory).append(",flag=").append(this.flag).append(",type=").append(this.type.getName()).append(")").toString();
    }

    void appendUsage(StringBuilder buf) {
        buf.append(" ");
        if (!this.isMandatory()) {
            buf.append("[");
        }
        if (this.flag != null) {
            buf.append("-").append(this.flag);
        }
        if (this.isMultiple()) {
            if (this.flag != null) {
                buf.append(" ");
            }
            buf.append("<").append(this.name).append("0 .. N>");
        } else if (!this.isBoolean()) {
            if (this.flag != null) {
                buf.append(" ");
            }
            if (this.isEnum()) {
                boolean first = true;
                Enum[] enumArray = this.type.asSubclass(Enum.class).getEnumConstants();
                int n = enumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Enum o = enumArray[n2];
                    if (first) {
                        first = false;
                    } else {
                        buf.append("|");
                    }
                    buf.append(o.name());
                    ++n2;
                }
            } else {
                buf.append("<").append(this.name).append(">");
            }
        }
        if (!this.isMandatory()) {
            buf.append("]");
        }
    }

    void appendUsage(StringBuilder buf, Object value) {
        if (value instanceof ArgumentFactory) {
            buf.append(" ");
            if (this.flag != null) {
                buf.append("-").append(this.flag).append(" ");
            }
            ((ArgumentFactory)value).appendUsage(buf);
            return;
        }
        if (this.isMultiple() && (value == null || ((List)value).isEmpty())) {
            return;
        }
        buf.append(" ");
        if (this.isBoolean()) {
            if (value != null && ((Boolean)value).booleanValue()) {
                buf.append("-").append(this.flag);
            }
        } else {
            if (this.flag != null) {
                buf.append("-").append(this.flag).append(" ");
            }
            if (value == null) {
                buf.append("\"\"");
            } else if (this.isMultiple()) {
                List values = (List)value;
                for (Object v : values) {
                    if (v == null) {
                        buf.append("\"\"");
                        continue;
                    }
                    if (v instanceof ArgumentFactory) {
                        ((ArgumentFactory)v).appendUsage(buf);
                        buf.append(" ");
                        continue;
                    }
                    buf.append(Converters.convertAndEscape(this.type, v)).append(" ");
                }
            } else {
                buf.append(Converters.convertAndEscape(this.type, value));
            }
        }
    }
}

