/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.ui.internal.query.arguments.LinkEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public abstract class ArgumentEditor
extends Composite {
    protected IQueryContext context;
    protected ArgumentDescriptor descriptor;
    private List<IEditorListener> listeners = Collections.synchronizedList(new ArrayList());
    protected TableItem item;

    public ArgumentEditor(Composite parent, IQueryContext context, ArgumentDescriptor descriptor, TableItem item) {
        super(parent, 0);
        this.context = context;
        this.descriptor = descriptor;
        this.item = item;
    }

    public void addListener(IEditorListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IEditorListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireValueChangedEvent(Object value, ArgumentEditor editor) {
        List<IEditorListener> list = this.listeners;
        synchronized (list) {
            for (IEditorListener listener : this.listeners) {
                listener.onValueChanged(value, this.descriptor, this.item, editor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireErrorEvent(String message, ArgumentEditor editor) {
        List<IEditorListener> list = this.listeners;
        synchronized (list) {
            for (IEditorListener listener : this.listeners) {
                listener.onError(editor, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFocusEvent(String message) {
        List<IEditorListener> list = this.listeners;
        synchronized (list) {
            for (IEditorListener listener : this.listeners) {
                listener.onFocus(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireModeChangeEvent(LinkEditor.Mode mode) {
        List<IEditorListener> list = this.listeners;
        synchronized (list) {
            for (IEditorListener listener : this.listeners) {
                listener.onModeChange(mode, this.descriptor);
            }
        }
    }

    public ArgumentDescriptor getDescriptor() {
        return this.descriptor;
    }

    public abstract void setValue(Object var1) throws SnapshotException;

    public abstract Object getValue();

    public static interface IEditorListener {
        public void onValueChanged(Object var1, ArgumentDescriptor var2, TableItem var3, ArgumentEditor var4);

        public void onError(ArgumentEditor var1, String var2);

        public void onFocus(String var1);

        public void onModeChange(LinkEditor.Mode var1, ArgumentDescriptor var2);
    }
}

