/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import com.ibm.icu.text.DecimalFormatSymbols;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.refined.Filter;
import org.eclipse.mat.report.IOutputter;
import org.eclipse.mat.report.Renderer;
import org.eclipse.mat.report.internal.OutputterBase;

@Renderer(target="csv", result={IResultTree.class, IResultTable.class})
public class CSVOutputter
extends OutputterBase {
    private static final char SEPARATOR = (char)(new DecimalFormatSymbols().getDecimalSeparator() == ',' ? 59 : 44);

    @Override
    public void process(IOutputter.Context context, IResult result, Writer writer) throws IOException {
        this.embedd(context, result, writer);
    }

    @Override
    public void embedd(IOutputter.Context context, IResult result, Writer writer) throws IOException {
        block12: {
            Filter.ValueConverter[] filter;
            Column[] columns;
            block11: {
                columns = result instanceof IResultTable ? ((IResultTable)result).getColumns() : ((IResultTree)result).getColumns();
                filter = new Filter.ValueConverter[columns.length];
                int columnIndex = 0;
                while (columnIndex < columns.length) {
                    filter[columnIndex] = (Filter.ValueConverter)columns[columnIndex].getData(Filter.ValueConverter.class);
                    if (context.isColumnVisible(columnIndex)) {
                        if (columns[columnIndex].getLabel() != null) {
                            CSVOutputter.escape(writer, columns[columnIndex].getLabel());
                        }
                        writer.append(SEPARATOR);
                    }
                    ++columnIndex;
                }
                writer.append("\n");
                if (!(result instanceof IResultTable)) break block11;
                IResultTable table = (IResultTable)result;
                int limit = context.hasLimit() ? Math.min(table.getRowCount(), context.getLimit()) : table.getRowCount();
                int row = 0;
                while (row < limit) {
                    int column = 0;
                    while (column < columns.length) {
                        if (context.isColumnVisible(column)) {
                            Object columnValue = table.getColumnValue(table.getRow(row), column);
                            if (columnValue != null) {
                                CSVOutputter.escape(writer, CSVOutputter.getStringValue(columnValue, filter[column]));
                            }
                            writer.append(SEPARATOR);
                        }
                        ++column;
                    }
                    writer.append("\n");
                    ++row;
                }
                break block12;
            }
            if (!(result instanceof IResultTree)) break block12;
            IResultTree tree = (IResultTree)result;
            List<?> elements = tree.getElements();
            int limit = context.hasLimit() ? Math.min(elements.size(), context.getLimit()) : elements.size();
            int row = 0;
            while (row < limit) {
                int column = 0;
                while (column < columns.length) {
                    if (context.isColumnVisible(column)) {
                        Object columnValue = tree.getColumnValue(elements.get(row), column);
                        if (columnValue != null) {
                            CSVOutputter.escape(writer, CSVOutputter.getStringValue(columnValue, filter[column]));
                        }
                        writer.append(SEPARATOR);
                    }
                    ++column;
                }
                writer.append("\n");
                ++row;
            }
        }
    }

    private static void escape(Writer writer, String data) throws IOException {
        boolean hasNewLine;
        if (data == null) {
            return;
        }
        boolean hasSeparator = data.indexOf(SEPARATOR) >= 0;
        boolean hasQuote = data.indexOf(34) >= 0;
        boolean bl = hasNewLine = data.indexOf(10) >= 0 || data.indexOf(13) >= 0 && data.indexOf(12) >= 0;
        if (hasSeparator || hasQuote || hasNewLine) {
            writer.append('\"');
            if (hasQuote) {
                int len = data.length();
                int ii = 0;
                while (ii < len) {
                    char c = data.charAt(ii);
                    if (c == '\"') {
                        writer.append('\"');
                    }
                    writer.append(c);
                    ++ii;
                }
            } else {
                writer.append(data);
            }
            writer.append('\"');
        } else {
            writer.append(data);
        }
    }
}

