/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class PopupMenu {
    private static final Object SEPARATOR = new Object();
    private String name;
    private String toolTipText;
    private String actionDefinitionId;
    private ImageDescriptor imageDescriptor;
    private List<Object> children = new ArrayList<Object>();
    private Boolean showImages;

    public PopupMenu() {
        this.name = Messages.PopupMenu_NONE;
    }

    public PopupMenu(String name) {
        this.name = name;
    }

    public void add(Action action) {
        this.children.add(action);
    }

    public void add(PopupMenu menu) {
        this.children.add(menu);
    }

    public void addSeparator() {
        this.children.add(SEPARATOR);
    }

    public PopupMenu getChildMenu(String name) {
        for (Object child : this.children) {
            if (!(child instanceof PopupMenu) || !((PopupMenu)child).name.equals(name)) continue;
            return (PopupMenu)child;
        }
        return null;
    }

    public void setToolTipText(String tooltip) {
        this.toolTipText = tooltip;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    public void setActionDefinitionId(String actionDefinitionId) {
        this.actionDefinitionId = actionDefinitionId;
    }

    public void addToMenu(IStatusLineManager statusLineManager, Menu menu) {
        HideListener hideListener = new HideListener(statusLineManager);
        ShowListener showListener = new ShowListener(statusLineManager);
        ArmListener armListener = new ArmListener(statusLineManager);
        SelectionListener selectionListener = new SelectionListener();
        this.addToMenu(menu, hideListener, showListener, armListener, selectionListener);
    }

    public Menu createMenu(IStatusLineManager statusLineManager, Control parent) {
        Menu menu = new Menu((Control)parent.getShell());
        this.addToMenu(statusLineManager, menu);
        return menu;
    }

    private void addToMenu(Menu menu, Listener hide, Listener show, Listener arm, Listener selection) {
        for (Object item : this.children) {
            int count;
            ExternalActionManager.ICallback callback;
            String acceleratorText;
            MenuItem menuItem;
            if (item instanceof Action) {
                ImageDescriptor id;
                Action action = (Action)item;
                int flags = 8;
                int style = action.getStyle();
                if (style == 2) {
                    flags = 32;
                } else if (style == 8) {
                    flags = 16;
                }
                menuItem = new MenuItem(menu, flags);
                acceleratorText = null;
                callback = ExternalActionManager.getInstance().getCallback();
                String commandId = action.getActionDefinitionId();
                if (commandId != null && callback != null) {
                    acceleratorText = callback.getAcceleratorText(commandId);
                }
                if (acceleratorText == null) {
                    menuItem.setText(action.getText());
                } else {
                    menuItem.setText(String.valueOf(action.getText()) + '\t' + acceleratorText);
                }
                if (flags != 8) {
                    menuItem.setSelection(action.isChecked());
                }
                if (this.showImages() && (id = action.getImageDescriptor()) != null) {
                    menuItem.setImage(MemoryAnalyserPlugin.getDefault().getImage(id));
                }
                menuItem.setData((Object)action);
                menuItem.addListener(13, selection);
                menuItem.addListener(30, arm);
                continue;
            }
            if (item instanceof PopupMenu) {
                PopupMenu popup = (PopupMenu)item;
                if (popup.isEmpty()) continue;
                ImageDescriptor imageDescriptor = popup.getImageDescriptor();
                Menu subMenu = new Menu((Decorations)menu.getShell(), 4);
                subMenu.addListener(23, hide);
                subMenu.addListener(22, show);
                popup.addToMenu(subMenu, hide, show, arm, selection);
                menuItem = new MenuItem(menu, 64);
                acceleratorText = null;
                callback = ExternalActionManager.getInstance().getCallback();
                if (popup.actionDefinitionId != null && callback != null) {
                    acceleratorText = callback.getAcceleratorText(popup.actionDefinitionId);
                }
                if (acceleratorText == null) {
                    menuItem.setText(popup.name);
                } else {
                    menuItem.setText(String.valueOf(popup.name) + '\t' + acceleratorText);
                }
                if (imageDescriptor != null) {
                    menuItem.setImage(MemoryAnalyserPlugin.getDefault().getImage(imageDescriptor));
                }
                menuItem.setMenu(subMenu);
                continue;
            }
            if (item != SEPARATOR || (count = menu.getItemCount()) <= 0 || (menu.getItem(count - 1).getStyle() & 2) == 2) continue;
            new MenuItem(menu, 2);
        }
    }

    private boolean showImages() {
        return this.showImages != null ? this.showImages : true;
    }

    private ImageDescriptor getImageDescriptor() {
        if (this.showImages != null || this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        this.showImages = Boolean.FALSE;
        int ii = 0;
        while (ii < this.children.size()) {
            ImageDescriptor d = null;
            Object child = this.children.get(ii);
            if (child instanceof Action) {
                d = ((Action)child).getImageDescriptor();
            } else if (child instanceof PopupMenu) {
                d = ((PopupMenu)child).getImageDescriptor();
            }
            if (ii == 0) {
                this.imageDescriptor = d;
            } else if (d != null && !d.equals(this.imageDescriptor) || d == null && this.imageDescriptor != null) {
                this.imageDescriptor = null;
                this.showImages = Boolean.TRUE;
                break;
            }
            ++ii;
        }
        return this.imageDescriptor;
    }

    private boolean isEmpty() {
        if (this.children.isEmpty()) {
            return true;
        }
        for (Object child : this.children) {
            if (child instanceof PopupMenu) {
                if (((PopupMenu)child).isEmpty()) continue;
                return false;
            }
            if (child == SEPARATOR) continue;
            return false;
        }
        return true;
    }

    private static final class ArmListener
    implements Listener {
        IStatusLineManager statusLineManager;

        private ArmListener(IStatusLineManager statusLineManager) {
            this.statusLineManager = statusLineManager;
        }

        public void handleEvent(Event event) {
            String tooltip = null;
            Object data = event.widget.getData();
            if (data instanceof Action) {
                tooltip = ((Action)data).getToolTipText();
            } else if (data instanceof PopupMenu) {
                tooltip = ((PopupMenu)data).toolTipText;
            }
            if (tooltip == null) {
                tooltip = "";
            }
            this.statusLineManager.setMessage(tooltip);
        }
    }

    private static final class HideListener
    implements Listener {
        IStatusLineManager statusLineManager;

        private HideListener(IStatusLineManager statusLineManager) {
            this.statusLineManager = statusLineManager;
        }

        public void handleEvent(Event event) {
            this.statusLineManager.setMessage("");
        }
    }

    private static final class SelectionListener
    implements Listener {
        private SelectionListener() {
        }

        public void handleEvent(Event event) {
            try {
                Action action = (Action)event.widget.getData();
                int style = action.getStyle();
                if ((style & 0x22) != 0 && action.getStyle() == 2) {
                    action.setChecked(((MenuItem)event.widget).getSelection());
                }
                action.runWithEvent(event);
            }
            catch (RuntimeException e) {
                ErrorHelper.logThrowableAndShowMessage(e);
            }
        }
    }

    private static final class ShowListener
    implements Listener {
        IStatusLineManager statusLineManager;

        private ShowListener(IStatusLineManager statusLineManager) {
            this.statusLineManager = statusLineManager;
        }

        public void handleEvent(Event event) {
            this.statusLineManager.setMessage("");
        }
    }
}

