/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.internal.collectionextract.HashedMapCollectionExtractorBase;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class ConcurrentHashMapCollectionExtractor
extends HashedMapCollectionExtractorBase {
    public ConcurrentHashMapCollectionExtractor(String arrayField, String keyField, String valueField) {
        super(arrayField, keyField, valueField);
    }

    @Override
    public boolean hasSize() {
        return true;
    }

    @Override
    public Integer getSize(IObject collection) throws SnapshotException {
        long[] refs;
        IObjectArray segmentsArray = this.extractBackingArray(collection);
        if (segmentsArray == null) {
            return 0;
        }
        ISnapshot snapshot = collection.getSnapshot();
        ICollectionExtractor segmentInfo = this.getSegmentExtractor();
        int size = 0;
        long[] lArray = refs = segmentsArray.getReferenceArray();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            long addr = lArray[n2];
            if (addr != 0L) {
                int segmentId = snapshot.mapAddressToId(addr);
                size += segmentInfo.getSize(snapshot.getObject(segmentId)).intValue();
            }
            ++n2;
        }
        return size;
    }

    @Override
    public boolean hasCapacity() {
        return true;
    }

    @Override
    public Integer getCapacity(IObject collection) throws SnapshotException {
        long[] refs;
        IObjectArray segmentsArray = this.extractBackingArray(collection);
        if (segmentsArray == null) {
            return 0;
        }
        ISnapshot snapshot = collection.getSnapshot();
        ICollectionExtractor extractor = this.getSegmentExtractor();
        int result = 0;
        long[] lArray = refs = segmentsArray.getReferenceArray();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            long addr = lArray[n2];
            if (addr != 0L) {
                int segmentId = snapshot.mapAddressToId(addr);
                IObject segment = snapshot.getObject(segmentId);
                Integer cap = extractor.getCapacity(segment);
                if (cap != null && extractor.hasSize()) {
                    cap = extractor.getSize(segment);
                }
                if (cap != null) {
                    result += cap.intValue();
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    public boolean hasExtractableContents() {
        return true;
    }

    @Override
    public boolean hasExtractableArray() {
        return false;
    }

    @Override
    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        long[] refs;
        ISnapshot snapshot = coll.getSnapshot();
        IObjectArray segmentsArray = this.extractBackingArray(coll);
        if (segmentsArray == null) {
            return new int[0];
        }
        ArrayInt result = new ArrayInt();
        ICollectionExtractor segmentInfo = this.getSegmentExtractor();
        long[] lArray = refs = segmentsArray.getReferenceArray();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            long addr = lArray[n2];
            if (addr != 0L) {
                int[] segmentEntries = segmentInfo.extractEntryIds(snapshot.getObject(snapshot.mapAddressToId(addr)));
                result.addAll(segmentEntries);
            }
            ++n2;
        }
        return result.toArray();
    }

    @Override
    public Integer getNumberOfNotNullElements(IObject collection) throws SnapshotException {
        long[] refs;
        IObjectArray segmentsArray = this.extractBackingArray(collection);
        if (segmentsArray == null) {
            return null;
        }
        ISnapshot snapshot = collection.getSnapshot();
        ICollectionExtractor segmentInfo = this.getSegmentExtractor();
        int result = 0;
        long[] lArray = refs = segmentsArray.getReferenceArray();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            long addr = lArray[n2];
            if (addr != 0L) {
                int segmentId = snapshot.mapAddressToId(addr);
                result += segmentInfo.getNumberOfNotNullElements(snapshot.getObject(segmentId)).intValue();
            }
            ++n2;
        }
        return result;
    }

    private ICollectionExtractor getSegmentExtractor() throws SnapshotException {
        return CollectionExtractionUtils.findCollectionExtractor("java.util.concurrent.ConcurrentHashMap$Segment");
    }
}

