/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HorizontalAlignment implements Enumerator
{
    LEFT_LITERAL(0, "Left", "Left"),
    CENTER_LITERAL(1, "Center", "Center"),
    RIGHT_LITERAL(2, "Right", "Right");

    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private static final HorizontalAlignment[] VALUES_ARRAY;
    public static final List<HorizontalAlignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HorizontalAlignment[]{LEFT_LITERAL, CENTER_LITERAL, RIGHT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HorizontalAlignment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HorizontalAlignment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HorizontalAlignment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HorizontalAlignment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HorizontalAlignment get(int value) {
        switch (value) {
            case 0: {
                return LEFT_LITERAL;
            }
            case 1: {
                return CENTER_LITERAL;
            }
            case 2: {
                return RIGHT_LITERAL;
            }
        }
        return null;
    }

    private HorizontalAlignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

