/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultPie;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ISelectionProvider;
import org.eclipse.mat.query.refined.Filter;
import org.eclipse.mat.query.refined.RefinedStructuredResult;
import org.eclipse.mat.query.refined.TotalsRow;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.report.IOutputter;
import org.eclipse.mat.report.Renderer;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.report.internal.OutputterBase;
import org.eclipse.mat.report.internal.TextEmitter;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.VoidProgressListener;

@Renderer(target="txt", result={IResultTree.class, IResultTable.class, TextResult.class, IResultPie.class})
public class TextOutputter
extends OutputterBase
implements IOutputter {
    @Override
    public void process(IOutputter.Context context, IResult result, Writer writer) throws IOException {
        this.embedd(context, result, writer);
    }

    @Override
    public void embedd(IOutputter.Context context, IResult result, Writer writer) throws IOException {
        if (result instanceof TextResult) {
            TextResult tr = (TextResult)result;
            String s = tr.getText();
            if (tr.isHtml()) {
                s = this.toTextFromHTML(s);
            }
            writer.append(s);
            writer.append(LINE_SEPARATOR);
        } else if (result instanceof IResultTable) {
            new RefinedTableTextEmitter(context, result, writer).doCopy();
        } else if (result instanceof IResultTree) {
            new RefinedTreeTextEmitter(context, result, writer).doCopy();
        } else if (result instanceof IResultPie) {
            IResultPie pie = (IResultPie)result;
            writer.append(MessageUtil.format(Messages.TextOutputter_PieChart, pie.getSlices().size()));
            writer.append(LINE_SEPARATOR);
            writer.append(LINE_SEPARATOR);
            int sl = 1;
            for (IResultPie.Slice slice : pie.getSlices()) {
                writer.append(MessageUtil.format(Messages.TextOutputter_Slice, sl, slice.getValue(), this.toTextFromHTML(slice.getDescription())));
                writer.append(LINE_SEPARATOR);
                writer.append(LINE_SEPARATOR);
                ++sl;
            }
        }
    }

    private String toTextFromHTML(String s) {
        s = s.replaceAll("<b>", "").replace("</b>", "");
        s = s.replaceAll("<strong>", "").replace("</strong>", "");
        s = s.replaceAll("<q>", "\"").replace("</q>", "\"");
        s = s.replaceAll("<br>", LINE_SEPARATOR);
        s = s.replaceAll("<br/>", LINE_SEPARATOR);
        s = s.replaceAll("<p>", LINE_SEPARATOR).replaceAll("</p>", "");
        s = s.replaceAll("<a [^>]+>", "").replaceAll("</a>", "");
        s = s.replaceAll("<ul [^>]+>", LINE_SEPARATOR).replaceAll("</ul>", "");
        s = s.replaceAll("<li>", "").replace("</li>", LINE_SEPARATOR);
        s = s.replaceAll("&quot;", "\"");
        s = s.replaceAll("&apos;", "'");
        s = s.replaceAll("&lt;", "<");
        s = s.replaceAll("&gt;", ">");
        s = s.replaceAll("&amp;", "&");
        return s;
    }

    private static class RefinedTableTextEmitter
    extends StructuredResultTextEmitter {
        private IResultTable table;

        public RefinedTableTextEmitter(IOutputter.Context context, IResult result, Writer writer) {
            super(context, result, writer);
        }

        @Override
        protected void initialize(IResult result) {
            this.table = (IResultTable)result;
        }

        @Override
        protected Object[] getItems() {
            int rows = this.context.hasLimit() ? Math.min(this.table.getRowCount(), this.context.getLimit()) : this.table.getRowCount();
            int rows1 = this.context.isTotalsRowVisible() && this.table instanceof RefinedStructuredResult ? rows + 1 : rows;
            int rows0 = 0;
            if (this.table instanceof RefinedStructuredResult && ((RefinedStructuredResult)((Object)this.table)).hasActiveFilter()) {
                ++rows1;
                rows0 = 1;
            }
            Object[] result = new Object[rows1];
            int i = 0;
            while (i < rows) {
                result[rows0 + i] = this.table.getRow(i);
                ++i;
            }
            if (this.table instanceof RefinedStructuredResult) {
                RefinedStructuredResult rsr = (RefinedStructuredResult)((Object)this.table);
                if (rows0 == 1) {
                    result[0] = rsr.getFilter();
                }
                if (rows1 > rows0 + rows) {
                    List<Object> subList = Arrays.asList(result).subList(rows0, rows0 + rows);
                    TotalsRow totalsRow = rsr.buildTotalsRow(subList);
                    totalsRow.setVisibleItems(rows);
                    rsr.calculateTotals(subList, totalsRow, new VoidProgressListener());
                    result[rows1 - 1] = totalsRow;
                }
            }
            return result;
        }

        @Override
        protected Object[] getColumns() {
            return this.table.getColumns();
        }

        @Override
        protected String getItemValue(Object item, int columnIndex) {
            if (item instanceof Filter[]) {
                Filter[] f = (Filter[])item;
                String fv = f[columnIndex].getCriteria();
                if (fv == null) {
                    fv = "";
                }
                return fv;
            }
            if (item instanceof TotalsRow) {
                TotalsRow tr = (TotalsRow)item;
                return tr.getLabel(columnIndex);
            }
            if (this.table instanceof RefinedStructuredResult) {
                return ((RefinedStructuredResult)((Object)this.table)).getFormattedColumnValue(item, columnIndex);
            }
            return TextOutputter.getStringValue(this.table.getColumnValue(item, columnIndex), this.filter[columnIndex]);
        }

        @Override
        protected String getDisplayableColumnValue(Object item, int index) {
            if (item instanceof Filter[]) {
                Filter[] f = (Filter[])item;
                String fv = f[index].getCriteria();
                if (fv == null) {
                    fv = "";
                }
                return fv;
            }
            if (item instanceof TotalsRow) {
                TotalsRow tr = (TotalsRow)item;
                return tr.getLabel(index);
            }
            if (this.table instanceof RefinedStructuredResult) {
                String v = ((RefinedStructuredResult)((Object)this.table)).getFormattedColumnValue(item, index);
                IDecorator dec = this.table.getColumns()[index].getDecorator();
                if (dec != null) {
                    String prefix = dec.prefix(item);
                    String suffix = dec.suffix(item);
                    if (prefix != null) {
                        v = suffix != null ? String.valueOf(prefix) + " " + v + " " + suffix : String.valueOf(prefix) + " " + v;
                    } else if (suffix != null) {
                        v = String.valueOf(v) + " " + suffix;
                    }
                }
                return v;
            }
            return TextOutputter.getStringValue(this.table.getColumnValue(item, index), this.filter[index]);
        }

        @Override
        protected boolean isExpanded(Object item) {
            return false;
        }
    }

    private static class RefinedTreeTextEmitter
    extends StructuredResultTextEmitter {
        private IResultTree tree;
        private ISelectionProvider sel;

        public RefinedTreeTextEmitter(IOutputter.Context context, IResult result, Writer writer) {
            super(context, result, writer);
        }

        @Override
        protected void initialize(IResult result) {
            this.tree = (IResultTree)result;
            this.sel = result instanceof ISelectionProvider ? (ISelectionProvider)((Object)result) : ISelectionProvider.EMPTY;
        }

        @Override
        protected Object[] getItems() {
            List<?> elements = this.tree.getElements();
            return this.getItems(elements);
        }

        protected Object[] getItems(List<?> elements) {
            int rows = this.context.hasLimit() ? Math.min(elements.size(), this.context.getLimit()) : elements.size();
            int rows1 = this.context.isTotalsRowVisible() && this.tree instanceof RefinedStructuredResult ? rows + 1 : rows;
            int rows0 = 0;
            if (this.tree instanceof RefinedStructuredResult && ((RefinedStructuredResult)((Object)this.tree)).hasActiveFilter()) {
                ++rows1;
                rows0 = 1;
            }
            Object[] result = new Object[rows1];
            int i = 0;
            while (i < rows) {
                result[rows0 + i] = elements.get(i);
                ++i;
            }
            if (this.tree instanceof RefinedStructuredResult) {
                RefinedStructuredResult rsr = (RefinedStructuredResult)((Object)this.tree);
                if (rows0 == 1) {
                    result[0] = rsr.getFilter();
                }
                if (rows1 > rows0 + rows) {
                    List<Object> subList = Arrays.asList(result).subList(rows0, rows0 + rows);
                    TotalsRow totalsRow = rsr.buildTotalsRow(subList);
                    totalsRow.setVisibleItems(rows);
                    rsr.calculateTotals(subList, totalsRow, new VoidProgressListener());
                    result[rows1 - 1] = totalsRow;
                }
            }
            return result;
        }

        @Override
        protected Object[] getColumns() {
            return this.tree.getColumns();
        }

        @Override
        protected String getDisplayableRowValue(Object item) {
            return this.tree.getColumnValue(item, -1).toString();
        }

        @Override
        protected String getItemValue(Object item, int columnIndex) {
            if (item instanceof Filter[]) {
                Filter[] f = (Filter[])item;
                String fv = f[columnIndex].getCriteria();
                if (fv == null) {
                    fv = "";
                }
                return fv;
            }
            if (item instanceof TotalsRow) {
                TotalsRow tr = (TotalsRow)item;
                return tr.getLabel(columnIndex);
            }
            if (this.tree instanceof RefinedStructuredResult) {
                return ((RefinedStructuredResult)((Object)this.tree)).getFormattedColumnValue(item, columnIndex);
            }
            return TextOutputter.getStringValue(this.tree.getColumnValue(item, columnIndex), this.filter[columnIndex]);
        }

        @Override
        protected String getDisplayableColumnValue(Object item, int index) {
            if (item instanceof Filter[]) {
                Filter[] f = (Filter[])item;
                String fv = f[index].getCriteria();
                if (fv == null) {
                    fv = "";
                }
                return fv;
            }
            if (item instanceof TotalsRow) {
                TotalsRow tr = (TotalsRow)item;
                return tr.getLabel(index);
            }
            if (this.tree instanceof RefinedStructuredResult) {
                String v = ((RefinedStructuredResult)((Object)this.tree)).getFormattedColumnValue(item, index);
                IDecorator dec = this.tree.getColumns()[index].getDecorator();
                if (dec != null) {
                    String prefix = dec.prefix(item);
                    String suffix = dec.suffix(item);
                    if (prefix != null) {
                        v = suffix != null ? String.valueOf(prefix) + " " + v + " " + suffix : String.valueOf(prefix) + " " + v;
                    } else if (suffix != null) {
                        v = String.valueOf(v) + " " + suffix;
                    }
                }
                return v;
            }
            return TextOutputter.getStringValue(this.tree.getColumnValue(item, index), this.filter[index]);
        }

        @Override
        protected boolean isExpanded(Object item) {
            if (item instanceof TotalsRow) {
                return false;
            }
            return this.sel.isExpanded(item);
        }

        @Override
        protected boolean shouldAddNextLine(Object item) {
            return this.isExpanded(item) && this.toPrint(item);
        }

        private boolean toPrint(Object item) {
            return true;
        }

        @Override
        protected boolean shouldProcessChild(Object child) {
            return true;
        }

        @Override
        protected Object[] getChildren(Object item) {
            List<?> children;
            if (item instanceof TotalsRow) {
                return null;
            }
            if (this.tree.hasChildren(item) && (children = this.tree.getChildren(item)) != null) {
                return this.getItems(children);
            }
            return null;
        }

        @Override
        protected int getColumnLength(Object[] items, Object[] objColumns, int columnNumber) {
            int lengthToCompare = 0;
            String header = this.getColumnName(objColumns[columnNumber]);
            int length = header != null ? header.length() : 0;
            int i = 0;
            while (i < items.length) {
                lengthToCompare = this.getDisplayableColumnValue(items[i], columnNumber).length();
                if (lengthToCompare > length) {
                    length = lengthToCompare;
                }
                if (this.isExpanded(items[i])) {
                    lengthToCompare = columnNumber == this.order[0] ? this.compare(items[i], length, columnNumber, new StringBuilder()) : this.getOtherColumnLength(items[i], length, columnNumber);
                }
                if (lengthToCompare > length) {
                    length = lengthToCompare;
                }
                ++i;
            }
            return length;
        }

        private int getOtherColumnLength(Object item, int length, int columnNumber) {
            int lengthToCompare = 0;
            Object[] children = this.getChildren(item);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    String columnText = this.getDisplayableColumnValue(children[i], columnNumber);
                    if (columnText != null) {
                        lengthToCompare = columnText.length();
                    }
                    if (lengthToCompare > length) {
                        length = lengthToCompare;
                    }
                    if (this.isExpanded(children[i]) && (lengthToCompare = this.getOtherColumnLength(children[i], length, columnNumber)) > length) {
                        length = lengthToCompare;
                    }
                    ++i;
                }
            }
            return length;
        }

        private int compare(Object item, int length, int columnNumber, StringBuilder level) {
            int lengthToCompare = 0;
            Object[] children = this.getChildren(item);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    level = this.getLevel(level, children.length, i);
                    lengthToCompare = this.getDisplayableColumnValue(children[i], columnNumber).length() + level.length();
                    if (lengthToCompare > length) {
                        length = lengthToCompare;
                    }
                    if (this.isExpanded(children[i]) && (lengthToCompare = this.compare(children[i], length, columnNumber, level)) > length) {
                        length = lengthToCompare;
                    }
                    if (level.length() >= 3) {
                        level.delete(level.length() - 3, level.length());
                    }
                    ++i;
                }
            }
            return length;
        }
    }

    private static abstract class StructuredResultTextEmitter
    extends TextEmitter {
        protected static final int ALIGN_LEFT = 0;
        protected static final int ALIGN_CENTER = 1;
        protected static final int ALIGN_RIGHT = 2;
        protected IOutputter.Context context;
        protected Writer writer;
        protected Filter.ValueConverter[] filter;

        public StructuredResultTextEmitter(IOutputter.Context context, IResult result, Writer writer) {
            this.context = context;
            this.writer = writer;
            this.initialize(result);
        }

        protected abstract void initialize(IResult var1);

        @Override
        protected void append(String string) {
            try {
                this.writer.append(string);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void done() {
        }

        @Override
        protected boolean shouldAddNextLine(Object item) {
            return false;
        }

        @Override
        protected boolean shouldSuppressLineBreak(Object item) {
            return false;
        }

        @Override
        protected void findColumnOrderAndAlignment(Object[] genericColumns) {
            Column[] columns = (Column[])genericColumns;
            this.align = new int[columns.length];
            this.order = new int[columns.length];
            this.filter = new Filter.ValueConverter[columns.length];
            int orderIndex = 0;
            int columnIndex = 0;
            while (columnIndex < columns.length) {
                this.filter[columnIndex] = (Filter.ValueConverter)columns[columnIndex].getData(Filter.ValueConverter.class);
                if (this.context.isColumnVisible(columnIndex)) {
                    this.order[orderIndex++] = columnIndex;
                }
                Column.Alignment alignment = columns[columnIndex].getAlign();
                switch (alignment) {
                    case CENTER: {
                        this.align[columnIndex] = 1;
                        break;
                    }
                    case RIGHT: {
                        this.align[columnIndex] = 2;
                        break;
                    }
                    default: {
                        this.align[columnIndex] = 0;
                    }
                }
                ++columnIndex;
            }
            if (orderIndex < this.order.length) {
                this.order = Arrays.copyOf(this.order, orderIndex);
            }
        }

        @Override
        protected String getColumnName(Object column) {
            return ((Column)column).getLabel();
        }

        @Override
        protected int getColumnLength(Object[] items, Object[] objColumns, int columnNumber) {
            int result = this.getColumnName(objColumns[columnNumber]).length();
            int i = 0;
            while (i < items.length) {
                String rowValue = this.getItemValue(items[i], columnNumber);
                if (rowValue.length() > result) {
                    result = rowValue.length();
                }
                ++i;
            }
            return result;
        }

        @Override
        protected boolean shouldProcessChild(Object child) {
            return false;
        }

        @Override
        protected String getDisplayableRowValue(Object item) {
            return null;
        }

        @Override
        protected Object[] getChildren(Object item) {
            return null;
        }

        @Override
        protected String getDisplayableColumnValueInSimpleStructure(Object item) {
            return this.getDisplayableRowValue(item);
        }

        @Override
        protected boolean isAlignmentRight(int alignment) {
            return alignment == 2;
        }

        @Override
        protected boolean isAlignmentCenter(int alignment) {
            return alignment == 1;
        }
    }
}

