/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.filtering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.WarPluginConfiguration;
import org.eclipse.m2e.wtp.internal.filtering.AbstractResourceFilteringConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResourceFilteringConfiguration
extends AbstractResourceFilteringConfiguration {
    private static final String WEB_INF = "WEB-INF/";
    private WarPluginConfiguration warPluginConfiguration;

    public WebResourceFilteringConfiguration(IMavenProjectFacade mavenProjectFacade) {
        super(mavenProjectFacade);
        this.warPluginConfiguration = new WarPluginConfiguration(mavenProjectFacade.getMavenProject(), mavenProjectFacade.getProject());
        this.pluginConfiguration = this.warPluginConfiguration;
    }

    @Override
    public IPath getTargetFolder() {
        return WebResourceFilteringConfiguration.getTargetFolder(this.mavenProjectFacade.getMavenProject(), this.mavenProjectFacade.getProject());
    }

    public static IPath getTargetFolder(MavenProject mavenProject, IProject project) {
        return ProjectUtils.getM2eclipseWtpFolder(mavenProject, project).append("web-resources");
    }

    @Override
    public List<Xpp3Dom> getResources() {
        Xpp3Dom webXmlResource;
        Xpp3Dom[] domResources = this.warPluginConfiguration.getWebResources();
        ArrayList<Xpp3Dom> resources = new ArrayList<Xpp3Dom>();
        if (domResources != null && domResources.length > 0) {
            resources.addAll(Arrays.asList(domResources));
        }
        if ((webXmlResource = this.getWebXmlResource()) != null) {
            resources.add(webXmlResource);
        }
        return resources;
    }

    private Xpp3Dom getWebXmlResource() {
        if (!this.pluginConfiguration.isFilteringDeploymentDescriptorsEnabled()) {
            return null;
        }
        String warSourceDirectory = this.warPluginConfiguration.getWarSourceDirectory();
        if (warSourceDirectory.startsWith("/")) {
            warSourceDirectory = warSourceDirectory.substring(1);
        }
        if (!warSourceDirectory.endsWith("/")) {
            warSourceDirectory = String.valueOf(warSourceDirectory) + "/";
        }
        Xpp3Dom resource = new Xpp3Dom("resource");
        Xpp3Dom directory = new Xpp3Dom("directory");
        directory.setValue(String.valueOf(warSourceDirectory) + WEB_INF);
        resource.addChild(directory);
        Xpp3Dom includes = new Xpp3Dom("includes");
        Xpp3Dom include = new Xpp3Dom("include");
        include.setValue("web.xml");
        includes.addChild(include);
        resource.addChild(includes);
        Xpp3Dom filter = new Xpp3Dom("filtering");
        filter.setValue(Boolean.TRUE.toString());
        Xpp3Dom targetPath = new Xpp3Dom("targetPath");
        targetPath.setValue(WEB_INF);
        resource.addChild(targetPath);
        resource.addChild(filter);
        return resource;
    }
}

