/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.LinkedHashSet;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.project.facet.AppClientFacetInstallDataModelProvider;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.wtp.AbstractProjectConfiguratorDelegate;
import org.eclipse.m2e.wtp.AcrPluginConfiguration;
import org.eclipse.m2e.wtp.ResourceCleaner;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

class AppClientProjectConfiguratorDelegate
extends AbstractProjectConfiguratorDelegate {
    AppClientProjectConfiguratorDelegate() {
    }

    protected void configure(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        LinkedHashSet<IFacetedProject.Action> actions = new LinkedHashSet<IFacetedProject.Action>();
        this.installJavaFacet(actions, project, facetedProject);
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project.getFile("pom.xml"), true, monitor);
        AcrPluginConfiguration config = new AcrPluginConfiguration(facade);
        String contentDir = config.getContentDirectory(project);
        IProjectFacetVersion fv = config.getFacetVersion();
        if (!facetedProject.hasProjectFacet(WTPProjectsUtil.APP_CLIENT_FACET)) {
            WTPProjectsUtil.removeConflictingFacets(facetedProject, fv, actions);
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, fv, (Object)this.getAppClientDataModel(contentDir)));
        } else {
            IProjectFacetVersion projectFacetVersion = facetedProject.getProjectFacetVersion(WTPProjectsUtil.APP_CLIENT_FACET);
            if (fv.getVersionString() != null && !fv.getVersionString().equals(projectFacetVersion.getVersionString())) {
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, fv, (Object)this.getAppClientDataModel(contentDir)));
            }
        }
        if (!actions.isEmpty()) {
            ResourceCleaner fileCleaner = new ResourceCleaner(project);
            try {
                this.addFoldersToClean(fileCleaner, facade);
                facetedProject.modify(actions, monitor);
            }
            finally {
                fileCleaner.cleanUp();
            }
        }
        this.fixMissingModuleCoreNature(project, monitor);
        this.removeTestFolderLinks(project, mavenProject, monitor, "/");
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            IPath contentDirPath = new Path("/").append(contentDir);
            WTPProjectsUtil.setDefaultDeploymentDescriptorFolder(component.getRootFolder(), contentDirPath, monitor);
        }
        this.setNonDependencyAttributeToContainer(project, monitor);
        WTPProjectsUtil.removeWTPClasspathContainer(project);
    }

    private IDataModel getAppClientDataModel(String contentDir) {
        IDataModel appClientModelCfg = DataModelFactory.createDataModel((IDataModelProvider)new AppClientFacetInstallDataModelProvider());
        appClientModelCfg.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)contentDir);
        appClientModelCfg.setProperty("IAppClientComponentCreationDataModelProperties.CREATE_DEFAULT_MAIN_CLASS", (Object)false);
        appClientModelCfg.setProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", (Object)false);
        return appClientModelCfg;
    }
}

