/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.internal.markers;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.core.ui.internal.markers.EditorAwareMavenProblemResolution;
import org.eclipse.m2e.core.ui.internal.util.XmlUtils;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractPomProblemResolution
extends EditorAwareMavenProblemResolution {
    protected static final String PROJECT_NODE = "project";
    protected static final String GROUP_ID_NODE = "groupId";
    protected static final String ARTIFACT_ID_NODE = "artifactId";
    protected static final String VERSION_NODE = "version";

    protected AbstractPomProblemResolution(IMarker marker) {
        super(marker);
    }

    protected abstract boolean canFix(String var1);

    protected abstract void processFix(IStructuredDocument var1, Element var2, List<IMarker> var3);

    public final boolean canFix(IMarker marker) {
        String hint = marker.getAttribute("editor_hint", null);
        return hint != null && this.canFix(hint);
    }

    protected final void fix(IDocument document, List<IMarker> markers, IProgressMonitor monitor) {
        XmlUtils.performOnRootElement((IDocument)document, (node, structured) -> this.processFix(structured, (Element)node, markers));
    }

    protected final void fix(IResource resource, List<IMarker> markers, IProgressMonitor monitor) {
        try {
            XmlUtils.performOnRootElement((IFile)((IFile)resource), (node, structured) -> this.processFix(structured, (Element)node, markers), (boolean)true);
        }
        catch (IOException | CoreException e) {
            this.LOG.error("Error processing marker", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    static String previewForRemovedElement(IDocument doc, Element removed) {
        void var3_2;
        IndexedRegion indexedRegion;
        Element element = removed;
        if (element instanceof IndexedRegion && (indexedRegion = (IndexedRegion)element) == (IndexedRegion)var3_2) {
            try {
                void reg;
                int maxl = doc.getNumberOfLines() - 1;
                int line = doc.getLineOfOffset(reg.getStartOffset());
                int startLine = doc.getLineOffset(line);
                int prev2Start = doc.getLineOffset(Math.max(line - 2, 0));
                int next2Start = doc.getLineOffset(Math.min(line + 1, maxl));
                int next2End = doc.getLineOffset(Math.min(line + 3, maxl));
                String prevString = doc.get(prev2Start, startLine - prev2Start);
                String nextString = next2Start < next2End ? doc.get(next2Start, next2End - next2Start) : "";
                prevString = prevString.replace("\t", "  ");
                nextString = nextString.replace("\t", "  ");
                prevString = StringUtils.convertToHTMLContent((String)prevString);
                nextString = StringUtils.convertToHTMLContent((String)nextString);
                return "<html>...<br>" + prevString + nextString + "...<html>";
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

